-- Adminer 4.6.2 MySQL dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

SET NAMES utf8mb4;

DROP TABLE IF EXISTS `wpqf_actionscheduler_actions`;
CREATE TABLE `wpqf_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheduled_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `wpqf_actionscheduler_claims`;
CREATE TABLE `wpqf_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `wpqf_actionscheduler_groups`;
CREATE TABLE `wpqf_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wpqf_actionscheduler_groups` (`group_id`, `slug`) VALUES
(1,	'action-scheduler-migration');

DROP TABLE IF EXISTS `wpqf_actionscheduler_logs`;
CREATE TABLE `wpqf_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `wpqf_aryo_activity_log`;
CREATE TABLE `wpqf_aryo_activity_log` (
  `histid` int(11) NOT NULL AUTO_INCREMENT,
  `user_caps` varchar(70) NOT NULL DEFAULT 'guest',
  `action` varchar(255) NOT NULL,
  `object_type` varchar(255) NOT NULL,
  `object_subtype` varchar(255) NOT NULL DEFAULT '',
  `object_name` varchar(255) NOT NULL,
  `object_id` int(11) NOT NULL DEFAULT 0,
  `user_id` int(11) NOT NULL DEFAULT 0,
  `hist_ip` varchar(55) NOT NULL DEFAULT '127.0.0.1',
  `hist_time` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`histid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `wpqf_aryo_activity_log` (`histid`, `user_caps`, `action`, `object_type`, `object_subtype`, `object_name`, `object_id`, `user_id`, `hist_ip`, `hist_time`) VALUES
(999,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'70.88.133.182',	1601934495),
(1000,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'70.88.133.182',	1601934499),
(1001,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'134.122.72.53',	1601936576),
(1002,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.89.110.45',	1601937804),
(1003,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'159.89.110.45',	1601937811),
(1004,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'165.22.209.132',	1601938923),
(1005,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'165.22.209.132',	1601938925),
(1006,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.71.111.16',	1601939467),
(1007,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'167.71.111.16',	1601939470),
(1008,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.224.216.78',	1601941265),
(1009,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'35.224.216.78',	1601941267),
(1010,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'64.225.14.25',	1601941870),
(1011,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'64.225.14.25',	1601941875),
(1012,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'137.74.24.180',	1601944176),
(1013,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.236.100.42',	1601945463),
(1014,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'82.223.98.190',	1601950506),
(1015,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.21.198.186',	1601952467),
(1016,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'70.88.133.182',	1601956361),
(1017,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'70.88.133.182',	1601956363),
(1018,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.196.37.206',	1601959438),
(1019,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'35.196.37.206',	1601959440),
(1020,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.221.71.0',	1601960640),
(1021,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'138.197.97.157',	1601964052),
(1022,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.110.145',	1601964608),
(1023,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'178.62.110.145',	1601964614),
(1024,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'82.223.98.190',	1601966262),
(1025,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.4.145',	1601966822),
(1026,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'142.93.237.176',	1601970925),
(1027,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'142.93.237.176',	1601970931),
(1028,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'147.135.211.127',	1601971428),
(1029,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'147.135.211.127',	1601971429),
(1030,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'145.239.211.242',	1601972055),
(1031,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'145.239.211.242',	1601972056),
(1032,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'173.236.146.172',	1601973267),
(1033,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'64.225.14.25',	1601975183),
(1034,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'18.134.8.128',	1601976380),
(1035,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.248.201.153',	1601978355),
(1036,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'93.113.111.193',	1601978972),
(1037,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'213.149.103.132',	1601979672),
(1038,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.68.114.57',	1601980987),
(1039,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.181.160.236',	1601983643),
(1040,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.236.100.42',	1602005447),
(1041,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.89.162.217',	1602007427),
(1042,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.203.98.228',	1602007949),
(1043,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.65.184.79',	1602008968),
(1044,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'89.115.245.50',	1602010898),
(1045,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'161.35.232.146',	1602011977),
(1046,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.248.29.200',	1602012506),
(1047,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.203.37.43',	1602013486),
(1048,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.203.176.82',	1602014558),
(1049,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.101.132.88',	1602015649),
(1050,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.4.145',	1602016747),
(1051,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.23.28',	1602020111),
(1052,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.71.63.47',	1602021193),
(1053,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'163.172.218.46',	1602021754),
(1054,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'164.132.48.179',	1602022830),
(1055,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'151.80.140.166',	1602025155),
(1056,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'161.35.232.146',	1602025761),
(1057,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.234.123.96',	1602026776),
(1058,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'35.234.123.96',	1602026777),
(1059,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.86.103.197',	1602027459),
(1060,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'66.198.246.47',	1602028000),
(1061,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'66.198.246.47',	1602028001),
(1062,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.198.172.68',	1602028670),
(1063,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'136.144.225.128',	1602030282),
(1064,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'132.148.164.212',	1602030413),
(1065,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'132.148.164.212',	1602030415),
(1066,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'80.90.82.70',	1602030832),
(1067,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'83.48.56.214',	1602032105),
(1068,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'142.93.226.235',	1602033983),
(1069,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.85.46.229',	1602034591),
(1070,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'34.85.46.229',	1602034593),
(1071,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'41.79.174.130',	1602036492),
(1072,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.101.95.65',	1602037029),
(1073,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'54.38.65.127',	1602038985),
(1074,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'54.38.65.127',	1602038986),
(1075,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'207.38.86.252',	1602039069),
(1076,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'207.38.86.252',	1602039071),
(1077,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'198.211.117.96',	1602039599),
(1078,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'198.211.117.96',	1602039600),
(1079,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.65.148.219',	1602040238),
(1080,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'159.65.148.219',	1602040240),
(1081,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.91.127.200',	1602040280),
(1082,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'51.91.127.200',	1602040281),
(1083,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.192.204.102',	1602044420),
(1084,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.99.189.150',	1602045280),
(1085,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'209.50.50.34',	1602045506),
(1086,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.178.42.44',	1602046623),
(1087,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'51.178.42.44',	1602046625),
(1088,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'188.166.94.198',	1602047859),
(1089,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'188.166.94.198',	1602047860),
(1090,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.229.238.71',	1602049726),
(1091,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.50.212',	1602051852),
(1092,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'178.62.50.212',	1602051853),
(1093,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.99.45.82',	1602052430),
(1094,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'167.99.45.82',	1602052437),
(1095,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'206.189.113.210',	1602057030),
(1096,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'206.189.113.210',	1602057031),
(1097,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.242.214.242',	1602058037),
(1098,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'161.35.232.146',	1602060190),
(1099,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.158.187.97',	1602061334),
(1100,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'198.27.67.87',	1602061879),
(1101,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.21.198.186',	1602062865),
(1102,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'157.230.104.185',	1602063398),
(1103,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.68.229.177',	1602063871),
(1104,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.185.226.238',	1602065630),
(1105,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'5.45.122.74',	1602065866),
(1106,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'138.197.179.94',	1602066492),
(1107,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.89.110.45',	1602067031),
(1108,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'49.50.250.83',	1602067488),
(1109,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'93.114.86.226',	1602068343),
(1110,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.86.103.197',	1602068822),
(1111,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.224.216.78',	1602069399),
(1112,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'212.83.190.22',	1602069900),
(1113,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.68.19.126',	1602070953),
(1114,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.65.19.39',	1602073841),
(1115,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'40.122.169.200',	1602074401),
(1116,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'188.166.36.93',	1602074800),
(1117,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'145.239.95.42',	1602075048),
(1118,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'145.239.95.42',	1602075050),
(1119,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'82.223.98.190',	1602075737),
(1120,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.65.184.79',	1602076662),
(1121,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'159.65.184.79',	1602076668),
(1122,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'164.132.48.179',	1602077544),
(1123,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'62.210.209.245',	1602077878),
(1124,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'3.6.250.172',	1602078919),
(1125,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'64.227.111.211',	1602079090),
(1126,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'77.68.30.62',	1602079368),
(1127,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'145.239.69.74',	1602079556),
(1128,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.73.237.110',	1602079711),
(1129,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.89.162.217',	1602080393),
(1130,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.101.139.73',	1602080524),
(1131,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'111.89.169.113',	1602081055),
(1132,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.38.211.30',	1602081195),
(1133,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.34.226',	1602082775),
(1134,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'64.202.189.187',	1602082853),
(1135,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.86.103.197',	1602083439),
(1136,	'guest',	'logged_in',	'User',	'',	'admin',	1,	1,	'109.66.57.145',	1602159461),
(1137,	'guest',	'logged_out',	'User',	'',	'',	0,	0,	'109.66.57.145',	1602159529),
(1138,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'138.68.143.189',	1602225427),
(1139,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'133.130.74.241',	1602225851),
(1140,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'66.42.73.64',	1602226086),
(1141,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'208.113.184.219',	1602226618),
(1142,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'15.188.158.216',	1602227263),
(1143,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'142.93.213.54',	1602228260),
(1144,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'142.93.213.54',	1602228265),
(1145,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'89.163.206.240',	1602230016),
(1146,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'188.208.140.21',	1602231548),
(1147,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.101.1.19',	1602232026),
(1148,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'85.128.142.53',	1602232650),
(1149,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'192.64.112.100',	1602232815),
(1150,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'85.128.142.53',	1602233267),
(1151,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.255.42.173',	1602234416),
(1152,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'51.255.42.173',	1602234418),
(1153,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'13.232.137.78',	1602234428),
(1154,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'138.68.143.189',	1602235403),
(1155,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'158.69.96.92',	1602235982),
(1156,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'158.69.96.92',	1602235983),
(1157,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.71.106.254',	1602236173),
(1158,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'62.210.57.132',	1602236650),
(1159,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.65.145.69',	1602237220),
(1160,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'52.252.164.12',	1602237600),
(1161,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'213.202.233.236',	1602237803),
(1162,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'60.43.193.206',	1602238099),
(1163,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.16.6',	1602238305),
(1164,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'181.236.184.36',	1602239605),
(1165,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'212.48.78.178',	1602240820),
(1166,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'212.48.78.178',	1602240821),
(1167,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.71.227.199',	1602242146),
(1168,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'54.37.121.239',	1602242492),
(1169,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'45.82.74.13',	1602243193),
(1170,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.94.213.47',	1602243320),
(1171,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'62.171.189.59',	1602245613),
(1172,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'195.154.225.16',	1602246357),
(1173,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'45.236.128.219',	1602246593),
(1174,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.89.10.154',	1602247781),
(1175,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'209.97.141.198',	1602248535),
(1176,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'136.244.102.196',	1602248861),
(1177,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.210.104.97',	1602249361),
(1178,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'209.97.141.198',	1602249437),
(1179,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'3.84.42.196',	1602250265),
(1180,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'3.84.42.196',	1602250267),
(1181,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'133.130.74.241',	1602250624),
(1182,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'89.163.206.240',	1602250779),
(1183,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'192.64.112.100',	1602251866),
(1184,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'54.37.121.239',	1602252124),
(1185,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.79.77.76',	1602252937),
(1186,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'62.75.143.197',	1602253162),
(1187,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.86.47',	1602253563),
(1188,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.255.42.173',	1602253839),
(1189,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'213.202.233.236',	1602254495),
(1190,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'60.43.193.206',	1602254764),
(1191,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'188.208.140.21',	1602255490),
(1192,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'54.37.121.239',	1602256016),
(1193,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'185.81.165.17',	1602256382),
(1194,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'3.14.113.214',	1602257043),
(1195,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'66.42.73.64',	1602257733),
(1196,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'60.43.193.206',	1602258529),
(1197,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'15.207.37.4',	1602262228),
(1198,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'15.207.128.244',	1602263315),
(1199,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'85.17.88.170',	1602263907),
(1200,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'13.233.147.87',	1602264078),
(1201,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'157.245.98.107',	1602265265),
(1202,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'157.245.98.107',	1602265267),
(1203,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.71.106.254',	1602265771),
(1204,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.234.123.96',	1602266708),
(1205,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'45.77.109.216',	1602266954),
(1206,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'45.77.109.216',	1602266956),
(1207,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'65.0.83.192',	1602268285),
(1208,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'192.64.112.100',	1602269037),
(1209,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'192.64.112.100',	1602269039),
(1210,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'195.154.225.16',	1602269375),
(1211,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'128.199.26.118',	1602269429),
(1212,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.65.148.219',	1602269603),
(1213,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'181.236.184.36',	1602271891),
(1214,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'181.236.184.36',	1602271893),
(1215,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.89.175.22',	1602272710),
(1216,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.101.1.19',	1602272926),
(1217,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'181.236.184.36',	1602273932),
(1218,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'52.252.164.12',	1602274070),
(1219,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'133.130.74.241',	1602274127),
(1220,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'162.241.67.232',	1602274615),
(1221,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'162.241.67.232',	1602274616),
(1222,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'158.69.96.92',	1602274746),
(1223,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.234.123.96',	1602275306),
(1224,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'173.212.247.232',	1602276954),
(1225,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'62.210.57.132',	1602277025),
(1226,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'162.241.67.232',	1602277108),
(1227,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'158.69.96.92',	1602278625),
(1228,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'213.202.233.236',	1602279576),
(1229,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'206.189.102.108',	1602280252),
(1230,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.71.227.199',	1602282599),
(1231,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.61.90',	1602283482),
(1232,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.16.6',	1602286043),
(1233,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'60.43.193.206',	1602288824),
(1234,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'60.43.193.206',	1602288831),
(1235,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'13.127.241.34',	1602289247),
(1236,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'195.154.225.16',	1602290797),
(1237,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'195.154.225.16',	1602290803),
(1238,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'81.19.215.15',	1602292875),
(1239,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'3.84.42.196',	1602294512),
(1240,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.101.1.19',	1602294654),
(1241,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'192.64.112.100',	1602295211),
(1242,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.65.145.69',	1602295780),
(1243,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'62.210.57.132',	1602297906),
(1244,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'52.252.164.12',	1602299322),
(1245,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.234.123.96',	1602300573),
(1246,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'35.234.123.96',	1602300574),
(1247,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'133.130.74.241',	1602301286),
(1248,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'65.0.83.192',	1602302114),
(1249,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'188.208.140.21',	1602303776),
(1250,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'188.208.140.21',	1602303778),
(1251,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'18.207.130.59',	1602306477),
(1252,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'206.189.102.108',	1602307313),
(1253,	'guest',	'deleted',	'Post',	'customize_changeset',	'(ללא כותרת)',	167,	0,	'31.168.11.69',	1602334541),
(1254,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'69.163.169.133',	1602413809),
(1255,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.89.116.255',	1602416035),
(1256,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'159.89.116.255',	1602416043),
(1257,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'134.122.78.89',	1602417067),
(1258,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'134.122.78.89',	1602417068),
(1259,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.247.42.6',	1602421669),
(1260,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'35.247.42.6',	1602421671),
(1261,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'195.154.225.16',	1602421883),
(1262,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'195.154.225.16',	1602421884),
(1263,	'guest',	'logged_in',	'User',	'',	'admin',	1,	1,	'79.176.72.202',	1602425808),
(1264,	'administrator',	'downloaded',	'Export',	'',	'all',	0,	1,	'79.176.72.202',	1602426102),
(1265,	'administrator',	'installed',	'Plugin',	'1.16.29',	'UpdraftPlus - Backup/Restore',	0,	1,	'79.176.72.202',	1602427400),
(1266,	'administrator',	'activated',	'Plugin',	'',	'UpdraftPlus - Backup/Restore',	0,	1,	'79.176.72.202',	1602427635),
(1267,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'54.38.78.181',	1602428908),
(1268,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'5.189.148.149',	1602428972),
(1269,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'62.210.142.107',	1602432449),
(1270,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'157.230.118.118',	1602432708),
(1271,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'192.99.7.106',	1602435282),
(1272,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.198.172.68',	1602440523),
(1273,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'65.0.83.192',	1602441311),
(1274,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'65.0.83.192',	1602441312),
(1275,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'198.57.197.57',	1602443204),
(1276,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'198.57.197.57',	1602443211),
(1277,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'149.255.58.34',	1602443948),
(1278,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'142.93.226.235',	1602446683),
(1279,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'69.163.197.8',	1602449414),
(1280,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'206.189.121.29',	1602453237),
(1281,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'23.101.123.2',	1602454134),
(1282,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'143.110.180.118',	1602456875),
(1283,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'54.38.65.127',	1602458168),
(1284,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'50.21.179.145',	1602458873),
(1285,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'50.21.179.145',	1602458875),
(1286,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'74.208.235.136',	1602463059),
(1287,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'74.208.235.136',	1602463066),
(1288,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'142.93.143.85',	1602463347),
(1289,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'195.2.84.220',	1602464481),
(1290,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'206.189.136.172',	1602468904),
(1291,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'134.122.72.53',	1602471187),
(1292,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'158.177.123.152',	1602476783),
(1293,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'158.177.123.152',	1602476784),
(1294,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.156.229.165',	1602476913),
(1295,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'69.163.197.8',	1602492096),
(1296,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'69.163.197.8',	1602492097),
(1297,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'128.199.21.230',	1602501442),
(1298,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'128.199.21.230',	1602501449),
(1299,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'138.197.146.132',	1602503601),
(1300,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'138.197.146.132',	1602503602),
(1301,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.204.172.12',	1602504722),
(1302,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'35.204.172.12',	1602504723),
(1303,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'157.230.96.179',	1602505789),
(1304,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.203.98.228',	1602507012),
(1305,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'62.210.113.228',	1602517906),
(1306,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.153.133',	1602522767),
(1307,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.203.98.228',	1602526669),
(1308,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'159.203.98.228',	1602526676),
(1309,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.203.105.90',	1602527455),
(1310,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'159.203.105.90',	1602527456),
(1311,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'154.17.1.210',	1602528454),
(1312,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'154.17.1.210',	1602528456),
(1313,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'54.36.40.175',	1602528630),
(1314,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'134.122.78.89',	1602532359),
(1315,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'69.163.169.133',	1602534233),
(1316,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.198.172.68',	1602537011),
(1317,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.33.222',	1602537988),
(1318,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.101.146.6',	1602546919),
(1319,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'161.35.41.208',	1602547951),
(1320,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.89.99.68',	1602549085),
(1321,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.89.123.66',	1602550226),
(1322,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'49.50.250.83',	1602551212),
(1323,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.182.181.154',	1602552267),
(1324,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'209.97.180.47',	1602554557),
(1325,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'206.81.16.252',	1602560191),
(1326,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.23.28',	1602564358),
(1327,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.189.223.35',	1602566279),
(1328,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'5.39.82.14',	1602568898),
(1329,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.89.162.217',	1602574325),
(1330,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.106.199.158',	1602575154),
(1331,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'161.35.41.208',	1602577413),
(1332,	'guest',	'deleted',	'Post',	'customize_changeset',	'(ללא כותרת)',	208,	0,	'31.168.11.69',	1602593873),
(1333,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.116.132.197',	1602601849),
(1334,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'206.189.121.29',	1602605305),
(1335,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.33.222',	1602608676),
(1336,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'182.74.99.186',	1602611508),
(1337,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'157.245.42.253',	1602615125),
(1338,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'157.245.42.253',	1602615126),
(1339,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.106.254.109',	1602619626),
(1340,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'34.106.254.109',	1602619628),
(1341,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'64.227.111.211',	1602620605),
(1342,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'64.227.111.211',	1602620607),
(1343,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'146.185.163.81',	1602621566),
(1344,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'146.185.163.81',	1602621567),
(1345,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'146.185.163.81',	1602622541),
(1346,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'146.185.163.81',	1602622542),
(1347,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'5.39.82.14',	1602623523),
(1348,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'5.39.82.14',	1602623524),
(1349,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.106.93.46',	1602627792),
(1350,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'182.74.99.186',	1602630894),
(1351,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'182.74.99.186',	1602630897),
(1352,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.224.216.78',	1602631938),
(1353,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.147.218',	1602632905),
(1354,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'139.59.147.218',	1602632906),
(1355,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'188.166.36.93',	1602633928),
(1356,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.248.172.238',	1602634999),
(1357,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.224.216.78',	1602645934),
(1358,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'35.224.216.78',	1602645936),
(1359,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'142.93.35.169',	1602648033),
(1360,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'157.230.27.30',	1602650905),
(1361,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.23.28',	1602653608),
(1362,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.131.12.67',	1602658041),
(1363,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'206.189.136.172',	1602659883),
(1364,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'5.39.82.14',	1602662732),
(1365,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'5.39.82.14',	1602662733),
(1366,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'64.225.67.97',	1602668703),
(1367,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'64.225.67.97',	1602668704),
(1368,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.68.19.126',	1602671902),
(1369,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'51.68.19.126',	1602671903),
(1370,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.248.29.200',	1602676159),
(1371,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.131.142.224',	1602680551),
(1372,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'5.39.74.233',	1602965447),
(1373,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'138.197.135.102',	1602967490),
(1374,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'198.211.107.194',	1602968118),
(1375,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'187.188.25.187',	1602970298),
(1376,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'138.197.179.94',	1602970952),
(1377,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'154.0.170.4',	1602973749),
(1378,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'154.0.170.4',	1602973758),
(1379,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'151.80.212.71',	1602982271),
(1380,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'157.230.118.118',	1602982534),
(1381,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'95.110.129.91',	1602984038),
(1382,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'134.122.94.113',	1602987812),
(1383,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'142.93.182.7',	1602992234),
(1384,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'142.93.182.7',	1602992237),
(1385,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'142.93.66.165',	1602994582),
(1386,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'142.93.66.165',	1602994584),
(1387,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.76.138',	1602995931),
(1388,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'178.62.76.138',	1602995933),
(1389,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'54.37.179.248',	1602997332),
(1390,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.172.56.36',	1603003336),
(1391,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'167.172.56.36',	1603003337),
(1392,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'138.197.179.94',	1603005261),
(1393,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'138.197.179.94',	1603005262),
(1394,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'145.239.29.217',	1603006668),
(1395,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'163.172.32.190',	1603012889),
(1396,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.189.223.35',	1603017769),
(1397,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'15.223.81.60',	1603018172),
(1398,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'112.196.72.188',	1603019939),
(1399,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'198.12.229.7',	1603026627),
(1400,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'5.39.74.233',	1603028038),
(1401,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'206.81.16.252',	1603030267),
(1402,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'213.32.95.146',	1603030769),
(1403,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.114.152.170',	1603033999),
(1404,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'165.22.209.132',	1603035516),
(1405,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.101.120.8',	1603035879),
(1406,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.71.104.1',	1603037472),
(1407,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'167.71.104.1',	1603037473),
(1408,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'173.212.244.135',	1603039433),
(1409,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'173.212.244.135',	1603039434),
(1410,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.93.234.254',	1603039873),
(1411,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'34.93.234.254',	1603039877),
(1412,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.153.133',	1603041888),
(1413,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'206.189.125.96',	1603045524),
(1414,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'146.59.130.120',	1603045972),
(1415,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'157.245.106.153',	1603051037),
(1416,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.1.145',	1603073599),
(1417,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'178.62.1.145',	1603073600),
(1418,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.81.68',	1603079850),
(1419,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'145.239.29.217',	1603081898),
(1420,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'165.22.35.21',	1603084003),
(1421,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.79.100.13',	1603091485),
(1422,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'51.79.100.13',	1603091486),
(1423,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.128.39.211',	1603093088),
(1424,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'178.128.39.211',	1603093094),
(1425,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'198.211.117.96',	1603093773),
(1426,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.68.45.227',	1603096069),
(1427,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'157.245.5.133',	1603099370),
(1428,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'142.93.35.169',	1603101799),
(1429,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'163.172.32.190',	1603103468),
(1430,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.85.41',	1603105091),
(1431,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'138.197.146.132',	1603107658),
(1432,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'138.197.146.132',	1603107659),
(1433,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.131.12.67',	1603113503),
(1434,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'104.131.12.67',	1603113505),
(1435,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.203.20.254',	1603118035),
(1436,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.89.99.68',	1603133204),
(1437,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'145.239.69.74',	1603134766),
(1438,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.101.246.76',	1603141051),
(1439,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.50.212',	1603149973),
(1440,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'209.97.180.47',	1603151515),
(1441,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.38.47.79',	1603153022),
(1442,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'52.170.46.39',	1603159917),
(1443,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.71.45.35',	1603160693),
(1444,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.203.98.228',	1603163415),
(1445,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'142.93.99.56',	1603164359),
(1446,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.203.44.244',	1603178629),
(1447,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.101.132.88',	1603182634),
(1448,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.89.124.170',	1603207219),
(1449,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'188.165.228.82',	1603211705),
(1450,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'13.74.158.85',	1603233578),
(1451,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'149.202.8.66',	1603260339),
(1452,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'15.223.81.60',	1603278578),
(1453,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.71.46.185',	1603291383),
(1454,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'154.0.170.4',	1603306710),
(1455,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.148.41.11',	1603314663),
(1456,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.15.214.14',	1603351195),
(1457,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'51.15.214.14',	1603351196),
(1458,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.229.135.66',	1603361117),
(1459,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'138.197.131.66',	1603367396),
(1460,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'192.99.212.104',	1603377968),
(1461,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.43.196',	1603378836),
(1462,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'198.12.229.7',	1603383176),
(1463,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.248.47.82',	1603384055),
(1464,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'142.93.44.20',	1603384811),
(1465,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'3.113.227.62',	1603387110),
(1466,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'3.113.227.62',	1603387112),
(1467,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'52.72.187.87',	1603388313),
(1468,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'52.72.187.87',	1603388315),
(1469,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'144.91.126.211',	1603389907),
(1470,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.30.190',	1603390408),
(1471,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'18.222.161.154',	1603391406),
(1472,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'142.93.152.19',	1603392928),
(1473,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'13.53.135.219',	1603394378),
(1474,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'182.73.145.150',	1603397402),
(1475,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'207.180.230.40',	1603402935),
(1476,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'207.180.230.40',	1603402937),
(1477,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'213.149.103.132',	1603406710),
(1478,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'182.73.145.150',	1603410695),
(1479,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'161.35.154.24',	1603413038),
(1480,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'142.93.35.169',	1603417757),
(1481,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'3.23.222.10',	1603418973),
(1482,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'89.17.195.14',	1603420028),
(1483,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'66.70.160.187',	1603421878),
(1484,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'95.183.8.59',	1603424592),
(1485,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.83.198.113',	1603426299),
(1486,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.101.146.216',	1603426740),
(1487,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.113.189',	1603428798),
(1488,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.89.14',	1603429333),
(1489,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'93.114.184.8',	1603431808),
(1490,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'3.23.222.10',	1603433321),
(1491,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'93.189.27.197',	1603435445),
(1492,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.78.248',	1603436629),
(1493,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'52.72.187.87',	1603437627),
(1494,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'163.172.251.59',	1603438214),
(1495,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'213.149.103.132',	1603439103),
(1496,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.89.14',	1603446314),
(1497,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'178.62.89.14',	1603446315),
(1498,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'207.180.221.169',	1603453730),
(1499,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.99.179.192',	1603465257),
(1500,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'167.99.179.192',	1603465259),
(1501,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'161.35.158.191',	1603469866),
(1502,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'62.210.75.68',	1603476157),
(1503,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'207.180.221.169',	1603479561),
(1504,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.248.94.25',	1603479958),
(1505,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'208.113.181.161',	1603480572),
(1506,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'157.230.118.118',	1603481744),
(1507,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.99.179.192',	1603482795),
(1508,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'207.180.221.169',	1603487204),
(1509,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'54.148.165.18',	1603488931),
(1510,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.248.94.25',	1603490046),
(1511,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'54.37.130.135',	1603491722),
(1512,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'80.211.246.60',	1603493650),
(1513,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'193.70.81.132',	1603494822),
(1514,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.242.214.242',	1603507985),
(1515,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.86.133.132',	1603512206),
(1516,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'34.86.133.132',	1603512208),
(1517,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'134.209.147.203',	1603512283),
(1518,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'134.209.147.203',	1603512289),
(1519,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'163.172.42.173',	1603512960),
(1520,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'163.172.42.173',	1603512962),
(1521,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'161.35.170.157',	1603517077),
(1522,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.74.68.200',	1603518498),
(1523,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'192.99.212.104',	1603518778),
(1524,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'142.93.182.7',	1603519148),
(1525,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.106.43.33',	1603520017),
(1526,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'34.106.43.33',	1603520018),
(1527,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'142.93.34.169',	1603521231),
(1528,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'142.93.34.169',	1603521232),
(1529,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'153.127.67.228',	1603522119),
(1530,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'153.127.67.228',	1603522121),
(1531,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'95.128.47.91',	1603524469),
(1532,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'95.128.47.91',	1603524470),
(1533,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'185.57.152.70',	1603525382),
(1534,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'188.166.60.138',	1603526674),
(1535,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'188.166.60.138',	1603526675),
(1536,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'192.99.11.48',	1603529078),
(1537,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.99.179.192',	1603541683),
(1538,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.89.1.19',	1603542622),
(1539,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.239.120.114',	1603542947),
(1540,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'35.239.120.114',	1603542948),
(1541,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'157.245.91.33',	1603545607),
(1542,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'213.149.103.132',	1603546961),
(1543,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.255.216.24',	1603547628),
(1544,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'116.203.176.153',	1603548419),
(1545,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'85.220.155.250',	1603549769),
(1546,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'91.250.113.132',	1603553224),
(1547,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.71.53.185',	1603554613),
(1548,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'62.210.75.68',	1603556014),
(1549,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'64.227.78.218',	1603559739),
(1550,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.89.14',	1603562269),
(1551,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'128.199.21.230',	1603562886),
(1552,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'45.77.188.138',	1603565475),
(1553,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'69.163.169.133',	1603567832),
(1554,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'69.163.169.133',	1603567834),
(1555,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'18.133.71.155',	1603569950),
(1556,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'18.133.71.155',	1603569951),
(1557,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'138.197.131.66',	1603571776),
(1558,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.89.9.140',	1603574587),
(1559,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'188.166.60.138',	1603576158),
(1560,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'188.166.60.138',	1603576165),
(1561,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.101.228.94',	1603577386),
(1562,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'46.101.228.94',	1603577387),
(1563,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'138.197.131.66',	1603578628),
(1564,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'138.197.131.66',	1603578632),
(1565,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.30.190',	1603579284),
(1566,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.15.214.14',	1603581982),
(1567,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'51.15.214.14',	1603581983),
(1568,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.201.200.134',	1603587162),
(1569,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.131.142.224',	1603588160),
(1570,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'116.203.58.206',	1603588453),
(1571,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'142.93.182.7',	1603589933),
(1572,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.131.180.26',	1603592873),
(1573,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'104.131.180.26',	1603592875),
(1574,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'142.93.153.126',	1603593607),
(1575,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'142.93.153.126',	1603593614),
(1576,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'190.218.146.69',	1603594175),
(1577,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'190.218.146.69',	1603594177),
(1578,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'142.93.152.19',	1603595222),
(1579,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'142.93.152.19',	1603595224),
(1580,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.203.37.43',	1603597298),
(1581,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.128.230.35',	1603687301),
(1582,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'178.128.230.35',	1603687305),
(1583,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'134.209.147.203',	1603692643),
(1584,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.71.53.185',	1603696434),
(1585,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.43.196',	1603701559),
(1586,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'139.59.43.196',	1603701560),
(1587,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'41.93.82.7',	1603704604),
(1588,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'41.93.82.7',	1603704606),
(1589,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'192.241.199.202',	1603706370),
(1590,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'216.104.160.88',	1603706930),
(1591,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'209.97.180.47',	1603708626),
(1592,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'209.97.180.47',	1603708627),
(1593,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.225.214.232',	1603715010),
(1594,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'144.91.126.211',	1603715609),
(1595,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'145.239.142.148',	1603727428),
(1596,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'164.132.48.179',	1603730657),
(1597,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'54.38.65.127',	1603733044),
(1598,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'154.0.173.95',	1603734693),
(1599,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'209.178.59.140',	1603735141),
(1600,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.255.216.24',	1603738432),
(1601,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.99.179.192',	1603741684),
(1602,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'62.210.75.68',	1603746488),
(1603,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.65.184.79',	1603747487),
(1604,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.203.37.43',	1603748927),
(1605,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'159.203.37.43',	1603748928),
(1606,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'75.223.147.81',	1603748931),
(1607,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.222.31.20',	1603749418),
(1608,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'134.122.72.53',	1603749948),
(1609,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'199.192.16.113',	1603753082),
(1610,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'199.192.16.113',	1603753084),
(1611,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'80.211.139.155',	1603756285),
(1612,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.79.85.154',	1603756807),
(1613,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'54.38.78.181',	1603758912),
(1614,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.204.172.12',	1603761185),
(1615,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'151.80.45.51',	1603762311),
(1616,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.101.228.94',	1603764764),
(1617,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'134.122.69.140',	1603765323),
(1618,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'134.122.69.140',	1603765329),
(1619,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'148.216.1.174',	1603767386),
(1620,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.255.170.64',	1603897037),
(1621,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'51.255.170.64',	1603897039),
(1622,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'216.198.69.163',	1603897227),
(1623,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'163.172.90.175',	1603897669),
(1624,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'198.100.144.225',	1603897807),
(1625,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'209.97.187.35',	1603898700),
(1626,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'54.90.65.247',	1603899247),
(1627,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'185.229.114.248',	1603899506),
(1628,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.89.191.107',	1603899890),
(1629,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'199.192.27.161',	1603900249),
(1630,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'45.55.145.34',	1603900555),
(1631,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'207.180.227.49',	1603900901),
(1632,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'44.228.91.252',	1603901094),
(1633,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.234.123.96',	1603901288),
(1634,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'35.234.123.96',	1603901290),
(1635,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'133.18.68.53',	1603902009),
(1636,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'155.138.163.194',	1603902315),
(1637,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.128.34.135',	1603902892),
(1638,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'88.218.17.100',	1603903262),
(1639,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'31.220.104.7',	1603903541),
(1640,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'128.199.26.118',	1603903799),
(1641,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'44.228.91.252',	1603903952),
(1642,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'74.208.230.40',	1603904118),
(1643,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'185.28.21.196',	1603904303),
(1644,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.125.108.111',	1603904519),
(1645,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.89.191.107',	1603904898),
(1646,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'18.214.157.142',	1603905385),
(1647,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'138.197.1.150',	1603905568),
(1648,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'92.61.46.229',	1603906950),
(1649,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'52.147.213.76',	1603907895),
(1650,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'84.88.172.160',	1603908118),
(1651,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'162.241.87.45',	1603908179),
(1652,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.77.73',	1603908769),
(1653,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.86.201',	1603909029),
(1654,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'199.192.27.161',	1603910049),
(1655,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.131.53.18',	1603910265),
(1656,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.192.73.146',	1603910614),
(1657,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'146.185.141.95',	1603911376),
(1658,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'75.126.35.88',	1603911633),
(1659,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.101.221.37',	1603911820),
(1660,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'188.208.140.21',	1603912525),
(1661,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.192.73.146',	1603913039),
(1662,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'35.192.73.146',	1603913041),
(1663,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'95.179.190.255',	1603913597),
(1664,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.86.47',	1603915555),
(1665,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.38.107.237',	1603915713),
(1666,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'162.241.87.45',	1603916094),
(1667,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'81.19.215.19',	1603917543),
(1668,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'81.19.215.19',	1603917545),
(1669,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'136.144.170.246',	1603918307),
(1670,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'194.245.154.173',	1603918986),
(1671,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'31.220.104.17',	1603919554),
(1672,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'143.110.148.180',	1603919960),
(1673,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.230.127.50',	1603920263),
(1674,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'185.229.114.248',	1603921550),
(1675,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.65.145.69',	1603922480),
(1676,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'45.15.26.63',	1603923197),
(1677,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'85.128.142.142',	1603925407),
(1678,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'18.214.157.142',	1603926004),
(1679,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'3.133.121.246',	1603927295),
(1680,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'213.136.93.170',	1603927408),
(1681,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.99.129.0',	1603928328),
(1682,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'213.154.245.250',	1603928531),
(1683,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'52.166.164.170',	1603929072),
(1684,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'136.144.170.246',	1603929789),
(1685,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'54.90.65.247',	1603930238),
(1686,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'134.119.204.82',	1603930358),
(1687,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'103.140.132.16',	1603930577),
(1688,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'134.209.148.6',	1603931469),
(1689,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'3.135.65.187',	1603931718),
(1690,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'196.41.123.66',	1603931869),
(1691,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'196.41.123.66',	1603931872),
(1692,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.89.108.7',	1603932013),
(1693,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'88.218.17.100',	1603932258),
(1694,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'186.121.251.3',	1603933109),
(1695,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'103.140.132.16',	1603934118),
(1696,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'213.136.93.170',	1603934214),
(1697,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.77.73',	1603934644),
(1698,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.77.73',	1603935326),
(1699,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'195.154.225.16',	1603936268),
(1700,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'95.179.190.255',	1603936435),
(1701,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'190.96.172.101',	1603936678),
(1702,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'122.170.8.212',	1603937216),
(1703,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'103.140.132.16',	1603937662),
(1704,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'198.211.122.201',	1603938885),
(1705,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'163.172.90.175',	1603939345),
(1706,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.101.221.37',	1603939679),
(1707,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.243.185.122',	1603940257),
(1708,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'34.243.185.122',	1603940258),
(1709,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'185.28.21.189',	1603940450),
(1710,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'138.68.174.205',	1603941049),
(1711,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.38.49.5',	1603941370),
(1712,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'91.134.248.249',	1603942714),
(1713,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'185.199.223.64',	1603942927),
(1714,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'128.199.26.38',	1603943356),
(1715,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.172.225.121',	1603943546),
(1716,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'163.172.165.74',	1603943945),
(1717,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.234.123.96',	1603944333),
(1718,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'172.105.81.29',	1603944515),
(1719,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.99.56.138',	1603945366),
(1720,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.185.138.134',	1603945897),
(1721,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'85.128.142.142',	1603946372),
(1722,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'85.128.142.142',	1603946374),
(1723,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.77.26',	1603946992),
(1724,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.101.237.219',	1603947551),
(1725,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.89.116.255',	1604000714),
(1726,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.91.123.235',	1604003058),
(1727,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'163.172.42.123',	1604005177),
(1728,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'198.12.253.113',	1604007690),
(1729,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.204.172.12',	1604011591),
(1730,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.222.31.20',	1604013312),
(1731,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.116.132.197',	1604019854),
(1732,	'guest',	'updated',	'Core',	'',	'WordPress Auto Updated',	0,	0,	'31.168.11.69',	1604019894),
(1733,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.225.94.95',	1604020271),
(1734,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.75.53.141',	1604021366),
(1735,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'111.92.240.206',	1604021614),
(1736,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'176.31.54.244',	1604027781),
(1737,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.79.100.13',	1604028769),
(1738,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'79.137.77.213',	1604029910),
(1739,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'149.28.227.88',	1604033090),
(1740,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.125.63.10',	1604033784),
(1741,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.94.247.253',	1604034946),
(1742,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.68.229.177',	1604036464),
(1743,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'196.50.13.218',	1604037328),
(1744,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'54.39.152.32',	1604042136),
(1745,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'157.230.118.118',	1604044292),
(1746,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'3.18.134.81',	1604045951),
(1747,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'13.74.252.234',	1604046946),
(1748,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.70.198.5',	1604048942),
(1749,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'134.209.87.245',	1604049317),
(1750,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'54.36.181.100',	1604049959),
(1751,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'209.97.138.97',	1604052256),
(1752,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'209.97.138.97',	1604053363),
(1753,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.203.98.228',	1604058432),
(1754,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.15.214.14',	1604061979),
(1755,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'145.239.29.217',	1604065648),
(1756,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'198.12.253.113',	1604067842),
(1757,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.65.184.79',	1604070454),
(1758,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'134.122.44.174',	1604070826),
(1759,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'164.132.224.68',	1604073204),
(1760,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'134.209.147.203',	1604076424),
(1761,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.203.105.90',	1604077553),
(1762,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'46.101.139.73',	1604085270),
(1763,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'23.29.80.56',	1604086947),
(1764,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'161.35.170.157',	1604087933),
(1765,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'107.180.227.163',	1604089853),
(1766,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.94.247.253',	1604091887),
(1767,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'34.94.247.253',	1604091889),
(1768,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.75.53.141',	1604096312),
(1769,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.68.229.177',	1604097091),
(1770,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'198.12.253.113',	1604100324),
(1771,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.147.218',	1604103699),
(1772,	'guest',	'updated',	'Core',	'',	'WordPress Auto Updated',	0,	0,	'31.168.11.69',	1604106418),
(1773,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.230.162.59',	1604109336),
(1774,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'35.230.162.59',	1604109339),
(1775,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.131.57.95',	1604111877),
(1776,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'104.131.57.95',	1604111878),
(1777,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.125.63.10',	1604115420),
(1778,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'34.125.63.10',	1604115423),
(1779,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'148.216.1.174',	1604119037),
(1780,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'176.31.54.244',	1604119859),
(1781,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'157.245.220.153',	1604121005),
(1782,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.101.107',	1604121291),
(1783,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.131.12.67',	1604124208),
(1784,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.200.180.182',	1604128804),
(1785,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'139.59.77.43',	1604129420),
(1786,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'206.189.136.172',	1604129595),
(1787,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.245.32.206',	1604131277),
(1788,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'2.113.24.10',	1604132366),
(1789,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'209.97.138.97',	1604132545),
(1790,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'134.209.87.245',	1604136548),
(1791,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'167.71.140.30',	1604137721),
(1792,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.15.214.14',	1604144837),
(1793,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'64.227.101.139',	1604146165),
(1794,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'34.70.191.44',	1604148115),
(1795,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'34.70.191.44',	1604148125),
(1796,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'154.0.174.150',	1604148407),
(1797,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'154.0.174.150',	1604148414),
(1798,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.131.12.67',	1604149371),
(1799,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'104.131.12.67',	1604149373),
(1800,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'51.91.123.235',	1604153467),
(1801,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'51.91.123.235',	1604153468),
(1802,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'173.212.244.135',	1604153786),
(1803,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'173.212.244.135',	1604153787),
(1804,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'54.38.188.35',	1604154661),
(1805,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'54.38.188.35',	1604154663),
(1806,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'104.236.45.171',	1604155839),
(1807,	'guest',	'wrong_password',	'User',	'',	'[login]',	0,	0,	'104.236.45.171',	1604155845),
(1808,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'35.230.162.59',	1604157310),
(1809,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'52.214.110.3',	1604165139),
(1810,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'158.51.124.112',	1604165407),
(1811,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.62.9.122',	1604166156),
(1812,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'178.128.230.35',	1604167425),
(1813,	'guest',	'wrong_password',	'User',	'',	'admin',	0,	0,	'159.203.105.90',	1604168331),
(1814,	'guest',	'logged_in',	'User',	'',	'admin',	1,	1,	'5.29.205.209',	1604238848),
(1815,	'guest',	'logged_in',	'User',	'',	'admin',	1,	1,	'31.154.69.220',	1604251252),
(1816,	'administrator',	'installed',	'Plugin',	'1.3.38',	'Duplicator',	0,	1,	'31.154.69.220',	1604251410),
(1817,	'administrator',	'activated',	'Plugin',	'',	'Duplicator',	0,	1,	'31.154.69.220',	1604251431),
(1818,	'administrator',	'installed',	'Plugin',	'3.6',	'File Manager Advanced',	0,	1,	'31.154.69.220',	1604251776),
(1819,	'administrator',	'activated',	'Plugin',	'',	'File Manager Advanced',	0,	1,	'31.154.69.220',	1604251784);

DROP TABLE IF EXISTS `wpqf_commentmeta`;
CREATE TABLE `wpqf_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `wpqf_comments`;
CREATE TABLE `wpqf_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wpqf_comments` (`comment_ID`, `comment_post_ID`, `comment_author`, `comment_author_email`, `comment_author_url`, `comment_author_IP`, `comment_date`, `comment_date_gmt`, `comment_content`, `comment_karma`, `comment_approved`, `comment_agent`, `comment_type`, `comment_parent`, `user_id`) VALUES
(1,	1,	'A WordPress Commenter',	'wapuu@wordpress.example',	'https://wordpress.org/',	'',	'2020-08-30 12:37:19',	'2020-08-30 12:37:19',	'Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.',	0,	'1',	'',	'comment',	0,	0);

DROP TABLE IF EXISTS `wpqf_duplicator_packages`;
CREATE TABLE `wpqf_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `wpqf_links`;
CREATE TABLE `wpqf_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `wpqf_options`;
CREATE TABLE `wpqf_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wpqf_options` (`option_id`, `option_name`, `option_value`, `autoload`) VALUES
(1,	'siteurl',	'https://snapir-swim.co.il',	'yes'),
(2,	'home',	'https://snapir-swim.co.il',	'yes'),
(3,	'blogname',	'סנפיר',	'yes'),
(4,	'blogdescription',	'בית ספר לשחייה',	'yes'),
(5,	'users_can_register',	'0',	'yes'),
(6,	'admin_email',	'shai@snapirswimming.org.il',	'yes'),
(7,	'start_of_week',	'1',	'yes'),
(8,	'use_balanceTags',	'0',	'yes'),
(9,	'use_smilies',	'1',	'yes'),
(10,	'require_name_email',	'1',	'yes'),
(11,	'comments_notify',	'1',	'yes'),
(12,	'posts_per_rss',	'10',	'yes'),
(13,	'rss_use_excerpt',	'0',	'yes'),
(14,	'mailserver_url',	'mail.example.com',	'yes'),
(15,	'mailserver_login',	'login@example.com',	'yes'),
(16,	'mailserver_pass',	'password',	'yes'),
(17,	'mailserver_port',	'110',	'yes'),
(18,	'default_category',	'1',	'yes'),
(19,	'default_comment_status',	'open',	'yes'),
(20,	'default_ping_status',	'open',	'yes'),
(21,	'default_pingback_flag',	'1',	'yes'),
(22,	'posts_per_page',	'10',	'yes'),
(23,	'date_format',	'F j, Y',	'yes'),
(24,	'time_format',	'g:i a',	'yes'),
(25,	'links_updated_date_format',	'F j, Y g:i a',	'yes'),
(26,	'comment_moderation',	'0',	'yes'),
(27,	'moderation_notify',	'1',	'yes'),
(28,	'permalink_structure',	'/%year%/%monthnum%/%day%/%postname%/',	'yes'),
(29,	'rewrite_rules',	'a:164:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:13:\"חנות-2/?$\";s:27:\"index.php?post_type=product\";s:43:\"חנות-2/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:38:\"חנות-2/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:30:\"חנות-2/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=11&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:62:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc-api(/(.*))?/?$\";s:99:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc-api=$matches[6]\";s:62:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:73:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}',	'yes'),
(30,	'hack_file',	'0',	'yes'),
(31,	'blog_charset',	'UTF-8',	'yes'),
(32,	'moderation_keys',	'',	'no'),
(33,	'active_plugins',	'a:16:{i:0;s:39:\"aryo-activity-log/aryo-activity-log.php\";i:1;s:39:\"crocoblock-wizard/crocoblock-wizard.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:31:\"elementor-pro/elementor-pro.php\";i:4;s:23:\"elementor/elementor.php\";i:5;s:47:\"file-manager-advanced/file_manager_advanced.php\";i:6;s:29:\"jet-elements/jet-elements.php\";i:7;s:41:\"pojo-accessibility/pojo-accessibility.php\";i:8;s:39:\"pojo-custom-fonts/pojo-custom-fonts.php\";i:9;s:25:\"pojo-forms/pojo-forms.php\";i:10;s:31:\"pojo-importer/pojo-importer.php\";i:11;s:31:\"pojo-lightbox/pojo-lightbox.php\";i:12;s:37:\"pojo-news-ticker/pojo-news-ticker.php\";i:13;s:31:\"pojo-sidebars/pojo-sidebars.php\";i:14;s:27:\"updraftplus/updraftplus.php\";i:15;s:27:\"woocommerce/woocommerce.php\";}',	'yes'),
(34,	'category_base',	'',	'yes'),
(35,	'ping_sites',	'http://rpc.pingomatic.com/',	'yes'),
(36,	'comment_max_links',	'2',	'yes'),
(37,	'gmt_offset',	'0',	'yes'),
(38,	'default_email_category',	'1',	'yes'),
(39,	'recently_edited',	'',	'no'),
(40,	'template',	'hello-elementor',	'yes'),
(41,	'stylesheet',	'hello-theme-child-master',	'yes'),
(42,	'comment_registration',	'0',	'yes'),
(43,	'html_type',	'text/html',	'yes'),
(44,	'use_trackback',	'0',	'yes'),
(45,	'default_role',	'subscriber',	'yes'),
(46,	'db_version',	'48748',	'yes'),
(47,	'uploads_use_yearmonth_folders',	'1',	'yes'),
(48,	'upload_path',	'',	'yes'),
(49,	'blog_public',	'1',	'yes'),
(50,	'default_link_category',	'2',	'yes'),
(51,	'show_on_front',	'page',	'yes'),
(52,	'tag_base',	'',	'yes'),
(53,	'show_avatars',	'1',	'yes'),
(54,	'avatar_rating',	'G',	'yes'),
(55,	'upload_url_path',	'',	'yes'),
(56,	'thumbnail_size_w',	'150',	'yes'),
(57,	'thumbnail_size_h',	'150',	'yes'),
(58,	'thumbnail_crop',	'1',	'yes'),
(59,	'medium_size_w',	'300',	'yes'),
(60,	'medium_size_h',	'300',	'yes'),
(61,	'avatar_default',	'mystery',	'yes'),
(62,	'large_size_w',	'1024',	'yes'),
(63,	'large_size_h',	'1024',	'yes'),
(64,	'image_default_link_type',	'none',	'yes'),
(65,	'image_default_size',	'',	'yes'),
(66,	'image_default_align',	'',	'yes'),
(67,	'close_comments_for_old_posts',	'0',	'yes'),
(68,	'close_comments_days_old',	'14',	'yes'),
(69,	'thread_comments',	'1',	'yes'),
(70,	'thread_comments_depth',	'5',	'yes'),
(71,	'page_comments',	'0',	'yes'),
(72,	'comments_per_page',	'50',	'yes'),
(73,	'default_comments_page',	'newest',	'yes'),
(74,	'comment_order',	'asc',	'yes'),
(75,	'sticky_posts',	'a:0:{}',	'yes'),
(76,	'widget_categories',	'a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}',	'yes'),
(77,	'widget_text',	'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}',	'yes'),
(78,	'widget_rss',	'a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}',	'yes'),
(79,	'uninstall_plugins',	'a:2:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:39:\"aryo-activity-log/aryo-activity-log.php\";a:2:{i:0;s:15:\"AAL_Maintenance\";i:1;s:9:\"uninstall\";}}',	'no'),
(80,	'timezone_string',	'',	'yes'),
(81,	'page_for_posts',	'0',	'yes'),
(82,	'page_on_front',	'11',	'yes'),
(83,	'default_post_format',	'0',	'yes'),
(84,	'link_manager_enabled',	'0',	'yes'),
(85,	'finished_splitting_shared_terms',	'1',	'yes'),
(86,	'site_icon',	'10',	'yes'),
(87,	'medium_large_size_w',	'768',	'yes'),
(88,	'medium_large_size_h',	'0',	'yes'),
(89,	'wp_page_for_privacy_policy',	'3',	'yes'),
(90,	'show_comments_cookies_opt_in',	'1',	'yes'),
(91,	'admin_email_lifespan',	'1614343039',	'yes'),
(92,	'disallowed_keys',	'',	'no'),
(93,	'comment_previously_approved',	'1',	'yes'),
(94,	'auto_plugin_theme_update_emails',	'a:0:{}',	'no'),
(95,	'initial_db_version',	'48748',	'yes'),
(96,	'wpqf_user_roles',	'a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:115:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:26:\"view_all_aryo_activity_log\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}',	'yes'),
(97,	'fresh_site',	'0',	'yes'),
(98,	'widget_search',	'a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}',	'yes'),
(99,	'widget_recent-posts',	'a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}',	'yes'),
(100,	'widget_recent-comments',	'a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}',	'yes'),
(101,	'widget_archives',	'a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}',	'yes'),
(102,	'widget_meta',	'a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}',	'yes'),
(103,	'sidebars_widgets',	'a:2:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:13:\"array_version\";i:3;}',	'yes'),
(104,	'cron',	'a:16:{i:1604252401;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1604253365;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1604254474;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1604254481;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1604255841;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1604275200;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1604275682;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1604277439;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1604297292;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1604301274;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1604308082;a:1:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1604320639;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1604320891;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1604320893;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1604902142;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}',	'yes'),
(105,	'widget_pages',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(106,	'widget_calendar',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(107,	'widget_media_audio',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(108,	'widget_media_image',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(109,	'widget_media_gallery',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(110,	'widget_media_video',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(111,	'widget_tag_cloud',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(112,	'widget_nav_menu',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(113,	'widget_custom_html',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(115,	'recovery_keys',	'a:0:{}',	'yes'),
(116,	'theme_mods_twentytwenty',	'a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1598791302;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}',	'yes'),
(198,	'elementor_log',	'a:16:{s:32:\"91d37e3b2958b001362af789f64a95ee\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 13:15:51\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 13:15:51\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"76903900a134d7866700da371566ce51\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 13:15:51\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:70:\"אלמנטור/Upgrades - _v_3_0_0_move_general_settings_to_kit Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 13:15:51\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:70:\"אלמנטור/Upgrades - _v_3_0_0_move_general_settings_to_kit Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"426ebb31ff3c9eea422f66aa18a34771\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 13:15:51\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:72:\"אלמנטור/Upgrades - _v_3_0_0_move_general_settings_to_kit Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 13:15:51\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:72:\"אלמנטור/Upgrades - _v_3_0_0_move_general_settings_to_kit Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"89b01a3a84515f55314865abf60eb5a7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 13:15:51\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:68:\"אלמנטור/Upgrades - _v_3_0_0_move_default_colors_to_kit Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 13:15:51\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:68:\"אלמנטור/Upgrades - _v_3_0_0_move_default_colors_to_kit Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"b4e043e2b19ec855108d523628c2c59f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 13:15:51\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:70:\"אלמנטור/Upgrades - _v_3_0_0_move_default_colors_to_kit Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 13:15:51\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:70:\"אלמנטור/Upgrades - _v_3_0_0_move_default_colors_to_kit Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"1bf6f64a3658fc72b4696bdb8d4b99da\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 13:15:51\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:66:\"אלמנטור/Upgrades - _v_3_0_0_move_saved_colors_to_kit Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 13:15:51\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:66:\"אלמנטור/Upgrades - _v_3_0_0_move_saved_colors_to_kit Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"6e7030e672be55f231bcd65322fac518\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 13:15:51\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:68:\"אלמנטור/Upgrades - _v_3_0_0_move_saved_colors_to_kit Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 13:15:51\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:68:\"אלמנטור/Upgrades - _v_3_0_0_move_saved_colors_to_kit Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"ea30e129da99573ceb4574313a533790\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 13:15:51\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:72:\"אלמנטור/Upgrades - _v_3_0_0_move_default_typography_to_kit Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 13:15:51\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:72:\"אלמנטור/Upgrades - _v_3_0_0_move_default_typography_to_kit Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"c4ec4f9ecc5397c4bab7c5bbac72acc0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 13:15:51\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:74:\"אלמנטור/Upgrades - _v_3_0_0_move_default_typography_to_kit Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 13:15:51\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:74:\"אלמנטור/Upgrades - _v_3_0_0_move_default_typography_to_kit Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"53ad50306f4c298d518604580a4233ff\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 13:15:51\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"אלמנטור\";s:4:\"from\";s:5:\"2.9.8\";s:2:\"to\";s:5:\"3.0.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 13:15:51\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"אלמנטור\";s:4:\"from\";s:5:\"2.9.8\";s:2:\"to\";s:5:\"3.0.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"3e701cd9224f10f78dfc60f4b4ea3f4f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-08-30 13:15:51\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"אלמנטור\";s:4:\"from\";s:5:\"2.9.8\";s:2:\"to\";s:5:\"3.0.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-08-30 13:15:51\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"אלמנטור\";s:4:\"from\";s:5:\"2.9.8\";s:2:\"to\";s:5:\"3.0.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"51e6a256e3f3855a7d0dc88410819c73\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:4:\"7209\";s:7:\"\0*\0file\";s:93:\"https://snapir-swim.co.il/wp-content/plugins/elementor-pro/assets/js/editor.min.js?ver=2.10.2\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2020-09-01 07:12:57\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:48:\"Cannot read property \\&#039;model\\&#039; of null\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2020-09-01 07:12:57\";i:1;s:19:\"2020-09-01 07:13:31\";i:2;s:19:\"2020-09-01 07:28:40\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1598944377\";s:7:\"message\";s:38:\"Cannot read property \\\'model\\\' of null\";s:3:\"url\";s:93:\"https://snapir-swim.co.il/wp-content/plugins/elementor-pro/assets/js/editor.min.js?ver=2.10.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:4:\"7209\";}}s:32:\"e86f48a282d0d119b33709b3b8027646\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2020-09-01 07:30:41\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"2.10.2\";s:2:\"to\";s:6:\"2.10.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-09-01 07:30:41\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"2.10.2\";s:2:\"to\";s:6:\"2.10.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"2cc3fadf832176ee6086ee0cb2692535\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:91:\"/home/snapirsw/public_html/wp-content/plugins/elementor/core/common/modules/ajax/module.php\";s:7:\"\0*\0line\";i:171;s:7:\"\0*\0date\";s:19:\"2020-09-01 07:34:23\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:21:\"Undefined index: data\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:4;s:14:\"\0*\0times_dates\";a:4:{i:0;s:19:\"2020-09-01 07:34:23\";i:1;s:19:\"2020-09-01 07:35:36\";i:2;s:19:\"2020-09-01 13:22:39\";i:3;s:19:\"2020-09-13 11:29:07\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:21:\"Undefined index: data\";s:4:\"file\";s:91:\"/home/snapirsw/public_html/wp-content/plugins/elementor/core/common/modules/ajax/module.php\";s:4:\"line\";i:171;s:5:\"trace\";b:1;}}s:32:\"41d8fc1b22f7b76b6629848d833ca78d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"44771\";s:7:\"\0*\0file\";s:93:\"https://snapir-swim.co.il/wp-content/plugins/elementor-pro/assets/js/editor.min.js?ver=2.10.3\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2020-09-01 07:34:22\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:56:\"Cannot read property \\&#039;settings\\&#039; of undefined\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-09-01 07:34:22\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1598945662\";s:7:\"message\";s:46:\"Cannot read property \\\'settings\\\' of undefined\";s:3:\"url\";s:93:\"https://snapir-swim.co.il/wp-content/plugins/elementor-pro/assets/js/editor.min.js?ver=2.10.3\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"44771\";}}s:32:\"51d796dde77c52e3e717a7bd0711bc85\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:91:\"/home/snapirsw/public_html/wp-content/plugins/elementor-pro/modules/posts/widgets/posts.php\";s:7:\"\0*\0line\";i:31;s:7:\"\0*\0date\";s:19:\"2020-09-01 11:44:17\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:32:\"Undefined index: posts_post_type\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2020-09-01 11:44:17\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:32:\"Undefined index: posts_post_type\";s:4:\"file\";s:91:\"/home/snapirsw/public_html/wp-content/plugins/elementor-pro/modules/posts/widgets/posts.php\";s:4:\"line\";i:31;s:5:\"trace\";b:1;}}}',	'no'),
(5498,	'updraft_dropbox',	'a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-7e5841c03af0124f9695798c8c6bba5e\";a:4:{s:6:\"appkey\";s:0:\"\";s:6:\"secret\";s:0:\"\";s:6:\"folder\";s:0:\"\";s:15:\"tk_access_token\";s:0:\"\";}}}',	'yes'),
(121,	'WPLANG',	'he_IL',	'yes'),
(475,	'action_scheduler_lock_async-request-runner',	'1604252368',	'yes'),
(201,	'elementor_active_kit',	'5',	'yes'),
(5499,	'updraft_s3',	'a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-2689afc0d860ff9d489bd82b48774758\";a:3:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}}}',	'yes'),
(5500,	'updraft_cloudfiles',	'a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-e46699f583732271a7786ee1368f952d\";a:5:{s:7:\"authurl\";s:35:\"https://auth.api.rackspacecloud.com\";s:6:\"region\";s:3:\"DFW\";s:4:\"user\";s:0:\"\";s:6:\"apikey\";s:0:\"\";s:4:\"path\";s:0:\"\";}}}',	'yes'),
(5501,	'updraft_googledrive',	'a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-23f6db14e25fb1ca2a26e54f941fa828\";a:9:{s:8:\"clientid\";s:0:\"\";s:6:\"secret\";s:0:\"\";s:5:\"token\";s:0:\"\";s:6:\"folder\";s:11:\"UpdraftPlus\";s:7:\"user_id\";s:64:\"a34915c89ba04a451deb47bbb6b0daa479fc82005819ec8927a03be4024db6e2\";s:16:\"tmp_access_token\";a:4:{s:12:\"access_token\";s:170:\"ya29.a0AfH6SMCdASltLOozjRVYOJYl1-kV28iaVd_-UGD2hMPlr0pcmtC8wNGl3XsOZAZ9S3jWlg9uQSTpYyoRcO_3Tce2tqoVhiDjhyd0T9SLv-VhSyPMfSbsStQx-zz7xIIke5QxLhYCqp5k7Eo1wRrpb-Z9hx3l0pwWK_I\";s:7:\"created\";i:1602428155;s:10:\"expires_in\";i:3599;s:13:\"refresh_token\";s:0:\"\";}s:10:\"expires_in\";i:1602431724;s:9:\"ownername\";s:13:\"שי פסקל\";s:16:\"instance_enabled\";i:1;}}}',	'yes'),
(5502,	'updraft_onedrive',	'a:1:{s:7:\"version\";s:1:\"1\";}',	'yes'),
(5503,	'updraft_ftp',	'a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-e85cee06be50e48677e5c327aac27260\";a:5:{s:4:\"host\";s:0:\"\";s:4:\"user\";s:0:\"\";s:4:\"pass\";s:0:\"\";s:4:\"path\";s:0:\"\";s:7:\"passive\";s:1:\"1\";}}}',	'yes'),
(5504,	'updraft_azure',	'a:1:{s:7:\"version\";s:1:\"1\";}',	'yes'),
(5535,	'updraft_include_uploads_exclude',	'backup*,*backups,backwpup*,wp-clone,snapshots',	'yes'),
(5505,	'updraft_sftp',	'a:1:{s:7:\"version\";s:1:\"1\";}',	'yes'),
(5534,	'updraft_include_uploads',	'1',	'yes'),
(5506,	'updraft_googlecloud',	'a:1:{s:7:\"version\";s:1:\"1\";}',	'yes'),
(5533,	'updraft_include_themes',	'1',	'yes'),
(5507,	'updraft_backblaze',	'a:1:{s:7:\"version\";s:1:\"1\";}',	'yes'),
(5532,	'updraft_include_plugins',	'1',	'yes'),
(5508,	'updraft_webdav',	'a:1:{s:7:\"version\";s:1:\"1\";}',	'yes'),
(5509,	'updraft_s3generic',	'a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-e66282d6162fd3c68c3babf2f4502c51\";a:4:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";s:8:\"endpoint\";s:0:\"\";}}}',	'yes'),
(5510,	'updraft_openstack',	'a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-78992874cbd2df86b6555879b6ba5e2e\";a:6:{s:7:\"authurl\";s:0:\"\";s:6:\"tenant\";s:0:\"\";s:6:\"region\";s:0:\"\";s:4:\"user\";s:0:\"\";s:8:\"password\";s:0:\"\";s:4:\"path\";s:0:\"\";}}}',	'yes'),
(5511,	'updraft_dreamobjects',	'a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-68b62b2f099fcd8a35ae31a9f7dd7708\";a:4:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";s:8:\"endpoint\";s:26:\"objects-us-east-1.dream.io\";}}}',	'yes'),
(5512,	'updraftplus-addons_siteid',	'0defad7a183f6f9a9839863a78ea21fa',	'no'),
(5516,	'updraftplus_tour_cancelled_on',	'premium',	'yes'),
(5521,	'updraft_retain_extrarules',	'a:0:{}',	'yes'),
(5522,	'updraft_email',	'shai@snapirswimming.org.il',	'yes'),
(5523,	'updraft_report_warningsonly',	'a:0:{}',	'yes'),
(5524,	'updraft_report_wholebackup',	'a:0:{}',	'yes'),
(5525,	'updraft_extradbs',	'a:0:{}',	'yes'),
(5526,	'updraft_include_more_path',	'a:0:{}',	'yes'),
(5527,	'updraft_interval',	'manual',	'yes'),
(5528,	'updraft_retain',	'2',	'yes'),
(5529,	'updraft_interval_database',	'manual',	'yes'),
(5530,	'updraft_retain_db',	'2',	'yes'),
(5531,	'updraft_service',	'googledrive',	'yes'),
(5536,	'updraft_include_others',	'1',	'yes'),
(5537,	'updraft_include_others_exclude',	'upgrade,cache,updraft,backup*,*backups,mysql.sql,debug.log',	'yes'),
(5538,	'updraft_split_every',	'400',	'yes'),
(5539,	'updraft_delete_local',	'1',	'yes'),
(5540,	'updraft_dir',	'updraft',	'yes'),
(5541,	'updraft_debug_mode',	'0',	'yes'),
(5542,	'updraft_ssl_useservercerts',	'0',	'yes'),
(5543,	'updraft_ssl_disableverify',	'0',	'yes'),
(5544,	'updraft_ssl_nossl',	'0',	'yes'),
(5545,	'updraft_auto_updates',	'0',	'yes'),
(128,	'elementor_version',	'3.0.3',	'yes'),
(135,	'_elementor_installed_time',	'1598791293',	'yes'),
(136,	'elementor_remote_info_library',	'a:3:{s:10:\"types_data\";a:2:{s:5:\"block\";a:1:{s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}}s:10:\"categories\";a:22:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:14:\"call to action\";i:4;s:7:\"clients\";i:5;s:7:\"contact\";i:6;s:3:\"faq\";i:7;s:8:\"features\";i:8;s:6:\"footer\";i:9;s:6:\"header\";i:10;s:4:\"hero\";i:11;s:9:\"portfolio\";i:12;s:7:\"pricing\";i:13;s:15:\"product archive\";i:14;s:8:\"services\";i:15;s:11:\"single page\";i:16;s:11:\"single post\";i:17;s:14:\"single product\";i:18;s:5:\"stats\";i:19;s:9:\"subscribe\";i:20;s:4:\"team\";i:21;s:12:\"testimonials\";}s:9:\"templates\";a:751:{i:0;a:14:{s:2:\"id\";i:5525;s:5:\"title\";s:8:\"About 14\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png\";s:12:\"tmpl_created\";i:1520443532;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:9;s:11:\"trend_index\";i:6;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:1;a:14:{s:2:\"id\";i:10107;s:5:\"title\";s:34:\"Classic | Promotion | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/balls_small.png\";s:12:\"tmpl_created\";i:1547851373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-promotion-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:240;s:11:\"trend_index\";i:197;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:2;a:14:{s:2:\"id\";i:14790;s:5:\"title\";s:33:\"Luxury Real Estate &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/07/Header.png\";s:12:\"tmpl_created\";i:1595315760;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/luxury-real-estate-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"header\",\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:320;s:11:\"trend_index\";i:12;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:3;a:14:{s:2:\"id\";i:5533;s:5:\"title\";s:8:\"About 15\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png\";s:12:\"tmpl_created\";i:1520443534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:27;s:11:\"trend_index\";i:11;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:4;a:14:{s:2:\"id\";i:14799;s:5:\"title\";s:38:\"Luxury Real Estate &#8211; single post\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/07/Post.png\";s:12:\"tmpl_created\";i:1595315792;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/luxury-real-estate-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:586;s:11:\"trend_index\";i:129;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:5;a:14:{s:2:\"id\";i:5575;s:5:\"title\";s:5:\"CTA 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_3.png\";s:12:\"tmpl_created\";i:1520443543;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:14;s:11:\"trend_index\";i:13;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:6;a:14:{s:2:\"id\";i:14809;s:5:\"title\";s:45:\"Luxury Real Estate &#8211; Properties Archive\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/07/Properties.png\";s:12:\"tmpl_created\";i:1595315826;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/blocks/luxury-real-estate-properties-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:598;s:11:\"trend_index\";i:195;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:7;a:14:{s:2:\"id\";i:5615;s:5:\"title\";s:10:\"Features 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_5.png\";s:12:\"tmpl_created\";i:1520443551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:33;s:11:\"trend_index\";i:64;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:8;a:14:{s:2:\"id\";i:14816;s:5:\"title\";s:47:\"Luxury Real Estate &#8211; Property single post\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/07/Single-Property-.png\";s:12:\"tmpl_created\";i:1595315847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/blocks/luxury-real-estate-property-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:278;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:9;a:14:{s:2:\"id\";i:5624;s:5:\"title\";s:10:\"Features 5\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_1.png\";s:12:\"tmpl_created\";i:1520443553;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:77;s:11:\"trend_index\";i:157;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:10;a:14:{s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:672;s:11:\"trend_index\";i:425;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:11;a:14:{s:2:\"id\";i:5684;s:5:\"title\";s:5:\"FAQ 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_1.png\";s:12:\"tmpl_created\";i:1520443565;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:67;s:11:\"trend_index\";i:75;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:12;a:14:{s:2:\"id\";i:10158;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/coco_small.png\";s:12:\"tmpl_created\";i:1547852227;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:268;s:11:\"trend_index\";i:238;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:13;a:14:{s:2:\"id\";i:15052;s:5:\"title\";s:36:\"Flooring Company &#8211; Single post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Single.png\";s:12:\"tmpl_created\";i:1597738858;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/flooring-company-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:688;s:11:\"trend_index\";i:175;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:14;a:14:{s:2:\"id\";i:5693;s:5:\"title\";s:5:\"FAQ 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_1.png\";s:12:\"tmpl_created\";i:1520443567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:200;s:11:\"trend_index\";i:198;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:15;a:14:{s:2:\"id\";i:15007;s:5:\"title\";s:31:\"Flooring Company &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Header.png\";s:12:\"tmpl_created\";i:1597738896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/flooring-company-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:48:\"[\"Flooring company\",\"Flooring website\",\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:685;s:11:\"trend_index\";i:192;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:16;a:14:{s:2:\"id\";i:5703;s:5:\"title\";s:6:\"FAQ 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_2.png\";s:12:\"tmpl_created\";i:1520443569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:28;s:11:\"trend_index\";i:25;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:17;a:14:{s:2:\"id\";i:15017;s:5:\"title\";s:31:\"Flooring Company &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/08/Footer.png\";s:12:\"tmpl_created\";i:1597738933;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/flooring-company-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:48:\"[\"Flooring company\",\"Flooring website\",\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:632;s:11:\"trend_index\";i:83;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:18;a:14:{s:2:\"id\";i:5711;s:5:\"title\";s:5:\"FAQ 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_2.png\";s:12:\"tmpl_created\";i:1520443571;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:192;s:11:\"trend_index\";i:265;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:19;a:14:{s:2:\"id\";i:10190;s:5:\"title\";s:30:\"Classic | Register | Subscribe\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/engage_small.png\";s:12:\"tmpl_created\";i:1547885703;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:246;s:11:\"trend_index\";i:137;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:20;a:14:{s:2:\"id\";i:15042;s:5:\"title\";s:32:\"Flooring Company &#8211; Archive\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Blog.png\";s:12:\"tmpl_created\";i:1597739084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/flooring-company-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:635;s:11:\"trend_index\";i:88;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:21;a:14:{s:2:\"id\";i:5719;s:5:\"title\";s:5:\"FAQ 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_3.png\";s:12:\"tmpl_created\";i:1520443573;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:119;s:11:\"trend_index\";i:145;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:22;a:14:{s:2:\"id\";i:15033;s:5:\"title\";s:28:\"Flooring Company &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/08/404.png\";s:12:\"tmpl_created\";i:1597739459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/flooring-company-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:45:\"[\"404\",\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:724;s:11:\"trend_index\";i:306;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:23;a:14:{s:2:\"id\";i:5729;s:5:\"title\";s:5:\"FAQ 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_3.png\";s:12:\"tmpl_created\";i:1520443575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:304;s:11:\"trend_index\";i:368;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:24;a:14:{s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:255;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:25;a:14:{s:2:\"id\";i:5737;s:5:\"title\";s:6:\"FAQ 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_4.png\";s:12:\"tmpl_created\";i:1520443576;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:157;s:11:\"trend_index\";i:115;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:26;a:14:{s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:725;s:11:\"trend_index\";i:337;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:27;a:14:{s:2:\"id\";i:5746;s:5:\"title\";s:6:\"FAQ 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_4.png\";s:12:\"tmpl_created\";i:1520443578;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/faq-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:195;s:11:\"trend_index\";i:167;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:28;a:14:{s:2:\"id\";i:5755;s:5:\"title\";s:5:\"FAQ 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_5.png\";s:12:\"tmpl_created\";i:1520443580;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:99;s:11:\"trend_index\";i:140;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:29;a:14:{s:2:\"id\";i:5764;s:5:\"title\";s:5:\"FAQ 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_5.png\";s:12:\"tmpl_created\";i:1520443582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/faq-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:3:\"faq\";s:4:\"tags\";s:7:\"[\"faq\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:315;s:11:\"trend_index\";i:315;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:30;a:14:{s:2:\"id\";i:10256;s:5:\"title\";s:20:\"Classic | Sale | Pop\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/fruit_small.png\";s:12:\"tmpl_created\";i:1547888909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:431;s:11:\"trend_index\";i:465;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:31;a:14:{s:2:\"id\";i:5773;s:5:\"title\";s:7:\"Hero 11\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_1.png\";s:12:\"tmpl_created\";i:1520443584;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:34;s:11:\"trend_index\";i:51;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:32;a:14:{s:2:\"id\";i:10267;s:5:\"title\";s:29:\"Classic | Contact | Christmas\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/christmas_small.png\";s:12:\"tmpl_created\";i:1547889047;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-contact-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:305;s:11:\"trend_index\";i:216;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:33;a:14:{s:2:\"id\";i:5783;s:5:\"title\";s:7:\"Hero 10\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_2.png\";s:12:\"tmpl_created\";i:1520443586;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:344;s:11:\"trend_index\";i:514;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:34;a:14:{s:2:\"id\";i:5792;s:5:\"title\";s:6:\"Hero 9\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_3.png\";s:12:\"tmpl_created\";i:1520443588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:220;s:11:\"trend_index\";i:308;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:35;a:14:{s:2:\"id\";i:5801;s:5:\"title\";s:6:\"Hero 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_4.png\";s:12:\"tmpl_created\";i:1520443589;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:16;s:11:\"trend_index\";i:14;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:36;a:14:{s:2:\"id\";i:5811;s:5:\"title\";s:6:\"Hero 8\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/header_5.png\";s:12:\"tmpl_created\";i:1520443591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:116;s:11:\"trend_index\";i:63;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:37;a:14:{s:2:\"id\";i:10307;s:5:\"title\";s:43:\"Fly In | Promotion | Christmas | Teddy Bear\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/teddy_small.png\";s:12:\"tmpl_created\";i:1547893266;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/fly-in-promotion-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:599;s:11:\"trend_index\";i:578;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:38;a:14:{s:2:\"id\";i:5820;s:5:\"title\";s:9:\"Contact 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_1.png\";s:12:\"tmpl_created\";i:1520443593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:173;s:11:\"trend_index\";i:251;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:39;a:14:{s:2:\"id\";i:10318;s:5:\"title\";s:27:\"Classic | Contact | Bicycle\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/01/by_small.png\";s:12:\"tmpl_created\";i:1547893367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/classic-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:336;s:11:\"trend_index\";i:398;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:40;a:14:{s:2:\"id\";i:5828;s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_1.png\";s:12:\"tmpl_created\";i:1520443595;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:300;s:11:\"trend_index\";i:288;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:41;a:14:{s:2:\"id\";i:5836;s:5:\"title\";s:10:\"Contact 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443597;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:115;s:11:\"trend_index\";i:111;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:42;a:14:{s:2:\"id\";i:10339;s:5:\"title\";s:22:\"Fly In | Contact | Spa\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/spa_small.png\";s:12:\"tmpl_created\";i:1547893603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/fly-in-contact-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:397;s:11:\"trend_index\";i:600;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:43;a:14:{s:2:\"id\";i:15204;s:5:\"title\";s:24:\"Psychologist &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/09/404.jpg\";s:12:\"tmpl_created\";i:1600161419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/psychologist-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:40:\"[\"404\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:44;a:14:{s:2:\"id\";i:5844;s:5:\"title\";s:10:\"Contact 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_2.png\";s:12:\"tmpl_created\";i:1520443599;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:285;s:11:\"trend_index\";i:317;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:45;a:14:{s:2:\"id\";i:10352;s:5:\"title\";s:23:\"Fly In | Contact | Wine\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_wine_small.png\";s:12:\"tmpl_created\";i:1547915335;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/fly-in-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:440;s:11:\"trend_index\";i:445;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:46;a:14:{s:2:\"id\";i:15212;s:5:\"title\";s:28:\"Psychologist &#8211; Archive\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Blog.jpg\";s:12:\"tmpl_created\";i:1600162340;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/psychologist-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:47;a:14:{s:2:\"id\";i:5852;s:5:\"title\";s:6:\"CTA 34\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2018/03/form_1.png\";s:12:\"tmpl_created\";i:1520443600;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-34/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:510;s:11:\"trend_index\";i:615;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:48;a:14:{s:2:\"id\";i:15219;s:5:\"title\";s:27:\"Psychologist &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/09/Footer.jpg\";s:12:\"tmpl_created\";i:1600163069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/psychologist-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:43:\"[\"footer\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:49;a:14:{s:2:\"id\";i:5947;s:5:\"title\";s:7:\"Stats 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_1.png\";s:12:\"tmpl_created\";i:1520443621;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:343;s:11:\"trend_index\";i:466;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:50;a:14:{s:2:\"id\";i:10372;s:5:\"title\";s:29:\"Fly In | Register | Subscribe\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/phone_small.png\";s:12:\"tmpl_created\";i:1547915554;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:596;s:11:\"trend_index\";i:661;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:51;a:14:{s:2:\"id\";i:15230;s:5:\"title\";s:27:\"Psychologist &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/09/Header.png\";s:12:\"tmpl_created\";i:1600163444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/psychologist-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"header\",\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:52;a:14:{s:2:\"id\";i:5956;s:5:\"title\";s:7:\"Stats 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_1.png\";s:12:\"tmpl_created\";i:1520443623;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:504;s:11:\"trend_index\";i:421;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:53;a:14:{s:2:\"id\";i:10382;s:5:\"title\";s:35:\"Bottom Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/bottom_pink_small.png\";s:12:\"tmpl_created\";i:1547916616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/bottom-bar-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:281;s:11:\"trend_index\";i:220;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:54;a:14:{s:2:\"id\";i:15240;s:5:\"title\";s:34:\"Psychologist &#8211; single post 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/09/Single-Post.png\";s:12:\"tmpl_created\";i:1600164087;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/psychologist-single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:55;a:14:{s:2:\"id\";i:5963;s:5:\"title\";s:10:\"Features 7\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_2.png\";s:12:\"tmpl_created\";i:1520443626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:63;s:11:\"trend_index\";i:60;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:56;a:14:{s:2:\"id\";i:15251;s:5:\"title\";s:34:\"Psychologist &#8211; single post 2\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2020/09/Single-Service-Page.png\";s:12:\"tmpl_created\";i:1600165179;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/psychologist-single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:57;a:14:{s:2:\"id\";i:5974;s:5:\"title\";s:10:\"Features 4\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_3.png\";s:12:\"tmpl_created\";i:1520443629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:62;s:11:\"trend_index\";i:103;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:58;a:14:{s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:59;a:14:{s:2:\"id\";i:5983;s:5:\"title\";s:10:\"Features 3\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_3.png\";s:12:\"tmpl_created\";i:1520443630;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:11:\"[\"featues\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:230;s:11:\"trend_index\";i:281;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:60;a:14:{s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:61;a:14:{s:2:\"id\";i:5991;s:5:\"title\";s:11:\"Features 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_4.png\";s:12:\"tmpl_created\";i:1520443632;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:123;s:11:\"trend_index\";i:174;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:62;a:14:{s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:63;a:14:{s:2:\"id\";i:5999;s:5:\"title\";s:7:\"Team 14\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_10.png\";s:12:\"tmpl_created\";i:1520443634;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:89;s:11:\"trend_index\";i:135;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:64;a:14:{s:2:\"id\";i:10434;s:5:\"title\";s:27:\"Classic | Sale | Headphones\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/head_small.png\";s:12:\"tmpl_created\";i:1547961950;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:369;s:11:\"trend_index\";i:327;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:65;a:14:{s:2:\"id\";i:6008;s:5:\"title\";s:6:\"Team 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_10.png\";s:12:\"tmpl_created\";i:1520443636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:66;s:11:\"trend_index\";i:99;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:66;a:14:{s:2:\"id\";i:10444;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/plant_small.png\";s:12:\"tmpl_created\";i:1547962029;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/classic-contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:396;s:11:\"trend_index\";i:484;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:67;a:14:{s:2:\"id\";i:6027;s:5:\"title\";s:7:\"About 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1-1.png\";s:12:\"tmpl_created\";i:1520443639;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-5-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:39;s:11:\"trend_index\";i:49;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:68;a:14:{s:2:\"id\";i:6036;s:5:\"title\";s:7:\"About 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1-1.png\";s:12:\"tmpl_created\";i:1520443641;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-6-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:86;s:11:\"trend_index\";i:85;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:69;a:14:{s:2:\"id\";i:10467;s:5:\"title\";s:27:\"Bottom Bar | Contact | Lego\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/tro_small.png\";s:12:\"tmpl_created\";i:1547962277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/bottom-bar-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:669;s:11:\"trend_index\";i:694;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:70;a:14:{s:2:\"id\";i:6044;s:5:\"title\";s:11:\"Features 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_5.png\";s:12:\"tmpl_created\";i:1520443643;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:65;s:11:\"trend_index\";i:71;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:71;a:14:{s:2:\"id\";i:6053;s:5:\"title\";s:10:\"Features 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_black_5.png\";s:12:\"tmpl_created\";i:1520443645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:168;s:11:\"trend_index\";i:205;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:72;a:14:{s:2:\"id\";i:10487;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/acc_small.png\";s:12:\"tmpl_created\";i:1547964527;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:520;s:11:\"trend_index\";i:503;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:73;a:14:{s:2:\"id\";i:6063;s:5:\"title\";s:7:\"Stats 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_2.png\";s:12:\"tmpl_created\";i:1520443647;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:161;s:11:\"trend_index\";i:257;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:74;a:14:{s:2:\"id\";i:10498;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/pink_small-1.png\";s:12:\"tmpl_created\";i:1547964616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:416;s:11:\"trend_index\";i:304;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:75;a:14:{s:2:\"id\";i:15407;s:5:\"title\";s:24:\"Dance Studio &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/10/404.jpg\";s:12:\"tmpl_created\";i:1603181958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/dance-studio-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:22:\"[\"404\",\"dance studio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:76;a:14:{s:2:\"id\";i:6071;s:5:\"title\";s:8:\"Stats 13\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_3.png\";s:12:\"tmpl_created\";i:1520443649;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:160;s:11:\"trend_index\";i:242;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:77;a:14:{s:2:\"id\";i:15400;s:5:\"title\";s:27:\"Dance Studio &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/10/Footer.jpg\";s:12:\"tmpl_created\";i:1603181989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/dance-studio-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:25:\"[\"dance studio\",\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:78;a:14:{s:2:\"id\";i:6079;s:5:\"title\";s:7:\"Stats 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_4.png\";s:12:\"tmpl_created\";i:1520443651;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:269;s:11:\"trend_index\";i:350;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:79;a:14:{s:2:\"id\";i:10519;s:5:\"title\";s:27:\"Hello Bar | Promotion | App\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/app_small-1.png\";s:12:\"tmpl_created\";i:1547964801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/hello-bar-promotion-app-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:549;s:11:\"trend_index\";i:456;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:80;a:14:{s:2:\"id\";i:15391;s:5:\"title\";s:27:\"Dance Studio &#8211; Header\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/10/Header.jpg\";s:12:\"tmpl_created\";i:1603182011;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/dance-studio-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:25:\"[\"dance studio\",\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:81;a:14:{s:2:\"id\";i:6089;s:5:\"title\";s:7:\"Stats 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_5.png\";s:12:\"tmpl_created\";i:1520443653;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:183;s:11:\"trend_index\";i:292;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:82;a:14:{s:2:\"id\";i:6097;s:5:\"title\";s:7:\"Stats 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_2.png\";s:12:\"tmpl_created\";i:1520443655;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:262;s:11:\"trend_index\";i:209;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:83;a:14:{s:2:\"id\";i:6106;s:5:\"title\";s:7:\"Stats 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_6.png\";s:12:\"tmpl_created\";i:1520443657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:337;s:11:\"trend_index\";i:443;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:84;a:14:{s:2:\"id\";i:6114;s:5:\"title\";s:7:\"Stats 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_6.png\";s:12:\"tmpl_created\";i:1520443659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:11:\"[\"numbers\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:378;s:11:\"trend_index\";i:439;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:85;a:14:{s:2:\"id\";i:6122;s:5:\"title\";s:7:\"About 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2-1.png\";s:12:\"tmpl_created\";i:1520443661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:36;s:11:\"trend_index\";i:45;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:86;a:14:{s:2:\"id\";i:10569;s:5:\"title\";s:15:\"Slide In | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/off_small.png\";s:12:\"tmpl_created\";i:1547967812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/popups/slide-in-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:501;s:11:\"trend_index\";i:556;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:87;a:14:{s:2:\"id\";i:6135;s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";i:1520443663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:83;s:11:\"trend_index\";i:121;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:88;a:14:{s:2:\"id\";i:6144;s:5:\"title\";s:7:\"Team 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_11.png\";s:12:\"tmpl_created\";i:1520443664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:155;s:11:\"trend_index\";i:277;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:89;a:14:{s:2:\"id\";i:10590;s:5:\"title\";s:19:\"Full Screen | Login\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/pass1_small.png\";s:12:\"tmpl_created\";i:1547967978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:470;s:11:\"trend_index\";i:411;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:90;a:14:{s:2:\"id\";i:6152;s:5:\"title\";s:7:\"Stats 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_1.png\";s:12:\"tmpl_created\";i:1520443666;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/stats-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:241;s:11:\"trend_index\";i:233;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:91;a:14:{s:2:\"id\";i:10600;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/orange_small.png\";s:12:\"tmpl_created\";i:1547968080;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:459;s:11:\"trend_index\";i:530;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:92;a:14:{s:2:\"id\";i:6162;s:5:\"title\";s:11:\"Services 31\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_1.png\";s:12:\"tmpl_created\";i:1520443668;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-31/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:339;s:11:\"trend_index\";i:430;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:93;a:14:{s:2:\"id\";i:6170;s:5:\"title\";s:8:\"Stats 11\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_2.png\";s:12:\"tmpl_created\";i:1520443670;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:332;s:11:\"trend_index\";i:419;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:94;a:14:{s:2:\"id\";i:10622;s:5:\"title\";s:34:\"Full Screen | Contact | Headphones\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/full_hear_small.png\";s:12:\"tmpl_created\";i:1547969678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/full-screen-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:528;s:11:\"trend_index\";i:459;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:95;a:14:{s:2:\"id\";i:6178;s:5:\"title\";s:8:\"Stats 10\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_2.png\";s:12:\"tmpl_created\";i:1520443676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:549;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:96;a:14:{s:2:\"id\";i:10633;s:5:\"title\";s:23:\"Slide In | Login | Lego\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/tro_small-1.png\";s:12:\"tmpl_created\";i:1547969858;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/slide-in-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:620;s:11:\"trend_index\";i:573;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:97;a:14:{s:2:\"id\";i:6186;s:5:\"title\";s:8:\"Stats 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_3.png\";s:12:\"tmpl_created\";i:1520443678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/stats-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"stats\";s:4:\"tags\";s:9:\"[\"Stats\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:486;s:11:\"trend_index\";i:586;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:98;a:14:{s:2:\"id\";i:10644;s:5:\"title\";s:26:\"Fly In | Contact | Webinar\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/blue_small-1.png\";s:12:\"tmpl_created\";i:1547970814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/fly-in-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:456;s:11:\"trend_index\";i:436;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:99;a:14:{s:2:\"id\";i:6196;s:5:\"title\";s:10:\"Features 9\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_6.png\";s:12:\"tmpl_created\";i:1520443680;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:106;s:11:\"trend_index\";i:130;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:100;a:14:{s:2:\"id\";i:10654;s:5:\"title\";s:31:\"Full Screen | Login | Christmas\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/full_login_small.png\";s:12:\"tmpl_created\";i:1547970917;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/full-screen-login-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:615;s:11:\"trend_index\";i:638;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:101;a:14:{s:2:\"id\";i:6204;s:5:\"title\";s:10:\"Features 8\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_6.png\";s:12:\"tmpl_created\";i:1520443681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:213;s:11:\"trend_index\";i:170;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:102;a:14:{s:2:\"id\";i:10664;s:5:\"title\";s:34:\"Slide In | Contact | Gym | Fitness\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/slide_gym_small.png\";s:12:\"tmpl_created\";i:1547973928;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-contact-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:515;s:11:\"trend_index\";i:517;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:103;a:14:{s:2:\"id\";i:6212;s:5:\"title\";s:11:\"Features 12\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_7.png\";s:12:\"tmpl_created\";i:1520443684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/features-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:76;s:11:\"trend_index\";i:67;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:104;a:14:{s:2:\"id\";i:10675;s:5:\"title\";s:35:\"Full Screen | Login | Gym | Fitness\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/gym_full_small.png\";s:12:\"tmpl_created\";i:1547974110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:496;s:11:\"trend_index\";i:510;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:105;a:14:{s:2:\"id\";i:6220;s:5:\"title\";s:10:\"Features 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/features_white_8.png\";s:12:\"tmpl_created\";i:1520443685;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/features-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"features\";s:4:\"tags\";s:12:\"[\"features\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:82;s:11:\"trend_index\";i:156;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:106;a:14:{s:2:\"id\";i:6230;s:5:\"title\";s:6:\"Hero 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_white_1.png\";s:12:\"tmpl_created\";i:1520443687;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:379;s:11:\"trend_index\";i:399;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:107;a:14:{s:2:\"id\";i:9719;s:5:\"title\";s:30:\"Classic | Subscribe | Register\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/register_small.png\";s:12:\"tmpl_created\";i:1547976107;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-subscribe-register/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:414;s:11:\"trend_index\";i:194;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:108;a:14:{s:2:\"id\";i:6239;s:5:\"title\";s:6:\"Hero 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_1.png\";s:12:\"tmpl_created\";i:1520443689;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:26;s:11:\"trend_index\";i:24;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:109;a:14:{s:2:\"id\";i:6249;s:5:\"title\";s:6:\"Hero 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_2.png\";s:12:\"tmpl_created\";i:1520443691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:56;s:11:\"trend_index\";i:87;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:110;a:14:{s:2:\"id\";i:6258;s:5:\"title\";s:6:\"Hero 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_3.png\";s:12:\"tmpl_created\";i:1520443693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:428;s:11:\"trend_index\";i:591;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:111;a:14:{s:2:\"id\";i:10137;s:5:\"title\";s:34:\"Full Screen | Contact | Restaurant\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/rest_small.png\";s:12:\"tmpl_created\";i:1547976342;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:527;s:11:\"trend_index\";i:534;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:112;a:14:{s:2:\"id\";i:6266;s:5:\"title\";s:6:\"Hero 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_4.png\";s:12:\"tmpl_created\";i:1520443695;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:53;s:11:\"trend_index\";i:90;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:113;a:14:{s:2:\"id\";i:10244;s:5:\"title\";s:17:\"Bottom Bar | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/wow_small.png\";s:12:\"tmpl_created\";i:1547976402;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/bottom-bar-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:579;s:11:\"trend_index\";i:624;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:114;a:14:{s:2:\"id\";i:6274;s:5:\"title\";s:6:\"Hero 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_5.png\";s:12:\"tmpl_created\";i:1520443698;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/hero-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:95;s:11:\"trend_index\";i:89;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:115;a:14:{s:2:\"id\";i:6017;s:5:\"title\";s:6:\"CTA 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_14.png\";s:12:\"tmpl_created\";i:1520520331;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:150;s:11:\"trend_index\";i:155;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:116;a:14:{s:2:\"id\";i:10127;s:5:\"title\";s:35:\"Fly In | Announcement | Maintenance\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/pizza_small.png\";s:12:\"tmpl_created\";i:1547984061;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:637;s:11:\"trend_index\";i:666;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:117;a:14:{s:2:\"id\";i:4826;s:5:\"title\";s:14:\"Testimonial 24\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_1.png\";s:12:\"tmpl_created\";i:1520520544;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/testimonial-24-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:254;s:11:\"trend_index\";i:309;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:118;a:14:{s:2:\"id\";i:4835;s:5:\"title\";s:14:\"Testimonial 16\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_1.png\";s:12:\"tmpl_created\";i:1520520546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:381;s:11:\"trend_index\";i:423;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:119;a:14:{s:2:\"id\";i:4843;s:5:\"title\";s:14:\"Testimonial 18\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_2.png\";s:12:\"tmpl_created\";i:1520520548;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:409;s:11:\"trend_index\";i:492;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:120;a:14:{s:2:\"id\";i:4854;s:5:\"title\";s:14:\"Testimonial 13\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_2.png\";s:12:\"tmpl_created\";i:1520520549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:580;s:11:\"trend_index\";i:610;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:121;a:14:{s:2:\"id\";i:4863;s:5:\"title\";s:14:\"Testimonial 19\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_3.png\";s:12:\"tmpl_created\";i:1520520551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:244;s:11:\"trend_index\";i:343;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:122;a:14:{s:2:\"id\";i:10776;s:5:\"title\";s:33:\"Fly In | Contact | Social | Share\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/social1_small.png\";s:12:\"tmpl_created\";i:1548047055;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/fly-in-contact-social-share/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:640;s:11:\"trend_index\";i:660;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:123;a:14:{s:2:\"id\";i:4871;s:5:\"title\";s:14:\"Testimonial 12\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_3.png\";s:12:\"tmpl_created\";i:1520520552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:245;s:11:\"trend_index\";i:329;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:124;a:14:{s:2:\"id\";i:10785;s:5:\"title\";s:33:\"Fly In | Contact | Social | Share\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/social2_small.png\";s:12:\"tmpl_created\";i:1548047593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/fly-in-contact-social-share-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:455;s:11:\"trend_index\";i:524;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:125;a:14:{s:2:\"id\";i:4880;s:5:\"title\";s:14:\"Testimonial 20\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/customers-1.jpg\";s:12:\"tmpl_created\";i:1520520554;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:394;s:11:\"trend_index\";i:427;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:126;a:14:{s:2:\"id\";i:4889;s:5:\"title\";s:14:\"Testimonial 11\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/customers-2.jpg\";s:12:\"tmpl_created\";i:1520520556;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:513;s:11:\"trend_index\";i:537;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:127;a:14:{s:2:\"id\";i:4897;s:5:\"title\";s:14:\"Testimonial 21\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_5.png\";s:12:\"tmpl_created\";i:1520520557;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:71;s:11:\"trend_index\";i:69;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:128;a:14:{s:2:\"id\";i:4905;s:5:\"title\";s:14:\"Testimonial 22\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_6.png\";s:12:\"tmpl_created\";i:1520520559;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:114;s:11:\"trend_index\";i:138;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:129;a:14:{s:2:\"id\";i:4913;s:5:\"title\";s:14:\"Testimonial 23\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_7.png\";s:12:\"tmpl_created\";i:1520520561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:232;s:11:\"trend_index\";i:291;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:130;a:14:{s:2:\"id\";i:4921;s:5:\"title\";s:14:\"Testimonial 10\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_5.png\";s:12:\"tmpl_created\";i:1520520562;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:209;s:11:\"trend_index\";i:218;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:131;a:14:{s:2:\"id\";i:4929;s:5:\"title\";s:14:\"Testimonial 24\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_8.png\";s:12:\"tmpl_created\";i:1520520564;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:43;s:11:\"trend_index\";i:70;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:132;a:14:{s:2:\"id\";i:4939;s:5:\"title\";s:13:\"Testimonial 9\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_8.png\";s:12:\"tmpl_created\";i:1520520565;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/testimonial-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:90;s:11:\"trend_index\";i:133;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:133;a:14:{s:2:\"id\";i:4947;s:5:\"title\";s:14:\"Testimonial 27\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_9.png\";s:12:\"tmpl_created\";i:1520520567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:197;s:11:\"trend_index\";i:313;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:134;a:14:{s:2:\"id\";i:4955;s:5:\"title\";s:14:\"Testimonial 29\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_9.png\";s:12:\"tmpl_created\";i:1520520569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:346;s:11:\"trend_index\";i:416;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:135;a:14:{s:2:\"id\";i:4963;s:5:\"title\";s:14:\"Testimonial 25\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_10.png\";s:12:\"tmpl_created\";i:1520520570;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/testimonial-25-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:391;s:11:\"trend_index\";i:401;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:136;a:14:{s:2:\"id\";i:4971;s:5:\"title\";s:14:\"Testimonial 26\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_11.png\";s:12:\"tmpl_created\";i:1520520572;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:594;s:11:\"trend_index\";i:664;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:137;a:14:{s:2:\"id\";i:4979;s:5:\"title\";s:14:\"Testimonial 15\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_10.png\";s:12:\"tmpl_created\";i:1520520573;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:529;s:11:\"trend_index\";i:648;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:138;a:14:{s:2:\"id\";i:4987;s:5:\"title\";s:14:\"Testimonial 17\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_12-1.png\";s:12:\"tmpl_created\";i:1520520575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:151;s:11:\"trend_index\";i:239;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:139;a:14:{s:2:\"id\";i:4995;s:5:\"title\";s:14:\"Testimonial 14\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_12.png\";s:12:\"tmpl_created\";i:1520520577;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/testimonial-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:12:\"testimonials\";s:4:\"tags\";s:15:\"[\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:372;s:11:\"trend_index\";i:509;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:140;a:14:{s:2:\"id\";i:5007;s:5:\"title\";s:11:\"Portfolio 7\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_1.png\";s:12:\"tmpl_created\";i:1520520578;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:41;s:11:\"trend_index\";i:36;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:141;a:14:{s:2:\"id\";i:5019;s:5:\"title\";s:11:\"Portfolio 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_1.png\";s:12:\"tmpl_created\";i:1520520580;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:164;s:11:\"trend_index\";i:207;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:142;a:14:{s:2:\"id\";i:5027;s:5:\"title\";s:12:\"Portfolio 11\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_2.png\";s:12:\"tmpl_created\";i:1520520581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:301;s:11:\"trend_index\";i:389;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:143;a:14:{s:2:\"id\";i:10794;s:5:\"title\";s:34:\"Classic | Contact | Social | Share\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/01/s_small.png\";s:12:\"tmpl_created\";i:1548067619;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-contact-social-share/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:430;s:11:\"trend_index\";i:296;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:144;a:14:{s:2:\"id\";i:5037;s:5:\"title\";s:12:\"Portfolio 12\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_3.png\";s:12:\"tmpl_created\";i:1520520583;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:265;s:11:\"trend_index\";i:346;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:145;a:14:{s:2:\"id\";i:5057;s:5:\"title\";s:12:\"Portfolio 13\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_4.png\";s:12:\"tmpl_created\";i:1520520586;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:231;s:11:\"trend_index\";i:334;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:146;a:14:{s:2:\"id\";i:5071;s:5:\"title\";s:12:\"Portfolio 14\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_5.png\";s:12:\"tmpl_created\";i:1520520588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:272;s:11:\"trend_index\";i:271;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:147;a:14:{s:2:\"id\";i:10871;s:5:\"title\";s:20:\"Bottom Bar | Contact\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/01/m_small.png\";s:12:\"tmpl_created\";i:1548074396;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/bottom-bar-contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:649;s:11:\"trend_index\";i:681;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:148;a:14:{s:2:\"id\";i:5082;s:5:\"title\";s:11:\"Portfolio 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_4.png\";s:12:\"tmpl_created\";i:1520520589;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:490;s:11:\"trend_index\";i:448;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:149;a:14:{s:2:\"id\";i:10936;s:5:\"title\";s:25:\"Full Screen | Toggle Menu\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/menu_small.png\";s:12:\"tmpl_created\";i:1548874587;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/full-screen-toggle-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:442;s:11:\"trend_index\";i:511;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:150;a:14:{s:2:\"id\";i:5090;s:5:\"title\";s:12:\"Portfolio 15\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_6.png\";s:12:\"tmpl_created\";i:1520520591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:171;s:11:\"trend_index\";i:191;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:151;a:14:{s:2:\"id\";i:5098;s:5:\"title\";s:12:\"Portfolio 16\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_7.png\";s:12:\"tmpl_created\";i:1520520593;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:152;s:11:\"trend_index\";i:142;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:152;a:14:{s:2:\"id\";i:5107;s:5:\"title\";s:11:\"Portfolio 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_7.png\";s:12:\"tmpl_created\";i:1520520594;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:359;s:11:\"trend_index\";i:433;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:153;a:14:{s:2:\"id\";i:10964;s:5:\"title\";s:59:\"Classic | Promotion | Coupon | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/02/love_small.png\";s:12:\"tmpl_created\";i:1550039106;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/classic-promotion-coupon/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:581;s:11:\"trend_index\";i:486;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:154;a:14:{s:2:\"id\";i:5115;s:5:\"title\";s:12:\"Portfolio 17\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_8.png\";s:12:\"tmpl_created\";i:1520520596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:22;s:11:\"trend_index\";i:18;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:155;a:14:{s:2:\"id\";i:10992;s:5:\"title\";s:59:\"Classic | Promotion | Coupon | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/02/h_small.png\";s:12:\"tmpl_created\";i:1550072007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-promotion-coupon-love-valentines-day/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:631;s:11:\"trend_index\";i:698;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:156;a:14:{s:2:\"id\";i:5125;s:5:\"title\";s:11:\"Portfolio 6\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_8.png\";s:12:\"tmpl_created\";i:1520520597;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:223;s:11:\"trend_index\";i:236;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:157;a:14:{s:2:\"id\";i:11005;s:5:\"title\";s:50:\"Classic | Promotion | Love | Valentine&#8217;s Day\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/02/bear_small.png\";s:12:\"tmpl_created\";i:1550073303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-promotion-love-valentines-day/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:628;s:11:\"trend_index\";i:609;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:158;a:14:{s:2:\"id\";i:5133;s:5:\"title\";s:12:\"Portfolio 18\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_9.png\";s:12:\"tmpl_created\";i:1520520599;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:170;s:11:\"trend_index\";i:149;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:159;a:14:{s:2:\"id\";i:5141;s:5:\"title\";s:12:\"Portfolio 10\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_10.png\";s:12:\"tmpl_created\";i:1520520601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:371;s:11:\"trend_index\";i:454;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:160;a:14:{s:2:\"id\";i:5149;s:5:\"title\";s:11:\"Portfolio 2\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_10.png\";s:12:\"tmpl_created\";i:1520520602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:365;s:11:\"trend_index\";i:546;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:161;a:14:{s:2:\"id\";i:5542;s:5:\"title\";s:6:\"CTA 19\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_1.png\";s:12:\"tmpl_created\";i:1520520681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:159;s:11:\"trend_index\";i:212;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:162;a:14:{s:2:\"id\";i:5550;s:5:\"title\";s:6:\"CTA 33\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_1.png\";s:12:\"tmpl_created\";i:1520520682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-33/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:249;s:11:\"trend_index\";i:268;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:163;a:14:{s:2:\"id\";i:5558;s:5:\"title\";s:5:\"CTA 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_2.png\";s:12:\"tmpl_created\";i:1520520684;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:135;s:11:\"trend_index\";i:146;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:164;a:14:{s:2:\"id\";i:5567;s:5:\"title\";s:5:\"CTA 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_2.png\";s:12:\"tmpl_created\";i:1520520685;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:146;s:11:\"trend_index\";i:80;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:165;a:14:{s:2:\"id\";i:11231;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/Post_small1.png\";s:12:\"tmpl_created\";i:1564642380;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/digital-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:166;s:11:\"trend_index\";i:158;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:166;a:14:{s:2:\"id\";i:5583;s:5:\"title\";s:6:\"CTA 26\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_3.png\";s:12:\"tmpl_created\";i:1520520689;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:131;s:11:\"trend_index\";i:42;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:167;a:14:{s:2:\"id\";i:11220;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/08/Archive_small1.png\";s:12:\"tmpl_created\";i:1564642385;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:121;s:11:\"trend_index\";i:48;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:168;a:14:{s:2:\"id\";i:5591;s:5:\"title\";s:5:\"CTA 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_4.png\";s:12:\"tmpl_created\";i:1520520691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:128;s:11:\"trend_index\";i:179;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:169;a:14:{s:2:\"id\";i:11204;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/07/404_small.jpg\";s:12:\"tmpl_created\";i:1564642389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:36:\"[\"404\",\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:327;s:11:\"trend_index\";i:237;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:170;a:14:{s:2:\"id\";i:5599;s:5:\"title\";s:5:\"CTA 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_4.png\";s:12:\"tmpl_created\";i:1520520693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:251;s:11:\"trend_index\";i:234;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:171;a:14:{s:2:\"id\";i:11198;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-digital-marketing-agency.png\";s:12:\"tmpl_created\";i:1564642395;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"header\",\"marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:46;s:11:\"trend_index\";i:17;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:172;a:14:{s:2:\"id\";i:5607;s:5:\"title\";s:6:\"CTA 13\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_5.png\";s:12:\"tmpl_created\";i:1520520695;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:51;s:11:\"trend_index\";i:9;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:173;a:14:{s:2:\"id\";i:11192;s:5:\"title\";s:14:\"Digital Agency\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/07/Footer_small.jpg\";s:12:\"tmpl_created\";i:1564642399;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/digital-agency-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"Digital Agency\",\"footer\",\"marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:191;s:11:\"trend_index\";i:159;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:174;a:14:{s:2:\"id\";i:5634;s:5:\"title\";s:6:\"CTA 24\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_6.png\";s:12:\"tmpl_created\";i:1520520699;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:172;s:11:\"trend_index\";i:256;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:175;a:14:{s:2:\"id\";i:5642;s:5:\"title\";s:6:\"CTA 25\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_6.png\";s:12:\"tmpl_created\";i:1520520701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-25/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:212;s:11:\"trend_index\";i:246;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:176;a:14:{s:2:\"id\";i:5650;s:5:\"title\";s:5:\"CTA 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_7.png\";s:12:\"tmpl_created\";i:1520520702;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:91;s:11:\"trend_index\";i:81;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:177;a:14:{s:2:\"id\";i:5658;s:5:\"title\";s:5:\"CTA 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_7.png\";s:12:\"tmpl_created\";i:1520520704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:180;s:11:\"trend_index\";i:163;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:178;a:14:{s:2:\"id\";i:5667;s:5:\"title\";s:5:\"CTA 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_8.png\";s:12:\"tmpl_created\";i:1520520705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:158;s:11:\"trend_index\";i:182;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:179;a:14:{s:2:\"id\";i:5675;s:5:\"title\";s:5:\"CTA 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_8.png\";s:12:\"tmpl_created\";i:1520520707;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/cta-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:361;s:11:\"trend_index\";i:418;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:180;a:14:{s:2:\"id\";i:5860;s:5:\"title\";s:6:\"CTA 17\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_9.png\";s:12:\"tmpl_created\";i:1520520746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:125;s:11:\"trend_index\";i:86;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:181;a:14:{s:2:\"id\";i:5869;s:5:\"title\";s:6:\"CTA 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_10.png\";s:12:\"tmpl_created\";i:1520520747;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:312;s:11:\"trend_index\";i:374;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:182;a:14:{s:2:\"id\";i:5877;s:5:\"title\";s:6:\"CTA 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_10.png\";s:12:\"tmpl_created\";i:1520520749;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:505;s:11:\"trend_index\";i:564;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:183;a:14:{s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:643;s:11:\"trend_index\";i:676;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:184;a:14:{s:2:\"id\";i:5885;s:5:\"title\";s:6:\"CTA 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_11.png\";s:12:\"tmpl_created\";i:1520520751;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:270;s:11:\"trend_index\";i:402;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:185;a:14:{s:2:\"id\";i:11461;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-gym-and-fitness.png\";s:12:\"tmpl_created\";i:1567393219;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:100:\"https://library.elementor.com/blocks/gym/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:16:\"[\"Gym\",\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:228;s:11:\"trend_index\";i:124;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:186;a:14:{s:2:\"id\";i:5893;s:5:\"title\";s:6:\"CTA 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_12.png\";s:12:\"tmpl_created\";i:1520520752;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:250;s:11:\"trend_index\";i:326;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:187;a:14:{s:2:\"id\";i:11453;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Footer_Small.png\";s:12:\"tmpl_created\";i:1567393224;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:16:\"[\"footer\",\"Gym\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:296;s:11:\"trend_index\";i:164;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:188;a:14:{s:2:\"id\";i:5904;s:5:\"title\";s:6:\"CTA 27\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_13.png\";s:12:\"tmpl_created\";i:1520520754;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:473;s:11:\"trend_index\";i:567;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:189;a:14:{s:2:\"id\";i:11445;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/08/Post_Small.png\";s:12:\"tmpl_created\";i:1567393229;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:432;s:11:\"trend_index\";i:428;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:190;a:14:{s:2:\"id\";i:5912;s:5:\"title\";s:6:\"CTA 28\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_11.png\";s:12:\"tmpl_created\";i:1520520755;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-28/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:602;s:11:\"trend_index\";i:662;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:191;a:14:{s:2:\"id\";i:11435;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/08/Archiv_Small.png\";s:12:\"tmpl_created\";i:1567393296;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:410;s:11:\"trend_index\";i:471;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:192;a:14:{s:2:\"id\";i:5921;s:5:\"title\";s:6:\"CTA 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_14.png\";s:12:\"tmpl_created\";i:1520520757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:261;s:11:\"trend_index\";i:338;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:193;a:14:{s:2:\"id\";i:11424;s:5:\"title\";s:3:\"GYM\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/08/404_Small.png\";s:12:\"tmpl_created\";i:1567393309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/blocks/gym-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:13:\"[\"404\",\"Gym\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:630;s:11:\"trend_index\";i:629;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:194;a:14:{s:2:\"id\";i:5930;s:5:\"title\";s:6:\"CTA 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_15.png\";s:12:\"tmpl_created\";i:1520520758;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:73;s:11:\"trend_index\";i:120;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:195;a:14:{s:2:\"id\";i:5939;s:5:\"title\";s:6:\"CTA 10\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_13-1.png\";s:12:\"tmpl_created\";i:1520520760;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:177;s:11:\"trend_index\";i:186;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:196;a:14:{s:2:\"id\";i:7596;s:5:\"title\";s:8:\"Header 1\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.12.jpg\";s:12:\"tmpl_created\";i:1521546999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:10:\"[\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:35;s:11:\"trend_index\";i:33;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:197;a:14:{s:2:\"id\";i:7615;s:5:\"title\";s:8:\"Header 2\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.1.jpg\";s:12:\"tmpl_created\";i:1521547237;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:10:\"[\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:29;s:11:\"trend_index\";i:29;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:198;a:14:{s:2:\"id\";i:7627;s:5:\"title\";s:8:\"Footer 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_1.png\";s:12:\"tmpl_created\";i:1521547332;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:113;s:11:\"trend_index\";i:94;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:199;a:14:{s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:606;s:11:\"trend_index\";i:628;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:200;a:14:{s:2:\"id\";i:7638;s:5:\"title\";s:8:\"Footer 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_2.png\";s:12:\"tmpl_created\";i:1521547502;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:120;s:11:\"trend_index\";i:136;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:201;a:14:{s:2:\"id\";i:11877;s:5:\"title\";s:27:\"Portfolio &#8211; Project 3\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project3_small.png\";s:12:\"tmpl_created\";i:1569429954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:626;s:11:\"trend_index\";i:613;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:202;a:14:{s:2:\"id\";i:7663;s:5:\"title\";s:13:\"Single Post 2\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/single_post_2_v2.jpg\";s:12:\"tmpl_created\";i:1521547761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:24:\"[\"Blog\",\"Post\",\"Single\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:50;s:11:\"trend_index\";i:65;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:203;a:14:{s:2:\"id\";i:11870;s:5:\"title\";s:27:\"Portfolio &#8211; Project 2\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png\";s:12:\"tmpl_created\";i:1569429964;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:604;s:11:\"trend_index\";i:619;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:204;a:14:{s:2:\"id\";i:7650;s:5:\"title\";s:13:\"Single Post 1\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/03/single_post_1_v2.jpg\";s:12:\"tmpl_created\";i:1521557736;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:24:\"[\"Blog\",\"Post\",\"Single\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:109;s:11:\"trend_index\";i:113;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:205;a:14:{s:2:\"id\";i:11861;s:5:\"title\";s:27:\"Portfolio &#8211; Project 1\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project1_small.png\";s:12:\"tmpl_created\";i:1569429975;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/portfolio-project-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:593;s:11:\"trend_index\";i:703;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:206;a:14:{s:2:\"id\";i:7686;s:5:\"title\";s:12:\"Blog Posts 1\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2018/03/blog_posts.png\";s:12:\"tmpl_created\";i:1521558047;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/blog-posts-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:26:\"[\"archive\",\"Blog\",\"posts\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:124;s:11:\"trend_index\";i:193;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:207;a:14:{s:2:\"id\";i:11854;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/09/Post_small.png\";s:12:\"tmpl_created\";i:1569429983;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/portfolio/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:472;s:11:\"trend_index\";i:404;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:208;a:14:{s:2:\"id\";i:4676;s:5:\"title\";s:8:\"Footer 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/03/footer_7.png\";s:12:\"tmpl_created\";i:1522014215;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/footer_7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:10:\"[\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:235;s:11:\"trend_index\";i:190;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:209;a:14:{s:2:\"id\";i:11847;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Archiv_small.png\";s:12:\"tmpl_created\";i:1569430010;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:326;s:11:\"trend_index\";i:222;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:210;a:14:{s:2:\"id\";i:7997;s:5:\"title\";s:10:\"footer 014\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.1.jpg\";s:12:\"tmpl_created\";i:1524582343;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-014/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:79;s:11:\"trend_index\";i:35;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:211;a:14:{s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:280;s:11:\"trend_index\";i:176;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:212;a:14:{s:2:\"id\";i:7982;s:5:\"title\";s:10:\"footer 013\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.2.jpg\";s:12:\"tmpl_created\";i:1524582468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-013/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:219;s:11:\"trend_index\";i:126;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:213;a:14:{s:2:\"id\";i:11832;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Footer_small.png\";s:12:\"tmpl_created\";i:1569430019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"footer\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:298;s:11:\"trend_index\";i:144;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:214;a:14:{s:2:\"id\";i:7959;s:5:\"title\";s:10:\"footer 012\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.3.jpg\";s:12:\"tmpl_created\";i:1524582605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-012/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:185;s:11:\"trend_index\";i:181;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:215;a:14:{s:2:\"id\";i:11807;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/09/404_small.png\";s:12:\"tmpl_created\";i:1569430070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/portfolio-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:40:\"[\"404\",\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:514;s:11:\"trend_index\";i:360;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:216;a:14:{s:2:\"id\";i:7950;s:5:\"title\";s:10:\"footer 011\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.4.jpg\";s:12:\"tmpl_created\";i:1524582631;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-011/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:255;s:11:\"trend_index\";i:235;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:217;a:14:{s:2:\"id\";i:7937;s:5:\"title\";s:10:\"footer 010\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.5.jpg\";s:12:\"tmpl_created\";i:1524582665;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/footer-010/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:203;s:11:\"trend_index\";i:154;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:218;a:14:{s:2:\"id\";i:11897;s:5:\"title\";s:27:\"Portfolio &#8211; Project 2\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png\";s:12:\"tmpl_created\";i:1569494236;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/blocks/portfolio-project-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:683;s:11:\"trend_index\";i:583;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:219;a:14:{s:2:\"id\";i:7927;s:5:\"title\";s:9:\"footer 09\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.6.jpg\";s:12:\"tmpl_created\";i:1524582691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-09/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:174;s:11:\"trend_index\";i:141;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:220;a:14:{s:2:\"id\";i:11890;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-design-portfolio.png\";s:12:\"tmpl_created\";i:1571907344;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:323;s:11:\"trend_index\";i:213;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:221;a:14:{s:2:\"id\";i:7917;s:5:\"title\";s:9:\"footer 08\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.7.jpg\";s:12:\"tmpl_created\";i:1524582788;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-08/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:97;s:11:\"trend_index\";i:110;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:222;a:14:{s:2:\"id\";i:7904;s:5:\"title\";s:9:\"footer 07\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.8.jpg\";s:12:\"tmpl_created\";i:1524582814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-07/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:204;s:11:\"trend_index\";i:226;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:223;a:14:{s:2:\"id\";i:7837;s:5:\"title\";s:9:\"footer 01\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.14.jpg\";s:12:\"tmpl_created\";i:1524582852;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:448;s:11:\"trend_index\";i:489;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:224;a:14:{s:2:\"id\";i:7852;s:5:\"title\";s:9:\"footer 02\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.13.jpg\";s:12:\"tmpl_created\";i:1524582875;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:216;s:11:\"trend_index\";i:188;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:225;a:14:{s:2:\"id\";i:7862;s:5:\"title\";s:9:\"footer 03\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.12.jpg\";s:12:\"tmpl_created\";i:1524582903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:143;s:11:\"trend_index\";i:128;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:226;a:14:{s:2:\"id\";i:12212;s:5:\"title\";s:28:\"Law Firm &#8211; Single Post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/single.png\";s:12:\"tmpl_created\";i:1572846914;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/law-firm-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:364;s:11:\"trend_index\";i:272;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:227;a:14:{s:2:\"id\";i:7871;s:5:\"title\";s:9:\"footer 04\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.11.jpg\";s:12:\"tmpl_created\";i:1524582927;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:107;s:11:\"trend_index\";i:125;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:228;a:14:{s:2:\"id\";i:12203;s:5:\"title\";s:30:\"Law Firm &#8211; Search Archiv\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/11/search_result.png\";s:12:\"tmpl_created\";i:1572846925;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/law-firm-search-archiv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:540;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:229;a:14:{s:2:\"id\";i:7884;s:5:\"title\";s:9:\"footer 05\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.10.jpg\";s:12:\"tmpl_created\";i:1524582944;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-05/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:84;s:11:\"trend_index\";i:172;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:230;a:14:{s:2:\"id\";i:12194;s:5:\"title\";s:23:\"Law Firm &#8211; Header\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-law-firm.png\";s:12:\"tmpl_created\";i:1572846935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:27:\"[\"header\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:126;s:11:\"trend_index\";i:28;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:231;a:14:{s:2:\"id\";i:7892;s:5:\"title\";s:9:\"footer 06\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/footer350.9.jpg\";s:12:\"tmpl_created\";i:1524583015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/footer-06/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:127;s:11:\"trend_index\";i:224;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:232;a:14:{s:2:\"id\";i:12179;s:5:\"title\";s:23:\"Law Firm &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/footer.png\";s:12:\"tmpl_created\";i:1572846958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:27:\"[\"footer\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:418;s:11:\"trend_index\";i:294;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:233;a:14:{s:2:\"id\";i:4212;s:5:\"title\";s:11:\"Services 23\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_1.png\";s:12:\"tmpl_created\";i:1520443248;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:130;s:11:\"trend_index\";i:109;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:234;a:14:{s:2:\"id\";i:7825;s:5:\"title\";s:9:\"header 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.11.jpg\";s:12:\"tmpl_created\";i:1524583273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:75;s:11:\"trend_index\";i:52;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:235;a:14:{s:2:\"id\";i:12170;s:5:\"title\";s:23:\"Law Firm &#8211; Archiv\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/11/archiv.png\";s:12:\"tmpl_created\";i:1572846967;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/law-firm-archiv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:423;s:11:\"trend_index\";i:377;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:236;a:14:{s:2:\"id\";i:4227;s:5:\"title\";s:11:\"Services 30\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_1.png\";s:12:\"tmpl_created\";i:1520443250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-30/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:329;s:11:\"trend_index\";i:431;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:237;a:14:{s:2:\"id\";i:7812;s:5:\"title\";s:9:\"header 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.10.jpg\";s:12:\"tmpl_created\";i:1524583298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:111;s:11:\"trend_index\";i:97;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:238;a:14:{s:2:\"id\";i:12164;s:5:\"title\";s:20:\"Law Firm &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/11/404.png\";s:12:\"tmpl_created\";i:1572846979;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/law-firm-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:24:\"[\"404\",\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:679;s:11:\"trend_index\";i:642;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:239;a:14:{s:2:\"id\";i:4235;s:5:\"title\";s:11:\"Services 18\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_2.png\";s:12:\"tmpl_created\";i:1520443251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:282;s:11:\"trend_index\";i:342;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:240;a:14:{s:2:\"id\";i:7724;s:5:\"title\";s:8:\"header 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.3.jpg\";s:12:\"tmpl_created\";i:1524583367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:31;s:11:\"trend_index\";i:19;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:241;a:14:{s:2:\"id\";i:4244;s:5:\"title\";s:11:\"Services 26\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_2.png\";s:12:\"tmpl_created\";i:1520443253;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:483;s:11:\"trend_index\";i:548;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:242;a:14:{s:2:\"id\";i:7734;s:5:\"title\";s:8:\"header 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.4.jpg\";s:12:\"tmpl_created\";i:1524583436;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:40;s:11:\"trend_index\";i:34;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:243;a:14:{s:2:\"id\";i:4252;s:5:\"title\";s:10:\"Services 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_3.png\";s:12:\"tmpl_created\";i:1520443255;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:42;s:11:\"trend_index\";i:27;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:244;a:14:{s:2:\"id\";i:7771;s:5:\"title\";s:8:\"header 8\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.7.jpg\";s:12:\"tmpl_created\";i:1524583540;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:100;s:11:\"trend_index\";i:118;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:245;a:14:{s:2:\"id\";i:4260;s:5:\"title\";s:11:\"Services 25\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_3.png\";s:12:\"tmpl_created\";i:1520443257;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-25/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:176;s:11:\"trend_index\";i:162;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:246;a:14:{s:2:\"id\";i:7787;s:5:\"title\";s:8:\"header 9\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.8.jpg\";s:12:\"tmpl_created\";i:1524583598;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:108;s:11:\"trend_index\";i:98;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:247;a:14:{s:2:\"id\";i:4268;s:5:\"title\";s:10:\"Services 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_4.png\";s:12:\"tmpl_created\";i:1520443259;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:167;s:11:\"trend_index\";i:252;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:248;a:14:{s:2:\"id\";i:7801;s:5:\"title\";s:9:\"header 10\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.9.jpg\";s:12:\"tmpl_created\";i:1524583659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:55;s:11:\"trend_index\";i:73;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:249;a:14:{s:2:\"id\";i:4276;s:5:\"title\";s:11:\"Services 24\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_4.png\";s:12:\"tmpl_created\";i:1520443261;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:342;s:11:\"trend_index\";i:347;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:250;a:14:{s:2:\"id\";i:7754;s:5:\"title\";s:8:\"header 7\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.6.jpg\";s:12:\"tmpl_created\";i:1524583712;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:96;s:11:\"trend_index\";i:254;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:251;a:14:{s:2:\"id\";i:4284;s:5:\"title\";s:10:\"Services 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_5.png\";s:12:\"tmpl_created\";i:1520443263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:30;s:11:\"trend_index\";i:8;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:252;a:14:{s:2:\"id\";i:7713;s:5:\"title\";s:8:\"header 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.2.jpg\";s:12:\"tmpl_created\";i:1524584780;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:47;s:11:\"trend_index\";i:37;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:253;a:14:{s:2:\"id\";i:4293;s:5:\"title\";s:10:\"Services 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_6.png\";s:12:\"tmpl_created\";i:1520443265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:276;s:11:\"trend_index\";i:267;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:254;a:14:{s:2:\"id\";i:7744;s:5:\"title\";s:8:\"Header 6\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/03/header350.5.jpg\";s:12:\"tmpl_created\";i:1524584784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/header-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:61;s:11:\"trend_index\";i:100;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:255;a:14:{s:2:\"id\";i:4302;s:5:\"title\";s:10:\"Services 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_7.png\";s:12:\"tmpl_created\";i:1520443266;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/services-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:58;s:11:\"trend_index\";i:46;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:256;a:14:{s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:532;s:11:\"trend_index\";i:485;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:257;a:14:{s:2:\"id\";i:4313;s:5:\"title\";s:11:\"Services 13\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_8.png\";s:12:\"tmpl_created\";i:1520443268;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:118;s:11:\"trend_index\";i:91;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:258;a:14:{s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-06/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:309;s:11:\"trend_index\";i:376;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:259;a:14:{s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:704;s:11:\"trend_index\";i:678;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:260;a:14:{s:2:\"id\";i:4324;s:5:\"title\";s:11:\"Services 14\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_9.png\";s:12:\"tmpl_created\";i:1520443270;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:286;s:11:\"trend_index\";i:248;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:261;a:14:{s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-07/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:318;s:11:\"trend_index\";i:386;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:262;a:14:{s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:638;s:11:\"trend_index\";i:621;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:263;a:14:{s:2:\"id\";i:4332;s:5:\"title\";s:11:\"Services 22\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_10.png\";s:12:\"tmpl_created\";i:1520443272;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:139;s:11:\"trend_index\";i:160;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:264;a:14:{s:2:\"id\";i:8525;s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";i:1526415374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-08/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:491;s:11:\"trend_index\";i:364;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:265;a:14:{s:2:\"id\";i:12492;s:5:\"title\";s:14:\"Travel -Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Footer_s.png\";s:12:\"tmpl_created\";i:1575960358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/travel-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:27:\"[\"footer\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:477;s:11:\"trend_index\";i:469;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:266;a:14:{s:2:\"id\";i:4341;s:5:\"title\";s:11:\"Services 21\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_11.png\";s:12:\"tmpl_created\";i:1520443274;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:141;s:11:\"trend_index\";i:171;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:267;a:14:{s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:445;s:11:\"trend_index\";i:501;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:268;a:14:{s:2:\"id\";i:12500;s:5:\"title\";s:21:\"Travel &#8211; Header\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-travel-and-tours.png\";s:12:\"tmpl_created\";i:1575960371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/travel-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:27:\"[\"header\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:436;s:11:\"trend_index\";i:394;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:269;a:14:{s:2:\"id\";i:4349;s:5:\"title\";s:11:\"Services 29\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_11.png\";s:12:\"tmpl_created\";i:1520443275;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:316;s:11:\"trend_index\";i:410;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:270;a:14:{s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:481;s:11:\"trend_index\";i:474;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:271;a:14:{s:2:\"id\";i:12509;s:5:\"title\";s:18:\"Travel &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/404.png\";s:12:\"tmpl_created\";i:1575960378;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/travel-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:24:\"[\"404\",\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:692;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:272;a:14:{s:2:\"id\";i:4357;s:5:\"title\";s:11:\"Services 20\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_12.png\";s:12:\"tmpl_created\";i:1520443277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:45;s:11:\"trend_index\";i:53;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:273;a:14:{s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-09/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:484;s:11:\"trend_index\";i:535;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:274;a:14:{s:2:\"id\";i:12516;s:5:\"title\";s:27:\"Travel &#8211; Archive Blog\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/12/Archiv_s.png\";s:12:\"tmpl_created\";i:1575960387;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/travel-archive-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:478;s:11:\"trend_index\";i:312;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:275;a:14:{s:2:\"id\";i:4368;s:5:\"title\";s:11:\"Services 16\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_13.png\";s:12:\"tmpl_created\";i:1520443279;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:64;s:11:\"trend_index\";i:74;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:276;a:14:{s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:585;s:11:\"trend_index\";i:647;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:277;a:14:{s:2:\"id\";i:12524;s:5:\"title\";s:26:\"Travel &#8211; Single Post\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/12/Single_Post_s.png\";s:12:\"tmpl_created\";i:1575960397;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/travel-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:555;s:11:\"trend_index\";i:571;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:278;a:14:{s:2:\"id\";i:4376;s:5:\"title\";s:11:\"Services 28\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_12.png\";s:12:\"tmpl_created\";i:1520443281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-28/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:148;s:11:\"trend_index\";i:122;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:279;a:14:{s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:377;s:11:\"trend_index\";i:576;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:280;a:14:{s:2:\"id\";i:12531;s:5:\"title\";s:31:\"Travel &#8211; Single Post Tour\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/12/Single_Tour_s.png\";s:12:\"tmpl_created\";i:1575960404;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/travel-single-post-tour/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:597;s:11:\"trend_index\";i:640;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:281;a:14:{s:2:\"id\";i:4391;s:5:\"title\";s:11:\"Services 17\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_14.png\";s:12:\"tmpl_created\";i:1520443283;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:153;s:11:\"trend_index\";i:165;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:282;a:14:{s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/404-page-05/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:439;s:11:\"trend_index\";i:455;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:283;a:14:{s:2:\"id\";i:4400;s:5:\"title\";s:11:\"Services 27\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_13.png\";s:12:\"tmpl_created\";i:1520443285;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/services-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"services\";s:4:\"tags\";s:12:\"[\"services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:266;s:11:\"trend_index\";i:381;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:284;a:14:{s:2:\"id\";i:8676;s:5:\"title\";s:13:\"single page 1\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.6.jpg\";s:12:\"tmpl_created\";i:1527682423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:335;s:11:\"trend_index\";i:300;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:285;a:14:{s:2:\"id\";i:4411;s:5:\"title\";s:9:\"Contact 3\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_1.png\";s:12:\"tmpl_created\";i:1520443287;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:101;s:11:\"trend_index\";i:150;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:286;a:14:{s:2:\"id\";i:8678;s:5:\"title\";s:13:\"single page 2\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.2.jpg\";s:12:\"tmpl_created\";i:1527682780;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:179;s:11:\"trend_index\";i:72;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:287;a:14:{s:2:\"id\";i:4420;s:5:\"title\";s:9:\"Contact 1\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_1.png\";s:12:\"tmpl_created\";i:1520443289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-1-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:184;s:11:\"trend_index\";i:259;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:288;a:14:{s:2:\"id\";i:8679;s:5:\"title\";s:13:\"single page 3\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.3.jpg\";s:12:\"tmpl_created\";i:1527682847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:54;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:289;a:14:{s:2:\"id\";i:4428;s:5:\"title\";s:9:\"Contact 4\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_2.png\";s:12:\"tmpl_created\";i:1520443291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:110;s:11:\"trend_index\";i:117;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:290;a:14:{s:2:\"id\";i:8680;s:5:\"title\";s:13:\"single page 4\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.1.jpg\";s:12:\"tmpl_created\";i:1527682896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:421;s:11:\"trend_index\";i:318;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:291;a:14:{s:2:\"id\";i:4436;s:5:\"title\";s:11:\"Contact  16\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_black_2.png\";s:12:\"tmpl_created\";i:1520443293;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:165;s:11:\"trend_index\";i:177;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:292;a:14:{s:2:\"id\";i:8681;s:5:\"title\";s:13:\"single page 5\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.5.jpg\";s:12:\"tmpl_created\";i:1527682969;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:319;s:11:\"trend_index\";i:230;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:293;a:14:{s:2:\"id\";i:4444;s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_1.png\";s:12:\"tmpl_created\";i:1520443295;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:85;s:11:\"trend_index\";i:66;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:294;a:14:{s:2:\"id\";i:8682;s:5:\"title\";s:13:\"single page 6\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.4.jpg\";s:12:\"tmpl_created\";i:1527683026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:454;s:11:\"trend_index\";i:299;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:295;a:14:{s:2:\"id\";i:4452;s:5:\"title\";s:9:\"Contact 6\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_1.png\";s:12:\"tmpl_created\";i:1520443296;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:138;s:11:\"trend_index\";i:107;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:296;a:14:{s:2:\"id\";i:8703;s:5:\"title\";s:13:\"single page 7\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.7.jpg\";s:12:\"tmpl_created\";i:1527683072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-page-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:413;s:11:\"trend_index\";i:314;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:297;a:14:{s:2:\"id\";i:4460;s:5:\"title\";s:9:\"Contact 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_2.png\";s:12:\"tmpl_created\";i:1520443298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:104;s:11:\"trend_index\";i:82;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:298;a:14:{s:2:\"id\";i:8961;s:5:\"title\";s:9:\"archive 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.1.jpg\";s:12:\"tmpl_created\";i:1528639909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:94;s:11:\"trend_index\";i:105;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:299;a:14:{s:2:\"id\";i:4468;s:5:\"title\";s:9:\"Contact 7\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_3.png\";s:12:\"tmpl_created\";i:1520443301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:133;s:11:\"trend_index\";i:96;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:300;a:14:{s:2:\"id\";i:8969;s:5:\"title\";s:9:\"archive 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.2.jpg\";s:12:\"tmpl_created\";i:1528700014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:252;s:11:\"trend_index\";i:496;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:301;a:14:{s:2:\"id\";i:12716;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 3\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post4_s.png\";s:12:\"tmpl_created\";i:1579060659;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/magazine-single-post-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:536;s:11:\"trend_index\";i:396;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:302;a:14:{s:2:\"id\";i:4476;s:5:\"title\";s:10:\"Contact 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_4.png\";s:12:\"tmpl_created\";i:1520443303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:234;s:11:\"trend_index\";i:244;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:303;a:14:{s:2:\"id\";i:8973;s:5:\"title\";s:9:\"archive 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.3.jpg\";s:12:\"tmpl_created\";i:1528700205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:188;s:11:\"trend_index\";i:215;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:304;a:14:{s:2:\"id\";i:12707;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 3\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post1_s.png\";s:12:\"tmpl_created\";i:1579060669;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:512;s:11:\"trend_index\";i:330;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:305;a:14:{s:2:\"id\";i:4484;s:5:\"title\";s:9:\"Contact 8\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_3.png\";s:12:\"tmpl_created\";i:1520443305;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/contact-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:324;s:11:\"trend_index\";i:397;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:306;a:14:{s:2:\"id\";i:8977;s:5:\"title\";s:9:\"archive 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.4.jpg\";s:12:\"tmpl_created\";i:1528700326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:349;s:11:\"trend_index\";i:490;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:307;a:14:{s:2:\"id\";i:12699;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 2\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post3_s.png\";s:12:\"tmpl_created\";i:1579060680;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:408;s:11:\"trend_index\";i:269;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:308;a:14:{s:2:\"id\";i:4492;s:5:\"title\";s:9:\"Contact 5\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/02/map_white_3.png\";s:12:\"tmpl_created\";i:1520443307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/contact-5-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:11:\"[\"contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:38;s:11:\"trend_index\";i:23;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:309;a:14:{s:2:\"id\";i:8981;s:5:\"title\";s:9:\"archive 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.5.jpg\";s:12:\"tmpl_created\";i:1528700484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:321;s:11:\"trend_index\";i:393;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:310;a:14:{s:2:\"id\";i:12688;s:5:\"title\";s:30:\"Magazine &#8211; Single Post 1\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/01/Post2_s.png\";s:12:\"tmpl_created\";i:1579060692;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/magazine-single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:400;s:11:\"trend_index\";i:243;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:311;a:14:{s:2:\"id\";i:4500;s:5:\"title\";s:9:\"Pricing 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_1.png\";s:12:\"tmpl_created\";i:1520443308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:469;s:11:\"trend_index\";i:481;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:312;a:14:{s:2:\"id\";i:8985;s:5:\"title\";s:9:\"archive 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.6.jpg\";s:12:\"tmpl_created\";i:1528700612;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:211;s:11:\"trend_index\";i:250;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:313;a:14:{s:2:\"id\";i:12678;s:5:\"title\";s:23:\"Magazine &#8211; Header\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-magazine.png\";s:12:\"tmpl_created\";i:1579060701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:28:\"[\"Blog\",\"header\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:313;s:11:\"trend_index\";i:240;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:314;a:14:{s:2:\"id\";i:4509;s:5:\"title\";s:9:\"Pricing 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_1.png\";s:12:\"tmpl_created\";i:1520443310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:652;s:11:\"trend_index\";i:687;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:315;a:14:{s:2:\"id\";i:8989;s:5:\"title\";s:9:\"archive 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.7.jpg\";s:12:\"tmpl_created\";i:1528701063;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:205;s:11:\"trend_index\";i:290;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:316;a:14:{s:2:\"id\";i:12669;s:5:\"title\";s:23:\"Magazine &#8211; Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Footer_s.png\";s:12:\"tmpl_created\";i:1579060715;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:28:\"[\"Blog\",\"footer\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:463;s:11:\"trend_index\";i:336;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:317;a:14:{s:2:\"id\";i:4521;s:5:\"title\";s:9:\"Pricing 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_2.png\";s:12:\"tmpl_created\";i:1520443312;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:310;s:11:\"trend_index\";i:344;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:318;a:14:{s:2:\"id\";i:8996;s:5:\"title\";s:9:\"archive 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.8.jpg\";s:12:\"tmpl_created\";i:1528701290;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:215;s:11:\"trend_index\";i:452;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:319;a:14:{s:2:\"id\";i:12661;s:5:\"title\";s:23:\"Magazine &#8211; Search\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/01/Search_s.png\";s:12:\"tmpl_created\";i:1579060722;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/magazine-search/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:443;s:11:\"trend_index\";i:214;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:320;a:14:{s:2:\"id\";i:4529;s:5:\"title\";s:9:\"Pricing 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_2.png\";s:12:\"tmpl_created\";i:1520443314;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:568;s:11:\"trend_index\";i:553;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:321;a:14:{s:2:\"id\";i:9001;s:5:\"title\";s:9:\"archive 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.9.jpg\";s:12:\"tmpl_created\";i:1528701433;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/archive-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:267;s:11:\"trend_index\";i:429;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:322;a:14:{s:2:\"id\";i:12652;s:5:\"title\";s:17:\"Magazine- Archiv2\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/01/Archiv2_s.png\";s:12:\"tmpl_created\";i:1579060730;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/magazine-archiv2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:525;s:11:\"trend_index\";i:516;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:323;a:14:{s:2:\"id\";i:4537;s:5:\"title\";s:9:\"Pricing 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_3.png\";s:12:\"tmpl_created\";i:1520443315;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:538;s:11:\"trend_index\";i:562;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:324;a:14:{s:2:\"id\";i:9119;s:5:\"title\";s:10:\"footer 015\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/Footer_GetStarted_350.png\";s:12:\"tmpl_created\";i:1532428138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/blocks/demo/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:253;s:11:\"trend_index\";i:266;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:325;a:14:{s:2:\"id\";i:12643;s:5:\"title\";s:24:\"Magazine &#8211; Archiv1\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/01/Archiv1_s.png\";s:12:\"tmpl_created\";i:1579060737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/magazine-archiv1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:386;s:11:\"trend_index\";i:287;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:326;a:14:{s:2:\"id\";i:4545;s:5:\"title\";s:9:\"Pricing 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_3.png\";s:12:\"tmpl_created\";i:1520443317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:648;s:11:\"trend_index\";i:658;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:327;a:14:{s:2:\"id\";i:9127;s:5:\"title\";s:9:\"header 13\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2018/07/Header_get_started_1200V3.png\";s:12:\"tmpl_created\";i:1532428699;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/header-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:60;s:11:\"trend_index\";i:106;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:328;a:14:{s:2:\"id\";i:12635;s:5:\"title\";s:20:\"Magazine &#8211; 404\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/01/404_s.png\";s:12:\"tmpl_created\";i:1579060746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/magazine-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:25:\"[\"404\",\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:611;s:11:\"trend_index\";i:528;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:329;a:14:{s:2:\"id\";i:4553;s:5:\"title\";s:10:\"Pricing 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_4.png\";s:12:\"tmpl_created\";i:1520443319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:482;s:11:\"trend_index\";i:453;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:330;a:14:{s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:670;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:331;a:14:{s:2:\"id\";i:4562;s:5:\"title\";s:9:\"Pricing 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_4.png\";s:12:\"tmpl_created\";i:1520443322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:636;s:11:\"trend_index\";i:709;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:332;a:14:{s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:417;s:11:\"trend_index\";i:274;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:333;a:14:{s:2:\"id\";i:4572;s:5:\"title\";s:10:\"Pricing 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_5.png\";s:12:\"tmpl_created\";i:1520443324;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:308;s:11:\"trend_index\";i:310;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:334;a:14:{s:2:\"id\";i:9174;s:5:\"title\";s:17:\"single product 01\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product01_350.png\";s:12:\"tmpl_created\";i:1532950125;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:44;s:11:\"trend_index\";i:16;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:335;a:14:{s:2:\"id\";i:13089;s:5:\"title\";s:23:\"Photography &#8211; 404\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/02/404_s.png\";s:12:\"tmpl_created\";i:1582091623;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/blocks/photography-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:33:\"[\"404\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:681;s:11:\"trend_index\";i:580;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:336;a:14:{s:2:\"id\";i:4580;s:5:\"title\";s:10:\"Pricing 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_6.png\";s:12:\"tmpl_created\";i:1520443326;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:537;s:11:\"trend_index\";i:588;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:337;a:14:{s:2:\"id\";i:9178;s:5:\"title\";s:17:\"single product 02\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product02_350new.png\";s:12:\"tmpl_created\";i:1532951997;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:87;s:11:\"trend_index\";i:55;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:338;a:14:{s:2:\"id\";i:13096;s:5:\"title\";s:32:\"Photography &#8211; Archiv Media\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Archiv_s.png\";s:12:\"tmpl_created\";i:1582091742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/photography-archiv-media/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:609;s:11:\"trend_index\";i:447;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:339;a:14:{s:2:\"id\";i:4589;s:5:\"title\";s:9:\"Pricing 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_6.png\";s:12:\"tmpl_created\";i:1520443327;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:659;s:11:\"trend_index\";i:713;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:340;a:14:{s:2:\"id\";i:9180;s:5:\"title\";s:17:\"single product 03\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product03_350.png\";s:12:\"tmpl_created\";i:1532952302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:129;s:11:\"trend_index\";i:61;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:341;a:14:{s:2:\"id\";i:13103;s:5:\"title\";s:26:\"Photography &#8211; Footer\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Footer_s.png\";s:12:\"tmpl_created\";i:1582091903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/photography-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:36:\"[\"footer\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:465;s:11:\"trend_index\";i:341;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:342;a:14:{s:2:\"id\";i:4597;s:5:\"title\";s:10:\"Pricing 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_7.png\";s:12:\"tmpl_created\";i:1520443330;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:561;s:11:\"trend_index\";i:715;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:343;a:14:{s:2:\"id\";i:9182;s:5:\"title\";s:17:\"single product 04\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/single_product040_350.png\";s:12:\"tmpl_created\";i:1532952606;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/single-product-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"single product\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:144;s:11:\"trend_index\";i:93;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:344;a:14:{s:2:\"id\";i:13120;s:5:\"title\";s:31:\"Photography &#8211; Single Post\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Post_s.png\";s:12:\"tmpl_created\";i:1582092351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/blocks/photography-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:590;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:345;a:14:{s:2:\"id\";i:4605;s:5:\"title\";s:9:\"Pricing 6\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_black_7.png\";s:12:\"tmpl_created\";i:1520443332;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/pricing-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:678;s:11:\"trend_index\";i:650;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:346;a:14:{s:2:\"id\";i:9239;s:5:\"title\";s:17:\"product archive 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-1.png\";s:12:\"tmpl_created\";i:1532953482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:80;s:11:\"trend_index\";i:30;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:347;a:14:{s:2:\"id\";i:13112;s:5:\"title\";s:26:\"Photography &#8211; Header\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-photography-portfolio.png\";s:12:\"tmpl_created\";i:1582092483;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/photography-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:36:\"[\"header\",\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:199;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:348;a:14:{s:2:\"id\";i:4613;s:5:\"title\";s:10:\"Pricing 14\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/02/price_white_8.png\";s:12:\"tmpl_created\";i:1520443334;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/pricing-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"pricing\";s:4:\"tags\";s:11:\"[\"pricing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:535;s:11:\"trend_index\";i:599;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:349;a:14:{s:2:\"id\";i:9247;s:5:\"title\";s:17:\"product archive 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-2.png\";s:12:\"tmpl_created\";i:1532953793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:93;s:11:\"trend_index\";i:43;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:350;a:14:{s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:616;s:11:\"trend_index\";i:699;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:351;a:14:{s:2:\"id\";i:9254;s:5:\"title\";s:17:\"product archive 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-3.png\";s:12:\"tmpl_created\";i:1532954032;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/product-archive-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:15:\"product archive\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:103;s:11:\"trend_index\";i:39;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:352;a:14:{s:2:\"id\";i:9301;s:5:\"title\";s:13:\"Single Post 4\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3003.jpg\";s:12:\"tmpl_created\";i:1537440661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:227;s:11:\"trend_index\";i:380;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:353;a:14:{s:2:\"id\";i:9296;s:5:\"title\";s:13:\"Single Post 3\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3002.jpg\";s:12:\"tmpl_created\";i:1537440673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:202;s:11:\"trend_index\";i:295;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:354;a:14:{s:2:\"id\";i:9313;s:5:\"title\";s:13:\"Single Post 5\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3001.jpg\";s:12:\"tmpl_created\";i:1537440798;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:181;s:11:\"trend_index\";i:301;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:355;a:14:{s:2:\"id\";i:9343;s:5:\"title\";s:13:\"Single Post 6\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3004.jpg\";s:12:\"tmpl_created\";i:1537443531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:208;s:11:\"trend_index\";i:385;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:356;a:14:{s:2:\"id\";i:9349;s:5:\"title\";s:13:\"Single Post 7\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2018/09/3005.jpg\";s:12:\"tmpl_created\";i:1537443903;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/single-post-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:147;s:11:\"trend_index\";i:166;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:357;a:14:{s:2:\"id\";i:4690;s:5:\"title\";s:6:\"Team 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_1.png\";s:12:\"tmpl_created\";i:1520443348;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:233;s:11:\"trend_index\";i:204;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:358;a:14:{s:2:\"id\";i:4698;s:5:\"title\";s:7:\"Team 15\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_1.png\";s:12:\"tmpl_created\";i:1520443350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:402;s:11:\"trend_index\";i:446;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:359;a:14:{s:2:\"id\";i:4706;s:5:\"title\";s:6:\"Team 5\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_2.png\";s:12:\"tmpl_created\";i:1520443352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:142;s:11:\"trend_index\";i:119;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:360;a:14:{s:2:\"id\";i:4718;s:5:\"title\";s:6:\"Team 4\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_3.png\";s:12:\"tmpl_created\";i:1520443354;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/team-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:178;s:11:\"trend_index\";i:221;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:361;a:14:{s:2:\"id\";i:4727;s:5:\"title\";s:7:\"Team 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_2.png\";s:12:\"tmpl_created\";i:1520443356;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:360;s:11:\"trend_index\";i:369;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:362;a:14:{s:2:\"id\";i:4736;s:5:\"title\";s:7:\"Team 20\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_4.png\";s:12:\"tmpl_created\";i:1520443358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:140;s:11:\"trend_index\";i:114;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:363;a:14:{s:2:\"id\";i:4746;s:5:\"title\";s:7:\"Team 23\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_4.png\";s:12:\"tmpl_created\";i:1520443360;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:263;s:11:\"trend_index\";i:223;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:364;a:14:{s:2:\"id\";i:4759;s:5:\"title\";s:7:\"Team 22\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_5.png\";s:12:\"tmpl_created\";i:1520443362;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:290;s:11:\"trend_index\";i:422;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:365;a:14:{s:2:\"id\";i:4770;s:5:\"title\";s:7:\"Team 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_6.png\";s:12:\"tmpl_created\";i:1520443364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/team-12-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:393;s:11:\"trend_index\";i:403;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:366;a:14:{s:2:\"id\";i:4781;s:5:\"title\";s:7:\"Team 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_7.png\";s:12:\"tmpl_created\";i:1520443365;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:258;s:11:\"trend_index\";i:479;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:367;a:14:{s:2:\"id\";i:9611;s:5:\"title\";s:16:\"Hello Bar | Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2019/01/Top-Bar_Sale_small_01.png\";s:12:\"tmpl_created\";i:1546965350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/hello-bar-sale-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:571;s:11:\"trend_index\";i:463;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:368;a:14:{s:2:\"id\";i:13274;s:5:\"title\";s:38:\"Interior Design &#8211; Single Project\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/04/Single-Project-.png\";s:12:\"tmpl_created\";i:1586148723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/blocks/interior-design-single-project/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:497;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:369;a:14:{s:2:\"id\";i:4793;s:5:\"title\";s:7:\"Team 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_8.png\";s:12:\"tmpl_created\";i:1520443367;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:194;s:11:\"trend_index\";i:210;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:370;a:14:{s:2:\"id\";i:9622;s:5:\"title\";s:19:\"Classic | Promotion\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_promotion_small_02.png\";s:12:\"tmpl_created\";i:1546965896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-promotion-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:575;s:11:\"trend_index\";i:533;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:371;a:14:{s:2:\"id\";i:13267;s:5:\"title\";s:35:\"Interior Design &#8211; Single News\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Post.png\";s:12:\"tmpl_created\";i:1586148728;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/interior-design-single-news/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:544;s:11:\"trend_index\";i:491;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:372;a:14:{s:2:\"id\";i:4801;s:5:\"title\";s:7:\"Team 11\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_8.png\";s:12:\"tmpl_created\";i:1520443369;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:333;s:11:\"trend_index\";i:328;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:373;a:14:{s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1546968270;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/slide-in-sale-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:601;s:11:\"trend_index\";i:618;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:374;a:14:{s:2:\"id\";i:13259;s:5:\"title\";s:36:\"Interior Design &#8211; News Archive\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Archiv-Blog.png\";s:12:\"tmpl_created\";i:1586148733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/interior-design-news-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:509;s:11:\"trend_index\";i:351;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:375;a:14:{s:2:\"id\";i:4809;s:5:\"title\";s:7:\"Team 19\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_white_9.png\";s:12:\"tmpl_created\";i:1520443371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:283;s:11:\"trend_index\";i:458;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:376;a:14:{s:2:\"id\";i:13251;s:5:\"title\";s:27:\"Interior Design &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/04/404.png\";s:12:\"tmpl_created\";i:1586148737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/blocks/interior-design-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:698;s:11:\"trend_index\";i:686;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:377;a:14:{s:2:\"id\";i:4818;s:5:\"title\";s:7:\"Team 21\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/team_black_9.png\";s:12:\"tmpl_created\";i:1520443373;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/team-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"team\";s:4:\"tags\";s:8:\"[\"team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:466;s:11:\"trend_index\";i:520;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:378;a:14:{s:2:\"id\";i:13244;s:5:\"title\";s:30:\"Interior Design &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/04/Footer.png\";s:12:\"tmpl_created\";i:1586148742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/interior-design-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:39:\"[\"business\",\"footer\",\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:405;s:11:\"trend_index\";i:219;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:379;a:14:{s:2:\"id\";i:5045;s:5:\"title\";s:11:\"Portfolio 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_2.png\";s:12:\"tmpl_created\";i:1520443423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"portfolio\";s:4:\"tags\";s:13:\"[\"portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:684;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:380;a:14:{s:2:\"id\";i:9662;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2019/01/Bottom-Bar_Register_small_01.png\";s:12:\"tmpl_created\";i:1547009087;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/bottom-bar-register-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:381;a:14:{s:2:\"id\";i:13236;s:5:\"title\";s:30:\"Interior Design &#8211; Header\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-interior-design.png\";s:12:\"tmpl_created\";i:1586148746;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/interior-design-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:39:\"[\"business\",\"header\",\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:222;s:11:\"trend_index\";i:78;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:382;a:14:{s:2:\"id\";i:5157;s:5:\"title\";s:11:\"Subscribe 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_1.png\";s:12:\"tmpl_created\";i:1520443448;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:341;s:11:\"trend_index\";i:323;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:383;a:14:{s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"interior design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:718;s:11:\"trend_index\";i:685;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:384;a:14:{s:2:\"id\";i:5165;s:5:\"title\";s:11:\"Subscribe 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_1.png\";s:12:\"tmpl_created\";i:1520443450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:498;s:11:\"trend_index\";i:505;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:385;a:14:{s:2:\"id\";i:5173;s:5:\"title\";s:11:\"Subscribe 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_2.png\";s:12:\"tmpl_created\";i:1520443452;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:271;s:11:\"trend_index\";i:228;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:386;a:14:{s:2:\"id\";i:9690;s:5:\"title\";s:17:\"Classic | Contact\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Contact_small_01.png\";s:12:\"tmpl_created\";i:1547011716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/classic-contact-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:380;s:11:\"trend_index\";i:426;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:387;a:14:{s:2:\"id\";i:5181;s:5:\"title\";s:11:\"Subscribe 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_2.png\";s:12:\"tmpl_created\";i:1520443454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/blocks/subscribe-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:426;s:11:\"trend_index\";i:440;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:388;a:14:{s:2:\"id\";i:9699;s:5:\"title\";s:33:\"Classic | Contact | Gym | Fitness\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Contact_small_02.png\";s:12:\"tmpl_created\";i:1547015827;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/classic-contact-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:449;s:11:\"trend_index\";i:536;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:389;a:14:{s:2:\"id\";i:5189;s:5:\"title\";s:6:\"CTA 29\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_1.png\";s:12:\"tmpl_created\";i:1520443456;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:435;s:11:\"trend_index\";i:475;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:390;a:14:{s:2:\"id\";i:5198;s:5:\"title\";s:6:\"CTA 30\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_1.png\";s:12:\"tmpl_created\";i:1520443458;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-30/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:517;s:11:\"trend_index\";i:563;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:391;a:14:{s:2:\"id\";i:9571;s:5:\"title\";s:14:\"Fly In | Login\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/FlyIn_Login_01_small.png\";s:12:\"tmpl_created\";i:1547726151;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/fly-in-login-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:583;s:11:\"trend_index\";i:577;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:392;a:14:{s:2:\"id\";i:13395;s:5:\"title\";s:34:\"Online Course &#8211; Start Lesson\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-Start.jpg\";s:12:\"tmpl_created\";i:1587474673;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/online-course-start-lesson/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:662;s:11:\"trend_index\";i:515;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:393;a:14:{s:2:\"id\";i:5206;s:5:\"title\";s:6:\"CTA 31\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_2.png\";s:12:\"tmpl_created\";i:1520443459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-31/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:548;s:11:\"trend_index\";i:550;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:394;a:14:{s:2:\"id\";i:13387;s:5:\"title\";s:32:\"Online Course &#8211; End Lesson\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-End-.jpg\";s:12:\"tmpl_created\";i:1587474682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/blocks/online-course-end-lesson/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:663;s:11:\"trend_index\";i:487;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:395;a:14:{s:2:\"id\";i:5214;s:5:\"title\";s:10:\"Contact 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_2.png\";s:12:\"tmpl_created\";i:1520443462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/blocks/contact-16-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:196;s:11:\"trend_index\";i:152;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:396;a:14:{s:2:\"id\";i:13378;s:5:\"title\";s:28:\"Online Course &#8211; Header\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2020/06/Header-education-online-courses.jpg\";s:12:\"tmpl_created\";i:1587474693;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/online-course-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:38:\"[\"Course Online\",\"Education\",\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:519;s:11:\"trend_index\";i:359;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:397;a:14:{s:2:\"id\";i:5222;s:5:\"title\";s:11:\"Subscribe 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_3.png\";s:12:\"tmpl_created\";i:1520443464;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/subscribe-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:9:\"subscribe\";s:4:\"tags\";s:20:\"[\"form\",\"subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:387;s:11:\"trend_index\";i:461;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:398;a:14:{s:2:\"id\";i:9740;s:5:\"title\";s:25:\"Classic | Promotion | App\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/app_small.png\";s:12:\"tmpl_created\";i:1547822836;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/classic-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:576;s:11:\"trend_index\";i:566;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:399;a:14:{s:2:\"id\";i:13369;s:5:\"title\";s:28:\"Online Course &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/04/Footer.jpg\";s:12:\"tmpl_created\";i:1587474701;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/online-course-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:38:\"[\"Course Online\",\"Education\",\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:480;s:11:\"trend_index\";i:371;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:400;a:14:{s:2:\"id\";i:5230;s:5:\"title\";s:10:\"Contact 17\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_3.png\";s:12:\"tmpl_created\";i:1520443466;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:18:\"[\"contact\",\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:325;s:11:\"trend_index\";i:356;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:401;a:14:{s:2:\"id\";i:13361;s:5:\"title\";s:25:\"Online Course &#8211; 404\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/04/404.jpg\";s:12:\"tmpl_created\";i:1587474710;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/online-course-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:35:\"[\"404\",\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:677;s:11:\"trend_index\";i:435;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:402;a:14:{s:2:\"id\";i:5238;s:5:\"title\";s:7:\"Hero 12\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4.png\";s:12:\"tmpl_created\";i:1520443468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/hero-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:4:\"hero\";s:4:\"tags\";s:8:\"[\"hero\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:564;s:11:\"trend_index\";i:570;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:403;a:14:{s:2:\"id\";i:9762;s:5:\"title\";s:36:\"Classic | Register | Subscribe | Spa\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/spa_small_classic.png\";s:12:\"tmpl_created\";i:1547824145;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-register-subscribe-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:451;s:11:\"trend_index\";i:349;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:404;a:14:{s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:590;s:11:\"trend_index\";i:407;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:405;a:14:{s:2:\"id\";i:5249;s:5:\"title\";s:6:\"CTA 32\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_4.png\";s:12:\"tmpl_created\";i:1520443470;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/blocks/cta-32/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:14:\"call to action\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:492;s:11:\"trend_index\";i:499;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:406;a:14:{s:2:\"id\";i:9772;s:5:\"title\";s:27:\"Hello bar | Promotion | App\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/app_hello_small.png\";s:12:\"tmpl_created\";i:1547824279;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/hello-bar-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:708;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:407;a:14:{s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:624;s:11:\"trend_index\";i:523;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:408;a:14:{s:2:\"id\";i:5257;s:5:\"title\";s:10:\"Contact 18\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5.png\";s:12:\"tmpl_created\";i:1520443472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/contact-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"contact\";s:4:\"tags\";s:8:\"[\"form\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:407;s:11:\"trend_index\";i:495;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:409;a:14:{s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:572;s:11:\"trend_index\";i:519;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"1\";}i:410;a:14:{s:2:\"id\";i:5266;s:5:\"title\";s:9:\"Clients 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_1.png\";s:12:\"tmpl_created\";i:1520443474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:98;s:11:\"trend_index\";i:92;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:411;a:14:{s:2:\"id\";i:9793;s:5:\"title\";s:13:\"Fly In | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_black_small.png\";s:12:\"tmpl_created\";i:1547831151;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/popups/fly-in-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:618;s:11:\"trend_index\";i:541;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:412;a:14:{s:2:\"id\";i:13621;s:5:\"title\";s:30:\"Barbershop &#8211; Single Post\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/05/Single-Page.jpg\";s:12:\"tmpl_created\";i:1589893137;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/blocks/barbershop-single-post/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:11:\"single post\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:723;s:11:\"trend_index\";i:623;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:413;a:14:{s:2:\"id\";i:5275;s:5:\"title\";s:9:\"Clients 5\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_1.png\";s:12:\"tmpl_created\";i:1520443476;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:322;s:11:\"trend_index\";i:258;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:414;a:14:{s:2:\"id\";i:13612;s:5:\"title\";s:25:\"Barbershop &#8211; Header\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/06/barber-shop-header.jpg\";s:12:\"tmpl_created\";i:1589893142;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/barbershop-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"header\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:476;s:11:\"trend_index\";i:225;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:415;a:14:{s:2:\"id\";i:5283;s:5:\"title\";s:9:\"Clients 1\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_2.png\";s:12:\"tmpl_created\";i:1520443478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-1-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:297;s:11:\"trend_index\";i:460;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:416;a:14:{s:2:\"id\";i:13604;s:5:\"title\";s:25:\"Barbershop &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1589893147;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/barbershop-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"Barber Shop\",\"Barbershop\",\"footer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:622;s:11:\"trend_index\";i:405;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:417;a:14:{s:2:\"id\";i:5290;s:5:\"title\";s:9:\"Clients 3\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_2.png\";s:12:\"tmpl_created\";i:1520443480;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:518;s:11:\"trend_index\";i:565;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:418;a:14:{s:2:\"id\";i:13528;s:5:\"title\";s:22:\"Barbershop &#8211; 404\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/05/404-Page.jpg\";s:12:\"tmpl_created\";i:1589893152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/blocks/barbershop-404/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:727;s:11:\"trend_index\";i:675;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:419;a:14:{s:2:\"id\";i:5298;s:5:\"title\";s:10:\"Clients 15\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_3.png\";s:12:\"tmpl_created\";i:1520443482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:437;s:11:\"trend_index\";i:506;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:420;a:14:{s:2:\"id\";i:9836;s:5:\"title\";s:21:\"Classic | Login | Pop\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/login_b_small.png\";s:12:\"tmpl_created\";i:1547835635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/popups/classic-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:584;s:11:\"trend_index\";i:552;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:421;a:14:{s:2:\"id\";i:13518;s:5:\"title\";s:26:\"Barbershop &#8211; Archive\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Blog-Page.jpg\";s:12:\"tmpl_created\";i:1589893157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/blocks/barbershop-archive/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"archive\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:649;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:422;a:14:{s:2:\"id\";i:5306;s:5:\"title\";s:10:\"Clients 10\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_3.png\";s:12:\"tmpl_created\";i:1520443484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:605;s:11:\"trend_index\";i:677;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:423;a:14:{s:2:\"id\";i:9847;s:5:\"title\";s:25:\"Fly In | Promotion | Lego\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_in_promotion_tro.png\";s:12:\"tmpl_created\";i:1547836956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/fly-in-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:686;s:11:\"trend_index\";i:692;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:424;a:14:{s:2:\"id\";i:5315;s:5:\"title\";s:10:\"Clients 12\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4-1.png\";s:12:\"tmpl_created\";i:1520443486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:485;s:11:\"trend_index\";i:568;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:425;a:14:{s:2:\"id\";i:9858;s:5:\"title\";s:27:\"Slide In | Promotion | Wine\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/slide-in_promotion_wine_small.png\";s:12:\"tmpl_created\";i:1547837100;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/slide-in-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:712;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:426;a:14:{s:2:\"id\";i:5324;s:5:\"title\";s:9:\"Clients 8\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5-1.png\";s:12:\"tmpl_created\";i:1520443488;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:511;s:11:\"trend_index\";i:603;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:427;a:14:{s:2:\"id\";i:5333;s:5:\"title\";s:10:\"Clients 13\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_6.png\";s:12:\"tmpl_created\";i:1520443489;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:238;s:11:\"trend_index\";i:324;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:428;a:14:{s:2:\"id\";i:5341;s:5:\"title\";s:10:\"Clients 11\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_4.png\";s:12:\"tmpl_created\";i:1520443491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:566;s:11:\"trend_index\";i:646;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:429;a:14:{s:2:\"id\";i:5349;s:5:\"title\";s:9:\"Clients 7\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_7.png\";s:12:\"tmpl_created\";i:1520443493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:243;s:11:\"trend_index\";i:261;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:430;a:14:{s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:701;s:11:\"trend_index\";i:551;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:431;a:14:{s:2:\"id\";i:5357;s:5:\"title\";s:9:\"Clients 2\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_7.png\";s:12:\"tmpl_created\";i:1520443495;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/clients-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:330;s:11:\"trend_index\";i:320;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:432;a:14:{s:2:\"id\";i:5368;s:5:\"title\";s:9:\"Clients 9\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_8.png\";s:12:\"tmpl_created\";i:1520443497;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/clients-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:247;s:11:\"trend_index\";i:273;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:433;a:14:{s:2:\"id\";i:5381;s:5:\"title\";s:10:\"Clients 16\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_white_9.png\";s:12:\"tmpl_created\";i:1520443499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:186;s:11:\"trend_index\";i:264;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:434;a:14:{s:2:\"id\";i:5389;s:5:\"title\";s:10:\"Clients 14\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/03/form_black_9.png\";s:12:\"tmpl_created\";i:1520443501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/blocks/clients-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:7:\"clients\";s:4:\"tags\";s:11:\"[\"clients\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:385;s:11:\"trend_index\";i:420;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:435;a:14:{s:2:\"id\";i:9944;s:5:\"title\";s:33:\"Slide In | Promotion | Headphones\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_head_small.png\";s:12:\"tmpl_created\";i:1547841939;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/slide-in-promotion-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:689;s:11:\"trend_index\";i:652;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:436;a:14:{s:2:\"id\";i:5397;s:5:\"title\";s:8:\"About 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png\";s:12:\"tmpl_created\";i:1520443503;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:154;s:11:\"trend_index\";i:151;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:437;a:14:{s:2:\"id\";i:9955;s:5:\"title\";s:14:\"Fly In | Login\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_login_lock_small.png\";s:12:\"tmpl_created\";i:1547842065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/popups/fly-in-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:524;s:11:\"trend_index\";i:522;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:438;a:14:{s:2:\"id\";i:5405;s:5:\"title\";s:8:\"About 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png\";s:12:\"tmpl_created\";i:1520443505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:224;s:11:\"trend_index\";i:348;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:439;a:14:{s:2:\"id\";i:9965;s:5:\"title\";s:30:\"Classic | Register | Subscribe\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_moon_small.png\";s:12:\"tmpl_created\";i:1547842174;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:539;s:11:\"trend_index\";i:606;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:440;a:14:{s:2:\"id\";i:5413;s:5:\"title\";s:8:\"About 21\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2.png\";s:12:\"tmpl_created\";i:1520443507;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:92;s:11:\"trend_index\";i:38;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:441;a:14:{s:2:\"id\";i:14058;s:5:\"title\";s:36:\"Japanese restaurant &#8211; 404 page\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/06/404-Page.jpg\";s:12:\"tmpl_created\";i:1592290211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/blocks/japanese-restaurant-404-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:38:\"[\"404\",\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:721;s:11:\"trend_index\";i:512;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:442;a:14:{s:2:\"id\";i:5421;s:5:\"title\";s:8:\"About 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png\";s:12:\"tmpl_created\";i:1520443509;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:226;s:11:\"trend_index\";i:247;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:443;a:14:{s:2:\"id\";i:14050;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Footer\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/Footer-Small.jpg\";s:12:\"tmpl_created\";i:1592290247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/japanese-restaurant-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:41:\"[\"Food\",\"footer\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:522;s:11:\"trend_index\";i:147;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:444;a:14:{s:2:\"id\";i:5429;s:5:\"title\";s:8:\"About 16\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png\";s:12:\"tmpl_created\";i:1520443510;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:74;s:11:\"trend_index\";i:56;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:445;a:14:{s:2:\"id\";i:9995;s:5:\"title\";s:27:\"Slide In | Sale | Christmas\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_christmas_small.png\";s:12:\"tmpl_created\";i:1547844802;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-sale-christmas/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:719;s:11:\"trend_index\";i:693;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:446;a:14:{s:2:\"id\";i:14042;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Header\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2020/06/japanese-restaurant-header.jpg\";s:12:\"tmpl_created\";i:1592290277;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/blocks/japanese-restaurant-header/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:41:\"[\"Food\",\"header\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:196;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:447;a:14:{s:2:\"id\";i:5438;s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";i:1520443512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:182;s:11:\"trend_index\";i:148;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:448;a:14:{s:2:\"id\";i:5447;s:5:\"title\";s:7:\"About 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_5.png\";s:12:\"tmpl_created\";i:1520443514;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:54;s:11:\"trend_index\";i:47;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:449;a:14:{s:2:\"id\";i:10016;s:5:\"title\";s:16:\"Hello Bar | Sale\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/Hello-Bar_Promotion_bag_small.png\";s:12:\"tmpl_created\";i:1547845062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/hello-bar-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:726;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:450;a:14:{s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:675;s:11:\"trend_index\";i:476;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:451;a:14:{s:2:\"id\";i:5455;s:5:\"title\";s:8:\"About 20\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_6.png\";s:12:\"tmpl_created\";i:1520443516;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:137;s:11:\"trend_index\";i:169;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:452;a:14:{s:2:\"id\";i:10026;s:5:\"title\";s:46:\"Classic | Register | Subscribe | Gym | Fitness\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_register_small.png\";s:12:\"tmpl_created\";i:1547845205;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:556;s:11:\"trend_index\";i:620;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:453;a:14:{s:2:\"id\";i:5464;s:5:\"title\";s:8:\"About 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png\";s:12:\"tmpl_created\";i:1520443518;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:229;s:11:\"trend_index\";i:249;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:454;a:14:{s:2:\"id\";i:10036;s:5:\"title\";s:43:\"Full Screen | Sale | Promotion | Headphones\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/full_sale_head_small.png\";s:12:\"tmpl_created\";i:1547845409;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:574;s:11:\"trend_index\";i:467;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:455;a:14:{s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:715;s:11:\"trend_index\";i:587;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:456;a:14:{s:2:\"id\";i:5472;s:5:\"title\";s:7:\"About 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_7.png\";s:12:\"tmpl_created\";i:1520443520;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:214;s:11:\"trend_index\";i:178;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:457;a:14:{s:2:\"id\";i:5480;s:5:\"title\";s:7:\"About 4\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_7-1.png\";s:12:\"tmpl_created\";i:1520443522;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blocks/about-4-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:424;s:11:\"trend_index\";i:417;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:458;a:14:{s:2:\"id\";i:10057;s:5:\"title\";s:48:\"Hello Bar | Register | Subscribe | Gym | Fitness\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2019/01/hello-bar_register_sport_small.png\";s:12:\"tmpl_created\";i:1547847938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/hello-bar-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:702;s:11:\"trend_index\";i:674;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:459;a:14:{s:2:\"id\";i:5488;s:5:\"title\";s:7:\"About 7\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_8.png\";s:12:\"tmpl_created\";i:1520443524;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:314;s:11:\"trend_index\";i:355;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:460;a:14:{s:2:\"id\";i:5496;s:5:\"title\";s:7:\"About 9\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_8-1.png\";s:12:\"tmpl_created\";i:1520443526;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/blocks/about-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:508;s:11:\"trend_index\";i:575;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:461;a:14:{s:2:\"id\";i:5504;s:5:\"title\";s:8:\"About 18\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png\";s:12:\"tmpl_created\";i:1520443528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:112;s:11:\"trend_index\";i:161;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:462;a:14:{s:2:\"id\";i:10087;s:5:\"title\";s:25:\"Full Screen | Login | Spa\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2019/01/full-screen_login_spa_small.png\";s:12:\"tmpl_created\";i:1547848301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/full-screen-login-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:595;s:11:\"trend_index\";i:625;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:463;a:14:{s:2:\"id\";i:14772;s:5:\"title\";s:35:\"Luxury Real Estate &#8211; 404 page\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2020/07/404.png\";s:12:\"tmpl_created\";i:1595315728;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/blocks/luxury-real-estate-404-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:34:\"[\"404\",\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:728;s:11:\"trend_index\";i:626;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:464;a:14:{s:2:\"id\";i:5515;s:5:\"title\";s:8:\"About 19\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png\";s:12:\"tmpl_created\";i:1520443530;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/blocks/about-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:275;s:11:\"trend_index\";i:280;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:465;a:14:{s:2:\"id\";i:10097;s:5:\"title\";s:37:\"Classic | Register | Subscribe | Lego\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_lego_small.png\";s:12:\"tmpl_created\";i:1547848411;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/classic-register-subscribe-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:632;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:466;a:14:{s:2:\"id\";i:14779;s:5:\"title\";s:33:\"Luxury Real Estate &#8211; Footer\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/07/Footer.png\";s:12:\"tmpl_created\";i:1595315743;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/blocks/luxury-real-estate-footer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:7:\"subtype\";s:6:\"footer\";s:4:\"tags\";s:37:\"[\"footer\",\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:666;s:11:\"trend_index\";i:263;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:467;a:14:{s:2:\"id\";i:1190;s:5:\"title\";s:26:\"Landing Page &#8211; Hotel\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp2-l.png\";s:12:\"tmpl_created\";i:1490707391;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/landing-page-hotel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:3;s:11:\"trend_index\";i:1;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:468;a:14:{s:2:\"id\";i:9816;s:5:\"title\";s:30:\"Classic | Sale | Gym | Fitness\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2019/01/classic_sale_sport_small.png\";s:12:\"tmpl_created\";i:1547991876;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:655;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:469;a:14:{s:2:\"id\";i:9602;s:5:\"title\";s:35:\"Bottom Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2019/01/Bottombar_Announcement_small_01.png\";s:12:\"tmpl_created\";i:1546964559;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/bottom-bar-announcement-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:560;s:11:\"trend_index\";i:663;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:470;a:14:{s:2:\"id\";i:225;s:5:\"title\";s:27:\"Homepage &#8211; Restaurant\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0016.png\";s:12:\"tmpl_created\";i:1470829872;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/homepage-restaurant/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Homepage\",\"Restaurant\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:1;s:11:\"trend_index\";i:3;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:471;a:14:{s:2:\"id\";i:463;s:5:\"title\";s:22:\"Homepage &#8211; Study\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0022.png\";s:12:\"tmpl_created\";i:1477388340;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/homepage-study/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Education\",\"Homepage\",\"Study\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:5;s:11:\"trend_index\";i:4;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:472;a:14:{s:2:\"id\";i:10277;s:5:\"title\";s:36:\"Bottom Bar | Promotion | Sale | Book\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/book_small.png\";s:12:\"tmpl_created\";i:1548055999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/bottom-bar-promotion-book/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:674;s:11:\"trend_index\";i:654;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:473;a:14:{s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:370;s:11:\"trend_index\";i:311;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:474;a:14:{s:2:\"id\";i:181;s:5:\"title\";s:23:\"Homepage &#8211; Agency\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0019.png\";s:12:\"tmpl_created\";i:1470826567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/homepage-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Agency\",\"Creative\",\"Homepage\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:2;s:11:\"trend_index\";i:2;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:475;a:14:{s:2:\"id\";i:9903;s:5:\"title\";s:34:\"Bottom Bar | Promotion | Olive Oil\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2019/01/bottom-bar_promotion_olive_small.png\";s:12:\"tmpl_created\";i:1547838896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/bottom-bar-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:712;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:476;a:14:{s:2:\"id\";i:150;s:5:\"title\";s:19:\"Product &#8211; App\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0003.png\";s:12:\"tmpl_created\";i:1470829879;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/product-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:6;s:11:\"trend_index\";i:5;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:477;a:14:{s:2:\"id\";i:15317;s:5:\"title\";s:25:\"Dance Studio &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/10/Home.jpg\";s:12:\"tmpl_created\";i:1603181291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/dance-studio-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:478;a:14:{s:2:\"id\";i:10549;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/com_small.png\";s:12:\"tmpl_created\";i:1547967595;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/bottom-bar-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:661;s:11:\"trend_index\";i:671;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:479;a:14:{s:2:\"id\";i:15334;s:5:\"title\";s:26:\"Dance Studio &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/About.jpg\";s:12:\"tmpl_created\";i:1603181364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/dance-studio-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:480;a:14:{s:2:\"id\";i:15349;s:5:\"title\";s:28:\"Dance Studio &#8211; Classes\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes.jpg\";s:12:\"tmpl_created\";i:1603181425;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/dance-studio-classes/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:481;a:14:{s:2:\"id\";i:15366;s:5:\"title\";s:29:\"Dance Studio &#8211; Schedule\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/10/Classes-Schedule.jpg\";s:12:\"tmpl_created\";i:1603181056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/dance-studio-schedule/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:482;a:14:{s:2:\"id\";i:10529;s:5:\"title\";s:36:\"Classic | Announcement | Maintenance\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/icon_small.png\";s:12:\"tmpl_created\";i:1548046309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:452;s:11:\"trend_index\";i:408;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:483;a:14:{s:2:\"id\";i:15373;s:5:\"title\";s:28:\"Dance Studio &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/10/Pricing.jpg\";s:12:\"tmpl_created\";i:1603181678;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/dance-studio-pricing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:484;a:14:{s:2:\"id\";i:15384;s:5:\"title\";s:28:\"Dance Studio &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/10/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1603181738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/dance-studio-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:16:\"[\"dance studio\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:485;a:14:{s:2:\"id\";i:15158;s:5:\"title\";s:26:\"Psychologist &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/About.jpg\";s:12:\"tmpl_created\";i:1600157561;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/psychologist-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:486;a:14:{s:2:\"id\";i:15197;s:5:\"title\";s:28:\"Psychologist &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1600160499;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/psychologist-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:487;a:14:{s:2:\"id\";i:15142;s:5:\"title\";s:25:\"Psychologist &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/09/Home.jpg\";s:12:\"tmpl_created\";i:1600156308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/psychologist-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:488;a:14:{s:2:\"id\";i:15188;s:5:\"title\";s:28:\"Psychologist &#8211; Pricing\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/09/Pricing.jpg\";s:12:\"tmpl_created\";i:1600159731;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/psychologist-pricing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:489;a:14:{s:2:\"id\";i:15167;s:5:\"title\";s:29:\"Psychologist &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/09/Services.jpg\";s:12:\"tmpl_created\";i:1600158206;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/psychologist-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:490;a:14:{s:2:\"id\";i:14932;s:5:\"title\";s:30:\"Flooring Company &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/About.png\";s:12:\"tmpl_created\";i:1597740110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/flooring-company-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:642;s:11:\"trend_index\";i:102;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:491;a:14:{s:2:\"id\";i:10413;s:5:\"title\";s:28:\"Classic | Content Lock | Pop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/hot_small.png\";s:12:\"tmpl_created\";i:1547961774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-content-lock/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:687;s:11:\"trend_index\";i:680;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:492;a:14:{s:2:\"id\";i:14998;s:5:\"title\";s:32:\"Flooring Company &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/08/Contact-Us.png\";s:12:\"tmpl_created\";i:1597740222;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/flooring-company-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:676;s:11:\"trend_index\";i:116;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:493;a:14:{s:2:\"id\";i:10223;s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/welcome_small.png\";s:12:\"tmpl_created\";i:1547887343;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:471;s:11:\"trend_index\";i:437;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:494;a:14:{s:2:\"id\";i:14965;s:5:\"title\";s:32:\"Flooring Company &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/Gallery.png\";s:12:\"tmpl_created\";i:1597740353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/flooring-company-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:608;s:11:\"trend_index\";i:57;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:495;a:14:{s:2:\"id\";i:10559;s:5:\"title\";s:33:\"Bottom Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/fly_small.png\";s:12:\"tmpl_created\";i:1547967711;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/bottom-bar-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:645;s:11:\"trend_index\";i:704;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:496;a:14:{s:2:\"id\";i:14947;s:5:\"title\";s:33:\"Flooring company &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/08/Services.png\";s:12:\"tmpl_created\";i:1597740551;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/flooring-company-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:139;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:497;a:14:{s:2:\"id\";i:10403;s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/hello_small.png\";s:12:\"tmpl_created\";i:1548056371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:570;s:11:\"trend_index\";i:635;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:498;a:14:{s:2:\"id\";i:14901;s:5:\"title\";s:29:\"Flooring Company &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/08/Home.png\";s:12:\"tmpl_created\";i:1597740474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/flooring-company-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:639;s:11:\"trend_index\";i:131;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:499;a:14:{s:2:\"id\";i:9913;s:5:\"title\";s:27:\"Classic | Login | Christmas\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/log_small.png\";s:12:\"tmpl_created\";i:1547841430;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:451;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:500;a:14:{s:2:\"id\";i:14737;s:5:\"title\";s:32:\"Luxury Real Estate &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/About.png\";s:12:\"tmpl_created\";i:1595313527;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/luxury-real-estate-about-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:627;s:11:\"trend_index\";i:302;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:501;a:14:{s:2:\"id\";i:14756;s:5:\"title\";s:34:\"Luxury Real Estate &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/07/Contact-Us.png\";s:12:\"tmpl_created\";i:1595313519;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/luxury-real-estate-contact-us-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:658;s:11:\"trend_index\";i:303;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:502;a:14:{s:2:\"id\";i:14716;s:5:\"title\";s:31:\"Luxury Real Estate &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/07/Home.png\";s:12:\"tmpl_created\";i:1595313512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/luxury-real-estate-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:569;s:11:\"trend_index\";i:201;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:503;a:14:{s:2:\"id\";i:14763;s:5:\"title\";s:31:\"Luxury Real Estate &#8211; News\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/07/news-Archive.png\";s:12:\"tmpl_created\";i:1595313273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/luxury-real-estate-news-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"real estate\",\"realestate\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:589;s:11:\"trend_index\";i:168;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:504;a:14:{s:2:\"id\";i:9592;s:5:\"title\";s:26:\"Classic | Promotion | Sale\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/Classic_Promotion_small_01.png\";s:12:\"tmpl_created\";i:1546963720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/classic-promotion-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:607;s:11:\"trend_index\";i:601;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:505;a:14:{s:2:\"id\";i:13960;s:5:\"title\";s:32:\"Japanese restaurant &#8211; Home\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/06/Home-Page.jpg\";s:12:\"tmpl_created\";i:1592289775;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/japanese-restaurant-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:603;s:11:\"trend_index\";i:270;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:506;a:14:{s:2:\"id\";i:10210;s:5:\"title\";s:29:\"Classic | Promotion | Webinar\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/web_small-1.png\";s:12:\"tmpl_created\";i:1547886103;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-promotion-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:720;s:11:\"trend_index\";i:696;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:507;a:14:{s:2:\"id\";i:13993;s:5:\"title\";s:45:\"Japanese restaurant &#8211; Chef&#8217;s Menu\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2020/06/Chef_s-Menu-Page.jpg\";s:12:\"tmpl_created\";i:1592289691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/japanese-restaurant-chefs-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:504;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:508;a:14:{s:2:\"id\";i:14012;s:5:\"title\";s:36:\"Japanese restaurant &#8211; Bar Menu\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/06/Bar-Menu-Page.jpg\";s:12:\"tmpl_created\";i:1592289665;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/japanese-restaurant-bar-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:700;s:11:\"trend_index\";i:526;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:509;a:14:{s:2:\"id\";i:13917;s:5:\"title\";s:33:\"Japanese restaurant &#8211; About\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/06/About-Page.jpg\";s:12:\"tmpl_created\";i:1592289629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/japanese-restaurant-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:656;s:11:\"trend_index\";i:375;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:510;a:14:{s:2:\"id\";i:13937;s:5:\"title\";s:35:\"Japanese restaurant &#8211; Gallery\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/Gallery-Page.jpg\";s:12:\"tmpl_created\";i:1592289748;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/japanese-restaurant-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:670;s:11:\"trend_index\";i:395;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:511;a:14:{s:2:\"id\";i:10047;s:5:\"title\";s:15:\"Classic | Login\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/yellow_small.png\";s:12:\"tmpl_created\";i:1547847757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/popups/classic-login-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:503;s:11:\"trend_index\";i:450;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:512;a:14:{s:2:\"id\";i:9879;s:5:\"title\";s:38:\"Classic | Register | Subscribe | Leads\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/dog_small.png\";s:12:\"tmpl_created\";i:1547838416;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/classic-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:612;s:11:\"trend_index\";i:657;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:513;a:14:{s:2:\"id\";i:14030;s:5:\"title\";s:34:\"Japanese restaurant &#8211; Events\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/06/Events-Page.jpg\";s:12:\"tmpl_created\";i:1592289713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/japanese-restaurant-events/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:711;s:11:\"trend_index\";i:473;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:514;a:14:{s:2:\"id\";i:13984;s:5:\"title\";s:40:\"Japanese restaurant &#8211; Reservations\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/06/reservations.jpg\";s:12:\"tmpl_created\";i:1592294757;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/japanese-restaurant-reservations/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:699;s:11:\"trend_index\";i:494;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:515;a:14:{s:2:\"id\";i:13479;s:5:\"title\";s:23:\"Barbershop &#8211; Home\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/05/Home-Page.jpg\";s:12:\"tmpl_created\";i:1589893275;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/barbershop-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:644;s:11:\"trend_index\";i:592;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:516;a:14:{s:2:\"id\";i:13503;s:5:\"title\";s:24:\"Barbershop &#8211; About\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/05/About-Page.jpg\";s:12:\"tmpl_created\";i:1589893289;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/barbershop-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:697;s:11:\"trend_index\";i:631;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:517;a:14:{s:2:\"id\";i:10297;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/s_yellow_small.png\";s:12:\"tmpl_created\";i:1548056099;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:612;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:518;a:14:{s:2:\"id\";i:13548;s:5:\"title\";s:27:\"Barbershop &#8211; Services\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2020/05/Services-Page.jpg\";s:12:\"tmpl_created\";i:1589893298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/barbershop-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:710;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:519;a:14:{s:2:\"id\";i:10393;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/blue_small.png\";s:12:\"tmpl_created\";i:1548056682;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:621;s:11:\"trend_index\";i:714;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:520;a:14:{s:2:\"id\";i:13560;s:5:\"title\";s:26:\"Barbershop &#8211; Gallery\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2020/05/Gallery-Page.jpg\";s:12:\"tmpl_created\";i:1589893307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/barbershop-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:707;s:11:\"trend_index\";i:672;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:521;a:14:{s:2:\"id\";i:13587;s:5:\"title\";s:26:\"Barbershop &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/05/Contact-Us-Page.jpg\";s:12:\"tmpl_created\";i:1589893315;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/barbershop-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:703;s:11:\"trend_index\";i:706;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:522;a:14:{s:2:\"id\";i:10579;s:5:\"title\";s:14:\"Classic | Sale\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/sale1_small.png\";s:12:\"tmpl_created\";i:1547967887;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/popups/classic-sale-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:657;s:11:\"trend_index\";i:608;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:523;a:14:{s:2:\"id\";i:13307;s:5:\"title\";s:26:\"Online Course &#8211; Home\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.jpg\";s:12:\"tmpl_created\";i:1587474541;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/online-course-home/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:311;s:11:\"trend_index\";i:101;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:524;a:14:{s:2:\"id\";i:13328;s:5:\"title\";s:27:\"Online Course &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.jpg\";s:12:\"tmpl_created\";i:1587474558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/online-course-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:540;s:11:\"trend_index\";i:293;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:525;a:14:{s:2:\"id\";i:13338;s:5:\"title\";s:33:\"Online Course &#8211; Course Page\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/Course-Page.png\";s:12:\"tmpl_created\";i:1587474574;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/online-course-course-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:384;s:11:\"trend_index\";i:203;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:526;a:14:{s:2:\"id\";i:13352;s:5:\"title\";s:29:\"Online Course &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.jpg\";s:12:\"tmpl_created\";i:1587474591;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/online-course-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:562;s:11:\"trend_index\";i:279;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:527;a:14:{s:2:\"id\";i:13187;s:5:\"title\";s:33:\"Interior Design &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2020/04/Home.png\";s:12:\"tmpl_created\";i:1586148661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/interior-design-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:376;s:11:\"trend_index\";i:340;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:528;a:14:{s:2:\"id\";i:10180;s:5:\"title\";s:21:\"Fly In | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/glass_small.png\";s:12:\"tmpl_created\";i:1548045309;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:623;s:11:\"trend_index\";i:682;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:529;a:14:{s:2:\"id\";i:13199;s:5:\"title\";s:29:\"Interior Design &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/About.png\";s:12:\"tmpl_created\";i:1586148666;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/interior-design-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:362;s:11:\"trend_index\";i:202;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:530;a:14:{s:2:\"id\";i:13214;s:5:\"title\";s:32:\"Interior Design &#8211; Projects\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/04/portfolio_s.jpg\";s:12:\"tmpl_created\";i:1586148672;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/interior-design-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:406;s:11:\"trend_index\";i:229;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:531;a:14:{s:2:\"id\";i:13229;s:5:\"title\";s:31:\"Interior Design &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.png\";s:12:\"tmpl_created\";i:1586148677;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/interior-design-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"business\",\"interior design\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:434;s:11:\"trend_index\";i:231;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:532;a:14:{s:2:\"id\";i:9731;s:5:\"title\";s:26:\"Classic | Sale | Promotion\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/01/icecream_small.png\";s:12:\"tmpl_created\";i:1547976166;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/popups/classic-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:587;s:11:\"trend_index\";i:543;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:533;a:14:{s:2:\"id\";i:12948;s:5:\"title\";s:29:\"Photography &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Home_s.png\";s:12:\"tmpl_created\";i:1582093442;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/photography-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:292;s:11:\"trend_index\";i:143;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:534;a:14:{s:2:\"id\";i:12798;s:5:\"title\";s:25:\"Photography &#8211; About\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/About_s.png\";s:12:\"tmpl_created\";i:1582093446;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/photography-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:488;s:11:\"trend_index\";i:480;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:535;a:14:{s:2:\"id\";i:12868;s:5:\"title\";s:27:\"Photography &#8211; Contact\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Contact_s.png\";s:12:\"tmpl_created\";i:1582093450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/photography-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:523;s:11:\"trend_index\";i:390;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:536;a:14:{s:2:\"id\";i:13056;s:5:\"title\";s:28:\"Photography &#8211; Wildlife\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/02/Wildlife_s.png\";s:12:\"tmpl_created\";i:1582093454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/photography-wildlife/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:550;s:11:\"trend_index\";i:472;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:537;a:14:{s:2:\"id\";i:12922;s:5:\"title\";s:37:\"Photography &#8211; Glowing Jellyfish\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Jellyfish_S.png\";s:12:\"tmpl_created\";i:1582093457;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photography-glowing-jellyfish/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:591;s:11:\"trend_index\";i:321;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:538;a:14:{s:2:\"id\";i:12875;s:5:\"title\";s:36:\"Photography &#8211; Fluttering Birds\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Birds_s.png\";s:12:\"tmpl_created\";i:1582093461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/photography-fluttering-birds/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:653;s:11:\"trend_index\";i:637;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:539;a:14:{s:2:\"id\";i:12962;s:5:\"title\";s:26:\"Photography &#8211; Nature\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2020/02/Nature_s.png\";s:12:\"tmpl_created\";i:1582093465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/photography-nature/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:567;s:11:\"trend_index\";i:434;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:540;a:14:{s:2:\"id\";i:12833;s:5:\"title\";s:38:\"Photography &#8211; Blossoming Flowers\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Flowers_s.png\";s:12:\"tmpl_created\";i:1582093469;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photography-blossoming-flowers/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:577;s:11:\"trend_index\";i:358;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:541;a:14:{s:2:\"id\";i:12898;s:5:\"title\";s:36:\"Photography &#8211; Forest Mushrooms\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2020/02/Mushrooms_s.png\";s:12:\"tmpl_created\";i:1582093473;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/photography-forest-mushrooms/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:629;s:11:\"trend_index\";i:574;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:542;a:14:{s:2:\"id\";i:10005;s:5:\"title\";s:38:\"Fly In | Promotion | Spa | Body Lotion\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/01/Flyin_lotion_small.png\";s:12:\"tmpl_created\";i:1547844909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/popups/fly-in-promotion-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:694;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:543;a:14:{s:2:\"id\";i:10424;s:5:\"title\";s:21:\"Fly In | Announcement\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/flower_small.png\";s:12:\"tmpl_created\";i:1547961866;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-announcement-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:610;s:11:\"trend_index\";i:702;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:544;a:14:{s:2:\"id\";i:12994;s:5:\"title\";s:24:\"Photography &#8211; Pets\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/02/Pets_s.png\";s:12:\"tmpl_created\";i:1582093477;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/photography-pets/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:592;s:11:\"trend_index\";i:488;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:545;a:14:{s:2:\"id\";i:9975;s:5:\"title\";s:24:\"Fly In | Promotion | App\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_webinar_app_small.png\";s:12:\"tmpl_created\";i:1547842284;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/fly-in-promotion-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:714;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:546;a:14:{s:2:\"id\";i:12805;s:5:\"title\";s:38:\"Photography &#8211; B&#038;W Portraits\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/Black_s.png\";s:12:\"tmpl_created\";i:1582093481;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/photography-bw-portraits/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:660;s:11:\"trend_index\";i:555;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:547;a:14:{s:2:\"id\";i:10067;s:5:\"title\";s:31:\"Fly In | Announcement | Cookies\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/fly-in_cookie_yellow_small.png\";s:12:\"tmpl_created\";i:1547848075;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/fly-in-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:546;s:11:\"trend_index\";i:493;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:548;a:14:{s:2:\"id\";i:13031;s:5:\"title\";s:33:\"Photography &#8211; Vivid Parrots\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2020/02/Parrots_s.png\";s:12:\"tmpl_created\";i:1582093484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/photography-vivid-parrots/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:27:\"[\"Photography\",\"portfolio\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:613;s:11:\"trend_index\";i:518;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:549;a:14:{s:2:\"id\";i:12621;s:5:\"title\";s:26:\"Magazine &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2020/01/Home_s.png\";s:12:\"tmpl_created\";i:1579060604;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/magazine-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:199;s:11:\"trend_index\";i:77;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:550;a:14:{s:2:\"id\";i:10329;s:5:\"title\";s:25:\"Fly In | Sale | Promotion\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/01/organic_small.png\";s:12:\"tmpl_created\";i:1547893478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/fly-in-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:722;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:551;a:14:{s:2:\"id\";i:12352;s:5:\"title\";s:24:\"Travel &#8211; Home Page\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2019/12/Home_s.png\";s:12:\"tmpl_created\";i:1575960464;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/travel-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:294;s:11:\"trend_index\";i:211;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:552;a:14:{s:2:\"id\";i:12400;s:5:\"title\";s:20:\"Travel &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/12/About.png\";s:12:\"tmpl_created\";i:1575960441;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/travel-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:412;s:11:\"trend_index\";i:367;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:553;a:14:{s:2:\"id\";i:9650;s:5:\"title\";s:36:\"Fly In | Register | Subscribe | Sale\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2019/01/Fly-In_Register_small_01a.png\";s:12:\"tmpl_created\";i:1547007598;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/fly-in-register_big-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:708;s:11:\"trend_index\";i:701;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:554;a:14:{s:2:\"id\";i:12479;s:5:\"title\";s:20:\"Travel &#8211; Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Tours_s.png\";s:12:\"tmpl_created\";i:1575960474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/travel-tours/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:499;s:11:\"trend_index\";i:412;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:555;a:14:{s:2:\"id\";i:12466;s:5:\"title\";s:27:\"Travel &#8211; Testimonials\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/Testimonials.png\";s:12:\"tmpl_created\";i:1575960469;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-testimonials/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:507;s:11:\"trend_index\";i:507;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:556;a:14:{s:2:\"id\";i:10200;s:5:\"title\";s:33:\"Full Screen | Content Lock | Wine\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/lock_wine_small.png\";s:12:\"tmpl_created\";i:1548055635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/full-screen-content-lock/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:665;s:11:\"trend_index\";i:667;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:557;a:14:{s:2:\"id\";i:12443;s:5:\"title\";s:22:\"Travel &#8211; Gallery\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/Gallery.png\";s:12:\"tmpl_created\";i:1575960459;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/travel-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:446;s:11:\"trend_index\";i:531;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:558;a:14:{s:2:\"id\";i:10287;s:5:\"title\";s:34:\"Full Screen | Register | Subscribe\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/glass_pink_small.png\";s:12:\"tmpl_created\";i:1547994301;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:553;s:11:\"trend_index\";i:643;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:559;a:14:{s:2:\"id\";i:12431;s:5:\"title\";s:18:\"Travel &#8211; FAQ\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/12/FAQ.png\";s:12:\"tmpl_created\";i:1575960453;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:100:\"https://library.elementor.com/travel-faq/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:64;s:16:\"popularity_index\";i:495;s:11:\"trend_index\";i:384;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:560;a:14:{s:2:\"id\";i:12421;s:5:\"title\";s:27:\"Travel &#8211; Contact Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/12/Contsct-Us.png\";s:12:\"tmpl_created\";i:1575960445;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/travel-contact-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:65;s:16:\"popularity_index\";i:531;s:11:\"trend_index\";i:482;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:561;a:14:{s:2:\"id\";i:11763;s:5:\"title\";s:27:\"Portfolio &#8211; Home Page\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Homepage_small.png\";s:12:\"tmpl_created\";i:1569428959;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/portfolio-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:293;s:11:\"trend_index\";i:319;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:562;a:14:{s:2:\"id\";i:9889;s:5:\"title\";s:28:\"Full Screen | Login | Cactus\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/cac_small.png\";s:12:\"tmpl_created\";i:1547838722;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/full-screen-login/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:66;s:16:\"popularity_index\";i:684;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:563;a:14:{s:2:\"id\";i:11781;s:5:\"title\";s:23:\"Portfolio &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/About_small.png\";s:12:\"tmpl_created\";i:1569428955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/portfolio-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:352;s:11:\"trend_index\";i:361;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:564;a:14:{s:2:\"id\";i:10077;s:5:\"title\";s:29:\"Fly In | Register | Subscribe\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2019/01/flyin_register_blue_small.png\";s:12:\"tmpl_created\";i:1547848197;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/fly-in-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:67;s:16:\"popularity_index\";i:506;s:11:\"trend_index\";i:585;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:565;a:14:{s:2:\"id\";i:11793;s:5:\"title\";s:26:\"Portfolio &#8211; Projects\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/09/Projects_small.png\";s:12:\"tmpl_created\";i:1569428951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/portfolio-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:68;s:16:\"popularity_index\";i:415;s:11:\"trend_index\";i:335;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:566;a:14:{s:2:\"id\";i:10362;s:5:\"title\";s:32:\"Full Screen | Login | Restaurant\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/vip_small.png\";s:12:\"tmpl_created\";i:1548056253;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/full-screen-login-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:565;s:11:\"trend_index\";i:366;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:567;a:14:{s:2:\"id\";i:11800;s:5:\"title\";s:25:\"Portfolio &#8211; Contact\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/09/Contact_small.png\";s:12:\"tmpl_created\";i:1569428946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/portfolio-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:34:\"[\"creative portfolio\",\"portfolio\"]\";s:10:\"menu_order\";i:69;s:16:\"popularity_index\";i:467;s:11:\"trend_index\";i:547;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:568;a:14:{s:2:\"id\";i:11163;s:5:\"title\";s:32:\"Digital Agency &#8211; Home Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/07/Home_small.png\";s:12:\"tmpl_created\";i:1564641877;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/digital-agency-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:70;s:16:\"popularity_index\";i:69;s:11:\"trend_index\";i:26;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:569;a:14:{s:2:\"id\";i:10454;s:5:\"title\";s:29:\"Full Screen | Promotion | App\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/appy_small.png\";s:12:\"tmpl_created\";i:1548056896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/full-screen-promotion-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:713;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:570;a:14:{s:2:\"id\";i:9139;s:5:\"title\";s:25:\"Homepage &#8211; Business\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/07/Get_Started_250.png\";s:12:\"tmpl_created\";i:1532949924;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/homepage-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:167:\"[\"Agency\",\"bootstrap\",\"business\",\"corporate\",\"Landing Page\",\"marketing campaign\",\"marketing landing page\",\"product launch\",\"software\",\"Startup\",\"startup landing page\"]\";s:10:\"menu_order\";i:71;s:16:\"popularity_index\";i:7;s:11:\"trend_index\";i:7;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:571;a:14:{s:2:\"id\";i:1634;s:5:\"title\";s:33:\"Landing Page &#8211; Chiropractor\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Chiropractor.png\";s:12:\"tmpl_created\";i:1494352119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-chiropractor/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:207;s:11:\"trend_index\";i:208;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:572;a:14:{s:2:\"id\";i:9803;s:5:\"title\";s:41:\"Full Screen | Register | Contact | Meetup\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2019/01/designme_full_small.png\";s:12:\"tmpl_created\";i:1547831298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/full-screen-register-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:72;s:16:\"popularity_index\";i:641;s:11:\"trend_index\";i:645;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:573;a:14:{s:2:\"id\";i:10611;s:5:\"title\";s:18:\"Full Screen | Sale\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/fla_small.png\";s:12:\"tmpl_created\";i:1547968868;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/full-screen-sale/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:716;s:11:\"trend_index\";i:705;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:574;a:14:{s:2:\"id\";i:12143;s:5:\"title\";s:22:\"Law Firm &#8211; About\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/about.png\";s:12:\"tmpl_created\";i:1572847069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/law-firm-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:73;s:16:\"popularity_index\";i:375;s:11:\"trend_index\";i:284;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:575;a:14:{s:2:\"id\";i:12091;s:5:\"title\";s:21:\"Law Firm &#8211; Team\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2019/11/team.png\";s:12:\"tmpl_created\";i:1572847113;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/law-firm-team/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:74;s:16:\"popularity_index\";i:354;s:11:\"trend_index\";i:241;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:576;a:14:{s:2:\"id\";i:10508;s:5:\"title\";s:25:\"Full Screen | Welcome Mat\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/01/hand_small-1.png\";s:12:\"tmpl_created\";i:1547964711;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/full-screen-welcome-mat-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:647;s:11:\"trend_index\";i:659;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:577;a:14:{s:2:\"id\";i:11129;s:5:\"title\";s:28:\"Digital Agency &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/About_small.png\";s:12:\"tmpl_created\";i:1564641889;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/digital-agency-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:75;s:16:\"popularity_index\";i:193;s:11:\"trend_index\";i:112;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:578;a:14:{s:2:\"id\";i:11572;s:5:\"title\";s:19:\"Gym &#8211; Trainer\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Trainer_Small.png\";s:12:\"tmpl_created\";i:1567392934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-trainer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:534;s:11:\"trend_index\";i:589;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:579;a:14:{s:2:\"id\";i:9934;s:5:\"title\";s:38:\"Full Screen | Welcome Mat | Teddy Bear\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/full_mat_teddy_small.png\";s:12:\"tmpl_created\";i:1547841787;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/full-screen-welcome-mat/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:76;s:16:\"popularity_index\";i:617;s:11:\"trend_index\";i:665;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:580;a:14:{s:2:\"id\";i:1504;s:5:\"title\";s:33:\"Landing Page &#8211; Mobile App 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-app2.png\";s:12:\"tmpl_created\";i:1494352112;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-mobile-app-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:77;s:16:\"popularity_index\";i:163;s:11:\"trend_index\";i:253;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:581;a:14:{s:2:\"id\";i:12133;s:5:\"title\";s:24:\"Law Firm &#8211; Careers\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/11/careers.png\";s:12:\"tmpl_created\";i:1572847078;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-careers/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:558;s:11:\"trend_index\";i:545;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:582;a:14:{s:2:\"id\";i:9709;s:5:\"title\";s:25:\"Full Screen | Welcome Mat\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2019/01/Full-Screen_Welcome-Mat_01_small-1.png\";s:12:\"tmpl_created\";i:1547023834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/popups/full-screen-welcome-mat-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:78;s:16:\"popularity_index\";i:667;s:11:\"trend_index\";i:634;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:583;a:14:{s:2:\"id\";i:12155;s:5:\"title\";s:26:\"Law Firm &#8211; Home Page\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2019/11/home.png\";s:12:\"tmpl_created\";i:1572847054;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/law-firm-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:218;s:11:\"trend_index\";i:245;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:584;a:14:{s:2:\"id\";i:9671;s:5:\"title\";s:34:\"Hello Bar | Announcement | Cookies\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2019/01/Top-Bar_Announcement_small_01.png\";s:12:\"tmpl_created\";i:1547010259;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/hello-bar-announcement-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:79;s:16:\"popularity_index\";i:588;s:11:\"trend_index\";i:633;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:585;a:14:{s:2:\"id\";i:10234;s:5:\"title\";s:38:\"Hello Bar | Announcement | Maintenance\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/pink_small.png\";s:12:\"tmpl_created\";i:1548055049;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/popups/hello-bar-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:693;s:11:\"trend_index\";i:697;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:586;a:14:{s:2:\"id\";i:12080;s:5:\"title\";s:24:\"Law Firm &#8211; Partner\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/11/partner-1.png\";s:12:\"tmpl_created\";i:1572847120;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-partner/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:80;s:16:\"popularity_index\";i:541;s:11:\"trend_index\";i:478;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:587;a:14:{s:2:\"id\";i:11074;s:5:\"title\";s:31:\"Digital Agency &#8211; Services\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2019/07/Services_small.png\";s:12:\"tmpl_created\";i:1564641872;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/digital-agency-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:81;s:16:\"popularity_index\";i:169;s:11:\"trend_index\";i:108;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:588;a:14:{s:2:\"id\";i:11506;s:5:\"title\";s:19:\"Gym &#8211; Classes\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Classes_Small.png\";s:12:\"tmpl_created\";i:1567392930;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-classes/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:82;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:538;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:589;a:14:{s:2:\"id\";i:1503;s:5:\"title\";s:33:\"Landing Page &#8211; Mobile App 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-app1.png\";s:12:\"tmpl_created\";i:1494352113;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-mobile-app-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:162;s:11:\"trend_index\";i:187;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:590;a:14:{s:2:\"id\";i:9869;s:5:\"title\";s:28:\"Hello Bar | Promotion | Sale\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/01/ru_small.png\";s:12:\"tmpl_created\";i:1547837269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/popups/hello-bar-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:83;s:16:\"popularity_index\";i:706;s:11:\"trend_index\";i:707;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:591;a:14:{s:2:\"id\";i:10539;s:5:\"title\";s:19:\"Hello Bar | Contact\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/hello_pink_small.png\";s:12:\"tmpl_created\";i:1548056994;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/hello-bar-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:664;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:592;a:14:{s:2:\"id\";i:12044;s:5:\"title\";s:24:\"Law Firm &#8211; Contact\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/11/contsct_us.png\";s:12:\"tmpl_created\";i:1572847130;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:84;s:16:\"popularity_index\";i:441;s:11:\"trend_index\";i:400;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:593;a:14:{s:2:\"id\";i:12124;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2019/11/services.png\";s:12:\"tmpl_created\";i:1572847096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/law-firm-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:85;s:16:\"popularity_index\";i:422;s:11:\"trend_index\";i:316;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:594;a:14:{s:2:\"id\";i:11056;s:5:\"title\";s:35:\"Digital Agency &#8211; Social Media\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2019/07/Social-Media_small.png\";s:12:\"tmpl_created\";i:1564641867;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/digital-agency-social-media/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:86;s:16:\"popularity_index\";i:295;s:11:\"trend_index\";i:184;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:595;a:14:{s:2:\"id\";i:11536;s:5:\"title\";s:19:\"Gym &#8211; Fitness\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Fitness_Small.png\";s:12:\"tmpl_created\";i:1567392927;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:87;s:16:\"popularity_index\";i:582;s:11:\"trend_index\";i:596;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:596;a:14:{s:2:\"id\";i:11545;s:5:\"title\";s:21:\"Gym &#8211; Home Page\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/08/Home_Small.png\";s:12:\"tmpl_created\";i:1567392943;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/gym-home-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:88;s:16:\"popularity_index\";i:317;s:11:\"trend_index\";i:345;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:597;a:14:{s:2:\"id\";i:10147;s:5:\"title\";s:34:\"Hello Bar | Sale | Promotion | Pop\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/donut_small.png\";s:12:\"tmpl_created\";i:1548055522;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/hello-bar-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:700;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:598;a:14:{s:2:\"id\";i:12116;s:5:\"title\";s:24:\"Law Firm &#8211; Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/11/family_law.png\";s:12:\"tmpl_created\";i:1572847105;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/law-firm-service/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:89;s:16:\"popularity_index\";i:474;s:11:\"trend_index\";i:406;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:599;a:14:{s:2:\"id\";i:11094;s:5:\"title\";s:30:\"Digital Agency &#8211; Clients\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/07/Clients_small.png\";s:12:\"tmpl_created\";i:1564641885;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/digital-agency-clients/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:404;s:11:\"trend_index\";i:365;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:600;a:14:{s:2:\"id\";i:9923;s:5:\"title\";s:23:\"Slide In | Announcement\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/slide-in_ann_italian_small.png\";s:12:\"tmpl_created\";i:1547841537;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/popups/slide-in-announcement/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:90;s:16:\"popularity_index\";i:634;s:11:\"trend_index\";i:611;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:601;a:14:{s:2:\"id\";i:10117;s:5:\"title\";s:23:\"Slide In | Announcement\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/white_small.png\";s:12:\"tmpl_created\";i:1548066998;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-announcement-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:668;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:602;a:14:{s:2:\"id\";i:11478;s:5:\"title\";s:17:\"Gym &#8211; About\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/About_Small.png\";s:12:\"tmpl_created\";i:1567392939;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:99:\"https://library.elementor.com/gym-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:91;s:16:\"popularity_index\";i:462;s:11:\"trend_index\";i:391;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:603;a:14:{s:2:\"id\";i:11563;s:5:\"title\";s:19:\"Gym &#8211; Pricing\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Pricing_Small.png\";s:12:\"tmpl_created\";i:1567392923;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-pricing/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:542;s:11:\"trend_index\";i:561;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:604;a:14:{s:2:\"id\";i:9826;s:5:\"title\";s:33:\"Slide In | Announcement | webinar\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/01/web_small-2.png\";s:12:\"tmpl_created\";i:1547835513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-announcement-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:92;s:16:\"popularity_index\";i:682;s:11:\"trend_index\";i:711;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:605;a:14:{s:2:\"id\";i:10478;s:5:\"title\";s:18:\"Slide In | Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2019/01/slide_wow_small.png\";s:12:\"tmpl_created\";i:1548056829;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/popups/slide-in-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:552;s:11:\"trend_index\";i:508;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:606;a:14:{s:2:\"id\";i:11034;s:5:\"title\";s:30:\"Digital Agency &#8211; Contact\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/07/Contsct-Us_small.png\";s:12:\"tmpl_created\";i:1564641881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/contact-digital-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:30:\"[\"Digital Agency\",\"marketing\"]\";s:10:\"menu_order\";i:93;s:16:\"popularity_index\";i:198;s:11:\"trend_index\";i:123;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:607;a:14:{s:2:\"id\";i:11528;s:5:\"title\";s:19:\"Gym &#8211; Contact\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2019/08/Contact_Small.png\";s:12:\"tmpl_created\";i:1567392917;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/gym-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:7:\"[\"Gym\"]\";s:10:\"menu_order\";i:94;s:16:\"popularity_index\";i:493;s:11:\"trend_index\";i:424;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:608;a:14:{s:2:\"id\";i:519;s:5:\"title\";s:24:\"Homepage &#8211; Fitness\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0023.png\";s:12:\"tmpl_created\";i:1477388808;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/homepage-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Fitness\",\"Gym\",\"Health\",\"Homepage\",\"Sport\"]\";s:10:\"menu_order\";i:95;s:16:\"popularity_index\";i:10;s:11:\"trend_index\";i:32;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:609;a:14:{s:2:\"id\";i:487;s:5:\"title\";s:29:\"Landing Page &#8211; Vacation\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0021.png\";s:12:\"tmpl_created\";i:1477388357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-vacation/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:25;s:11:\"trend_index\";i:76;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:610;a:14:{s:2:\"id\";i:10685;s:5:\"title\";s:32:\"Hello Bar | Register | Subscribe\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2019/01/env_small.png\";s:12:\"tmpl_created\";i:1547974729;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/hello-bar-register-subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:96;s:16:\"popularity_index\";i:651;s:11:\"trend_index\";i:690;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:611;a:14:{s:2:\"id\";i:855;s:5:\"title\";s:37:\"Landing Page &#8211; Personal Trainer\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Personal-Trainer.png\";s:12:\"tmpl_created\";i:1494352061;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/landing-page-personal-trainer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:97;s:16:\"popularity_index\";i:264;s:11:\"trend_index\";i:373;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:612;a:14:{s:2:\"id\";i:955;s:5:\"title\";s:31:\"Landing Page &#8211; Law Office\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Law-Office.png\";s:12:\"tmpl_created\";i:1494352069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/landing-page-law-office/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:31:\"[\"Landing Page\",\"Law\",\"Office\"]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:175;s:11:\"trend_index\";i:331;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:613;a:14:{s:2:\"id\";i:9985;s:5:\"title\";s:20:\"Slide In | Promotion\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_promotion_av_small.png\";s:12:\"tmpl_created\";i:1547844661;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/popups/slide-in-promotion-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:98;s:16:\"popularity_index\";i:695;s:11:\"trend_index\";i:691;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:614;a:14:{s:2:\"id\";i:9373;s:5:\"title\";s:33:\"Landing Page &#8211; Conference 5\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/11/conference-250.png\";s:12:\"tmpl_created\";i:1542811219;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-conference-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:99;s:16:\"popularity_index\";i:256;s:11:\"trend_index\";i:378;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:615;a:14:{s:2:\"id\";i:974;s:5:\"title\";s:28:\"Landing Page &#8211; Stylist\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/03/Landing-Page-Stylist.png\";s:12:\"tmpl_created\";i:1494352071;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-stylist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:146:\"[\"cosmetics\",\"fashion\",\"girly\",\"hairdresser\",\"lifestyle\",\"makeup\",\"manicure\",\"pedicure\",\"products\",\"salon\",\"Shop\",\"skincare\",\"stylist\",\"wellness\"]\";s:10:\"menu_order\";i:100;s:16:\"popularity_index\";i:302;s:11:\"trend_index\";i:382;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:616;a:14:{s:2:\"id\";i:11948;s:5:\"title\";s:18:\"Maintenance Mode 3\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/10/mm3.png\";s:12:\"tmpl_created\";i:1572153978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";i:101;s:16:\"popularity_index\";i:206;s:11:\"trend_index\";i:79;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:617;a:14:{s:2:\"id\";i:754;s:5:\"title\";s:25:\"Services &#8211; Interior\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/01/Interior-Services.png\";s:12:\"tmpl_created\";i:1485269691;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/services-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:102;s:16:\"popularity_index\";i:239;s:11:\"trend_index\";i:285;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:618;a:14:{s:2:\"id\";i:752;s:5:\"title\";s:24:\"Contact &#8211; Interior\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/01/interior-contact.png\";s:12:\"tmpl_created\";i:1485269737;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/contact-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:103;s:16:\"popularity_index\";i:307;s:11:\"trend_index\";i:557;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:619;a:14:{s:2:\"id\";i:753;s:5:\"title\";s:22:\"About &#8211; Interior\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/01/Interior-About.png\";s:12:\"tmpl_created\";i:1485269710;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/about-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:104;s:16:\"popularity_index\";i:291;s:11:\"trend_index\";i:441;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:620;a:14:{s:2:\"id\";i:751;s:5:\"title\";s:25:\"Homepage &#8211; Interior\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/01/interior-home.png\";s:12:\"tmpl_created\";i:1485269743;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/homepage-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:248;s:11:\"trend_index\";i:372;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:621;a:14:{s:2:\"id\";i:9559;s:5:\"title\";s:16:\"Slide In | Login\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_login_01_small.png\";s:12:\"tmpl_created\";i:1546946547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/popups/slide-in-login-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:105;s:16:\"popularity_index\";i:554;s:11:\"trend_index\";i:636;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:622;a:14:{s:2:\"id\";i:2402;s:5:\"title\";s:32:\"Homepage &#8211; Interior Design\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2017/09/Interior.png\";s:12:\"tmpl_created\";i:1506441447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/homepage-interior-design/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:193:\"[\"Architecture\",\"building\",\"business\",\"Creative\",\"exterior design\",\"furniture design\",\"Gallery\",\"garden design\",\"house\",\"interior design\",\"landscape design\",\"multipurpose\",\"portfolio\",\"studio\"]\";s:10:\"menu_order\";i:106;s:16:\"popularity_index\";i:105;s:11:\"trend_index\";i:275;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:623;a:14:{s:2:\"id\";i:3626;s:5:\"title\";s:30:\"Snowboard Site &#8211; Contact\";s:9:\"thumbnail\";s:62:\"https://library.elementor.com/wp-content/uploads/2017/12/3.png\";s:12:\"tmpl_created\";i:1513513193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/snowboard-site-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:260;s:11:\"trend_index\";i:353;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:624;a:14:{s:2:\"id\";i:9752;s:5:\"title\";s:27:\"Slide In | Sale | Promotion\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2019/01/rush_small.png\";s:12:\"tmpl_created\";i:1547823982;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/popups/slide-in-sale-promotion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:107;s:16:\"popularity_index\";i:680;s:11:\"trend_index\";i:655;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:625;a:14:{s:2:\"id\";i:11966;s:5:\"title\";s:18:\"Maintenance mode 4\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/10/mm4.png\";s:12:\"tmpl_created\";i:1572154274;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";i:108;s:16:\"popularity_index\";i:502;s:11:\"trend_index\";i:413;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:626;a:14:{s:2:\"id\";i:3632;s:5:\"title\";s:31:\"Snowboard Site &#8211; Services\";s:9:\"thumbnail\";s:62:\"https://library.elementor.com/wp-content/uploads/2017/12/2.png\";s:12:\"tmpl_created\";i:1513513171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/snowboard-site-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:109;s:16:\"popularity_index\";i:201;s:11:\"trend_index\";i:362;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:627;a:14:{s:2:\"id\";i:3619;s:5:\"title\";s:31:\"Snowboard Site &#8211; Homepage\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2017/12/home.png\";s:12:\"tmpl_created\";i:1513513137;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/snowboard-site-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:110;s:16:\"popularity_index\";i:217;s:11:\"trend_index\";i:438;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:628;a:14:{s:2:\"id\";i:9425;s:5:\"title\";s:38:\"Black Friday &#8211;  80&#8217;s style\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2018/11/unnamed-file.png\";s:12:\"tmpl_created\";i:1542901234;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/black-friday-80s-style/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:111;s:16:\"popularity_index\";i:338;s:11:\"trend_index\";i:332;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:629;a:14:{s:2:\"id\";i:10169;s:5:\"title\";s:37:\"Slide In | Register | Subscribe | App\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2019/01/slideinapp_small.png\";s:12:\"tmpl_created\";i:1547852334;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/popups/slide-in-register-subscribe-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:461;s:11:\"trend_index\";i:656;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:630;a:14:{s:2:\"id\";i:11973;s:5:\"title\";s:18:\"Maintenance mode 5\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/10/mm5.png\";s:12:\"tmpl_created\";i:1572154523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";i:112;s:16:\"popularity_index\";i:447;s:11:\"trend_index\";i:289;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:631;a:14:{s:2:\"id\";i:11981;s:5:\"title\";s:18:\"Maintenance mode 6\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2019/10/mm6.png\";s:12:\"tmpl_created\";i:1572155125;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";i:113;s:16:\"popularity_index\";i:444;s:11:\"trend_index\";i:260;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:632;a:14:{s:2:\"id\";i:147;s:5:\"title\";s:20:\"Homepage &#8211; App\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0004.png\";s:12:\"tmpl_created\";i:1470829868;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/homepage-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:18:\"[\"App\",\"Homepage\"]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:4;s:11:\"trend_index\";i:21;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:633;a:14:{s:2:\"id\";i:9680;s:5:\"title\";s:23:\"Slide In | Content Lock\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2019/01/Slide-in_Content-lock_small_01.png\";s:12:\"tmpl_created\";i:1547010967;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/popups/slide-in-content-lock-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:115;s:16:\"popularity_index\";i:671;s:11:\"trend_index\";i:668;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:634;a:14:{s:2:\"id\";i:777;s:5:\"title\";s:28:\"Homepage &#8211; Coffee Shop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/01/rest-home.jpg\";s:12:\"tmpl_created\";i:1485273092;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/homepage-coffee-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:41:\"[\"Coffee\",\"Homepage\",\"Restaurant\",\"Shop\"]\";s:10:\"menu_order\";i:116;s:16:\"popularity_index\";i:156;s:11:\"trend_index\";i:276;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:635;a:14:{s:2:\"id\";i:2404;s:5:\"title\";s:24:\"Homepage &#8211; Product\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2017/09/product.png\";s:12:\"tmpl_created\";i:1506441452;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/homepage-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:103:\"[\"business\",\"colorful\",\"ecommerce\",\"flat\",\"mobile\",\"modern\",\"responsive\",\"retina\",\"Shop\",\"woocommerce\"]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:149;s:11:\"trend_index\";i:325;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:636;a:14:{s:2:\"id\";i:9783;s:5:\"title\";s:31:\"Slide In | Register | Subscribe\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2019/01/slidein_yellow_small.png\";s:12:\"tmpl_created\";i:1547831059;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/popups/slide-in-register-subscribe/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:117;s:16:\"popularity_index\";i:500;s:11:\"trend_index\";i:579;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"1\";}i:637;a:14:{s:2:\"id\";i:492;s:5:\"title\";s:25:\"Homepage &#8211; Law firm\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0024.png\";s:12:\"tmpl_created\";i:1477388365;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/homepage-law-firm/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:25:\"[\"Firm\",\"Homepage\",\"Law\"]\";s:10:\"menu_order\";i:118;s:16:\"popularity_index\";i:13;s:11:\"trend_index\";i:58;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:638;a:14:{s:2:\"id\";i:3451;s:5:\"title\";s:39:\"Homepage &#8211; Goodness meal services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2017/11/goodness-featured-image.png\";s:12:\"tmpl_created\";i:1512054116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/homepage-goodness-meal-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:119;s:16:\"popularity_index\";i:236;s:11:\"trend_index\";i:357;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:639;a:14:{s:2:\"id\";i:2152;s:5:\"title\";s:26:\"Homepage &#8211; Cake Shop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/07/cake-home.png\";s:12:\"tmpl_created\";i:1499774132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/homepage-cake-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Cake\",\"Homepage\",\"Restaurant\",\"Shop\"]\";s:10:\"menu_order\";i:120;s:16:\"popularity_index\";i:348;s:11:\"trend_index\";i:477;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:640;a:14:{s:2:\"id\";i:1068;s:5:\"title\";s:27:\"Homepage &#8211; Copywriter\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2017/03/copywriter.png\";s:12:\"tmpl_created\";i:1488805928;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/homepage-copywriter/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:25:\"[\"Copywriter\",\"Homepage\"]\";s:10:\"menu_order\";i:121;s:16:\"popularity_index\";i:221;s:11:\"trend_index\";i:415;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:641;a:14:{s:2:\"id\";i:2813;s:5:\"title\";s:32:\"Homepage &#8211; Creative Agency\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2017/11/Creative-Agency-–-Home-Page.png\";s:12:\"tmpl_created\";i:1509615049;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/homepage-creative-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:32:\"[\"Agency\",\"Creative\",\"Homepage\"]\";s:10:\"menu_order\";i:122;s:16:\"popularity_index\";i:117;s:11:\"trend_index\";i:217;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:642;a:14:{s:2:\"id\";i:728;s:5:\"title\";s:33:\"Homepage &#8211; Delivery Company\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/01/delivery-company-home-page.jpg\";s:12:\"tmpl_created\";i:1485269993;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/homepage-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:23:\"[\"Delivery\",\"Homepage\"]\";s:10:\"menu_order\";i:123;s:16:\"popularity_index\";i:288;s:11:\"trend_index\";i:529;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:643;a:14:{s:2:\"id\";i:2403;s:5:\"title\";s:29:\"Homepage &#8211; Luxury Hotel\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/09/Hotel.png\";s:12:\"tmpl_created\";i:1506441428;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/homepage-luxury-hotel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:124;s:16:\"popularity_index\";i:277;s:11:\"trend_index\";i:339;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:644;a:14:{s:2:\"id\";i:1903;s:5:\"title\";s:20:\"One Page &#8211; Spa\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2017/06/spa.png\";s:12:\"tmpl_created\";i:1496822325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/one-page-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:132:\"[\"beauty\",\"care\",\"girly\",\"hair\",\"Health\",\"hospitality\",\"massage\",\"medical\",\"parlor\",\"physiotherapy\",\"salon\",\"spa\",\"wellness\",\"yoga\"]\";s:10:\"menu_order\";i:125;s:16:\"popularity_index\";i:187;s:11:\"trend_index\";i:227;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:645;a:14:{s:2:\"id\";i:2123;s:5:\"title\";s:33:\"One Page &#8211; Architect Office\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/06/architect.png\";s:12:\"tmpl_created\";i:1499772989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/one-page-architect-office/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:126;s:16:\"popularity_index\";i:11;s:11:\"trend_index\";i:20;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:646;a:14:{s:2:\"id\";i:1888;s:5:\"title\";s:32:\"One Page &#8211; Creative Meetup\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2017/06/creative-meetup.png\";s:12:\"tmpl_created\";i:1496822319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/one-page-creative-meetup/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:127;s:16:\"popularity_index\";i:284;s:11:\"trend_index\";i:502;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:647;a:14:{s:2:\"id\";i:1891;s:5:\"title\";s:35:\"One Page &#8211; Textile Convention\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/06/textile-meetup.png\";s:12:\"tmpl_created\";i:1496822323;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/one-page-textile-convention/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:128;s:16:\"popularity_index\";i:427;s:11:\"trend_index\";i:594;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:648;a:14:{s:2:\"id\";i:1880;s:5:\"title\";s:24:\"One Page &#8211; Wedding\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2017/06/wedding.png\";s:12:\"tmpl_created\";i:1496822317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/one-page-wedding/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"bride\",\"ceremony\",\"cute\",\"event\",\"fancy\",\"girly\",\"groom\",\"guestbook\",\"marriage\"]\";s:10:\"menu_order\";i:129;s:16:\"popularity_index\";i:468;s:11:\"trend_index\";i:614;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:649;a:14:{s:2:\"id\";i:1885;s:5:\"title\";s:29:\"One Page &#8211; Yacht Rental\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2017/06/yacht-home.png\";s:12:\"tmpl_created\";i:1496822321;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/one-page-yacht-rental/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:130;s:16:\"popularity_index\";i:210;s:11:\"trend_index\";i:409;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:650;a:14:{s:2:\"id\";i:2723;s:5:\"title\";s:34:\"Portfolio &#8211; Graphic Designer\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2017/11/Graphic-Designer-–-Portfolio.png\";s:12:\"tmpl_created\";i:1509633883;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/portfolio-graphic-designer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:131;s:16:\"popularity_index\";i:190;s:11:\"trend_index\";i:282;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:651;a:14:{s:2:\"id\";i:2145;s:5:\"title\";s:30:\"About &#8211; Delivery Company\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/07/delivery-about.png\";s:12:\"tmpl_created\";i:1499774125;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/about-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:10:\"[\"moving\"]\";s:10:\"menu_order\";i:132;s:16:\"popularity_index\";i:355;s:11:\"trend_index\";i:630;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:652;a:14:{s:2:\"id\";i:2155;s:5:\"title\";s:23:\"About &#8211; Cake Shop\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2017/07/cake-about.png\";s:12:\"tmpl_created\";i:1499774130;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/about-cake-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:8:\"[\"Food\"]\";s:10:\"menu_order\";i:133;s:16:\"popularity_index\";i:403;s:11:\"trend_index\";i:584;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:653;a:14:{s:2:\"id\";i:1085;s:5:\"title\";s:21:\"About &#8211; Startup\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2017/03/Startup.png\";s:12:\"tmpl_created\";i:1488810874;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/about-startup/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:19:\"[\"About\",\"Startup\"]\";s:10:\"menu_order\";i:134;s:16:\"popularity_index\";i:8;s:11:\"trend_index\";i:10;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:654;a:14:{s:2:\"id\";i:143;s:5:\"title\";s:22:\"About &#8211; Personal\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0010.png\";s:12:\"tmpl_created\";i:1470820447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/about-personal/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"About\",\"Personal\"]\";s:10:\"menu_order\";i:135;s:16:\"popularity_index\";i:24;s:11:\"trend_index\";i:68;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:655;a:14:{s:2:\"id\";i:101;s:5:\"title\";s:16:\"About &#8211; CV\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0018.png\";s:12:\"tmpl_created\";i:1470829785;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:98:\"https://library.elementor.com/about-cv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:77:\"[\"creative portfolio\",\"Personal\",\"portfolio\",\"professional\",\"resume\",\"vcard\"]\";s:10:\"menu_order\";i:136;s:16:\"popularity_index\";i:49;s:11:\"trend_index\";i:173;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:656;a:14:{s:2:\"id\";i:140;s:5:\"title\";s:25:\"About &#8211; Art Gallery\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0009.png\";s:12:\"tmpl_created\";i:1470820463;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/about-art-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:25:\"[\"About\",\"Art\",\"Gallery\"]\";s:10:\"menu_order\";i:137;s:16:\"popularity_index\";i:18;s:11:\"trend_index\";i:41;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:657;a:14:{s:2:\"id\";i:213;s:5:\"title\";s:26:\"About &#8211; Architecture\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0008.png\";s:12:\"tmpl_created\";i:1470829766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/about-architecture/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"About\",\"Architecture\"]\";s:10:\"menu_order\";i:138;s:16:\"popularity_index\";i:19;s:11:\"trend_index\";i:59;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:658;a:14:{s:2:\"id\";i:2802;s:5:\"title\";s:38:\"Portfolio &#8211; Fashion Photographer\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2017/11/Fashion-photographer-–-Portfolio.png\";s:12:\"tmpl_created\";i:1509615440;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/portfolio-fashion-photographer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:139;s:16:\"popularity_index\";i:225;s:11:\"trend_index\";i:483;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:659;a:14:{s:2:\"id\";i:2828;s:5:\"title\";s:35:\"Landing Page &#8211; Law Convention\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2017/11/Law-Convention-–-Landing-Page.png\";s:12:\"tmpl_created\";i:1509631636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/landing-page-law-convention/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:35:\"[\"Convention\",\"Landing Page\",\"Law\"]\";s:10:\"menu_order\";i:140;s:16:\"popularity_index\";i:367;s:11:\"trend_index\";i:560;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:660;a:14:{s:2:\"id\";i:1461;s:5:\"title\";s:28:\"Landing Page &#8211; Ebook 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Ebook-1.png\";s:12:\"tmpl_created\";i:1494352121;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-ebook-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:127:\"[\"App\",\"author\",\"book\",\"brochure\",\"download\",\"e-book\",\"ebook\",\"marketing\",\"product\",\"publisher\",\"sell online\",\"seo\",\"showcase\"]\";s:10:\"menu_order\";i:141;s:16:\"popularity_index\";i:353;s:11:\"trend_index\";i:554;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:661;a:14:{s:2:\"id\";i:1460;s:5:\"title\";s:28:\"Landing Page &#8211; Ebook 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Ebook-2.png\";s:12:\"tmpl_created\";i:1494352124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-ebook-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:373;s:11:\"trend_index\";i:444;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:662;a:14:{s:2:\"id\";i:1459;s:5:\"title\";s:28:\"Landing Page &#8211; Ebook 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Ebook-3.png\";s:12:\"tmpl_created\";i:1494352125;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-ebook-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:143;s:16:\"popularity_index\";i:242;s:11:\"trend_index\";i:283;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:663;a:14:{s:2:\"id\";i:1052;s:5:\"title\";s:33:\"Landing Page &#8211; Mobile App 1\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2017/03/app.png\";s:12:\"tmpl_created\";i:1488810873;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/landing-page-mobile-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:144;s:16:\"popularity_index\";i:37;s:11:\"trend_index\";i:84;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:664;a:14:{s:2:\"id\";i:1505;s:5:\"title\";s:33:\"Landing Page &#8211; Mobile App 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-app3.png\";s:12:\"tmpl_created\";i:1494352110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-mobile-app-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:145;s:16:\"popularity_index\";i:395;s:11:\"trend_index\";i:598;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:665;a:14:{s:2:\"id\";i:726;s:5:\"title\";s:33:\"Landing Page &#8211; Conference 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2017/01/convention-landing-page.jpg\";s:12:\"tmpl_created\";i:1485270062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/landing-page-conference/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:146;s:16:\"popularity_index\";i:438;s:11:\"trend_index\";i:539;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:666;a:14:{s:2:\"id\";i:1613;s:5:\"title\";s:33:\"Landing Page &#8211; Conference 2\";s:9:\"thumbnail\";s:109:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-International-Womens-Day-Conference.png\";s:12:\"tmpl_created\";i:1494352129;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-conference-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:147;s:16:\"popularity_index\";i:453;s:11:\"trend_index\";i:462;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:667;a:14:{s:2:\"id\";i:1612;s:5:\"title\";s:33:\"Landing Page &#8211; Conference 3\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Tech-Conference.png\";s:12:\"tmpl_created\";i:1494352127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-conference-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:148;s:16:\"popularity_index\";i:479;s:11:\"trend_index\";i:673;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:668;a:14:{s:2:\"id\";i:1614;s:5:\"title\";s:33:\"Landing Page &#8211; Conference 4\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Sustainability-Conference.png\";s:12:\"tmpl_created\";i:1494352131;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-conference-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:149;s:16:\"popularity_index\";i:382;s:11:\"trend_index\";i:532;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:669;a:14:{s:2:\"id\";i:906;s:5:\"title\";s:29:\"Landing Page &#8211;  Coacher\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2017/02/Landin-Page-Coacher.png\";s:12:\"tmpl_created\";i:1494352066;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-coacher/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:150;s:16:\"popularity_index\";i:279;s:11:\"trend_index\";i:379;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:670;a:14:{s:2:\"id\";i:879;s:5:\"title\";s:41:\"Landing Page &#8211; Financial Consultant\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Financial-consultant.png\";s:12:\"tmpl_created\";i:1494352064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/landing-page-financial-consultant/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:151;s:16:\"popularity_index\";i:287;s:11:\"trend_index\";i:370;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:671;a:14:{s:2:\"id\";i:926;s:5:\"title\";s:33:\"Landing Page &#8211; Private Chef\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Private-Chef.png\";s:12:\"tmpl_created\";i:1494352068;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/landing-page-private-chef/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:152;s:16:\"popularity_index\";i:401;s:11:\"trend_index\";i:542;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:672;a:14:{s:2:\"id\";i:1032;s:5:\"title\";s:27:\"Landing Page &#8211; Agency\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2017/03/Agency.png\";s:12:\"tmpl_created\";i:1488810866;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/landing-page-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:153;s:16:\"popularity_index\";i:398;s:11:\"trend_index\";i:558;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:673;a:14:{s:2:\"id\";i:730;s:5:\"title\";s:24:\"Landing Page &#8211; App\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/01/app.-landing-page.jpg\";s:12:\"tmpl_created\";i:1485273430;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/landing-page-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:154;s:16:\"popularity_index\";i:358;s:11:\"trend_index\";i:525;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:674;a:14:{s:2:\"id\";i:643;s:5:\"title\";s:29:\"Landing Page &#8211; Festival\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2016/12/festival.jpg\";s:12:\"tmpl_created\";i:1481549290;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-festival/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:155;s:16:\"popularity_index\";i:450;s:11:\"trend_index\";i:569;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:675;a:14:{s:2:\"id\";i:542;s:5:\"title\";s:28:\"Landing Page &#8211; Wedding\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/10/0025.png\";s:12:\"tmpl_created\";i:1477388484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-wedding/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:156;s:16:\"popularity_index\";i:102;s:11:\"trend_index\";i:322;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:676;a:14:{s:2:\"id\";i:1187;s:5:\"title\";s:32:\"Landing Page &#8211; Photography\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp1-l.png\";s:12:\"tmpl_created\";i:1490707385;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/landing-page-photography/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:157;s:16:\"popularity_index\";i:48;s:11:\"trend_index\";i:95;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:677;a:14:{s:2:\"id\";i:641;s:5:\"title\";s:28:\"Landing Page &#8211; Fashion\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2016/12/fashion-landing-page.jpg\";s:12:\"tmpl_created\";i:1481549264;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-fashion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:158;s:16:\"popularity_index\";i:328;s:11:\"trend_index\";i:457;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:678;a:14:{s:2:\"id\";i:189;s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 1\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0005.png\";s:12:\"tmpl_created\";i:1470820715;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-tourism/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:159;s:16:\"popularity_index\";i:15;s:11:\"trend_index\";i:44;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:679;a:14:{s:2:\"id\";i:1547;s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Truism-1.png\";s:12:\"tmpl_created\";i:1494352115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/landing-page-tourism-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:160;s:16:\"popularity_index\";i:345;s:11:\"trend_index\";i:617;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:680;a:14:{s:2:\"id\";i:1546;s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Truism-2.png\";s:12:\"tmpl_created\";i:1494352116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/landing-page-tourism-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:161;s:16:\"popularity_index\";i:475;s:11:\"trend_index\";i:644;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:681;a:14:{s:2:\"id\";i:1545;s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 4\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Truism-3.png\";s:12:\"tmpl_created\";i:1494352118;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/landing-page-tourism-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:162;s:16:\"popularity_index\";i:374;s:11:\"trend_index\";i:449;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:682;a:14:{s:2:\"id\";i:2714;s:5:\"title\";s:30:\"Landing Page &#8211; Tourism 5\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2017/11/Vacation-–-Landing-Page.png\";s:12:\"tmpl_created\";i:1509631782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/landing-page-tourism-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:163;s:16:\"popularity_index\";i:366;s:11:\"trend_index\";i:544;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:683;a:14:{s:2:\"id\";i:195;s:5:\"title\";s:28:\"Landing Page &#8211; Product\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0006.png\";s:12:\"tmpl_created\";i:1470820765;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:164;s:16:\"popularity_index\";i:57;s:11:\"trend_index\";i:180;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:684;a:14:{s:2:\"id\";i:197;s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 1\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0007.png\";s:12:\"tmpl_created\";i:1470825711;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/landing-page-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:165;s:16:\"popularity_index\";i:136;s:11:\"trend_index\";i:383;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:685;a:14:{s:2:\"id\";i:1193;s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 2\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2017/03/lp3-l.png\";s:12:\"tmpl_created\";i:1490707422;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/landing-page-real-estate-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:166;s:16:\"popularity_index\";i:70;s:11:\"trend_index\";i:153;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:686;a:14:{s:2:\"id\";i:1415;s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Real-Estate-1.png\";s:12:\"tmpl_created\";i:1494352106;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/landing-page-real-estate-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:167;s:16:\"popularity_index\";i:356;s:11:\"trend_index\";i:695;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:687;a:14:{s:2:\"id\";i:1414;s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 4\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Real-Estate-2.png\";s:12:\"tmpl_created\";i:1494352107;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/landing-page-real-estate-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:168;s:16:\"popularity_index\";i:497;s:11:\"trend_index\";i:641;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:688;a:14:{s:2:\"id\";i:1413;s:5:\"title\";s:34:\"Landing Page &#8211; Real Estate 5\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Real-Estate-3.png\";s:12:\"tmpl_created\";i:1494352109;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/landing-page-real-estate-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:134:\"[\"Agent\",\"business\",\"clean\",\"corporate\",\"flat\",\"google maps\",\"homes\",\"listing\",\"modern\",\"real estate\",\"realestate\",\"realtor\",\"realty\"]\";s:10:\"menu_order\";i:169;s:16:\"popularity_index\";i:433;s:11:\"trend_index\";i:442;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:689;a:14:{s:2:\"id\";i:1573;s:5:\"title\";s:29:\"Landing Page &#8211; Coupon 1\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-02.png\";s:12:\"tmpl_created\";i:1494352133;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-coupon-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:170;s:16:\"popularity_index\";i:526;s:11:\"trend_index\";i:622;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:690;a:14:{s:2:\"id\";i:1572;s:5:\"title\";s:29:\"Landing Page &#8211; Coupon 2\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-03.png\";s:12:\"tmpl_created\";i:1494352134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-coupon-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:171;s:16:\"popularity_index\";i:557;s:11:\"trend_index\";i:582;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:691;a:14:{s:2:\"id\";i:1570;s:5:\"title\";s:29:\"Landing Page &#8211; Coupon 3\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-01.png\";s:12:\"tmpl_created\";i:1494352136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-coupon-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:172;s:16:\"popularity_index\";i:600;s:11:\"trend_index\";i:559;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:692;a:14:{s:2:\"id\";i:1571;s:5:\"title\";s:29:\"Landing Page &#8211; Coupon 4\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-04.png\";s:12:\"tmpl_created\";i:1494352138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/landing-page-coupon-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:173;s:16:\"popularity_index\";i:573;s:11:\"trend_index\";i:605;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:693;a:14:{s:2:\"id\";i:192;s:5:\"title\";s:28:\"Landing Page &#8211; Webinar\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0015.png\";s:12:\"tmpl_created\";i:1470820734;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/landing-page-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:174;s:16:\"popularity_index\";i:122;s:11:\"trend_index\";i:262;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:694;a:14:{s:2:\"id\";i:2141;s:5:\"title\";s:32:\"Contact &#8211; Delivery Company\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/07/delivery-contact.png\";s:12:\"tmpl_created\";i:1499774122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/contact-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:175;s:16:\"popularity_index\";i:331;s:11:\"trend_index\";i:470;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:695;a:14:{s:2:\"id\";i:137;s:5:\"title\";s:22:\"Contact &#8211; Modern\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0013.png\";s:12:\"tmpl_created\";i:1470829828;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/contact-modern/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:176;s:16:\"popularity_index\";i:52;s:11:\"trend_index\";i:127;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:696;a:14:{s:2:\"id\";i:256;s:5:\"title\";s:26:\"Contact &#8211; Restaurant\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0011.png\";s:12:\"tmpl_created\";i:1470829796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/contact-restaurant/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:177;s:16:\"popularity_index\";i:132;s:11:\"trend_index\";i:307;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:697;a:14:{s:2:\"id\";i:2150;s:5:\"title\";s:25:\"Contact &#8211; Cake Shop\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/07/cake-contact.png\";s:12:\"tmpl_created\";i:1499774127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/contact-cake-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:178;s:16:\"popularity_index\";i:68;s:11:\"trend_index\";i:183;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:698;a:14:{s:2:\"id\";i:223;s:5:\"title\";s:21:\"Contact &#8211; Hotel\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0002.png\";s:12:\"tmpl_created\";i:1470820471;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/contact-hotel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:179;s:16:\"popularity_index\";i:134;s:11:\"trend_index\";i:185;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:699;a:14:{s:2:\"id\";i:24;s:5:\"title\";s:25:\"Contact &#8211; Corporate\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0012.png\";s:12:\"tmpl_created\";i:1470248619;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/contact-corporate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:180;s:16:\"popularity_index\";i:12;s:11:\"trend_index\";i:15;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:700;a:14:{s:2:\"id\";i:184;s:5:\"title\";s:23:\"Services &#8211; Moving\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0017.png\";s:12:\"tmpl_created\";i:1470829889;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/services-moving/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:181;s:16:\"popularity_index\";i:23;s:11:\"trend_index\";i:50;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:701;a:14:{s:2:\"id\";i:625;s:5:\"title\";s:31:\"Services &#8211; Cake Shop Menu\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2016/12/cake-shop-menu.jpg\";s:12:\"tmpl_created\";i:1481549196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/services-cake-shop-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:182;s:16:\"popularity_index\";i:563;s:11:\"trend_index\";i:653;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:702;a:14:{s:2:\"id\";i:187;s:5:\"title\";s:20:\"Services &#8211; Fun\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0001.png\";s:12:\"tmpl_created\";i:1470829892;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/services-fun/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:183;s:16:\"popularity_index\";i:81;s:11:\"trend_index\";i:232;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:703;a:14:{s:2:\"id\";i:238;s:5:\"title\";s:27:\"Services &#8211; Consulting\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0014.png\";s:12:\"tmpl_created\";i:1470829865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/services-consulting/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:184;s:16:\"popularity_index\";i:21;s:11:\"trend_index\";i:40;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:704;a:14:{s:2:\"id\";i:647;s:5:\"title\";s:33:\"Services &#8211; Coffee Shop Menu\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2016/12/restaurant-menu.jpg\";s:12:\"tmpl_created\";i:1481549320;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/services-coffee-shop-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:185;s:16:\"popularity_index\";i:464;s:11:\"trend_index\";i:607;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:705;a:14:{s:2:\"id\";i:2138;s:5:\"title\";s:33:\"Services &#8211; Delivery Company\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/07/delivery-services.png\";s:12:\"tmpl_created\";i:1499774119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/services-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:186;s:16:\"popularity_index\";i:392;s:11:\"trend_index\";i:581;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:706;a:14:{s:2:\"id\";i:823;s:5:\"title\";s:19:\"Pricing &#8211; App\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2017/01/pricing-app.jpg\";s:12:\"tmpl_created\";i:1485272966;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/pricing-app-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:187;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:498;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:707;a:14:{s:2:\"id\";i:824;s:5:\"title\";s:24:\"Pricing &#8211; Software\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/01/pricing-software.png\";s:12:\"tmpl_created\";i:1485272900;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/pricing-software-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:188;s:16:\"popularity_index\";i:368;s:11:\"trend_index\";i:468;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:708;a:14:{s:2:\"id\";i:825;s:5:\"title\";s:24:\"Product &#8211; Speakers\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/01/product-page.jpg\";s:12:\"tmpl_created\";i:1485272513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/product-speakers/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:189;s:16:\"popularity_index\";i:388;s:11:\"trend_index\";i:595;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:709;a:14:{s:2:\"id\";i:245;s:5:\"title\";s:21:\"Product &#8211; Clean\";s:9:\"thumbnail\";s:65:\"https://library.elementor.com/wp-content/uploads/2016/08/0020.png\";s:12:\"tmpl_created\";i:1470829876;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/product-clean/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"fast\",\"minimal\",\"minimalistic\",\"seo\",\"simple\"]\";s:10:\"menu_order\";i:190;s:16:\"popularity_index\";i:88;s:11:\"trend_index\";i:132;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:710;a:14:{s:2:\"id\";i:1075;s:5:\"title\";s:19:\"Shop &#8211; Sweets\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2017/03/Sweets.png\";s:12:\"tmpl_created\";i:1488810871;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/shop-sweets/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:154:\"[\"bakery\",\"beverage\",\"business\",\"cafe\",\"candy bar\",\"catering\",\"delivery service\",\"Food\",\"online shop\",\"pastry\",\"Restaurant\",\"store\",\"sweet shop\",\"sweets\"]\";s:10:\"menu_order\";i:191;s:16:\"popularity_index\";i:59;s:11:\"trend_index\";i:104;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:711;a:14:{s:2:\"id\";i:1051;s:5:\"title\";s:24:\"Blog Post &#8211; Launch\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2017/03/post-cloud.png\";s:12:\"tmpl_created\";i:1488810869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/blog-post-launch/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:210:\"[\"Agency\",\"bootstrap\",\"business\",\"corporate\",\"Landing Page\",\"launch\",\"marketing campaign\",\"marketing landing page\",\"marketing template landing page\",\"product launch\",\"software\",\"Startup\",\"startup landing page\"]\";s:10:\"menu_order\";i:192;s:16:\"popularity_index\";i:17;s:11:\"trend_index\";i:22;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:712;a:14:{s:2:\"id\";i:1245;s:5:\"title\";s:13:\"Coming Soon 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-1.png\";s:12:\"tmpl_created\";i:1491207184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:193;s:16:\"popularity_index\";i:259;s:11:\"trend_index\";i:286;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:713;a:14:{s:2:\"id\";i:1247;s:5:\"title\";s:13:\"Coming Soon 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-2.png\";s:12:\"tmpl_created\";i:1491207138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:194;s:16:\"popularity_index\";i:32;s:11:\"trend_index\";i:31;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:714;a:14:{s:2:\"id\";i:1248;s:5:\"title\";s:13:\"Coming Soon 3\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-3.png\";s:12:\"tmpl_created\";i:1491207050;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:195;s:16:\"popularity_index\";i:389;s:11:\"trend_index\";i:597;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:715;a:14:{s:2:\"id\";i:1249;s:5:\"title\";s:13:\"Coming Soon 4\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-4.png\";s:12:\"tmpl_created\";i:1491207380;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:196;s:16:\"popularity_index\";i:429;s:11:\"trend_index\";i:500;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:716;a:14:{s:2:\"id\";i:1250;s:5:\"title\";s:13:\"Coming Soon 5\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-5.png\";s:12:\"tmpl_created\";i:1491207450;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:197;s:16:\"popularity_index\";i:72;s:11:\"trend_index\";i:134;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:717;a:14:{s:2:\"id\";i:1260;s:5:\"title\";s:18:\"Maintenance Mode 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-6.png\";s:12:\"tmpl_created\";i:1491207507;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";i:198;s:16:\"popularity_index\";i:457;s:11:\"trend_index\";i:432;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:718;a:14:{s:2:\"id\";i:1261;s:5:\"title\";s:18:\"Maintenance Mode 2\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/04/Coming-Soon-7.png\";s:12:\"tmpl_created\";i:1491207584;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/maintenance-mode-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:20:\"[\"Maintenance mode\"]\";s:10:\"menu_order\";i:199;s:16:\"popularity_index\";i:78;s:11:\"trend_index\";i:200;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:719;a:14:{s:2:\"id\";i:1272;s:5:\"title\";s:13:\"Coming Soon 8\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-8.png\";s:12:\"tmpl_created\";i:1491207674;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:200;s:16:\"popularity_index\";i:289;s:11:\"trend_index\";i:354;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:720;a:14:{s:2:\"id\";i:1279;s:5:\"title\";s:13:\"Coming Soon 9\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-9.png\";s:12:\"tmpl_created\";i:1491207756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:103:\"https://library.elementor.com/coming-soon-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:201;s:16:\"popularity_index\";i:145;s:11:\"trend_index\";i:206;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}i:721;a:14:{s:2:\"id\";i:1745;s:5:\"title\";s:14:\"Coming Soon 10\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/login-002.png\";s:12:\"tmpl_created\";i:1494849745;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/coming-soon-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:202;s:16:\"popularity_index\";i:278;s:11:\"trend_index\";i:297;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:722;a:14:{s:2:\"id\";i:1742;s:5:\"title\";s:12:\"Login Page 1\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/login-003.png\";s:12:\"tmpl_created\";i:1494849744;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:100:\"https://library.elementor.com/login-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:203;s:16:\"popularity_index\";i:420;s:11:\"trend_index\";i:388;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:723;a:14:{s:2:\"id\";i:1748;s:5:\"title\";s:12:\"Login Page 2\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/05/login-001.png\";s:12:\"tmpl_created\";i:1494849742;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:102:\"https://library.elementor.com/login-page-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:204;s:16:\"popularity_index\";i:299;s:11:\"trend_index\";i:363;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:724;a:14:{s:2:\"id\";i:3963;s:5:\"title\";s:32:\"Restaurant Site &#8211; Homepage\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2018/01/R.HomepageThumb.png\";s:12:\"tmpl_created\";i:1516284821;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/restaurant-site-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:109:\"[\"bar\",\"cafe\",\"cooking\",\"drink\",\"events\",\"fast food\",\"Food\",\"menu\",\"modern\",\"reservation\",\"Shop\",\"snack bar\"]\";s:10:\"menu_order\";i:205;s:16:\"popularity_index\";i:237;s:11:\"trend_index\";i:298;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:725;a:14:{s:2:\"id\";i:3969;s:5:\"title\";s:28:\"Restaurant Site &#8211; Menu\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2018/01/R.MenuThumb.png\";s:12:\"tmpl_created\";i:1516284829;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/restaurant-site-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:109:\"[\"bar\",\"cafe\",\"cooking\",\"drink\",\"events\",\"fast food\",\"Food\",\"menu\",\"modern\",\"reservation\",\"Shop\",\"snack bar\"]\";s:10:\"menu_order\";i:206;s:16:\"popularity_index\";i:390;s:11:\"trend_index\";i:627;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:726;a:14:{s:2:\"id\";i:3966;s:5:\"title\";s:29:\"Restaurant Site &#8211; About\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2018/01/R.AboutThumb.png.png\";s:12:\"tmpl_created\";i:1516284839;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:111:\"https://library.elementor.com/restaurant-site-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:109:\"[\"bar\",\"cafe\",\"cooking\",\"drink\",\"events\",\"fast food\",\"Food\",\"menu\",\"modern\",\"reservation\",\"Shop\",\"snack bar\"]\";s:10:\"menu_order\";i:207;s:16:\"popularity_index\";i:257;s:11:\"trend_index\";i:305;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:727;a:14:{s:2:\"id\";i:3972;s:5:\"title\";s:31:\"Restaurant Site &#8211; Contact\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/01/R.ContactThumb.png\";s:12:\"tmpl_created\";i:1516284847;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/restaurant-site-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:109:\"[\"bar\",\"cafe\",\"cooking\",\"drink\",\"events\",\"fast food\",\"Food\",\"menu\",\"modern\",\"reservation\",\"Shop\",\"snack bar\"]\";s:10:\"menu_order\";i:208;s:16:\"popularity_index\";i:363;s:11:\"trend_index\";i:464;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:728;a:14:{s:2:\"id\";i:2080;s:5:\"title\";s:27:\"Ski Resort &#8211; Homepage\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2017/10/Ski-Resort-Home-Page.png\";s:12:\"tmpl_created\";i:1508161124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/ski-resort-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:209;s:16:\"popularity_index\";i:340;s:11:\"trend_index\";i:387;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:729;a:14:{s:2:\"id\";i:2088;s:5:\"title\";s:24:\"Ski Resort &#8211; About\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/10/Ski-Resort-About.png\";s:12:\"tmpl_created\";i:1508161129;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:106:\"https://library.elementor.com/ski-resort-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:210;s:16:\"popularity_index\";i:425;s:11:\"trend_index\";i:513;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:730;a:14:{s:2:\"id\";i:2085;s:5:\"title\";s:27:\"Ski Resort &#8211; Services\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2017/10/Ski-Resort-Services.png\";s:12:\"tmpl_created\";i:1508161134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/ski-resort-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:211;s:16:\"popularity_index\";i:551;s:11:\"trend_index\";i:689;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:731;a:14:{s:2:\"id\";i:2462;s:5:\"title\";s:23:\"Architect &#8211; About\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2017/10/architect-–-about.png\";s:12:\"tmpl_created\";i:1508243317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:105:\"https://library.elementor.com/architect-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:212;s:16:\"popularity_index\";i:334;s:11:\"trend_index\";i:616;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:732;a:14:{s:2:\"id\";i:2362;s:5:\"title\";s:26:\"Architect &#8211; Projects\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2017/10/Architect-Projects.png\";s:12:\"tmpl_created\";i:1508243335;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/architect-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:213;s:16:\"popularity_index\";i:399;s:11:\"trend_index\";i:572;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:733;a:14:{s:2:\"id\";i:614;s:5:\"title\";s:25:\"Architect &#8211; Contact\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2016/12/architect-contact.jpg\";s:12:\"tmpl_created\";i:1481549169;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/architect-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:214;s:16:\"popularity_index\";i:303;s:11:\"trend_index\";i:392;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:734;a:14:{s:2:\"id\";i:2126;s:5:\"title\";s:37:\"Construction Company &#8211; Homepage\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2017/10/Construction-Company-Home-Page.png\";s:12:\"tmpl_created\";i:1508325849;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/construction-company-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:215;s:16:\"popularity_index\";i:274;s:11:\"trend_index\";i:333;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:735;a:14:{s:2:\"id\";i:2129;s:5:\"title\";s:34:\"Construction Company &#8211; About\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2017/10/Construction-Company-About.png\";s:12:\"tmpl_created\";i:1508325881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/construction-company-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:216;s:16:\"popularity_index\";i:306;s:11:\"trend_index\";i:521;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:736;a:14:{s:2:\"id\";i:2135;s:5:\"title\";s:36:\"Construction Company &#8211; Contact\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2017/10/Construction-Company-Contact.png\";s:12:\"tmpl_created\";i:1508325922;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/construction-company-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:217;s:16:\"popularity_index\";i:350;s:11:\"trend_index\";i:414;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:737;a:14:{s:2:\"id\";i:2094;s:5:\"title\";s:28:\"Plants Shop &#8211; Homepage\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2017/11/Plants-Shop-Home.png\";s:12:\"tmpl_created\";i:1509621053;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/plants-shop-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:218;s:16:\"popularity_index\";i:273;s:11:\"trend_index\";i:189;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:738;a:14:{s:2:\"id\";i:2120;s:5:\"title\";s:25:\"Plants Shop &#8211; About\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2017/11/Plants-Shop-About.png\";s:12:\"tmpl_created\";i:1509631820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:107:\"https://library.elementor.com/plants-shop-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:219;s:16:\"popularity_index\";i:351;s:11:\"trend_index\";i:352;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:739;a:14:{s:2:\"id\";i:3153;s:5:\"title\";s:14:\"Halloween Pack\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/10/halloween.png\";s:12:\"tmpl_created\";i:1508950132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:104:\"https://library.elementor.com/halloween-pack/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:220;s:16:\"popularity_index\";i:614;s:11:\"trend_index\";i:0;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:740;a:14:{s:2:\"id\";i:3338;s:5:\"title\";s:31:\"Black Friday &#8211; Nature Set\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-1.png\";s:12:\"tmpl_created\";i:1511203351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/black-friday-nature-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:221;s:16:\"popularity_index\";i:545;s:11:\"trend_index\";i:683;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:741;a:14:{s:2:\"id\";i:3339;s:5:\"title\";s:35:\"Black Friday &#8211; Pop-Styled Set\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-2.png\";s:12:\"tmpl_created\";i:1511203636;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/black-friday-pop-styled-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:222;s:16:\"popularity_index\";i:487;s:11:\"trend_index\";i:679;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:742;a:14:{s:2:\"id\";i:3335;s:5:\"title\";s:31:\"Black Friday &#8211; Retail Set\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-4.png\";s:12:\"tmpl_created\";i:1511203246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/black-friday-retail-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:223;s:16:\"popularity_index\";i:489;s:11:\"trend_index\";i:602;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:743;a:14:{s:2:\"id\";i:3340;s:5:\"title\";s:41:\"Black Friday &#8211; Software Product Set\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-3.png\";s:12:\"tmpl_created\";i:1511203713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/black-friday-software-product-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:224;s:16:\"popularity_index\";i:460;s:11:\"trend_index\";i:639;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:744;a:14:{s:2:\"id\";i:3517;s:5:\"title\";s:27:\"Christmas &#8211; Gift Shop\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2017/12/XmasThumb.png\";s:12:\"tmpl_created\";i:1513877937;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/christmas-gift-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:225;s:16:\"popularity_index\";i:543;s:11:\"trend_index\";i:593;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:745;a:14:{s:2:\"id\";i:3734;s:5:\"title\";s:28:\"Christmas &#8211; Car Agency\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/12/cover-lib-v3.png\";s:12:\"tmpl_created\";i:1514197794;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:110:\"https://library.elementor.com/christmas-car-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:226;s:16:\"popularity_index\";i:521;s:11:\"trend_index\";i:604;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:746;a:14:{s:2:\"id\";i:3764;s:5:\"title\";s:33:\"Christmas &#8211; Interior Design\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/12/cover-lib-v6.png\";s:12:\"tmpl_created\";i:1514198234;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/christmas-interior-design/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:227;s:16:\"popularity_index\";i:494;s:11:\"trend_index\";i:669;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:747;a:14:{s:2:\"id\";i:3565;s:5:\"title\";s:27:\"Christmas &#8211; Tree Shop\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2017/12/XmasTreeThumb.png\";s:12:\"tmpl_created\";i:1514204382;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/christmas-tree-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:228;s:16:\"popularity_index\";i:419;s:11:\"trend_index\";i:527;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:748;a:14:{s:2:\"id\";i:3862;s:5:\"title\";s:35:\"Christmas &#8211; Design Conference\";s:9:\"thumbnail\";s:63:\"https://library.elementor.com/wp-content/uploads/2017/12/q1.png\";s:12:\"tmpl_created\";i:1514206745;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/christmas-design-conference/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:229;s:16:\"popularity_index\";i:411;s:11:\"trend_index\";i:651;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:749;a:14:{s:2:\"id\";i:3777;s:5:\"title\";s:39:\"Christmas &#8211; Snowboard Competition\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2017/12/cover-lib-v7.png\";s:12:\"tmpl_created\";i:1514205420;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/christmas-snowboard-competition/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:230;s:16:\"popularity_index\";i:458;s:11:\"trend_index\";i:688;s:6:\"is_pro\";s:1:\"1\";s:17:\"has_page_settings\";s:1:\"0\";}i:750;a:14:{s:2:\"id\";i:420;s:5:\"title\";s:11:\"Hero UI Kit\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2016/09/library-ui-kit-cover.png\";s:12:\"tmpl_created\";i:1475067229;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:101:\"https://library.elementor.com/hero-ui-kit/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:231;s:16:\"popularity_index\";i:20;s:11:\"trend_index\";i:62;s:6:\"is_pro\";s:1:\"0\";s:17:\"has_page_settings\";s:1:\"0\";}}}',	'no'),
(137,	'elementor_remote_info_feed_data',	'a:5:{i:0;a:5:{s:5:\"title\";s:59:\"How To Build a Mega Menu With Elementor and the Plus Addons\";s:7:\"excerpt\";s:251:\"Do your site visitors need to hover over an awkward drop-down, in the hopes of picking the right option? Then you need a mega-menu. In this tutorial, we\'ll show you how to create your own custom WordPress mega menu using Elementor and The Plus Addons.\";s:7:\"created\";i:1603963969;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:119:\"https://elementor.com/blog/wordpress-mega-menu/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:67:\"How To Choose The Right Brand Imagery For Your Business | Elementor\";s:7:\"excerpt\";s:148:\"Brand imagery plays a vital role in creating a positive and long-lasting association with your brand. Discover how to choose the right one for you. \";s:7:\"created\";i:1603895496;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:113:\"https://elementor.com/blog/brand-imagery/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:30:\"Meet Our Leaders: Menny Benady\";s:7:\"excerpt\";s:265:\"A web professional and digital marketing expert, Menny Benady is an artist who dabbles with different methods and techniques — from sketching to oil and acrylic painting and sculpting. This month, we introduce you to the leader of the Israel Elementor Community! \";s:7:\"created\";i:1603787082;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:129:\"https://elementor.com/blog/meet-our-leaders-menny-benady/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:3;a:5:{s:5:\"title\";s:47:\"Elementor Sites of the Month — September 2020\";s:7:\"excerpt\";s:325:\"Get ready to see some of the best magazine and blog websites built with Elementor. This month’s showcase explores the top ten magazine or blog websites from our user community, and shows prime examples for how to design your next blog or magazine site, with many unique options for layout, color schemes, motifs, and so on.\";s:7:\"created\";i:1602495962;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:123:\"https://elementor.com/blog/showcase-september-2020/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:4;a:5:{s:5:\"title\";s:36:\"The Complete WordPress Sidebar Guide\";s:7:\"excerpt\";s:150:\"Learn how sidebars can improve your site navigation and help you convert more of your traffic with the aid of the right widgets and good use of space.\";s:7:\"created\";i:1602398496;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:123:\"https://elementor.com/blog/wordpress-sidebar-guide/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}',	'no'),
(7485,	'_transient_timeout_elementor_remote_info_api_data_3.0.3',	'1604282052',	'no'),
(7486,	'_transient_elementor_remote_info_api_data_3.0.3',	'a:4:{s:9:\"timestamp\";s:10:\"1604235975\";s:14:\"upgrade_notice\";a:3:{s:7:\"version\";s:5:\"2.0.0\";s:7:\"message\";s:0:\"\";s:11:\"update_link\";s:0:\"\";}s:11:\"pro_widgets\";a:59:{i:0;a:4:{s:4:\"name\";s:5:\"posts\";s:5:\"title\";s:5:\"Posts\";s:4:\"icon\";s:15:\"eicon-post-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:1;a:4:{s:4:\"name\";s:9:\"portfolio\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:18:\"eicon-gallery-grid\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:2;a:4:{s:4:\"name\";s:7:\"gallery\";s:5:\"title\";s:7:\"Gallery\";s:4:\"icon\";s:23:\"eicon-gallery-justified\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:3;a:4:{s:4:\"name\";s:4:\"form\";s:5:\"title\";s:4:\"Form\";s:4:\"icon\";s:21:\"eicon-form-horizontal\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:4;a:4:{s:4:\"name\";s:5:\"login\";s:5:\"title\";s:5:\"Login\";s:4:\"icon\";s:15:\"eicon-lock-user\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:5;a:4:{s:4:\"name\";s:6:\"slides\";s:5:\"title\";s:6:\"Slides\";s:4:\"icon\";s:12:\"eicon-slides\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:6;a:4:{s:4:\"name\";s:8:\"nav-menu\";s:5:\"title\";s:8:\"Nav Menu\";s:4:\"icon\";s:14:\"eicon-nav-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:7;a:4:{s:4:\"name\";s:17:\"animated-headline\";s:5:\"title\";s:17:\"Animated Headline\";s:4:\"icon\";s:23:\"eicon-animated-headline\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:8;a:4:{s:4:\"name\";s:10:\"price-list\";s:5:\"title\";s:10:\"Price List\";s:4:\"icon\";s:16:\"eicon-price-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:9;a:4:{s:4:\"name\";s:11:\"price-table\";s:5:\"title\";s:11:\"Price Table\";s:4:\"icon\";s:17:\"eicon-price-table\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:10;a:4:{s:4:\"name\";s:8:\"flip-box\";s:5:\"title\";s:8:\"Flip Box\";s:4:\"icon\";s:14:\"eicon-flip-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:11;a:4:{s:4:\"name\";s:14:\"call-to-action\";s:5:\"title\";s:14:\"Call to Action\";s:4:\"icon\";s:20:\"eicon-image-rollover\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:12;a:4:{s:4:\"name\";s:14:\"media-carousel\";s:5:\"title\";s:14:\"Media Carousel\";s:4:\"icon\";s:20:\"eicon-media-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:13;a:4:{s:4:\"name\";s:20:\"testimonial-carousel\";s:5:\"title\";s:20:\"Testimonial Carousel\";s:4:\"icon\";s:26:\"eicon-testimonial-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:14;a:4:{s:4:\"name\";s:7:\"reviews\";s:5:\"title\";s:7:\"Reviews\";s:4:\"icon\";s:12:\"eicon-review\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:15;a:4:{s:4:\"name\";s:17:\"table-of-contents\";s:5:\"title\";s:17:\"Table of Contents\";s:4:\"icon\";s:23:\"eicon-table-of-contents\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:16;a:4:{s:4:\"name\";s:9:\"countdown\";s:5:\"title\";s:9:\"Countdown\";s:4:\"icon\";s:15:\"eicon-countdown\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:17;a:4:{s:4:\"name\";s:13:\"share-buttons\";s:5:\"title\";s:13:\"Share Buttons\";s:4:\"icon\";s:11:\"eicon-share\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:18;a:4:{s:4:\"name\";s:11:\"search-form\";s:5:\"title\";s:11:\"Search Form\";s:4:\"icon\";s:17:\"eicon-site-search\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:19;a:4:{s:4:\"name\";s:10:\"author-box\";s:5:\"title\";s:10:\"Author Box\";s:4:\"icon\";s:12:\"eicon-person\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:20;a:4:{s:4:\"name\";s:13:\"post-comments\";s:5:\"title\";s:13:\"Post Comments\";s:4:\"icon\";s:14:\"eicon-comments\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:21;a:4:{s:4:\"name\";s:15:\"post-navigation\";s:5:\"title\";s:15:\"Post Navigation\";s:4:\"icon\";s:21:\"eicon-post-navigation\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:22;a:4:{s:4:\"name\";s:9:\"post-info\";s:5:\"title\";s:9:\"Post Info\";s:4:\"icon\";s:15:\"eicon-post-info\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:23;a:4:{s:4:\"name\";s:7:\"sitemap\";s:5:\"title\";s:7:\"Sitemap\";s:4:\"icon\";s:13:\"eicon-sitemap\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:24;a:4:{s:4:\"name\";s:11:\"breadcrumbs\";s:5:\"title\";s:11:\"Breadcrumbs\";s:4:\"icon\";s:11:\"eicon-yoast\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:25;a:4:{s:4:\"name\";s:10:\"blockquote\";s:5:\"title\";s:10:\"Blockquote\";s:4:\"icon\";s:16:\"eicon-blockquote\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:26;a:4:{s:4:\"name\";s:19:\"wc-archive-products\";s:5:\"title\";s:16:\"Archive Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:27;a:4:{s:4:\"name\";s:31:\"woocommerce-archive-description\";s:5:\"title\";s:19:\"Archive Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:28;a:4:{s:4:\"name\";s:20:\"woocommerce-products\";s:5:\"title\";s:8:\"Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:29;a:4:{s:4:\"name\";s:22:\"woocommerce-breadcrumb\";s:5:\"title\";s:23:\"WooCommerce Breadcrumbs\";s:4:\"icon\";s:25:\"eicon-product-breadcrumbs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:30;a:4:{s:4:\"name\";s:14:\"wc-add-to-cart\";s:5:\"title\";s:18:\"Custom Add To Cart\";s:4:\"icon\";s:17:\"eicon-woocommerce\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:31;a:4:{s:4:\"name\";s:11:\"wc-elements\";s:5:\"title\";s:17:\"WooCommerce Pages\";s:4:\"icon\";s:19:\"eicon-product-pages\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:32;a:4:{s:4:\"name\";s:13:\"wc-categories\";s:5:\"title\";s:18:\"Product Categories\";s:4:\"icon\";s:24:\"eicon-product-categories\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:33;a:4:{s:4:\"name\";s:21:\"woocommerce-menu-cart\";s:5:\"title\";s:9:\"Menu Cart\";s:4:\"icon\";s:10:\"eicon-cart\";s:10:\"categories\";s:41:\"[\"theme-elements\",\"woocommerce-elements\"]\";}i:34;a:4:{s:4:\"name\";s:25:\"woocommerce-product-title\";s:5:\"title\";s:13:\"Product Title\";s:4:\"icon\";s:19:\"eicon-product-title\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:35;a:4:{s:4:\"name\";s:26:\"woocommerce-product-images\";s:5:\"title\";s:14:\"Product Images\";s:4:\"icon\";s:20:\"eicon-product-images\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:36;a:4:{s:4:\"name\";s:25:\"woocommerce-product-price\";s:5:\"title\";s:13:\"Product Price\";s:4:\"icon\";s:19:\"eicon-product-price\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:37;a:4:{s:4:\"name\";s:31:\"woocommerce-product-add-to-cart\";s:5:\"title\";s:11:\"Add To Cart\";s:4:\"icon\";s:25:\"eicon-product-add-to-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:38;a:4:{s:4:\"name\";s:26:\"woocommerce-product-rating\";s:5:\"title\";s:14:\"Product Rating\";s:4:\"icon\";s:20:\"eicon-product-rating\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:39;a:4:{s:4:\"name\";s:25:\"woocommerce-product-stock\";s:5:\"title\";s:13:\"Product Stock\";s:4:\"icon\";s:19:\"eicon-product-stock\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:40;a:4:{s:4:\"name\";s:24:\"woocommerce-product-meta\";s:5:\"title\";s:12:\"Product Meta\";s:4:\"icon\";s:18:\"eicon-product-meta\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:41;a:4:{s:4:\"name\";s:37:\"woocommerce-product-short-description\";s:5:\"title\";s:17:\"Short Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:42;a:4:{s:4:\"name\";s:29:\"woocommerce-product-data-tabs\";s:5:\"title\";s:17:\"Product Data Tabs\";s:4:\"icon\";s:18:\"eicon-product-tabs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:43;a:4:{s:4:\"name\";s:42:\"woocommerce-product-additional-information\";s:5:\"title\";s:22:\"Additional Information\";s:4:\"icon\";s:19:\" eicon-product-info\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:44;a:4:{s:4:\"name\";s:27:\"woocommerce-product-related\";s:5:\"title\";s:15:\"Product Related\";s:4:\"icon\";s:21:\"eicon-product-related\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:45;a:4:{s:4:\"name\";s:26:\"woocommerce-product-upsell\";s:5:\"title\";s:7:\"Upsells\";s:4:\"icon\";s:20:\"eicon-product-upsell\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:46;a:4:{s:4:\"name\";s:15:\"facebook-button\";s:5:\"title\";s:15:\"Facebook Button\";s:4:\"icon\";s:23:\"eicon-facebook-like-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:47;a:4:{s:4:\"name\";s:17:\"facebook-comments\";s:5:\"title\";s:17:\"Facebook Comments\";s:4:\"icon\";s:23:\"eicon-facebook-comments\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:48;a:4:{s:4:\"name\";s:14:\"facebook-embed\";s:5:\"title\";s:14:\"Facebook Embed\";s:4:\"icon\";s:14:\"eicon-fb-embed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:49;a:4:{s:4:\"name\";s:13:\"facebook-page\";s:5:\"title\";s:13:\"Facebook Page\";s:4:\"icon\";s:13:\"eicon-fb-feed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:50;a:4:{s:4:\"name\";s:8:\"template\";s:5:\"title\";s:8:\"Template\";s:4:\"icon\";s:19:\"eicon-document-file\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:51;a:4:{s:4:\"name\";s:15:\"theme-site-logo\";s:5:\"title\";s:9:\"Site Logo\";s:4:\"icon\";s:15:\"eicon-site-logo\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:52;a:4:{s:4:\"name\";s:16:\"theme-site-title\";s:5:\"title\";s:10:\"Site Title\";s:4:\"icon\";s:16:\"eicon-site-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:53;a:4:{s:4:\"name\";s:16:\"theme-page-title\";s:5:\"title\";s:10:\"Page Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:54;a:4:{s:4:\"name\";s:16:\"theme-post-title\";s:5:\"title\";s:10:\"Post Title\";s:4:\"icon\";s:16:\"eicon-post-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:55;a:4:{s:4:\"name\";s:18:\"theme-post-excerpt\";s:5:\"title\";s:12:\"Post Excerpt\";s:4:\"icon\";s:18:\"eicon-post-excerpt\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:56;a:4:{s:4:\"name\";s:25:\"theme-post-featured-image\";s:5:\"title\";s:14:\"Featured Image\";s:4:\"icon\";s:20:\"eicon-featured-image\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:57;a:4:{s:4:\"name\";s:19:\"theme-archive-title\";s:5:\"title\";s:13:\"Archive Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:58;a:4:{s:4:\"name\";s:13:\"archive-posts\";s:5:\"title\";s:13:\"Archive Posts\";s:4:\"icon\";s:19:\"eicon-archive-posts\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:11:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"3.0.0\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.0.0.zip\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:3:\"5.4\";s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"conditions\";a:1:{i:0;a:1:{i:0;a:3:{s:4:\"type\";s:8:\"language\";s:9:\"languages\";a:26:{i:0;s:5:\"he_IL\";i:1;s:5:\"en_GB\";i:2;s:5:\"en_NZ\";i:3;s:5:\"en_ZA\";i:4;s:5:\"en_AU\";i:5;s:5:\"en_CA\";i:6;s:5:\"sv_SE\";i:7;s:5:\"da_DK\";i:8;s:5:\"fr_FR\";i:9;s:5:\"nl_NL\";i:10;s:5:\"nb_NO\";i:11;s:5:\"de_AT\";i:12;s:2:\"fi\";i:13;s:5:\"it_IT\";i:14;s:5:\"nn_NO\";i:15;s:5:\"de_CH\";i:16;s:5:\"en_GB\";i:17;s:5:\"is_IS\";i:18;s:2:\"ga\";i:19;s:5:\"fr_BE\";i:20;s:5:\"nl_BE\";i:21;s:3:\"ast\";i:22;s:5:\"lb_LU\";i:23;s:5:\"es_ES\";i:24;s:5:\"pt_PT\";i:25;s:3:\"mlt\";}s:8:\"operator\";s:2:\"in\";}}}}}',	'no'),
(1226,	'auto_core_update_notified',	'a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:26:\"shai@snapirswimming.org.il\";s:7:\"version\";s:5:\"5.5.3\";s:9:\"timestamp\";i:1604106420;}',	'no'),
(187,	'finished_updating_comment_type',	'1',	'yes'),
(143,	'can_compress_scripts',	'1',	'no'),
(2229,	'theme_mods_atlanta',	'a:2:{s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1599716015;s:4:\"data\";a:6:{s:19:\"wp_inactive_widgets\";a:0:{}s:17:\"pojo-main-sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:18:\"pojo-top-bar-right\";a:0:{}s:17:\"pojo-top-bar-left\";a:0:{}s:19:\"pojo-outer-slidebar\";a:0:{}s:11:\"pojo-footer\";a:0:{}}}}',	'yes'),
(7518,	'_transient_timeout_feed_mod_e0061ca2fa5b884e483872aa34d3e7eb',	'1604294489',	'no'),
(7519,	'_transient_feed_mod_e0061ca2fa5b884e483872aa34d3e7eb',	'1604251289',	'no'),
(7520,	'_transient_timeout_updraftplus_dashboard_news',	'1604294489',	'no'),
(7521,	'_transient_updraftplus_dashboard_news',	'<div class=\"rss-widget\"><ul><li class=\"updraftplus_dashboard_news_item\"><a href=\"https://snapir-swim.co.il/wp-admin/\" class=\"dashicons dashicons-no-alt\" title=\"Dismiss all UpdraftPlus news\" onClick=\"updraftplus_dismiss_dashboard_news(); return false;\" style=\"float: right; box-shadow: none; margin-left: 5px;\"></a><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/UpdraftPlus/~3/h3KIeKVYYms/\'>UpdraftPlus: How to backup your WordPress database in 2020</a></li><li class=\"updraftplus_dashboard_news_item\"><a href=\"https://snapir-swim.co.il/wp-admin/\" class=\"dashicons dashicons-no-alt\" title=\"Dismiss all UpdraftPlus news\" onClick=\"updraftplus_dismiss_dashboard_news(); return false;\" style=\"float: right; box-shadow: none; margin-left: 5px;\"></a><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/UpdraftPlus/~3/28VCH-Wa9Ok/\'>UpdraftPlus: UpdraftPlus 1.16.30 Update Released</a></li></ul></div>',	'no'),
(7522,	'_transient_timeout_dash_v2_79d416175c23891a9c8cd6a8c75caced',	'1604294489',	'no'),
(7523,	'_transient_dash_v2_79d416175c23891a9c8cd6a8c75caced',	'<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://he.wordpress.org/2020/08/11/%D7%95%D7%95%D7%A8%D7%93%D7%A4%D7%A8%D7%A1-5-5-%D7%91%D7%A2%D7%91%D7%A8%D7%99%D7%AA/\'>וורדפרס 5.5 בעברית</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/wordpress-auto-update-system-misfires-updating-live-sites-to-an-alpha-release?utm_source=rss&#038;utm_medium=rss&#038;utm_campaign=wordpress-auto-update-system-misfires-updating-live-sites-to-an-alpha-release\'>WPTavern: WordPress Auto-Update System Misfires, Updating Live Sites to an Alpha Release</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/twenty-twenty-one-blocks-theme-launching-as-a-separate-project?utm_source=rss&#038;utm_medium=rss&#038;utm_campaign=twenty-twenty-one-blocks-theme-launching-as-a-separate-project\'>WPTavern: Twenty Twenty-One Blocks Theme Launching as a Separate Project</a></li><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2020/10/wordpress-5-5-3-maintenance-release/\'>WordPress.org blog: WordPress 5.5.3 Maintenance Release</a></li></ul></div>',	'no'),
(7525,	'_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a',	'1604262149',	'no'),
(7526,	'_site_transient_poptags_40cd750bba9870f18aada2478b24840a',	'O:8:\"stdClass\":100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4726;}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:4454;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2689;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2565;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:1979;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:1832;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1812;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1492;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1492;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1491;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1461;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:1461;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1448;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1306;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1226;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1209;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1170;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1136;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1109;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1020;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:907;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:906;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:883;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:882;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:827;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:804;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:796;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:783;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:782;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:756;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:753;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:726;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:721;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:707;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:703;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:689;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:666;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:663;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:658;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:653;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:637;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:636;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:616;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:616;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:593;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:587;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:583;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:579;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:577;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:562;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:560;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:557;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:554;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:552;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:542;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:541;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:533;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:533;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:524;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:522;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:522;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:507;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:496;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:493;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:486;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:483;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:479;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:466;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:459;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:443;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:443;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:441;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:440;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:439;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:435;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:433;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:427;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:427;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:424;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:422;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:419;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:413;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:405;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:400;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:397;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:394;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:390;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:387;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:385;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:379;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:379;}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";i:379;}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";i:373;}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";i:365;}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";i:361;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:359;}s:16:\"google-analytics\";a:3:{s:4:\"name\";s:16:\"google analytics\";s:4:\"slug\";s:16:\"google-analytics\";s:5:\"count\";i:350;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:346;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:345;}s:16:\"custom-post-type\";a:3:{s:4:\"name\";s:16:\"custom post type\";s:4:\"slug\";s:16:\"custom-post-type\";s:5:\"count\";i:339;}}',	'no'),
(5548,	'updraft_lastmessage',	'The backup apparently succeeded and is now complete (אוק 11 15:03:47)',	'yes'),
(5549,	'updraftplus_locked_fd',	'1',	'no'),
(5550,	'updraftplus_last_lock_time_fd',	'2020-10-11 14:56:23',	'no'),
(5551,	'updraftplus_semaphore_fd',	'1',	'no'),
(5552,	'updraft_last_scheduled_fd',	'1602428309',	'yes'),
(5561,	'updraft_backup_history',	'a:1:{i:1602428183;a:19:{s:7:\"plugins\";a:1:{i:0;s:62:\"backup_2020-10-11-1456_snapirswimcoil_07c5c7939db5-plugins.zip\";}s:12:\"plugins-size\";i:29819668;s:6:\"themes\";a:1:{i:0;s:61:\"backup_2020-10-11-1456_snapirswimcoil_07c5c7939db5-themes.zip\";}s:11:\"themes-size\";i:4221904;s:7:\"uploads\";a:1:{i:0;s:62:\"backup_2020-10-11-1456_snapirswimcoil_07c5c7939db5-uploads.zip\";}s:12:\"uploads-size\";i:4777921;s:6:\"others\";a:1:{i:0;s:61:\"backup_2020-10-11-1456_snapirswimcoil_07c5c7939db5-others.zip\";}s:11:\"others-size\";i:1575808;s:2:\"db\";s:56:\"backup_2020-10-11-1456_snapirswimcoil_07c5c7939db5-db.gz\";s:7:\"db-size\";i:365406;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"17ff2c7480095ce0c5db18eed80d15e8c6cc9b9d\";s:7:\"themes0\";s:40:\"5356d6a676de263a2334d48bf9563d648a787bce\";s:8:\"uploads0\";s:40:\"4170ff5cb01046cd27a9ce7d7648802094d0d966\";s:7:\"others0\";s:40:\"7be847365f5cecbf8090bb5d4dc47cc73849faa8\";s:3:\"db0\";s:40:\"d4ccfbd7d886e98b7c11169837e2fe587c0a0a4d\";}s:6:\"sha256\";a:5:{s:8:\"plugins0\";s:64:\"c8c84764273a4f7ec57afdc1cc1916638501b263de04eaeb7e003da4985a960b\";s:7:\"themes0\";s:64:\"46d218b93c143f84723359bf76830e1b894db8ba2b2875e48210bf0d9f6bc188\";s:8:\"uploads0\";s:64:\"3ccd69ea57f859b760f93ad1d8822d8edf36f65c7380df0777f4f4c8c24a160e\";s:7:\"others0\";s:64:\"7e8304b584abc746597cc8641288ac15896c924ab95a4fd588b8921914abc351\";s:3:\"db0\";s:64:\"3ff16ed05cfce95197d009d31d8f3583590400c70b8a60499ca6b4c22fc253dc\";}}s:5:\"nonce\";s:12:\"07c5c7939db5\";s:7:\"service\";a:1:{i:0;s:11:\"googledrive\";}s:20:\"service_instance_ids\";a:1:{s:11:\"googledrive\";a:1:{i:0;s:34:\"s-23f6db14e25fb1ca2a26e54f941fa828\";}}s:11:\"always_keep\";b:1;s:19:\"files_enumerated_at\";a:4:{s:7:\"plugins\";i:1602428489;s:6:\"themes\";i:1602428552;s:7:\"uploads\";i:1602428571;s:6:\"others\";i:1602428580;}s:18:\"created_by_version\";s:7:\"1.16.29\";s:21:\"last_saved_by_version\";s:7:\"1.16.29\";s:12:\"is_multisite\";b:0;}}',	'no'),
(5562,	'updraft_last_backup',	'a:5:{s:11:\"backup_time\";i:1602428183;s:12:\"backup_array\";a:11:{s:7:\"plugins\";a:1:{i:0;s:62:\"backup_2020-10-11-1456_snapirswimcoil_07c5c7939db5-plugins.zip\";}s:12:\"plugins-size\";i:29819668;s:6:\"themes\";a:1:{i:0;s:61:\"backup_2020-10-11-1456_snapirswimcoil_07c5c7939db5-themes.zip\";}s:11:\"themes-size\";i:4221904;s:7:\"uploads\";a:1:{i:0;s:62:\"backup_2020-10-11-1456_snapirswimcoil_07c5c7939db5-uploads.zip\";}s:12:\"uploads-size\";i:4777921;s:6:\"others\";a:1:{i:0;s:61:\"backup_2020-10-11-1456_snapirswimcoil_07c5c7939db5-others.zip\";}s:11:\"others-size\";i:1575808;s:2:\"db\";s:56:\"backup_2020-10-11-1456_snapirswimcoil_07c5c7939db5-db.gz\";s:7:\"db-size\";i:365406;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"17ff2c7480095ce0c5db18eed80d15e8c6cc9b9d\";s:7:\"themes0\";s:40:\"5356d6a676de263a2334d48bf9563d648a787bce\";s:8:\"uploads0\";s:40:\"4170ff5cb01046cd27a9ce7d7648802094d0d966\";s:7:\"others0\";s:40:\"7be847365f5cecbf8090bb5d4dc47cc73849faa8\";s:3:\"db0\";s:40:\"d4ccfbd7d886e98b7c11169837e2fe587c0a0a4d\";}s:6:\"sha256\";a:5:{s:8:\"plugins0\";s:64:\"c8c84764273a4f7ec57afdc1cc1916638501b263de04eaeb7e003da4985a960b\";s:7:\"themes0\";s:64:\"46d218b93c143f84723359bf76830e1b894db8ba2b2875e48210bf0d9f6bc188\";s:8:\"uploads0\";s:64:\"3ccd69ea57f859b760f93ad1d8822d8edf36f65c7380df0777f4f4c8c24a160e\";s:7:\"others0\";s:64:\"7e8304b584abc746597cc8641288ac15896c924ab95a4fd588b8921914abc351\";s:3:\"db0\";s:64:\"3ff16ed05cfce95197d009d31d8f3583590400c70b8a60499ca6b4c22fc253dc\";}}}s:7:\"success\";i:1;s:6:\"errors\";a:0:{}s:12:\"backup_nonce\";s:12:\"07c5c7939db5\";}',	'yes'),
(2354,	'elementor_rollback',	'',	'yes'),
(2355,	'elementor_rollback_pro_separator',	'',	'yes'),
(2356,	'elementor_rollback_pro',	'',	'yes'),
(2357,	'elementor_re_migrate_globals_separator',	'',	'yes'),
(2358,	'elementor_re_migrate_globals',	'',	'yes'),
(2359,	'elementor_beta',	'no',	'yes'),
(2360,	'elementor_maintenance_mode_mode',	'',	'yes'),
(2361,	'elementor_maintenance_mode_exclude_mode',	'logged_in',	'yes'),
(2362,	'elementor_maintenance_mode_exclude_roles',	'a:0:{}',	'yes'),
(2363,	'elementor_maintenance_mode_template_id',	'',	'yes'),
(2366,	'_elementor_global_css',	'a:7:{s:4:\"time\";i:1599755137;s:5:\"fonts\";a:0:{}s:5:\"icons\";a:0:{}s:20:\"dynamic_elements_ids\";a:0:{}s:6:\"status\";s:5:\"empty\";i:0;b:0;s:3:\"css\";s:0:\"\";}',	'yes'),
(7425,	'_site_transient_timeout_jet_dashboard_license_expire_check',	'1604258122',	'no'),
(7426,	'_site_transient_jet_dashboard_license_expire_check',	'true',	'no'),
(5041,	'_transient_timeout_wc_low_stock_count',	'1604751467',	'no'),
(5042,	'_transient_wc_low_stock_count',	'0',	'no'),
(5043,	'_transient_timeout_wc_outofstock_count',	'1604751467',	'no'),
(5044,	'_transient_wc_outofstock_count',	'0',	'no'),
(332,	'elementor_pro_theme_builder_conditions',	'a:4:{s:7:\"archive\";a:1:{i:147;a:1:{i:0;s:23:\"include/product_archive\";}}s:6:\"single\";a:2:{i:141;a:1:{i:0;s:15:\"include/product\";}i:124;a:1:{i:0;s:21:\"include/singular/post\";}}s:6:\"footer\";a:1:{i:88;a:1:{i:0;s:15:\"include/general\";}}s:6:\"header\";a:1:{i:43;a:1:{i:0;s:15:\"include/general\";}}}',	'yes'),
(335,	'nav_menu_options',	'a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}',	'yes'),
(7514,	'_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9',	'1604294489',	'no'),
(7515,	'_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9',	'1604251289',	'no'),
(7516,	'_transient_timeout_feed_e0061ca2fa5b884e483872aa34d3e7eb',	'1604294489',	'no'),
(7517,	'_transient_feed_e0061ca2fa5b884e483872aa34d3e7eb',	'a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"UpdraftPlus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"https://updraftplus.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WordPress\'s leading backup plugin - backup, restore and clone WordPress sites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 Oct 2020 10:52:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wordpress.org/?v=5.4.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:88:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"How to backup your WordPress database in 2020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://feedproxy.google.com/~r/UpdraftPlus/~3/h3KIeKVYYms/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://updraftplus.com/how-to-backup-your-wordpress-database-in-2020/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 Oct 2020 10:52:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:15:\"Tips and tricks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:4:\"2020\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:6:\"Backup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"database\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:11:\"UpdraftPlus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:9:\"wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://updraftplus.com/?p=683923\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:760:\"<p>Your WordPress database contains all kinds of vital data. Firstly, all of your content is in there, such as pages, blog posts, and comments. But it goes much deeper than that. The WordPress database contains critical information, including theme settings, &#8230; <a href=\"https://updraftplus.com/how-to-backup-your-wordpress-database-in-2020/\">Continue reading <span class=\"meta-nav\">&#8594;</span></a></p>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/how-to-backup-your-wordpress-database-in-2020/\">How to backup your WordPress database in 2020</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Gina Lucia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:16477:\"<p><span style=\"font-weight: 400;\">Your WordPress database contains all kinds of vital data. Firstly, all of your content is in there, such as pages, blog posts, and comments. But it goes much deeper than that. The WordPress database contains critical information, including theme settings, plugin settings and much more.  </span></p>\n<p><span style=\"font-weight: 400;\">The problem is that, on its own, WordPress will not save all of the critical information stored within the database. That means if something goes wrong, such as your website being hacked, you’ll be unable to restore your WordPress site to its previous state.  </span></p>\n<p><span style=\"font-weight: 400;\">There’s good news though, it’s not difficult to backup your WordPress database with a little help. </span></p>\n<p><span style=\"font-weight: 400;\">So,</span><b> by the end of this article, you’ll know exactly how to backup your WordPress database</b><span style=\"font-weight: 400;\">. The best part? You’ll be able to do it in 4 steps with the WordPress backup plugin, UpdraftPlus.</span></p>\n<h2><span style=\"font-weight: 400;\">Why you should backup your WordPress database</span></h2>\n<p><span style=\"font-weight: 400;\">As a website owner, you should always plan for the unexpected. A malware attack or a website update gone horribly wrong could leave you having to </span><a href=\"https://updraftplus.com/how-to-restore-your-wordpress-site-to-a-previous-date/\"><span style=\"font-weight: 400;\">restore your website to a previous date</span></a><span style=\"font-weight: 400;\">. </span></p>\n<p><span style=\"font-weight: 400;\">Your site’s database contains a treasure trove of data that reaches far beyond your theme or plugin settings. </span></p>\n<p><b>It contains vital data such as:</b></p>\n<ul>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">User logins and passwords. </span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Widget configurations.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Website customisations.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">And a range of other site-wide settings. </span></li>\n</ul>\n<p><span style=\"font-weight: 400;\">If these aren’t backed up correctly, you could lose them all in an instant. Can you imagine losing every page, post, and link you’ve ever created? For most, a permanent loss of data on this scale doesn’t bear thinking about.   </span></p>\n<p><span style=\"font-weight: 400;\">Fortunately, with the help of </span><a href=\"https://updraftplus.com/\"><span style=\"font-weight: 400;\">UpdraftPlus</span></a><span style=\"font-weight: 400;\">, you’ll never have to fear losing critical data from your WordPress database ever again.  </span></p>\n<p><iframe title=\"Intro Video - Full\" src=\"https://player.vimeo.com/video/154870690?dnt=1&amp;app_id=122963\" width=\"1080\" height=\"608\" frameborder=\"0\" allow=\"autoplay; fullscreen\" allowfullscreen></iframe></p>\n<h2><span style=\"font-weight: 400;\">How UpdraftPlus works</span></h2>\n<p><span style=\"font-weight: 400;\">UpdraftPlus backs up everything you could possibly need to restore your site to its previous settings in the event of your site being compromised. With this free plugin, you can restore your website with the click of a mouse. </span></p>\n<p><span style=\"font-weight: 400;\">UpdraftPlus allows you to achieve this outcome by backing up all WordPress data contained within the database, including: </span></p>\n<ul>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Content files including pages and blog posts.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Comments data and metadata.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">All links.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Plugin settings.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Theme settings.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">User account data.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">WordPress site-wide settings and customisations.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">All media/upload records.</span></li>\n</ul>\n<p><a href=\"https://updraftplus.com/shop/updraftplus-premium/\"><span style=\"font-weight: 400;\">UpdraftPlus Premium</span></a><span style=\"font-weight: 400;\"> takes this a step further, you can backup unlimited WordPress and non-WordPress files. These can be saved to more than one cloud storage locations for a more thorough and secure backup. </span></p>\n<p><span style=\"font-weight: 400;\">You can also take advantage of the </span><a href=\"https://updraftplus.com/updraftvault/\"><span style=\"font-weight: 400;\">UpdraftPlus Vault</span></a><span style=\"font-weight: 400;\">, which, as part of the UpdraftPlus plug, backs up your data at predetermined intervals and is encrypted for an additional layer of security. </span></p>\n<p><span style=\"font-weight: 400;\">Now we’ve covered how the plugin works, let’s show you how to backup your WordPress database.</span></p>\n<h2><span style=\"font-weight: 400;\">How to backup your WordPress database</span></h2>\n<p><b>To backup your WordPress database, you’ll need to:</b></p>\n<ol>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Install the WordPress backup plugin, </span><a href=\"https://wordpress.org/plugins/updraftplus/\"><span style=\"font-weight: 400;\">UpdraftPlus</span></a><span style=\"font-weight: 400;\">.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Adjust your database backup settings.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Select where you’d like your backups to be stored.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Backup your WordPress root database.</span></li>\n</ol>\n<p><span style=\"font-weight: 400;\">That’s it. Below, we’ll outline these steps in detail so that you can backup your WordPress database and have greater peace of mind. </span></p>\n<p><span style=\"font-weight: 400;\">Let’s make a start with step one, installing UpdraftPlus.</span></p>\n<p><img src=\"https://lh6.googleusercontent.com/tthnRXPibokfWcVATUNhu-bSG1cVaLLTrOU_IRk11V6_kJVQu28_uyzRdqYsJnP857YT4uWuIB6fRWgd7y-wd6xFIEe0WeXY51uhN5VP7ySuQpJ4cDpAKtDbzQXvY3ZpguuP9TNn\" /></p>\n<h3><span style=\"font-weight: 400;\">Step #1: Install UpdraftPlus</span></h3>\n<p><span style=\"font-weight: 400;\">The process of backing up your WordPress database starts with installing </span><a href=\"https://updraftplus.com/\"><span style=\"font-weight: 400;\">UpdraftPlus</span></a><span style=\"font-weight: 400;\">. Fortunately, this is a process that only takes a couple of minutes. The process is much the same as any other WordPress plugin. </span></p>\n<p><b>To install UpdraftPlus, take the following steps: </b></p>\n<p><span style=\"font-weight: 400;\">1. In your WordPress dashboard, navigate to </span><b>Plugins </b><span style=\"font-weight: 400;\">&gt;</span><b> Add New</b><span style=\"font-weight: 400;\">. </span></p>\n<p><img src=\"https://lh6.googleusercontent.com/JFByLUY8YeynIRerfSPBCegXCOWjaJJOzAGMYsJgqgIgyEnKDNETCXSm7obZ2j1lDWSNltJwvYRyY7yVrbKMweQQnhv_EVQLguiLV_VHM1952CvkcxeSJCySeihrWQAy0SadEOjc\" /></p>\n<p><span style=\"font-weight: 400;\">2. In the search bar, type </span><b>UpdraftPlus</b><span style=\"font-weight: 400;\">. </span></p>\n<p><img src=\"https://lh3.googleusercontent.com/TadrIX5L4G31lggnUH7jaqVp03HqUn2hChrjsGecYihyXU1vIoEVwwakrbuuU2zNqddOqZx3Ww7co4feyWQInzD21BdZ8PDYqp4ilQvd\" /></p>\n<p><span style=\"font-weight: 400;\">3. Find the </span><b>UpdraftPlus WordPress Backup Plugin</b><span style=\"font-weight: 400;\"> within the search results and then press </span><b>Install Now</b><span style=\"font-weight: 400;\">. </span></p>\n<p><img src=\"https://lh6.googleusercontent.com/sJd_51vYR-vmfnWMBKoy3CwQk4IDBPINDcBJodhw0uiUo_IL99ZQZi9-glKKpMtUyeK2ycS5W3VssJ8oneAMnlxDE9JNLhrtsgG1D8iZc5t6pay6vyrqDFGj_8Go-NCf28-Dk7wN\" /></p>\n<p><span style=\"font-weight: 400;\">4. Once installed, click </span><b>Activate</b><span style=\"font-weight: 400;\">.</span></p>\n<p><span style=\"font-weight: 400;\">Now that we have UpdraftPlus installed, we can move onto creating a backup of your WordPress database.</span></p>\n<h3><span style=\"font-weight: 400;\">Step #2: Adjust your database backup settings</span></h3>\n<p><span style=\"font-weight: 400;\">Once installed, you need to adjust your database backup settings before performing your first backup. </span></p>\n<ol>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Navigate from the WordPress dashboard to </span><b>Settings</b><span style=\"font-weight: 400;\"> &gt;</span><b> UpdraftPlus Backups</b><span style=\"font-weight: 400;\">. This will open your UpdraftPlus settings page.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Next, select the </span><b>Settings</b><span style=\"font-weight: 400;\"> tab from the choices at the top. </span></li>\n</ol>\n<p><span style=\"font-weight: 400;\">Here, you’ll be offered several options concerning how often you would like UpdraftPlus to make a backup of your WordPress website. </span></p>\n<p><span style=\"font-weight: 400;\">If you’re in charge of a sizable website with new posts and pages created each day, then the incremental options of 2, 4, 8, or 12-hourly backups may suit you best. </span></p>\n<p><img src=\"https://lh5.googleusercontent.com/P1t-F4oTGQb_oc2q9uIt7uIbawKtxuTmFGF4oyzlJDTphcj73zra1XJu3rz_0ezlc7xDhh6qDn-hho-LduTmJM0EtSNjleFnsrwutJdp_l-TGYbhEuFTktWgyvgBV7pNhuZxJzsf\" /></p>\n<p><span style=\"font-weight: 400;\">Alternatively, should you operate a smaller site that doesn’t need to be backed up as frequently. You can configure UpdraftPlus to backup daily, weekly, fortnightly, or monthly.   </span></p>\n<p><span style=\"font-weight: 400;\">You also have the opportunity to determine how many of these backups should be stored at any one time. Subsequent backups will override the existing ones. UpdraftPlus also allows you to schedule backup files and databases separately or together.</span></p>\n<h3><span style=\"font-weight: 400;\">Step #3: Select where you’d like your backups to be stored</span></h3>\n<p><span style=\"font-weight: 400;\">If you scroll down the page a little further, you’ll notice you’re given the option of where you’d like your file backups to be stored. There are numerous options here. Including leading providers of cloud-based storage such as Dropbox, Amazon S3, and Google Drive. </span></p>\n<p><img src=\"https://lh4.googleusercontent.com/6ebze5NubsKy20KUcdAt7nHE4-7bF8STEsam_dEiDYKjEMmvv4cWLvQTPlgbWy43UqBLCwK_YHsYIODUSMKFnrJVYZcxl5S3lfP4QTurgcHw2pAsm9jcpm9opWnuXibRTdAu7Bh9\" /></p>\n<p><b><i>Top tip:</i></b><i><span style=\"font-weight: 400;\"> If you’d like to store your backups remotely, </span></i><a href=\"https://updraftplus.com/shop/updraftplus-premium/\"><i><span style=\"font-weight: 400;\">UpdraftPlus Premium</span></i></a><i><span style=\"font-weight: 400;\"> comes with a free 1GB of storage using UpdraftVault for 1 year.</span></i></p>\n<p><b>Once selected, follow the on-screen instructions. </b></p>\n<p><span style=\"font-weight: 400;\">Each storage option comes complete with its own set of instructions for setting up. Once you have completed those instructions, select which files you want to include within the backup and press the blue </span><b>Save Changes</b><span style=\"font-weight: 400;\"> button positioned at the bottom of the page.</span></p>\n<p><b>If you upgrade to </b><a href=\"https://updraftplus.com/shop/updraftplus-premium/\"><b>Updraft Premium</b></a><b>, you can choose to spread your backups across multiple storage locations.</b><span style=\"font-weight: 400;\"> Alternatively, you can purchase the </span><a href=\"https://updraftplus.com/shop/morestorage/\"><span style=\"font-weight: 400;\">Multiple Storage Destinations Add-On</span></a><span style=\"font-weight: 400;\"> on its own.</span></p>\n<h3><span style=\"font-weight: 400;\">Step #4: Backup your WordPress root database</span></h3>\n<p><span style=\"font-weight: 400;\">With the free version of the plugin, UpdraftPlus creates backups of everything in the WordPress content directory, including but not limited to database files, plugins, uploads, themes, and so on. </span></p>\n<p><b>However, if you upgrade to </b><a href=\"https://updraftplus.com/shop/updraftplus-premium/\"><b>UpdraftPlus Premium</b></a><b>, you can perform a complete backup of your WordPress website. </b></p>\n<p><img src=\"https://lh4.googleusercontent.com/Z4H9OJ7tac_p97dLiagEhLntxGOxYvB2cfX6yd4okyjWzRAmSZfBHN-cA3TRh22QocMsZjZrv-X9Vs6dnvN6PViwThhOMW-eMcSafA-Lcs443MP0mVzENWORzpjEVYjrbAFDaXaz\" /></p>\n<p><span style=\"font-weight: 400;\">With Premium, you can back up</span><i><span style=\"font-weight: 400;\"> all</span></i><span style=\"font-weight: 400;\"> files from your WordPress install. This includes files you’ve added in a non-standard way, and you can even backup directories from your web server that aren’t even part of WordPress. </span></p>\n<p><b>All in all, you can take backups of the following: </b></p>\n<ul>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Any modifications you’ve made to the WordPress core. </span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">New files uploaded to WordPress using non-standard mechanisms. </span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Other resources (or even sub-sites) in the same folder as WordPress.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Files from other directories on your server</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Your wp-config.php file, which allows you to avoid re-entering database settings and other customisations upon restoring.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">You can also browse your backups and download individual files from them from within your WordPress dashboard.</span></li>\n</ul>\n<h2><span style=\"font-weight: 400;\">Backup your WordPress database with UpdraftPlus</span></h2>\n<p><span style=\"font-weight: 400;\">That’s it, you now have a secure backup of your WordPress database with </span><a href=\"https://wordpress.org/plugins/updraftplus/\"><span style=\"font-weight: 400;\">UpdraftPlus</span></a><span style=\"font-weight: 400;\">. </span></p>\n<p><span style=\"font-weight: 400;\">With this up and running, you’ll be able to create secure backups of crucial data and broader site settings governing your plugins, theme, and user accounts. </span></p>\n<p><span style=\"font-weight: 400;\">Whether your hosting company folds or you’ve performed an update that has ruined your website’s functionality, with UpdraftPlus, you can rest assured that your WordPress website is only a click away from being restored.</span></p>\n<p><span style=\"font-weight: 400;\">With </span><a href=\"https://updraftplus.com/shop/updraftplus-premium/\"><span style=\"font-weight: 400;\">UpdraftPlus Premium</span></a><span style=\"font-weight: 400;\">, you can go one step further. You can take advantage of the included add-ons to:</span></p>\n<ul>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Schedule your backups at specific times of the day to avoid high-traffic periods.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Spread your storage files across multiple locations for enhanced security.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Receive detailed reports of your backups.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Limitless backups of all files, including those not contained within WordPress.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Multi-site network compatibility.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Free, rapid-response support from technical experts.</span></li>\n</ul>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/how-to-backup-your-wordpress-database-in-2020/\">How to backup your WordPress database in 2020</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://updraftplus.com/how-to-backup-your-wordpress-database-in-2020/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://updraftplus.com/how-to-backup-your-wordpress-database-in-2020/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:85:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"UpdraftPlus 1.16.30 Update Released\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://feedproxy.google.com/~r/UpdraftPlus/~3/28VCH-Wa9Ok/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://updraftplus.com/updraftplus-1-16-30-update-released/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Oct 2020 13:43:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:28:\"UpdraftPlus development news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:5:\"Clone\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:6:\"update\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:11:\"UpdraftPlus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://updraftplus.com/?p=683300\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:728:\"<p>The latest updates for UpdraftPlus 1.16.30 update has now been released. This latest version has various performance tweaks and bug fixes to make UpdraftPlus backups better than ever. One of the main performance improvements for the latest update is for &#8230; <a href=\"https://updraftplus.com/updraftplus-1-16-30-update-released/\">Continue reading <span class=\"meta-nav\">&#8594;</span></a></p>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/updraftplus-1-16-30-update-released/\">UpdraftPlus 1.16.30 Update Released</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Wayne Mullins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3719:\"<p><span style=\"font-weight: 400;\">The latest updates for UpdraftPlus 1.16.30 update has now been released. This latest version has various performance tweaks and bug fixes to make UpdraftPlus backups better than ever.</span></p>\n<p><span style=\"font-weight: 400;\">One of the main performance improvements for the latest update is for websites/hosts. Where mysqldump is disabled, UpdraftPlus will now extract database data via the primary key (where one is available). This improvement results in a substantial performance increase when fetching large tables using PHP.</span></p>\n<p><span style=\"font-weight: 400;\">We have also undertaken various fixes when importing settings into UpdraftPlus. These include the fixing of an issue that caused all database tables that were not selected, to be backed up in a &#8220;Backup Now&#8221; backup during a resumption. Additionally some under the hood improvements have been implemented to allow faster booting of UpdraftClones in the future.</span></p>\n<p><span style=\"font-weight: 400;\">The change-log for the latest update is as follows:</span></p>\n<ul>\n<li><span style=\"font-weight: 400;\">PERFORMANCE: Where a table has a numerical primary key, extract its data using that index. This results in a substantial performance increase when fetching large tables using PHP. (The filter updraftplus_can_use_primary_key_default can be used to de-activate this behaviour)</span></li>\n<li><span style=\"font-weight: 400;\">FIX: Remove incorrect decodeURIComponent() parsing when importing settings, which could prevent import of settings containing some special characters</span></li>\n<li><span style=\"font-weight: 400;\">FIX: An issue where database tables that were not selected to be backed up in a &#8220;Backup Now&#8221; backup would get added to the backup during a resumption (i.e. if it did not finish in a single run)</span></li>\n<li><span style=\"font-weight: 400;\">TWEAK: Catch errors from Google Cloud when the bucket is not found</span></li>\n<li><span style=\"font-weight: 400;\">TWEAK: Fix undefined variables instead of expected values in message prior to settings import</span></li>\n<li><span style=\"font-weight: 400;\">TWEAK: Strip the redundant WHERE for the &#8211;where parameter to mysqldump (which modern versions strip out, but a version was found that didn&#8217;t)</span></li>\n<li><span style=\"font-weight: 400;\">TWEAK: Handle hosts that have disabled the session_id() function</span></li>\n<li><span style=\"font-weight: 400;\">TWEAK: Provide SQL mode information in the &#8216;Site Information&#8217; section under the &#8216;Advanced Tools&#8217; tab and in the database backup&#8217;s header</span></li>\n<li><span style=\"font-weight: 400;\">TWEAK: Show a notification of UpdraftPlus plugin updates even if the associated user account is not connected to the UpdraftPlus website</span></li>\n<li><span style=\"font-weight: 400;\">TWEAK: Add mechanism to detect what hosting provider is being used and use it to make UpdraftPlus comply with Kinsta&#8217;s backup limit policies (thus removing it from the list of disallowed plugins)</span></li>\n<li><span style=\"font-weight: 400;\">TWEAK: When booting a clone if it&#8217;s claimed from the clone queue then update the token being used</span></li>\n<li><span style=\"font-weight: 400;\">TWEAK: Tweaked downwards the minimum time in the future for rescheduling a resumption</span></li>\n</ul>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/updraftplus-1-16-30-update-released/\">UpdraftPlus 1.16.30 Update Released</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://updraftplus.com/updraftplus-1-16-30-update-released/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://updraftplus.com/updraftplus-1-16-30-update-released/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:85:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"How to add BackBlaze to your UpdraftPlus account settings\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://feedproxy.google.com/~r/UpdraftPlus/~3/gex-NA2bjTk/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://updraftplus.com/how-to-add-backblaze-to-your-updraftplus-account-settings/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Oct 2020 13:32:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:15:\"Tips and tricks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:16:\"account settings\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:9:\"backblaze\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"how to add\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:5:\"Setup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://updraftplus.com/?p=676796\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:811:\"<p>UpdraftPlus has lots of options when it comes to backing up to a remote storage location.We recently updated the instructional videos for several of the most popular remote storage options, including Azure, RackSpace, Amazon S3, DropBox, Microsoft OneDrive and Microsoft &#8230; <a href=\"https://updraftplus.com/how-to-add-backblaze-to-your-updraftplus-account-settings/\">Continue reading <span class=\"meta-nav\">&#8594;</span></a></p>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/how-to-add-backblaze-to-your-updraftplus-account-settings/\">How to add BackBlaze to your UpdraftPlus account settings</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Wayne Mullins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2444:\"<p><span style=\"font-weight: 400;\">UpdraftPlus has lots of options when it comes to backing up to a remote storage location.We recently updated the instructional videos for several of the most popular remote storage options, including </span><a href=\"https://vimeo.com/460092515\"><span style=\"font-weight: 400;\">Azure</span></a><span style=\"font-weight: 400;\">, </span><a href=\"https://vimeo.com/453658473\"><span style=\"font-weight: 400;\">RackSpace</span></a><span style=\"font-weight: 400;\">, </span><a href=\"https://vimeo.com/448825837\"><span style=\"font-weight: 400;\">Amazon S3</span></a><span style=\"font-weight: 400;\">, </span><a href=\"https://vimeo.com/444181924\"><span style=\"font-weight: 400;\">DropBox</span></a><span style=\"font-weight: 400;\">, </span><a href=\"https://vimeo.com/440012729\"><span style=\"font-weight: 400;\">Microsoft OneDrive</span></a><span style=\"font-weight: 400;\"> and </span><a href=\"https://vimeo.com/429975021\"><span style=\"font-weight: 400;\">Microsoft Cloud</span></a><span style=\"font-weight: 400;\">.    </span></p>\n<p><span style=\"font-weight: 400;\">Our newest instructional update video is for the </span><a href=\"https://www.backblaze.com/\"><span style=\"font-weight: 400;\">BackBlaze</span></a><span style=\"font-weight: 400;\"> remote storage option. You can open a free BackBlaze account today and receive 10GB of free storage. Just watch the short video below for all the information you need on connecting your accounts. </span></p>\n<p><span style=\"font-weight: 400;\">Written instructions on how to add BackBlaze to your UpdraftPlus backup account can also be found </span><a href=\"https://updraftplus.com/support/configuring-backblaze-cloud-storage-access-in-updraftplus/\"><span style=\"font-weight: 400;\">here</span></a><span style=\"font-weight: 400;\">. </span></p>\n<p><iframe title=\"How to add BackBlaze to your UpdraftPlus account settings\" src=\"https://player.vimeo.com/video/465032755?dnt=1&amp;app_id=122963\" width=\"1080\" height=\"608\" frameborder=\"0\" allow=\"autoplay; fullscreen\" allowfullscreen></iframe></p>\n<p>&nbsp;</p>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/how-to-add-backblaze-to-your-updraftplus-account-settings/\">How to add BackBlaze to your UpdraftPlus account settings</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://updraftplus.com/how-to-add-backblaze-to-your-updraftplus-account-settings/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://updraftplus.com/how-to-add-backblaze-to-your-updraftplus-account-settings/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:97:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"Setup Bedrock for WordPress Development on Windows OS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://feedproxy.google.com/~r/UpdraftPlus/~3/7638ZLTUxZo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://updraftplus.com/setup-bedrock-for-wordpress-development-on-windows-os/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 02 Oct 2020 14:25:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:9:{i:0;a:5:{s:4:\"data\";s:15:\"Tips and tricks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Bedrock\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:16:\"Operating System\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:2:\"OS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:6:\"Set-up\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:5:\"Setup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:7;a:5:{s:4:\"data\";s:7:\"windows\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:8;a:5:{s:4:\"data\";s:9:\"wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://updraftplus.com/?p=674309\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:749:\"<p>As an experienced PHP Developer, I have more often or not used WordPress when working on my web projects. Like many other developers, I have started to lose the same level of excitement I used to have when working within &#8230; <a href=\"https://updraftplus.com/setup-bedrock-for-wordpress-development-on-windows-os/\">Continue reading <span class=\"meta-nav\">&#8594;</span></a></p>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/setup-bedrock-for-wordpress-development-on-windows-os/\">Setup Bedrock for WordPress Development on Windows OS</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Sajid Sayyad\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6690:\"<p>As an experienced PHP Developer, I have more often or not used WordPress when working on my web projects. Like many other developers, I have started to lose the same level of excitement I used to have when working within its rigid structure, as I found it has restricted form and limited functionality over time.</p>\n<p>Recently however, I found a WordPress boilerplate called &#8216;Bedrock&#8217; &#8211; which was created by the guys from <a href=\"https://roots.io\">Roots</a> that pleasantly surprised me. It works by allowing the user to leverage a modern day development workflow that can help speed up your development process.</p>\n<p>In this blog, we will go through the steps to set-up Bedrock for WordPress development. Throughout this tutorial, I will be using and referring to the Windows OS only. When working on other operating systems, the steps to set-up the document root will differ slightly, but everything else should be broadly similar.</p>\n<p><strong>Installation of Bedrock</strong><br />\nUsing a Windows computer with XAMPP already set-up, install Bedrock to begin setting up the WordPress boilerplate for development. We&#8217;ll use <a href=\"https://composer.rarst.net/\">Composer</a> to create our project, so make sure it is installed on your system before proceeding.</p>\n<p>To create the project using Composer, head over to your htdocs directory from the command line and run the following command:</p>\n<pre>composer create-project roots/bedrock</pre>\n<p>This command creates a <code>bedrock</code> folder inside the htdocs. You can also pass the directory name as follows:</p>\n<pre>composer create-project roots/bedrock DIRECTORY_NAME</pre>\n<p>If you jump into your project directory, you will notice a few files such as;<br />\n<code>.env</code>, <code>composer.json</code> have been created. There is also a pre-filled <code>.gitignore</code> file with all rules defined already in it.</p>\n<p>Next, go to the project directory in the terminal window/command line and install the dependencies using the command:</p>\n<pre>composer install</pre>\n<p>This installs all the dependencies required for the development and adds them inside the <code>vendor</code> folder created on your project&#8217;s file system.</p>\n<p>We are now done with the installation, so let&#8217;s go ahead and configure Bedrock.</p>\n<p><strong>Bedrock setup and configuration</strong></p>\n<p>Start with the document root set-up on your OS for the Bedrock project.</p>\n<p>Open <code>xampp\\apache\\conf\\extra\\httpd-vhosts.conf</code> in your text editor to configure the virtual hosts.</p>\n<p>Add the following to the end of the file.</p>\n<pre><em>[php]</em>\n<em>&lt;VirtualHost *:80&gt;</em>\n<em>DocumentRoot \"D:/xampp/htdocs\"</em>\n<em>ServerName localhost</em>\n<em>&lt;/VirtualHost&gt;</em>\n\n<em>&lt;VirtualHost *:80&gt;</em>\n<em>DocumentRoot \"D:/xampp/htdocs/bedrock/web\"</em>\n<em>ServerName bedrock.local</em>\n<em>&lt;/VirtualHost&gt;</em>\n<em>[/php]</em></pre>\n<p>Here I have entered the directory path of the project &#8211; i.e. &#8220;D:/xampp/htdocs/bedrock/web&#8221; You can adjust this path as per your XAMPP setup.</p>\n<p>Next, we need to make a small change to the Windows system file.<br />\nOpen <code>C:\\Windows\\System32\\drivers\\etc\\hosts</code> in the Notepad application.</p>\n<p>Be sure you have opened the Notepad application with administrator access to make this change. To do this, Right-click on the App icon &gt; Run as administrator.</p>\n<p><img src=\"https://lh6.googleusercontent.com/eU1kewv5RM8soZ8JIUROYlMwJ_HDN7dK-B5lca9n3sqgVXTmP7uFvdgHNXjyrZeKV7LBPhagq1-sHVWT42h7qLbfiZOmW6Q81aVAwbH-3QUGbc_zBOnELRqMM4u6zYOBLO8HB0za\" /></p>\n<p>Add the following lines to the end of the file.</p>\n<pre><em>[php]</em>\n<em>127.0.0.1 localhost</em>\n<em>127.0.0.1 bedrock.local</em>\n<em>[/php]</em></pre>\n<p>Note that I passed &#8216;bedrock.local&#8217; as the local IP address with the same string (&#8216;bedrock.local&#8217;) added in the &#8216;httpd-vhosts.conf&#8217; file and it is mapped to my project directory path. If I now run <i>bedrock.local</i> on the browser it will point to the project directory that is associated with the above steps.</p>\n<p>The final step in our setup is to create an empty database for our website and add its credentials in the <code>.env</code> file.<br />\nYou can find this file in the root directory of the project.<br />\nOpen the <code>.env</code> and add the DB Credentials as constants.</p>\n<p>DB_NAME=bedrock<br />\nDB_USER=ADD_DB_USERNAME<br />\nDB_PASSWORD=ADD_DB_PASSWORD</p>\n<p>Also, add the WP_HOME URL &amp; the salt key (You can generate a salt key at <a href=\"https://roots.io/salts.html\">https://roots.io/salts.html</a>)</p>\n<pre><em>[php]</em>\n<em>WP_HOME=http://bedrock.local</em>\n<em>[/php]</em></pre>\n<p>Keep the rest of the document as is, save and close the file.</p>\n<p>Restart the Apache server and go to the URL: <i>http://bedrock.local</i> in your browser. It should redirect you to the famous 5-minute WordPress installation.</p>\n<p><strong>How to use Bedrock for WordPress development</strong></p>\n<p>We have so far learned how to install and set-up Bedrock, so let&#8217;s see how we can use Bedrock to develop a WordPress project.</p>\n<p>In a default WordPress installation, the themes and plugins folder are found inside the &#8216;wp-content&#8217; directory. With Bedrock, they are situated inside the &#8216;web/app&#8217; folder. To set-up themes or plugins for Bedrock, add your theme(s) in &#8216;web/app/themes/&#8217; and your plugins in the &#8216;web/app/plugins&#8217; directory.</p>\n<p>Using Composer, you can install the plugin as follows:</p>\n<pre>composer require wpackagist-plugin/updraftplus</pre>\n<p>Here &#8216;updraftplus&#8217; is a slug of a plugin. This means you just need to use the ‘slug’ and Composer will install the plugin for you. There is no need to follow the manual process for installing plugins as you can search for the plugin packages on <a href=\"https://wpackagist.org\">WordPress Packagist</a>.</p>\n<p>This concludes our quick tutorial on how to setup Bedrock &#8211; a very useful tool to manage your development. I recommend using it for all your upcoming WordPress developments.</p>\n<p>Please share your thoughts or suggestions in the comment section below.</p>\n<p><strong>Sajid Sayyad</strong></p>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/setup-bedrock-for-wordpress-development-on-windows-os/\">Setup Bedrock for WordPress Development on Windows OS</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://updraftplus.com/setup-bedrock-for-wordpress-development-on-windows-os/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://updraftplus.com/setup-bedrock-for-wordpress-development-on-windows-os/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:88:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"How to add Microsoft Azure to your UpdraftPlus account settings\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://feedproxy.google.com/~r/UpdraftPlus/~3/6m36m_z2fyo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://updraftplus.com/how-to-add-microsoft-azure-to-your-updraftplus-account-settings/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 Sep 2020 14:31:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:7:\"Support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:5:\"Azure\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:7:\"connect\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:15:\"microsoft azure\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:14:\"remote storage\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:11:\"UpdraftPlus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://updraftplus.com/?p=666116\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:802:\"<p>Backing up your website to the remote storage location of your choice is something UpdraftPlus have put a lot of time and effort into working on. We currently have a wide-range of supported remote storage options including Google Drive, Amazon &#8230; <a href=\"https://updraftplus.com/how-to-add-microsoft-azure-to-your-updraftplus-account-settings/\">Continue reading <span class=\"meta-nav\">&#8594;</span></a></p>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/how-to-add-microsoft-azure-to-your-updraftplus-account-settings/\">How to add Microsoft Azure to your UpdraftPlus account settings</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Wayne Mullins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1881:\"<p><span style=\"font-weight: 400;\">Backing up your website to the remote storage location of your choice is something UpdraftPlus have put a lot of time and effort into working on. We currently have a wide-range of supported remote storage options including Google Drive, Amazon S3 and DropBox.</span></p>\n<p><span style=\"font-weight: 400;\">Another remote storage option UpdraftPlus supports is </span><a href=\"https://azure.microsoft.com/en-gb/documentation/services/storage/\"><span style=\"font-weight: 400;\">Microsoft Azure</span></a><span style=\"font-weight: 400;\">. You can create a free Azure account for 12 months that offers users a wide choice of free Azure products and includes</span><span style=\"font-weight: 400;\"> 5GB of LRS-Hot </span><a href=\"https://azure.microsoft.com/en-gb/services/storage/blobs/\"><span style=\"font-weight: 400;\">Blob Storage</span></a><span style=\"font-weight: 400;\"> with 20,000 read and 10,000 write operations.</span></p>\n<p><span style=\"font-weight: 400;\">While connecting an Azure account may not be quite as simple as Google Drive, by following our easy to understand ‘step-by-step’ instructional video below, you can start backing up your website to Azure in next to no time. </span></p>\n<p><iframe title=\"How to add Azure to your UpdraftPlus account settings\" src=\"https://player.vimeo.com/video/460092515?dnt=1&amp;app_id=122963\" width=\"1080\" height=\"608\" frameborder=\"0\" allow=\"autoplay; fullscreen\" allowfullscreen></iframe></p>\n<p>&nbsp;</p>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/how-to-add-microsoft-azure-to-your-updraftplus-account-settings/\">How to add Microsoft Azure to your UpdraftPlus account settings</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://updraftplus.com/how-to-add-microsoft-azure-to-your-updraftplus-account-settings/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://updraftplus.com/how-to-add-microsoft-azure-to-your-updraftplus-account-settings/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:76:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"UpdraftPlus announces MetaSlider is now sold to Extendify\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://feedproxy.google.com/~r/UpdraftPlus/~3/8I60miJclTA/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://updraftplus.com/updraftplus-announces-metaslider-is-now-sold-to-extendify/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Sep 2020 15:21:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:10:\"MetaSlider\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"Extendify\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://updraftplus.com/?p=653346\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:783:\"<p>We are excited to announce we&#8217;ve sold our MetaSlider business to Extendify. Kevin, the lead developer who&#8217;s helped build MetaSlider to what it is today, is moving with the plugin and continuing to work on it with the new owners.  &#8230; <a href=\"https://updraftplus.com/updraftplus-announces-metaslider-is-now-sold-to-extendify/\">Continue reading <span class=\"meta-nav\">&#8594;</span></a></p>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/updraftplus-announces-metaslider-is-now-sold-to-extendify/\">UpdraftPlus announces MetaSlider is now sold to Extendify</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Joe Miles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1568:\"<p dir=\"ltr\">We are excited to announce we&#8217;ve sold our MetaSlider business to Extendify.</p>\n<p dir=\"ltr\">Kevin, the lead developer who&#8217;s helped build MetaSlider to what it is today, is moving with the plugin and continuing to work on it with the new owners.  You can find more info on their plans for MetaSlider <a href=\"https://www.metaslider.com/supercharging-metaslider/\" target=\"_blank\" rel=\"noopener noreferrer\">here</a>.</p>\n<p dir=\"ltr\">It&#8217;s been great working with this excellent plugin over the last three years and seeing lots of new features released.  It was also very satisfying to see it transforming thousands of sites, including high profile customers such as NASA; who purchased MetaSlider Premium to power their space education pages on NASA.gov.</p>\n<p dir=\"ltr\">Extendify will, of course, honour all existing support arrangements, GDPR agreements, and licenses.</p>\n<p dir=\"ltr\">We&#8217;re confident it&#8217;s in excellent hands with the vision to take it to the next level, and maintain its position as the most popular WordPress slider plugin, whilst we focus more on our backend plugins such as UpdraftPlus, EasyUpdatesManager, and WP-Optimize.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/updraftplus-announces-metaslider-is-now-sold-to-extendify/\">UpdraftPlus announces MetaSlider is now sold to Extendify</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://updraftplus.com/updraftplus-announces-metaslider-is-now-sold-to-extendify/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://updraftplus.com/updraftplus-announces-metaslider-is-now-sold-to-extendify/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:72:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"UpdraftPlus release latest 1.16.28 version\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://feedproxy.google.com/~r/UpdraftPlus/~3/yubuGfKps0Y/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Sep 2020 10:54:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:13:\"Uncategorized\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:28:\"UpdraftPlus development news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:11:\"development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:11:\"new release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:6:\"update\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:11:\"UpdraftPlus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://updraftplus.com/?p=653204\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:736:\"<p>The latest updates for UpdraftPlus 1.16.28 have now been released. This latest version comes with two main new features and several tweaks and fixes. The first new feature we are releasing with UpdraftPlus 1.16.28 is that users can now back &#8230; <a href=\"https://updraftplus.com/updraftplus-release-latest-1-16-28-version/\">Continue reading <span class=\"meta-nav\">&#8594;</span></a></p>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/updraftplus-release-latest-1-16-28-version/\">UpdraftPlus release latest 1.16.28 version</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Wayne Mullins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3507:\"<p><span style=\"font-weight: 400;\">The latest updates for UpdraftPlus 1.16.28 have now been released. This latest version comes with two main new features and several tweaks and fixes. The first new feature we are releasing with UpdraftPlus 1.16.28 is that users can now back up and restore MySQL and MariaDB routines. Backing up these stored routines means that users do not need to keep reissuing the individual statements, but can refer to the stored routine instead. </span></p>\n<p><span style=\"font-weight: 400;\">The second new feature gives users the ability to search and replace the database via WP-CLI. Having this search and replace option will come in very handy when users need to change a site’s URL for example, or make another change of frequently appearing text inside your WordPress database. This new feature will save users lots of time when compared to manually updating any changes or creating a raw MySQL query to carry out the same action.</span></p>\n<p><span style=\"font-weight: 400;\">We recommend the update for all users.</span></p>\n<p><span style=\"font-weight: 400;\">The change-log for UpdraftPlus 1.16.28 is as follows. </span></p>\n<p><b>1.16.28</b></p>\n<ul>\n<li><span style=\"font-weight: 400;\">FEATURE: Support backing up and restoring MySQL/MariaDB routines (stored procedures and functions)</span></li>\n<li><span style=\"font-weight: 400;\">FEATURE: Added the ability to search and replace the database via WP-CLI</span></li>\n<li><span style=\"font-weight: 400;\">FIX: Bit fields in a table don&#8217;t necessarily get backed up correctly due to the difference in the output of mysql_query() and mysqli_query() for the bit-field type</span></li>\n<li><span style=\"font-weight: 400;\">FIX: Allow single multisite sub-sites to be restored when there is a http/https mismatch between the site and database backup</span></li>\n<li><span style=\"font-weight: 400;\">TWEAK: Update plugin updates checker dependency (in paid versions) to the 4.10 series, improving compatibility with WP 5.5+&#8217;s updates management</span></li>\n<li><span style=\"font-weight: 400;\">TWEAK: Suppress message about how to upgrade an already-installed plugin when on WP 5.5+ (where it is no longer relevant)</span></li>\n<li><span style=\"font-weight: 400;\">TWEAK: Internal refactoring to allow more flexibility when creating database backups</span></li>\n<li><span style=\"font-weight: 400;\">TWEAK: Force the turning off of ANSI_QUOTES in the active SQL mode when creating a backup, for better compatibility</span></li>\n<li><span style=\"font-weight: 400;\">TWEAK: Add the ability to configure the &#8216;max_allowed_packet&#8217; option in the binary mysqldump command via the &#8216;UPDRAFTPLUS_MYSQLDUMP_MAX_ALLOWED_PACKET&#8217; constant</span></li>\n<li><span style=\"font-weight: 400;\">TWEAK: The Google Drive options exist condition to prevent a false positive saved settings error</span></li>\n<li><span style=\"font-weight: 400;\">TWEAK: Improve the UpdraftPlus get_outgoing_ip_address method in finding user webserver&#8217;s IPv6 address</span></li>\n<li><span style=\"font-weight: 400;\">TWEAK: Removed MetaSlider notice in the notices collection</span></li>\n</ul>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/updraftplus-release-latest-1-16-28-version/\">UpdraftPlus release latest 1.16.28 version</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://updraftplus.com/updraftplus-release-latest-1-16-28-version/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:72:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"How to add Google Cloud to your UpdraftPlus account settings\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://feedproxy.google.com/~r/UpdraftPlus/~3/3ZVBc0WzTDo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Aug 2020 13:39:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:7:\"Support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:12:\"google cloud\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:5:\"guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:6:\"How to\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:14:\"remote storage\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:11:\"UpdraftPlus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://updraftplus.com/?p=649225\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:756:\"<p>The latest version of UpdraftPlus gives you the option of backing up your WordPress website by using several different remote storage options. Ranging from Google, to Amazon S3, to DropBox, there is a remote storage option for everyone. As with &#8230; <a href=\"https://updraftplus.com/google-cloud-updraftplus-account-settings/\">Continue reading <span class=\"meta-nav\">&#8594;</span></a></p>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/google-cloud-updraftplus-account-settings/\">How to add Google Cloud to your UpdraftPlus account settings</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Wayne Mullins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2044:\"<p><span style=\"font-weight: 400;\">The latest version of UpdraftPlus gives you the option of backing up your WordPress website by using several different remote storage options. Ranging from Google, to Amazon S3, to DropBox, there is a remote storage option for everyone.</span></p>\n<p><span style=\"font-weight: 400;\">As with Google Drive, </span><a href=\"https://cloud.google.com/\"><span style=\"font-weight: 400;\">Google Cloud</span></a><span style=\"font-weight: 400;\">, as it offers 15GB of free remote storage for free per month and can be used in the knowledge that you are putting your backups and security in the hands of one the largest and most dependable companies in the world. </span></p>\n<p><span style=\"font-weight: 400;\">By using your existing Google email account, you can set up your Google Cloud remote storage account in next to no time. If you require more remote storage space, you can purchase up to 2TB of space for just £79.99 a year. </span></p>\n<p><span style=\"font-weight: 400;\">UpdraftPlus can be connected to your Google Cloud remote storage location in just a few minutes. We know that all the different options and settings can sometimes be a lot to figure out, so we have created the following helpful video guide on how to quickly and easily connect UpdraftPlus and Google Cloud.</span></p>\n<p><span style=\"font-weight: 400;\">Just follow the video below for a step-by-step guide.<br />\n</span><br />\n<iframe title=\"How to add Google Cloud to your UpdraftPlus account settings\" src=\"https://player.vimeo.com/video/429975021?dnt=1&amp;app_id=122963\" width=\"1080\" height=\"608\" frameborder=\"0\" allow=\"autoplay; fullscreen\" allowfullscreen></iframe></p>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/google-cloud-updraftplus-account-settings/\">How to add Google Cloud to your UpdraftPlus account settings</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://updraftplus.com/google-cloud-updraftplus-account-settings/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"How to add Google Drive to your UpdraftPlus account settings\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://feedproxy.google.com/~r/UpdraftPlus/~3/iPALaoG6mcs/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Aug 2020 12:51:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Uncategorized\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://updraftplus.com/?p=643739\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:782:\"<p>When backing up your WordPress website with UpdraftPlus, you have the option of using several remote storage options in which to save your backup files. One of the most popular storage locations is Google Drive, as it offers 15GB of &#8230; <a href=\"https://updraftplus.com/how-to-add-google-drive-to-your-updraftplus-account-settings/\">Continue reading <span class=\"meta-nav\">&#8594;</span></a></p>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/how-to-add-google-drive-to-your-updraftplus-account-settings/\">How to add Google Drive to your UpdraftPlus account settings</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Wayne Mullins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1773:\"<p><span style=\"font-weight: 400;\">When backing up your WordPress website with UpdraftPlus, you have the option of using several remote storage options in which to save your backup files.</span></p>\n<p><span style=\"font-weight: 400;\">One of the most popular storage locations is </span><a href=\"https://www.google.com/drive/\"><span style=\"font-weight: 400;\">Google Drive</span></a><span style=\"font-weight: 400;\">, as it offers 15GB of free remote storage, has a world-wide reputation for security and dependability and is a quick and easy remote storage option to connect to as pretty much everyone already has a Gmail account already setup. </span></p>\n<p><span style=\"font-weight: 400;\">As user interfaces and setup processes change rapidly, we at UpdraftPlus are constantly updating the latest ‘how-to’ videos, so users have a clear understanding of how to connect Google Drive and other remote backup options to their UpdraftPlus account. </span></p>\n<p><span style=\"font-weight: 400;\">To find out how to add Google Drive to your UpdraftPlus backup settings, just follow the video below for a step-by-step instructions.</span></p>\n<p><iframe title=\"How to add Google Drive to your UpdraftPlus account settings\" src=\"https://player.vimeo.com/video/428043381?dnt=1&amp;app_id=122963\" width=\"1080\" height=\"608\" frameborder=\"0\" allow=\"autoplay; fullscreen\" allowfullscreen></iframe></p>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/how-to-add-google-drive-to-your-updraftplus-account-settings/\">How to add Google Drive to your UpdraftPlus account settings</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://updraftplus.com/how-to-add-google-drive-to-your-updraftplus-account-settings/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Easy Updates Manager and WordPress 5.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://feedproxy.google.com/~r/UpdraftPlus/~3/346-jgo0dic/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Aug 2020 16:18:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:20:\"Easy Updates Manager\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"update\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:13:\"WordPress 5.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://updraftplus.com/?p=639067\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:745:\"<p>Easy Updates Manager has long been the leader in WordPress update management. We&#8217;ve watched Easy Updates Manager go from a humble 10,000 installs to its current 300,000 install count. With WordPress 5.5, auto-updates have landed in WordPress Core. This is &#8230; <a href=\"https://updraftplus.com/easy-updates-manager-and-wordpress-5-5/\">Continue reading <span class=\"meta-nav\">&#8594;</span></a></p>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/easy-updates-manager-and-wordpress-5-5/\">Easy Updates Manager and WordPress 5.5</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Joe Miles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4159:\"<p><span style=\"font-weight: 400;\">Easy Updates Manager has long been the leader in WordPress update management. We&#8217;ve watched Easy Updates Manager go from a humble 10,000 installs to its current 300,000 install count.</span></p>\n<p><span style=\"font-weight: 400;\">With WordPress 5.5, auto-updates have landed in WordPress Core. This is exciting.</span></p>\n<p><a href=\"https://updraftplus.com/wp-content/uploads/2020/08/plugin-auto-updates-1.png\"><img class=\"alignnone wp-image-639073\" src=\"https://updraftplus.com/wp-content/uploads/2020/08/plugin-auto-updates-1.png\" alt=\"\" width=\"827\" height=\"595\" /></a></p>\n<p><span style=\"font-weight: 400;\">With this latest WordPress update, we had to make the tough decision whether to natively integrate with WordPress Core&#8217;s interpretation of automatic updates, in regards to plugins and themes. While the native core integration of auto-updates is well-thought and we foresee it becoming more powerful, EUM has taken the decision to continue to control updates through our unique and innovative interface.</span></p>\n<p><span style=\"font-weight: 400;\">One example is our plugins and themes screen. Users can still enable auto-updates through those screens and it integrates well with core emails and our log functionality. Additionally, you can also disable updates completely for certain assets.</span></p>\n<p><span style=\"font-weight: 400;\">EUM also integrates out-of-the-box with most third-party plugins and has worked with hosts throughout the years to make native automatic updates to plugins and themes a possibility, even on managed hosts.</span></p>\n<p><a href=\"https://updraftplus.com/wp-content/uploads/2020/08/image-4-1.png\"><img class=\"alignnone wp-image-639074\" src=\"https://updraftplus.com/wp-content/uploads/2020/08/image-4-1.png\" alt=\"\" width=\"688\" height=\"239\" /></a></p>\n<p><span style=\"font-weight: 400;\">When a user couples automatic updates with backups that most managed hosts handle natively, or our own UpdraftPlus backup solution, users are covered even if the worst should happen.</span></p>\n<p><span style=\"font-weight: 400;\">With EUM Free, we have identified that most users simply want auto-updates to be enabled holistically throughout WordPress. This includes plugin/theme updates, translation updates and WordPress Core updates (minor and major versions).</span></p>\n<p><span style=\"font-weight: 400;\">We foresee automatic updates, as they have landed in Core, to be a popular feature. We provide additional features with our Premium offering.</span></p>\n<p><span style=\"font-weight: 400;\">With EUM Premium, users are given more control over updates. Examples of our popular Premium features include:</span></p>\n<ul>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Update scheduling &#8211; Control when updates are run to avoid excessive server load and downtime.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Logs &#8211; Logs are a native feature, but premium allows you to integrate logs with third-party services such as Slack. The export log functionality also allows you to generate a report for clients.</span></li>\n<li style=\"font-weight: 400;\"><span style=\"font-weight: 400;\">Email reports of pending updates &#8211; If for some reason an update isn&#8217;t available through auto-updates, we can send you a periodic report of updates that need action. This will also work if you have disabled an asset from updating.</span></li>\n</ul>\n<p><span style=\"font-weight: 400;\">At Easy Updates Manager, we will strive to give users the features they need to have full control over their updates and will continue working with WordPress Core in regards to automatic updates. As Core updates mature, we will strive to integrate with native Core functionality when it makes sense.</span></p>\n<p>The post <a rel=\"nofollow\" href=\"https://updraftplus.com/easy-updates-manager-and-wordpress-5-5/\">Easy Updates Manager and WordPress 5.5</a> appeared first on <a rel=\"nofollow\" href=\"https://updraftplus.com\">UpdraftPlus</a>. <a href=\"http://updraftplus.com\">UpdraftPlus - Backup, restore and migration plugin for WordPress.</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:8:\"origLink\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://updraftplus.com/easy-updates-manager-and-wordpress-5-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";s:4:\"href\";s:39:\"http://feeds.feedburner.com/UpdraftPlus\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"rel\";s:3:\"hub\";s:4:\"href\";s:32:\"http://pubsubhubbub.appspot.com/\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:42:\"http://rssnamespace.org/feedburner/ext/1.0\";a:1:{s:4:\"info\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"uri\";s:11:\"updraftplus\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:4:\"etag\";s:27:\"3QbufseFsNTFLFlBPSc6MfUzJUI\";s:13:\"last-modified\";s:29:\"Sun, 01 Nov 2020 17:12:58 GMT\";s:16:\"content-encoding\";s:4:\"gzip\";s:4:\"date\";s:29:\"Sun, 01 Nov 2020 17:21:29 GMT\";s:7:\"expires\";s:29:\"Sun, 01 Nov 2020 17:21:29 GMT\";s:13:\"cache-control\";s:18:\"private, max-age=0\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:16:\"x-xss-protection\";s:13:\"1; mode=block\";s:6:\"server\";s:3:\"GSE\";s:7:\"alt-svc\";s:194:\"h3-Q050=\":443\"; ma=2592000,h3-29=\":443\"; ma=2592000,h3-T051=\":443\"; ma=2592000,h3-T050=\":443\"; ma=2592000,h3-Q046=\":443\"; ma=2592000,h3-Q043=\":443\"; ma=2592000,quic=\":443\"; ma=2592000; v=\"46,43\"\";}}s:5:\"build\";s:14:\"20200501165608\";}',	'no'),
(4633,	'_transient_timeout_wc_shipping_method_count_legacy',	'1604440111',	'no'),
(4634,	'_transient_wc_shipping_method_count_legacy',	'a:2:{s:7:\"version\";s:10:\"1598965236\";s:5:\"value\";i:0;}',	'no'),
(7536,	'_transient_timeout__woocommerce_helper_updates',	'1604294586',	'no'),
(7537,	'_transient__woocommerce_helper_updates',	'a:4:{s:4:\"hash\";s:32:\"d751713988987e9331980363e24189ce\";s:7:\"updated\";i:1604251386;s:8:\"products\";a:0:{}s:6:\"errors\";a:1:{i:0;s:10:\"http-error\";}}',	'no'),
(7509,	'_transient_feed_8627b082b8f1f678e97db7dbbc36d821',	'a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://he.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"מערכת אישית בקוד פתוח לניהול בלוגים עצמאיים\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 29 Sep 2020 20:21:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"he-IL\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.6-beta2-49470\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"וורדפרס 5.5 בעברית\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"https://he.wordpress.org/2020/08/11/%d7%95%d7%95%d7%a8%d7%93%d7%a4%d7%a8%d7%a1-5-5-%d7%91%d7%a2%d7%91%d7%a8%d7%99%d7%aa/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2020 20:06:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:19:\"שחרור גרסה\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"וורדפרס\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:27:\"וורדפרס בעברית\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://he.wordpress.org/?p=1171\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:601:\"בגרסה זו נוסף מנגנון לשדרוג אוטומטי של תוספים ותבניות, טעינת תמונות מהירה יותר באמצעות \'lazy loading\' מובנה, מפת אתר מובנית בתוך וורדפרס, ספריית בלוקים חדשה, הגדרת סביבת פיתוח באמצעות משתנה גלובלי, ועוד הרבה סוכריות למשתמשים ולמפתחים. ניתן להוריד את גרסה 5.5 בעברית או לשדרג את המערכת בצורה אוטומטית דרך לוח הבקרה של וורדפרס. יש לזכור [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Rami Yushuvaev\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:872:\"\n<p>בגרסה זו נוסף מנגנון לשדרוג אוטומטי של תוספים ותבניות, טעינת תמונות מהירה יותר באמצעות \'lazy loading\' מובנה, מפת אתר מובנית בתוך וורדפרס, ספריית בלוקים חדשה, הגדרת סביבת פיתוח באמצעות משתנה גלובלי, ועוד הרבה סוכריות למשתמשים ולמפתחים.</p>\n\n\n\n<p>ניתן להוריד את גרסה 5.5 בעברית או לשדרג את המערכת בצורה אוטומטית דרך לוח הבקרה של וורדפרס. יש לזכור לבצע גיבוי לפני השדרוג.</p>\n\n\n\n<p>מידע נוסף על וורדפרס 5.5:</p>\n\n\n\n<ul><li><a href=\"https://wordpress.org/news/2020/08/eckstine/\" target=\"_blank\" rel=\"noreferrer noopener\">הודעת השחרור של WordPress 5.5</a></li></ul>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"וורדפרס 5.4 בעברית\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"https://he.wordpress.org/2020/04/01/%d7%95%d7%95%d7%a8%d7%93%d7%a4%d7%a8%d7%a1-5-4-%d7%91%d7%a2%d7%91%d7%a8%d7%99%d7%aa/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 31 Mar 2020 21:35:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:19:\"שחרור גרסה\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"וורדפרס\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:27:\"וורדפרס בעברית\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://he.wordpress.org/?p=1158\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:511:\"בגרסה זו נוספו שני בלוקים חדשים, הורחב מנגנון הפרטיות, שופרה ההנגשה בעורך הבלוקים, ונוספו כלים נוספים למפתחים. ניתן להוריד את גרסה 5.4 בעברית או לשדרג את המערכת בצורה אוטומטית דרך לוח הבקרה של וורדפרס. יש לזכור לבצע גיבוי לפני השדרוג. מידע נוסף על וורדפרס 5.4: הודעת השחרור של WordPress&#160;5.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Rami Yushuvaev\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:662:\"\n<p>בגרסה זו נוספו שני בלוקים חדשים, הורחב מנגנון הפרטיות, שופרה ההנגשה בעורך הבלוקים, ונוספו כלים נוספים למפתחים.</p>\n\n\n\n<p>ניתן להוריד את גרסה 5.4 בעברית או לשדרג את המערכת בצורה אוטומטית דרך לוח הבקרה של וורדפרס. יש לזכור לבצע גיבוי לפני השדרוג.</p>\n\n\n\n<p>מידע נוסף על וורדפרס 5.4:</p>\n\n\n\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://wordpress.org/news/2020/03/adderley/\" target=\"_blank\">הודעת השחרור של WordPress&nbsp;5.4</a></li></ul>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"וורדפרס 5.3 בעברית\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"https://he.wordpress.org/2019/11/13/%d7%95%d7%95%d7%a8%d7%93%d7%a4%d7%a8%d7%a1-5-3-%d7%91%d7%a2%d7%91%d7%a8%d7%99%d7%aa/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 13 Nov 2019 21:00:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:19:\"שחרור גרסה\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"וורדפרס\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:27:\"וורדפרס בעברית\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://he.wordpress.org/?p=1174\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:525:\"בגרסה זו נוספה תבנית ברירת מחדל חדשה, עורך הבלוקים שופר ונוספו בלוקים קבוצתיים ובלוק עמודות ונוספו כלים נוספים למפתחים. ניתן להוריד את גרסה 5.3 בעברית או לשדרג את המערכת בצורה אוטומטית דרך לוח הבקרה של וורדפרס. יש לזכור לבצע גיבוי לפני השדרוג. מידע נוסף על וורדפרס 5.3: הודעת השחרור של WordPress 5.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Rami Yushuvaev\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:941:\"\n<p>בגרסה זו נוספה תבנית ברירת מחדל חדשה, עורך הבלוקים שופר ונוספו בלוקים קבוצתיים ובלוק עמודות ונוספו כלים נוספים למפתחים.</p>\n\n\n\n<p>ניתן להוריד את גרסה 5.3 בעברית או לשדרג את המערכת בצורה אוטומטית דרך לוח הבקרה של וורדפרס. יש לזכור לבצע גיבוי לפני השדרוג.</p>\n\n\n\n<p>מידע נוסף על וורדפרס 5.3:</p>\n\n\n\n<ul><li><a rel=\"noreferrer noopener\" href=\"https://wordpress.org/news/2020/03/adderley/\" target=\"_blank\">הודעת השחרור של </a><a href=\"https://wordpress.org/news/2019/11/kirk/\" data-type=\"URL\" data-id=\"https://wordpress.org/news/2019/11/kirk/\" target=\"_blank\" rel=\"noreferrer noopener\">WordPress </a><a rel=\"noreferrer noopener\" href=\"https://wordpress.org/news/2020/03/adderley/\" target=\"_blank\">5.3</a></li></ul>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"עיצוב חדש לעמודי האודות\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:160:\"https://he.wordpress.org/2018/04/01/%d7%a2%d7%99%d7%a6%d7%95%d7%91-%d7%97%d7%93%d7%a9-%d7%9c%d7%a2%d7%9e%d7%95%d7%93%d7%99-%d7%94%d7%90%d7%95%d7%93%d7%95%d7%aa/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 01 Apr 2018 07:16:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"הודעות\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://he.wordpress.org/?p=1093\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:637:\"צוות הפיתוח של וורדפרס שיחרר עיצוב חדש לעמוד האודות ותתי-העמודים השונים. השינוי המבורך כולל מיגרציה של התכנים לתבנית וורדפרס חדשה העומדת בסטנדרטים המקובלים עם אפשרות לתרגום המחרוזות. כפועל יוצא, העיצוב יושם בכל אתרי רוזטה המציגים את אתר וורדפרס הראשי בשפות השונות. הדבר נועד להחליף את העמודים המותאים שנוצרו בכל שפה, ולייצר ממשק אחיד בכל השפות. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Rami Yushuvaev\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2317:\"<p>צוות הפיתוח של וורדפרס שיחרר עיצוב חדש ל<a href=\"https://wordpress.org/about/\" target=\"_blank\" rel=\"noopener noreferrer\">עמוד האודות</a> ותתי-העמודים השונים. השינוי המבורך כולל מיגרציה של התכנים לתבנית וורדפרס חדשה העומדת בסטנדרטים המקובלים עם אפשרות לתרגום המחרוזות.</p>\n<p>כפועל יוצא, העיצוב יושם בכל אתרי רוזטה המציגים את אתר וורדפרס הראשי בשפות השונות. הדבר נועד להחליף את העמודים המותאים שנוצרו בכל שפה, ולייצר ממשק אחיד בכל השפות. כך למשל, באתר <a href=\"https://he.wordpress.org/\" target=\"_blank\" rel=\"noopener noreferrer\">וורדפרס בעברית</a> מחקתי את כל עמודי המידע שיצרתי באופן ידני לטובת לטובת <a href=\"https://he.wordpress.org/about/\" target=\"_blank\" rel=\"noopener noreferrer\">עמוד האודות החדש בעברית</a>. התכנים בעמוד זה ובעמודי-המשנה זהים לעמוד האודות בשפה האנגלית ובשאר השפות. בצורה זו המשתמש מקבל עיצוב אחיד עם אותו המידע על פני רשת אתרי wp.org.</p>\n<p><a href=\"https://meta.trac.wordpress.org/ticket/3046\" target=\"_blank\" rel=\"noopener noreferrer\">השינוי</a> שבוצע כולל עיצוב מחדש וסידור של כל עמודי המשנה בנושא וורדפרס: <a href=\"https://he.wordpress.org/about/requirements/\">הדרישות</a>, <a href=\"https://he.wordpress.org/about/security/\">האבטחה</a>, <a href=\"https://he.wordpress.org/about/roadmap/\">מפת הדרכים</a>, <a href=\"https://he.wordpress.org/about/history/\">ההיסטוריה</a>, <a href=\"https://he.wordpress.org/about/stats/\">הסטטיסטיקות</a>, <a href=\"https://he.wordpress.org/about/logos/\">לוגואים וגרפיקה</a> ורבים נוספים. הכל זמין לתרגום ולתיקון באמצעות <a href=\"https://translate.wordpress.org/projects/meta/wordpress-org/he/default\">ממשק התרגום של וורדפרס</a>. אתם מוזמנים לעזור בעבודת התרגום.</p>\n<p>&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"עיצוב חדש לאתרי וורדפרס מקומיים\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:203:\"https://he.wordpress.org/2017/12/01/%d7%a2%d7%99%d7%a6%d7%95%d7%91-%d7%97%d7%93%d7%a9-%d7%9c%d7%90%d7%aa%d7%a8%d7%99-%d7%95%d7%95%d7%a8%d7%93%d7%a4%d7%a8%d7%a1-%d7%9e%d7%a7%d7%95%d7%9e%d7%99%d7%99%d7%9d/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Dec 2017 17:40:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"הודעות\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://he.wordpress.org/?p=1014\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:577:\"אחרי עבודה מאומצת, כל האתרים המקומיים של וורדפרס עוצבו מחדש בדמותו של אתר וורדפרס באנגלית. התבנית Rosetta אשר משמשת את כל אתרי הוורדפרס המקומיים עודכנה ויושמה בכל האתרים. אם בעבר האחראים על הגרסאות המקומיות יכלו לשלוט על התוכן של העמוד הראשי, מעתה יש שליטה רק על התוכן בעמודי המשנה ואילו העמוד הראשי תואם לעמוד הראשי [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Rami Yushuvaev\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1073:\"<p>אחרי עבודה מאומצת, כל האתרים המקומיים של וורדפרס עוצבו מחדש בדמותו של אתר וורדפרס באנגלית. התבנית Rosetta אשר משמשת את כל אתרי הוורדפרס המקומיים עודכנה ויושמה בכל האתרים.</p>\n<p>אם בעבר האחראים על הגרסאות המקומיות יכלו לשלוט על התוכן של העמוד הראשי, מעתה יש שליטה רק על התוכן בעמודי המשנה ואילו העמוד הראשי תואם לעמוד הראשי האנגלי ויהיה ניתן לתרגום אותו דרך <a href=\"https://translate.wordpress.org/projects/meta/wordpress-org\" target=\"_blank\" rel=\"noopener noreferrer\">ממשק התרגום הוותיק של וורדפרס</a>. בנוסף, בכל עמודי המשנה הוסרו תפרטי הצד</p>\n<p>המאמץ תואם למאמצים בשנים קודמות, כאשר אחרי שחרור גרסה ראשית עוברים לטפל בתשתיות של WordPress.org.</p>\n<p>&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"וורדפרס 4.9 בעברית\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"https://he.wordpress.org/2017/11/22/%d7%95%d7%95%d7%a8%d7%93%d7%a4%d7%a8%d7%a1-4-9-%d7%91%d7%a2%d7%91%d7%a8%d7%99%d7%aa/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 22 Nov 2017 12:28:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:19:\"שחרור גרסה\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"וורדפרס\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:27:\"וורדפרס בעברית\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://he.wordpress.org/?p=997\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:580:\"בגרסה זו שופר מנגנון ההתאמה האישית, התווסף וידגט להצגת גלריות, עודכן מספר וידג\'ט שנוספו בגרסה הקודמת, בעריכת הקוד של תבניות ותוספים תחביר הקוד מודגש עוד&#8230; ניתן להוריד את גרסה 4.9 בעברית או לשדרג את המערכת בצורה אוטומטית דרך לוח הבקרה של וורדפרס. יש לזכור לבצע גיבוי לפני השדרוג. מידע נוסף על וורדפרס 4.9: הודעת השחרור [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Rami Yushuvaev\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:903:\"<p>בגרסה זו שופר מנגנון ההתאמה האישית, התווסף וידגט להצגת גלריות, עודכן מספר וידג\'ט שנוספו בגרסה הקודמת, בעריכת הקוד של תבניות ותוספים תחביר הקוד מודגש עוד&#8230;</p>\n<p>ניתן להוריד את גרסה 4.9 בעברית או לשדרג את המערכת בצורה אוטומטית דרך לוח הבקרה של וורדפרס. יש לזכור לבצע גיבוי לפני השדרוג.</p>\n<p>מידע נוסף על וורדפרס 4.9:</p>\n<ul>\n<li><a href=\"https://wordpress.org/news/2017/11/tipton/\" target=\"_blank\" rel=\"noopener\">הודעת השחרור של WordPress 4.9</a></li>\n<li><a href=\"https://codex.wordpress.org/Version_4.9\" target=\"_blank\" rel=\"noopener\">פירוט מלא של התכונות החדשות בוורדפרס 4.9 (באנגלית)</a></li>\n</ul>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"וורדפרס 4.8 בעברית\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"https://he.wordpress.org/2017/06/08/%d7%95%d7%95%d7%a8%d7%93%d7%a4%d7%a8%d7%a1-4-8-%d7%91%d7%a2%d7%91%d7%a8%d7%99%d7%aa/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 08 Jun 2017 20:23:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:19:\"שחרור גרסה\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"וורדפרס\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:27:\"וורדפרס בעברית\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://he.wordpress.org/?p=984\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:591:\"בגרסה זו נוספו שלושה וידג\'טים חדשים המכסים תמונות, וידאו ואודיו, עודכן וידג\'ט טקסט כך שיתמוך בעריכה ויזואלית, ובךלוח הבקרה ניתן עכשיו לראות אירועי וורדפרס קרובים. ניתן להוריד את גרסה 4.8 בעברית או לשדרג את המערכת בצורה אוטומטית דרך לוח הבקרה של וורדפרס. יש לזכור לבצע גיבוי לפני השדרוג. מידע נוסף על וורדפרס 4.8: הודעת השחרור [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Rami Yushuvaev\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:913:\"<p>בגרסה זו נוספו שלושה וידג\'טים חדשים המכסים תמונות, וידאו ואודיו, עודכן וידג\'ט טקסט כך שיתמוך בעריכה ויזואלית, ובךלוח הבקרה ניתן עכשיו לראות אירועי וורדפרס קרובים.</p>\n<p>ניתן להוריד את גרסה 4.8 בעברית או לשדרג את המערכת בצורה אוטומטית דרך לוח הבקרה של וורדפרס. יש לזכור לבצע גיבוי לפני השדרוג.</p>\n<p>מידע נוסף על וורדפרס 4.8:</p>\n<ul>\n<li><a href=\"https://wordpress.org/news/2017/06/evans/\" target=\"_blank\" rel=\"noopener\">הודעת השחרור של WordPress 4.8</a></li>\n<li><a href=\"https://codex.wordpress.org/Version_4.8\" target=\"_blank\" rel=\"noopener\">פירוט מלא של התכונות החדשות בוורדפרס 4.8 (באנגלית)</a></li>\n</ul>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"וורדפרס 4.7 בעברית\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"https://he.wordpress.org/2016/12/07/%d7%95%d7%95%d7%a8%d7%93%d7%a4%d7%a8%d7%a1-4-7-%d7%91%d7%a2%d7%91%d7%a8%d7%99%d7%aa/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Dec 2016 22:01:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:19:\"שחרור גרסה\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"וורדפרס\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:27:\"וורדפרס בעברית\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://he.wordpress.org/?p=969\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:567:\"וורדפרס 4.7 היא הגרסה האחרונה של וורדפרס. בגרסה זו הוצגה תבנית ברירת מחדל חדשה, תכנים התחלתיים לתבניות, קיצורי עריכה, כותרות וידאו, CSS מותאם, תצוגה מקדימה של קבצי PDF, לוח בקרה בשפות שונות, נקודות קצה לתכנים ב-Rest API ושינויים רבים נוספים. ניתן להוריד את גרסה 4.7 בעברית או לשדרג את המערכת בצורה אוטומטית דרך לוח הבקרה [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Rami Yushuvaev\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1483:\"<p>וורדפרס 4.7 היא הגרסה האחרונה של וורדפרס. בגרסה זו הוצגה תבנית ברירת מחדל חדשה, תכנים התחלתיים לתבניות, קיצורי עריכה, כותרות וידאו, CSS מותאם, תצוגה מקדימה של קבצי PDF, לוח בקרה בשפות שונות, נקודות קצה לתכנים ב-Rest API ושינויים רבים נוספים.</p>\n<p><iframe width=\'612\' height=\'344\' src=\'https://videopress.com/embed/AHz0Ca46?hd=0\' frameborder=\'0\' allowfullscreen></iframe><script src=\'https://v0.wordpress.com/js/next/videopress-iframe.js?m=1435166243\'></script></p>\n<p>ניתן להוריד את גרסה 4.7 בעברית או לשדרג את המערכת בצורה אוטומטית דרך לוח הבקרה של וורדפרס. יש לזכור לבצע גיבוי לפני השדרוג.</p>\n<p>מידע נוסף על וורדפרס 4.7:</p>\n<ul>\n<li><a href=\"https://wordpress.org/news/2016/12/vaughan/\" target=\"_blank\" rel=\"noopener\">הודעת השחרור של WordPress 4.7</a></li>\n<li><a href=\"https://codex.wordpress.org/Version_4.7\" target=\"_blank\" rel=\"noopener\">פירוט מלא של התכונות החדשות בוורדפרס 4.7 (באנגלית)</a></li>\n<li><a href=\"http://www.wp-tricks.co.il/2016/12/%D7%95%D7%95%D7%A8%D7%93%D7%A4%D7%A8%D7%A1-4-7/\" target=\"_blank\" rel=\"noopener\">פירוט מלא של התכונות החדשות בוורדפרס 4.7 (בעברית)</a></li>\n</ul>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"יום התרגום הבינלאומי השני של וורדפרס\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://he.wordpress.org/2016/10/19/global-translation-day/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Oct 2016 17:00:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"הודעות\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://he.wordpress.org/?p=955\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:625:\"צוות התרגום &#8211; הפוליגלוטים (Polyglots) &#8211; של וורדפרס מארגן את יום התרגום הבינלאומי השני של וורדפרס, ב-12 לנובמבר 2016, וכולכם מוזמנים להצטרף. אחת הדרכים הפשוטות ביותר לתרום לוורדפרס ולהיות מעורבים בפרוייקט, היא לתרגם. יום התרגום הבינלאומי הוא הזדמנות ללמוד איך עושים זאת, לפגוש אנשים מכל העולם, ולתרגם את וורדפרס לאחת מתוך 160 שפות נתמכות. הצטרפו [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Yoav Farhi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2740:\"<p>צוות התרגום &#8211; הפוליגלוטים (Polyglots) &#8211; של וורדפרס מארגן את יום התרגום הבינלאומי השני של וורדפרס, ב-12 לנובמבר 2016, וכולכם מוזמנים להצטרף.</p>\n<p>אחת הדרכים הפשוטות ביותר לתרום לוורדפרס ולהיות מעורבים בפרוייקט, היא לתרגם. יום התרגום הבינלאומי הוא הזדמנות ללמוד איך עושים זאת, לפגוש אנשים מכל העולם, <a href=\"https://make.wordpress.org/polyglots/teams\">ולתרגם את וורדפרס לאחת מתוך 160 שפות נתמכות</a>.</p>\n<h3>הצטרפו אלינו ב-12 בנובמבר מכל מקום בעולם</h3>\n<p>יום התרגום מתחיל ביום שבת 12 בנובמבר 2016, בחצות UTC (שלוש בלילה, שעון ישראל) ומסתיים 24 שעות לאחר מכן. אפשר להצטרף כבר מההתחלה, או בכל זמן מתאים לאורך היום.</p>\n<h3>מה נעשה?</h3>\n<p>ימי השתתפות פעילים (Contributor Days) מתרחשים בכל רחבי העולם. <a href=\"https://www.google.com/maps/d/viewer?mid=12Gni4JMfShyWHPqGNwh5-PMneMM&amp;usp=sharing\">צפו במפה</a> כדי לראות אם מתקיים אירוע תרגום מקומי קרוב אליכם. אם אין? <a href=\"https://make.wordpress.org/polyglots/2016/09/22/global-wordpress-translation-day-2-on-november-12th-2016/\">יש באפשרותכם לארגן אירוע!</a></p>\n<p>במקביל, ניתן להצטרף לקהילה, ל-24 שעות של שידור-חי, ולקבל הדרכות מרחוק בשפות שונות. ההדרכות תעסוקנה בלוקליזציה, בינאום, והשתתפות בפרוייקט כמתרגמים.</p>\n<h3>למי זה נועד?</h3>\n<p>למתרגמים-חדשים שרוצים ללמוד איך לעשות זאת, וגם לעורכי-תרגום מנוסים המובילים קבוצה חזקה, יום התרגום הוא לכולם. גם מפתחים יוכלו ליהנות מהרצאות מעמיקות בנושא בינאום ותרגום, או פשוט למצוא מתרגמים לתוספים ולתבניות. כולם מוזמנים!</p>\n<h3>שאלות?</h3>\n<p>מארגני-האירוע וצוות-הפוליגלוטים זמינים בערוץ <a href=\"http://wordpress.slack.com/messages/polyglots/\">polyglots</a> בסלאק וישמחו לענות על כל שאלה! (אפשר לקבל הזמנה לסלאק דרך <a href=\"https://chat.wordpress.org/\">chat.wordpress.org</a>).</p>\n<p>הרשמו <a href=\"https://wptranslationday.org/\">באתר</a> כדי לקחת חלק באירוע הרשמי.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"פורום תמיכה מחודש\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:129:\"https://he.wordpress.org/2016/09/30/%d7%a4%d7%95%d7%a8%d7%95%d7%9d-%d7%aa%d7%9e%d7%99%d7%9b%d7%94-%d7%9e%d7%97%d7%95%d7%93%d7%a9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Sep 2016 07:10:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"הודעות\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://he.wordpress.org/?p=945\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:684:\"בשנה האחרונה בוצעו המון שינויים מאחורי הקלעים לשדרוג אתר WordPress.org. השינוי האחרון קשור לפורום התמיכה בשפות זרות, כולל הפורום בעברית. השינויים שבוצעו הפורומים של וורדפרס בכתובת wordpress.org/support עברו תהליך מיגרציה מורכבת מהתקנת ביביפרס גרסה 1 אל תוסף ביביפרס גרסה 2. יש לציין שביביפרס 1 היא מערכת נפרדת לחלוטין, הקוד שלה מיושן יחסית והוא לא נתמך כבר מספר שנים. לעומת זאת, ביביפרס [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Rami Yushuvaev\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3688:\"<p>בשנה האחרונה <a href=\"https://he.wordpress.org/2015/07/26/%d7%a9%d7%99%d7%a0%d7%95%d7%99%d7%99%d7%9d-%d7%91%d7%90%d7%aa%d7%a8-%d7%95%d7%95%d7%a8%d7%93%d7%a4%d7%a8%d7%a1-%d7%91%d7%a2%d7%91%d7%a8%d7%99%d7%aa/\">בוצעו המון שינויים מאחורי הקלעים</a> לשדרוג אתר WordPress.org. השינוי האחרון קשור לפורום התמיכה בשפות זרות, כולל הפורום בעברית.</p>\n<h3>השינויים שבוצעו</h3>\n<p>הפורומים של וורדפרס בכתובת <a href=\"https://wordpress.org/support/\" target=\"_blank\">wordpress.org/support</a> עברו תהליך מיגרציה מורכבת מהתקנת ביביפרס גרסה 1 אל תוסף ביביפרס גרסה 2. יש לציין שביביפרס 1 היא מערכת נפרדת לחלוטין, הקוד שלה מיושן יחסית והוא לא נתמך כבר מספר שנים. לעומת זאת, ביביפרס 2 הוא תוסף וורדפרס קל משקל שיורש את מרבית התכונות שלו מליבת וורדפרס (סוגי פוסטים, טקסונומיות, תפקידי משתמש, מטמון, שאילתות ועוד).</p>\n<p>הפורומים הישנים של wp.org היו מערכת נפרד, הם נבנו באמצעות ביביפרס 1 והורחבו על ידי עשרות רבות של טלאים. בחודשים האחרונים כל הטלאים הללו שוכתבו כתוספי וורדפרס נפרדים. המערכת החדשה של פורומי התמיכה היא חלק מרשת-אתרים שמרכיבה את אתר wp.org. זהו אתר וורדפרס נפרד ברשת עם תוסף ביביפרס 2 והרחבות נוספות.</p>\n<p>אחרי שכתבו מחדש את כל הקוד, רק אז ניתן היה להעביר את התכנים בין מסדי הנתונים. בשלב זה החל תהליך מיגרציה מורכב של התוכן &#8211; מיליוני דיונים ועשרות מיליוני תגובות. התהליך נמשך זמן רב ודרש סגירה מוחלטת של הפורומים למשך מספר ימים.</p>\n<h3>פורום בעברית– <a href=\"https://he.wordpress.org/support/\" target=\"_blank\">he.wordpress.org/support</a></h3>\n<p>בדומה לתהליך שעברו כל שאר האזורים באתר wp.org (תוספים, תבניות, חדשות וכו\') גם הפורומים המקומיים זמינים דרך תת-דומיין של השפה.</p>\n<p>הפורומים בשפה האנגלית מקבלים המון תנועה, אך בשפות אחרות התנועה הייתה דלילה והפורומים הכילו בעיקר ספאם. וזאת מכיוון שלא היה ניתן להתקין עליהם מסנני ספאם (לא היה תוסף אקיזמט שתואם להתקנת ביביפרס 1), אז לא ניקו את הספאם. בגלל זה הפורומים בעברית לא היו בשימוש וכל התמיכה עברה לקבוצות שונות ברשתות החברתיות.</p>\n<p>כיום, כשהמיגרציה הושלמה, תהליך סינון הספאם נהיה פשוט יותר. אלפי דיונים שסומנו כספאם הוסרו מהפורומים ונותרו רק דיוני לגיטימיים. הפורומים נקיים מזבל. עכשיו נותר רק להחזיר את המשתמשים לחזור ולנהל את הדיונים שלהם בפורום התמיכה המוחדש בשפה העברית.</p>\n<p>כולכם מוזמנים לחזור להשתמש בפורום התמיכה בכתובת: <a href=\"https://he.wordpress.org/support/\" target=\"_blank\">he.wordpress.org/support</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:30:\"https://he.wordpress.org/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 01 Nov 2020 17:21:27 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 29 Sep 2020 20:21:03 GMT\";s:4:\"link\";s:61:\"<https://he.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20200501165608\";}',	'no'),
(7454,	'_transient_timeout_wc_product_children_79',	'1606824665',	'no'),
(7455,	'_transient_wc_product_children_79',	'a:2:{s:3:\"all\";a:2:{i:0;i:80;i:1;i:81;}s:7:\"visible\";a:2:{i:0;i:80;i:1;i:81;}}',	'no'),
(7456,	'_transient_timeout_wc_var_prices_79',	'1606824665',	'no'),
(7457,	'_transient_wc_var_prices_79',	'{\"version\":\"1598957073\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"80\":\"70.00\",\"81\":\"70.00\"},\"regular_price\":{\"80\":\"70.00\",\"81\":\"70.00\"},\"sale_price\":{\"80\":\"70.00\",\"81\":\"70.00\"}}}',	'no'),
(7444,	'_transient_timeout_wc_product_children_74',	'1606823839',	'no'),
(7445,	'_transient_wc_product_children_74',	'a:2:{s:3:\"all\";a:3:{i:0;i:75;i:1;i:76;i:2;i:77;}s:7:\"visible\";a:3:{i:0;i:75;i:1;i:76;i:2;i:77;}}',	'no'),
(7446,	'_transient_timeout_wc_var_prices_74',	'1606823839',	'no'),
(7447,	'_transient_wc_var_prices_74',	'{\"version\":\"1598957073\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"75\":\"70.00\",\"76\":\"70.00\",\"77\":\"70.00\"},\"regular_price\":{\"75\":\"70.00\",\"76\":\"70.00\",\"77\":\"70.00\"},\"sale_price\":{\"75\":\"70.00\",\"76\":\"70.00\",\"77\":\"70.00\"}}}',	'no'),
(7437,	'_transient_timeout_wc_product_children_69',	'1606815926',	'no'),
(7438,	'_transient_wc_product_children_69',	'a:2:{s:3:\"all\";a:3:{i:0;i:70;i:1;i:71;i:2;i:72;}s:7:\"visible\";a:3:{i:0;i:70;i:1;i:71;i:2;i:72;}}',	'no'),
(7439,	'_transient_timeout_wc_var_prices_69',	'1606815926',	'no'),
(7440,	'_transient_wc_var_prices_69',	'{\"version\":\"1598957073\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"70\":\"70.00\",\"71\":\"70.00\",\"72\":\"70.00\"},\"regular_price\":{\"70\":\"70.00\",\"71\":\"70.00\",\"72\":\"70.00\"},\"sale_price\":{\"70\":\"70.00\",\"71\":\"70.00\",\"72\":\"70.00\"}}}',	'no'),
(4557,	'_transient_timeout_wc_term_counts',	'1604440089',	'no'),
(4558,	'_transient_wc_term_counts',	'a:3:{i:17;s:1:\"6\";i:18;s:1:\"3\";i:19;s:1:\"2\";}',	'no'),
(4561,	'_transient_timeout_wc_product_children_82',	'1604318263',	'no'),
(4562,	'_transient_wc_product_children_82',	'a:2:{s:3:\"all\";a:3:{i:0;i:84;i:1;i:85;i:2;i:86;}s:7:\"visible\";a:3:{i:0;i:84;i:1;i:85;i:2;i:86;}}',	'no'),
(4563,	'_transient_timeout_wc_var_prices_82',	'1604318263',	'no'),
(4564,	'_transient_wc_var_prices_82',	'{\"version\":\"1598957073\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"84\":\"70.00\",\"85\":\"70.00\",\"86\":\"70.00\"},\"regular_price\":{\"84\":\"70.00\",\"85\":\"70.00\",\"86\":\"70.00\"},\"sale_price\":{\"84\":\"70.00\",\"85\":\"70.00\",\"86\":\"70.00\"}}}',	'no'),
(2211,	'theme_mods_hello-theme-child-master',	'a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:209;s:11:\"custom_logo\";i:166;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1599715969;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}',	'yes'),
(2414,	'action_scheduler_migration_status',	'complete',	'yes'),
(609,	'_transient_product-transient-version',	'1598957073',	'yes'),
(7528,	'_site_transient_timeout_elementor_pro_remote_info_api_data_2.10.3',	'1604294984',	'no'),
(7529,	'_site_transient_elementor_pro_remote_info_api_data_2.10.3',	'a:17:{s:14:\"stable_version\";s:5:\"3.0.5\";s:12:\"last_updated\";s:19:\"2020-09-23 14:17:56\";s:8:\"sections\";s:109206:\"a:2:{s:11:\"description\";s:161:\"Elementor Pro adds new features to the Elementor Page Builder plugin. Control your conversions, your user engagement, your entire website, from one page builder.\";s:9:\"changelog\";s:108983:\"<h4>3.0.5 - 2020-09-23</h4>\n<ul>\n<li>Fix: If the default page layout is set to &quot;Canvas&quot; Headers and Footers cannot be edited</li>\n<li>Fix: Product Image Dynamic Tag throws an error when no image is set</li>\n<li>Fix: Missing Single document placeholder in Theme Builder</li>\n<li>Fix: Document editing handles inherit the <code>font-family</code> from 3rd party source</li>\n<li>Fix: Can\'t add linebreaks to Textarea input when used as Multi Step Form</li>\n<li>Fix: Incorrect width in Facebook Page widget</li>\n<li>Fix: Added compatibility to allow the use of \'get_create_url\' in Theme Builder</li>\n</ul>\n<h4>3.0.4 - 2020-09-09</h4>\n<ul>\n<li>Fix: Autogenerated screenshots appear in WP Media Library modal (<a href=\"https://github.com/elementor/elementor/issues/12304\">#12304</a>)</li>\n<li>Fix: Make sure Elementor Posts widget Pagination doesn\'t interfere with 3rd party plugins (<a href=\"https://github.com/elementor/elementor/issues/12126\">#12126</a>, <a href=\"https://github.com/elementor/elementor/issues/12127\">#12127</a>)</li>\n<li>Fix: Shrinking conditions indicator in Theme Builder</li>\n<li>Fix: Column can\'t be dragged and dropped if it populates a Global widget</li>\n<li>Fix: Styles are missing from Single templates in some edge cases</li>\n</ul>\n<h4>3.0.3 - 2020-09-02</h4>\n<ul>\n<li>Fix: Pagination doesn\'t work in WordPress 5.5 (<a href=\"https://github.com/elementor/elementor/issues/12126\">#12126</a>, <a href=\"https://github.com/elementor/elementor/issues/12127\">#12127</a>)</li>\n<li>Fix: Change delete template action to &quot;Move to Trash&quot; in the new Theme Builder view</li>\n</ul>\n<h4>3.0.2 - 2020-08-31</h4>\n<ul>\n<li>Tweak: Replaced WordPress &quot;Learn More&quot; links with dynamic links for better control over time (<a href=\"https://github.com/elementor/elementor/issues/12312\">#12312</a>)</li>\n<li>Tweak: UI tweaks to the Conditions screen In the new Theme Builder</li>\n<li>Fix: Motion Effects not working when assigned to a column and throws JS error when DOM optimization is disabled (<a href=\"https://github.com/elementor/elementor/issues/12299\">#12299</a>, <a href=\"https://github.com/elementor/elementor/issues/12275\">#12275</a>)</li>\n<li>Fix: Multiple Galleries display all the images in the Lightbox slideshow (<a href=\"https://github.com/elementor/elementor/issues/11809\">#11809</a>)</li>\n<li>Fix: Old Theme Builder is being opened when accessing through the Finder</li>\n<li>Fix: Mixed templates import glitch in Theme Builder</li>\n<li>Fix: Card icon sizes in Theme Builder</li>\n<li>Fix: Preview button leads to <code>render_mode</code> instead of preview when importing a template from the new Theme Builder</li>\n</ul>\n<h4>3.0.1 - 2020-08-26</h4>\n<ul>\n<li>Tweak: Keep previous Theme Builder when accessing from the WP Dashboard for legacy support</li>\n<li>Tweak: Updated video tutorials in Theme Builder</li>\n<li>Tweak: Don\'t show auto-screenshots in the Media Library (Props <a href=\"https://github.com/black-eye\">@black-eye</a>)</li>\n<li>Fix: Repeater items throws <code>childView</code> is undefined message in Forms widget (<a href=\"https://github.com/elementor/elementor/issues/12239\">#12239</a>, <a href=\"https://github.com/elementor/elementor/issues/12221\">#12221</a>)</li>\n<li>Fix: Misspelling of the word &quot;occurred&quot; in Form widget default error message (<a href=\"https://github.com/elementor/elementor/issues/12137\">#12137</a>)</li>\n<li>Fix: Facebook comments not showing up (<a href=\"https://github.com/elementor/elementor/issues/12157\">#12157</a>)</li>\n<li>Fix: Check for conflicts in Theme Builder doesn\'t work properly</li>\n<li>Fix: Minor UI fixes in Theme Builder</li>\n<li>Fix: Dark mode glitches in Theme Builder</li>\n<li>Fix: Global Site Part toaster appears when you publish a Popup</li>\n<li>Fix: Site Parts aren\'t in the correct order in Theme Builder</li>\n<li>Fix: Date field caused forms to get corrupted in Forms widget</li>\n<li>Fix: Theme Builder application page is forbidden</li>\n</ul>\n<h4>3.0.0 - 2020-08-23</h4>\n<ul>\n<li>New: Introducing the new and improved Theme Builder</li>\n<li>Tweak: Removed <code>.elementor-inner</code> and <code>.elementor-column-wrap</code> from DOM output to improve performance (<a href=\"https://github.com/elementor/elementor/issues/7351\">#7351</a>, <a href=\"https://github.com/elementor/elementor/issues/7817\">#7817</a>, <a href=\"https://developers.elementor.com/dom-improvements-ahead-html-wrappers-removal-from-v3-0/\">Developers Blog Post</a>)</li>\n<li>Tweak: Added contextual anchors ID support to Table of Contents widgets (<a href=\"https://github.com/elementor/elementor/issues/10052\">#10052</a>)</li>\n<li>Tweak: Added WeChat and Weibo social networks to Share Buttons widget (<a href=\"https://github.com/elementor/elementor/issues/11554\">#11554</a>)</li>\n<li>Tweak: Added Dynamic capabilities for Redirect after Login/Logout in Login widget (<a href=\"https://github.com/elementor/elementor/issues/11343\">#11343</a>)</li>\n<li>Tweak: Added Blend Mode and CSS Filters controls to adjust the Background Overlay in Flipbox widget (<a href=\"https://github.com/elementor/elementor/issues/11653\">#11653</a>)</li>\n<li>Tweak: Added responsive capabilities to Toggle Button styling in Nav Menu widget (<a href=\"https://github.com/elementor/elementor/issues/8269\">#8269</a>)</li>\n<li>Tweak: Added responsive Text Alignment control in Call to Action widget (<a href=\"https://github.com/elementor/elementor/issues/11968\">#11968</a>)</li>\n<li>Tweak: Added dynamic content to Ribbon element in Call to Action widget (<a href=\"https://github.com/elementor/elementor/issues/10364\">#10364</a>)</li>\n<li>Tweak: Converted uses of Color and Typography Schemes to Global Colors and Fonts</li>\n<li>Tweak: Separated Title and Description control fields labels in Call to Action widget</li>\n<li>Tweak: Removed unnecessary style in WC Product with variations</li>\n<li>Tweak: Converted Portfolio, Posts and Share Buttons widgets to use CSS Variable-based Elementor Grid (<a href=\"https://developers.elementor.com/elementor-dropping-support-ie/\">Developers Blog Post</a>)</li>\n<li>Tweak: Added Date Modified option to Posts widget metadata</li>\n<li>Fix: PHP 7.4 compatibility to Media Carousel widget (<a href=\"https://github.com/elementor/elementor/issues/11355\">#11355</a>)</li>\n<li>Fix: Divider alignment issue in Post Info widget (<a href=\"https://github.com/elementor/elementor/issues/11628\">#11628</a>)</li>\n<li>Fix: Color doesn’t change in Products Archive Description widget</li>\n<li>Fix: WC Product variations layout breaks when using Variation Swatches plugin</li>\n<li>Fix: WC Product variations layout issue</li>\n<li>Fix: WC Product variations mobile zoom-in glitch</li>\n<li>Fix: Can\'t edit a Popup after accessing Theme Style</li>\n<li>Fix: Twitter icon missing in Blockquote widget</li>\n<li>Fix: Removed redundant default text color from Share Buttons minimal skin</li>\n<li>Fix: UI glitch in Display Conditions modal</li>\n<li>Fix: Insert template button UI glitch in Templates Library</li>\n<li>Fix: Added sanitization to post titles in WordPress dashboard for better security</li>\n<li>Fix: Show when arriving from search engines rule doesn\'t work in Popup</li>\n<li>Fix: Child categories are shown with a different parent category in Query control</li>\n<li>Deprecated: See all deprecations to this version in our <a href=\"https://developers.elementor.com/v3-0-planned-deprecations/\">Developers Deprecations Post</a></li>\n</ul>\n<h4>2.10.3 - 2020-06-29</h4>\n<ul>\n<li>Fix: Form not being submitted when using &quot;Progress Bar&quot; and &quot;None&quot; view types in Multi Step Form (<a href=\"https://github.com/elementor/elementor/issues/11596\">#11596</a>, <a href=\"https://github.com/elementor/elementor/issues/11610\">#11610</a>)</li>\n<li>Fix: Missing &quot;for&quot; attribute in Password field label in Login widget (<a href=\"https://github.com/elementor/elementor/issues/8646\">#8646</a>)</li>\n</ul>\n<h4>2.10.2 - 2020-06-16</h4>\n<ul>\n<li>Fix: Run step events only when in Multi Step Form mode (<a href=\"https://github.com/elementor/elementor/issues/11644\">#11644</a>)</li>\n</ul>\n<h4>2.10.1 - 2020-06-16</h4>\n<ul>\n<li>Tweak: Improved License validation mechanism to avoid limitations</li>\n<li>Tweak: Changed control labels and ordering in Price Table, Lottie and Form widgets</li>\n<li>Fix: Popup close button vertical position glitch (<a href=\"https://github.com/elementor/elementor/issues/10921\">#10921</a>)</li>\n<li>Fix: Radio field placement glitch when in Multi Step mode in Form widget</li>\n<li>Fix: Clicking <code>Enter</code> key submits the form in Multi Step Form</li>\n<li>Fix: Hardened sanitization in Custom Attributes to avoid security issues</li>\n</ul>\n<h4>2.10.0 - 2020-06-07</h4>\n<ul>\n<li>New: Introducing Multi-Step Forms - Breakdown long forms into simple steps (<a href=\"https://github.com/elementor/elementor/issues/5975\">#5975</a>, <a href=\"https://github.com/elementor/elementor/issues/3911\">#3911</a>)</li>\n<li>New: Introducing Lottie widget - easily add Lottie animations to your site, no coding needed (<a href=\"https://github.com/elementor/elementor/issues/11026\">#11026</a>)</li>\n<li>Tweak: Added spacing option to Posts widget pagination (<a href=\"https://github.com/elementor/elementor/issues/5682\">#5682</a>)</li>\n<li>Tweak: Changed texts and logic for administrator plugin renewal notices</li>\n<li>Tweak: Added new Scroll Util for improved scrolling handling</li>\n<li>Tweak: Improved Motion Effects animation performance</li>\n</ul>\n<h4>2.9.5 - 2020-05-24</h4>\n<ul>\n<li>Fix: Added sanitization to Custom Attributes control to avoid security issue</li>\n</ul>\n<h4>2.9.4 - 2020-05-07</h4>\n<ul>\n<li>Fix: Hardened user role that is allowed to upload icon sets and unzip only allowed files in Custom Icons to prevent security vulnerability</li>\n</ul>\n<h4>2.9.3 - 2020-04-19</h4>\n<ul>\n<li>Fix: Form shortcode IDs are not wrapped in double-quotes (<a href=\"https://github.com/elementor/elementor/issues/11023\">#11023</a>, <a href=\"https://github.com/elementor/elementor/issues/10932\">#10932</a>, <a href=\"https://github.com/elementor/elementor/issues/10967\">#10967</a>, <a href=\"https://github.com/elementor/elementor/issues/11000\">#11000</a>, <a href=\"https://github.com/elementor/elementor/issues/11049\">#11049</a>)</li>\n<li>Fix: Escaped Form records metadata to prevent security vulnerability</li>\n<li>Fix: Closing &quot;Save Changes&quot; document confirmation modal causes Panel infinite loading</li>\n<li>Fix: Ken Burns effect not working when there is only one slide in Slides widget</li>\n<li>Fix: Document handles UI glitch</li>\n</ul>\n<h4>2.9.2 - 2020-03-25</h4>\n<ul>\n<li>Tweak: Added compatibility with WordPress v5.4 (<a href=\"https://github.com/elementor/elementor/issues/10745\">#10745</a>)</li>\n<li>Fix: Image ratio number is displayed under the Archive Posts widget (<a href=\"https://github.com/elementor/elementor/issues/10874\">#10874</a>)</li>\n<li>Fix: Theme Style Link color setting overrides the Table of Content list style</li>\n<li>Fix: PHP notice when using dynamic user info <code>id</code></li>\n<li>Fix: Navigation arrows direction is crossed on first drag in Slides Widget</li>\n<li>Fix: &quot;No headings were found on this page&quot; message was not displayed in the frontend in Table of Contents widget</li>\n<li>Fix: Container includes Popup tags by default in Table of Contents widget</li>\n<li>Fix: Twitter icon display issue when Font Awesome 4 support is disabled in Blockquote widget</li>\n<li>Fix: ACF Dynamic tag not working in Form widget Redirect action</li>\n</ul>\n<h4>2.9.1 - 2020-03-16</h4>\n<ul>\n<li>Fix: Can\'t access Elementor Editor when there is Page Title widget in the page</li>\n<li>Fix: Applying styling to Post Content widget affects the Page and Post editing handles</li>\n</ul>\n<h4>2.9.0 - 2020-03-15</h4>\n<ul>\n<li>New: Introducing Full Site Editing: Design header, footer, and content all in one place! (<a href=\"https://github.com/elementor/elementor/issues/4985\">#4985</a>)</li>\n<li>New: Added Global Custom CSS for Your Entire Site in Theme Style (<a href=\"https://github.com/elementor/elementor/issues/3345\">#3345</a>)</li>\n<li>New: Added Dynamic Colors tag (<a href=\"https://github.com/elementor/elementor/issues/6485\">#6485</a>)</li>\n<li>Tweak: Added option to set the Site Part HTML Wrapper Tags (<a href=\"https://github.com/elementor/elementor/issues/9293\">#9293</a>)</li>\n<li>Tweak: Added Link Attributes support to Pro widgets (<a href=\"https://github.com/elementor/elementor/issues/5716\">#5716</a>, <a href=\"https://github.com/elementor/elementor/issues/3642\">#3642</a>, <a href=\"https://github.com/elementor/elementor/issues/9225\">#9225</a>, <a href=\"https://github.com/elementor/elementor/issues/9079\">#9079</a>)</li>\n<li>Tweak: Added Theme Style support in Theme Builder parts (<a href=\"https://github.com/elementor/elementor/issues/10564\">#10564</a>)</li>\n<li>Tweak: Avoid creating empty Custom Font</li>\n<li>Tweak: Added <code>aria-expanded</code> attribute to Menu Cart widget</li>\n<li>Tweak: Moved Link Actions module to Core plugin</li>\n<li>Tweak: Changed the name of “TypeKit Web Fonts by Adobe” to “Adobe Fonts”</li>\n<li>Tweak: Removed redundant display conditions from Blockquote, Flipbox, Price Table, and Search Form widgets</li>\n<li>Tweak: Pro widgets are not draggable unless Elementor license has been activated</li>\n<li>Tweak: Remove redundant <code>label_block</code> parameters from several controls</li>\n<li>Tweak: Converted controls selectors to CSS variables in Gallery widget</li>\n<li>Tweak: Replaced Stumbleupon with Mix in Reviews widget recommended icons (<a href=\"https://github.com/elementor/elementor/issues/10099\">#10099</a>)</li>\n<li>Tweak: Added Mix to the Share Buttons network list (<a href=\"https://github.com/elementor/elementor/issues/10099\">#10099</a>)</li>\n<li>Tweak: Added &quot;Open in new tab&quot; option to Posts widget (<a href=\"https://github.com/elementor/elementor/issues/7924\">#7924</a>)</li>\n<li>Tweak: Upgraded Font Awesome Pro library to v5.12.0</li>\n<li>Tweak: Added new Lightbox compatibility for Gallery and Media Carousel widgets</li>\n<li>Tweak: Expose external API for Swiper instances</li>\n<li>Tweak: Added compatibility to JS API in Theme Builder, Popups, Form widget and Global widget</li>\n<li>Tweak: Replaced nerd icons with new Elementor emojis</li>\n<li>Tweak: Added specific <code>color</code> attribute to header title in Table of Contents widget</li>\n<li>Fix: Line break issues in Animated Headline widget (<a href=\"https://github.com/elementor/elementor/issues/10585\">#10585</a>)</li>\n<li>Fix: Theme Style Link color overrides the Table of Content list style</li>\n<li>Fix: Active state glitches when using Table of contents widget with Sticky mode</li>\n<li>Fix: &quot;Graphic Element&quot; section appears as empty in case of unmarked Graphic Element in Call to Action widget</li>\n<li>Fix: Page Title widget render glitches in the Editor</li>\n<li>Fix: Image ratio parameter visible in some edge cases in Posts widget</li>\n<li>Fix: Image missing when sharing to Pinterest using Share Buttons widget</li>\n<li>Fix: Theme Style Link color setting override the list style in Table of Contents widget</li>\n<li>Deprecated: See all deprecations to this version in our <a href=\"https://developers.elementor.com/v2-9-0-planned-deprecations/\">Developers Deprecations Post</a></li>\n</ul>\n<h4>2.8.5 - 2020-03-08</h4>\n<ul>\n<li>Tweak: Added new Swiper parameter to all Pro carousels to allow 3rd party integration</li>\n<li>Fix: Missing closing bracket in Animated Headline widget</li>\n<li>Fix: Share buttons widgets show Font Awesome 4 icons on first drag in Editor</li>\n</ul>\n<h4>2.8.4 - 2020-02-16</h4>\n<ul>\n<li>Tweak: Added Lightbox Title &amp; Description support to Gallery widget</li>\n<li>Tweak: Added RTL support for Slides widget</li>\n<li>Tweak: Display Lightbox images in Full size in Gallery widget</li>\n<li>Fix: Template with Slides widget not working properly when placed inside Tabs, Accordion and Toggle widget</li>\n<li>Fix: Dropdown menu lost styling after Elementor Pro v2.8 upgrade in Nav Menu widget</li>\n<li>Fix: Indent doesn\'t work on RTL websites in Table of Contents widget</li>\n<li>Fix: Query Control throws <code>Undefined index: q</code> error</li>\n<li>Fix: Typography control not affecting dropdown menu in Nav Menu widget</li>\n<li>Fix: Discord forms integration fails to send submissions in some server configurations</li>\n<li>Fix: Rotating headlines don\'t align center in Animated Headline widget</li>\n<li>Fix: Custom secondary color displayed when not needed in Share buttons widget</li>\n<li>Fix: Motion Effects of certain objects are not functioning properly on Safari browser</li>\n<li>Fix: Missing eye icon in Single template footer preview button</li>\n</ul>\n<h4>2.8.3 - 2020-01-01</h4>\n<ul>\n<li>Tweak: Updated Table of Contents widget panel location</li>\n<li>Fix: ACF URL Dynamic field throws <code>undefined index</code> PHP notice (<a href=\"https://github.com/elementor/elementor/issues/9929\">#9929</a>)</li>\n<li>Fix: Gallery lightbox pagination shows images from all tabs</li>\n<li>Fix: &quot;Reply To&quot; option not working in Form widget &quot;Email 2&quot; Action</li>\n<li>Fix: ACF Dynamic tag not working in Form widget Redirect action</li>\n<li>Fix: Underline option not working in Table of Contents widget Normal state</li>\n<li>Fix: Query Control <code>Undefined index: autocomplete</code> notice in some cases</li>\n<li>Fix: Missing display condition to Read More Spacing control in Posts widget</li>\n</ul>\n<h4>2.8.2 - 2019-12-19</h4>\n<ul>\n<li>Tweak: Improved scroll-spy and collapsing functionality in Table of Contents widget</li>\n<li>Fix: &quot;No products were found&quot; message not being displayed in an empty Products Archive</li>\n<li>Fix: Redundant <code>&lt;br&gt;</code> tags in Single theme template (<a href=\"https://github.com/elementor/elementor/issues/9927\">#9927</a>, <a href=\"https://github.com/elementor/elementor/issues/9928\">#9928</a>)</li>\n<li>Fix: Draft Popup shows up in Dynamic tag dropdown</li>\n</ul>\n<h4>2.8.1 - 2019-12-18</h4>\n<ul>\n<li>Fix: Share Buttons widget not working (<a href=\"https://github.com/elementor/elementor/issues/9920\">#9920</a>)</li>\n<li>Fix: Redundant <code>&lt;p&gt;</code> tags added to Single Template posts</li>\n</ul>\n<h4>2.8.0 - 2019-12-18</h4>\n<ul>\n<li>New: Table of Contents Widget (<a href=\"https://github.com/elementor/elementor/issues/5171\">#5171</a>)</li>\n<li>New: Added Font Awesome Pro Duotone font family support (<a href=\"https://github.com/elementor/elementor/issues/9578\">#9578</a>)</li>\n<li>Tweak: Added Lazy Load option to Gallery widget (<a href=\"https://github.com/elementor/elementor/issues/9763\">#9763</a>)</li>\n<li>Tweak: Added Random order option to Gallery widget (<a href=\"https://github.com/elementor/elementor/issues/9269\">#9269</a>)</li>\n<li>Tweak: Updated Font Awesome Pro to v5.11.2 (<a href=\"https://github.com/elementor/elementor/issues/9578\">#9578</a>)</li>\n<li>Tweak: Added preselect support for multiple default select values in Forms Widget (<a href=\"https://github.com/elementor/elementor/issues/9324\">#9324</a>)</li>\n<li>Tweak: Avoid duplicate queries for Custom Icons (<a href=\"https://github.com/elementor/elementor/issues/9579\">#9579</a>)</li>\n<li>Tweak: Major performance improvements to Gallery widget</li>\n<li>Tweak: Avoid non-existing images in Gallery widget</li>\n<li>Tweak: Added <code>tabindex</code>, <code>aria-expanded</code>, <code>aria-hidden</code> and <code>role=\"navigation\"</code> accessibility attributes to Nav Menu widget</li>\n<li>Tweak: Changed button HTML tag from <code>button</code> to <code>span</code> in Call to Action and Flip Box widgets for better W3C compliance and accessibility</li>\n<li>Tweak: Removed Google+ from default networks in Share Buttons widget</li>\n<li>Tweak: Added compatibility for Library Connect</li>\n<li>Tweak: Added i18n to Toolset date dynamic tag</li>\n<li>Tweak: Added external link support to Gallery widget</li>\n<li>Tweak: Changed the link external attributes implementation to use <code>add_link_attributes()</code> in Gallery widget</li>\n<li>Tweak: Updated references to the new Schemes system location</li>\n<li>Tweak: Avoid running Gallery handler when the gallery is empty</li>\n<li>Tweak: UI Tweaks in Editor Panel</li>\n<li>Tweak: Added responsive capabilities to Pointer Width control in Nav Menu widget</li>\n<li>Tweak: Added mobile support for responsive controls in Nav Menu widget</li>\n<li>Tweak: Refactor <code>register_controls()</code> method in Posts widget skin trait</li>\n<li>Fix: ACF URL &quot;undefined Index&quot; notice (<a href=\"https://github.com/elementor/elementor/issues/7646\">#7646</a>)</li>\n<li>Fix: WooCommerce Mini-Cart widget causes fatal error in edge cases (<a href=\"https://github.com/elementor/elementor/issues/9304\">#9304</a>)</li>\n<li>Fix: <code>PHP Notice: Undefined index</code> display for Author query (<a href=\"https://github.com/elementor/elementor/issues/9864\">#9864</a>)</li>\n<li>Fix: Added compatibility for Button widget placed inside Swiper carousel (<a href=\"https://wordpress.org/support/topic/broken-buttons-since-elementor-2-8/\">Topic</a>)</li>\n<li>Fix: Avoid empty spaces in Post info widget</li>\n<li>Tweak: Always show &quot;Custom label&quot; control in Login widget</li>\n<li>Fix: Nav Menu item typography selector in Nav Menu widget</li>\n<li>Fix: Facebook Like Button widget causes flickering</li>\n<li>Fix: WooCommerce mini-cart behaviour when using <code>plain</code> permalinks format</li>\n<li>Fix: Avoid running Popup triggers when set without conditions</li>\n<li>Fix: Removed &quot;Date&quot; query from Products widget</li>\n<li>Fix: Slides widget when used as a Shortcode and is hidden</li>\n<li>Fix: Custom URL being accessed on swipe in Media Carousel</li>\n<li>Fix: Media Carousel widget Cube effect glitch</li>\n<li>Fix: Lightbox shows images from multiple Gallery widgets in the same page</li>\n<li>Fix: Image <code>alt</code> Text not displayed on overlay in Gallery widget</li>\n<li>Fix: Gallery widget not visible in Posts widget Full Content skin</li>\n<li>Fix: WooCommerce mini-cart remove unnecessary hooks registration when WooCommerce integration set to <code>Disable</code></li>\n<li>Fix: Slides widget button wrapping breaks in mobile view</li>\n<li>Fix: Dynamic capabilities with the Reviews widget</li>\n<li>Fix: Disabling autoplay doesn\'t work in Slides widget</li>\n<li>Fix: Posts widget Full Content skin not working on Single template</li>\n<li>Fix: Autocomplete not working for &quot;By Author&quot; condition in Display Conditions screen</li>\n<li>Fix: Posts widget alignment issue</li>\n<li>Fix: Product Variations Clear button not working in edge cases</li>\n<li>Fix: Styling issues in Form widget submit button</li>\n</ul>\n<h4>2.7.3 - 2019-10-28</h4>\n<ul>\n<li>Tweak: Added RTL support to Galleries widget (<a href=\"https://github.com/elementor/elementor/issues/9213\">#9213</a>)</li>\n<li>Tweak: Added Custom Icons compatibility for WordPress 5.3</li>\n<li>Fix: Missing template function declaration causes fatal error in WC mini-cart widget</li>\n<li>Fix: Pause on hover doesn\'t work in Carousel widgets</li>\n<li>Fix: Link-actions conflict with <code>?action=</code> parameter in the URL</li>\n<li>Fix: Lightbox navigation not working in Gallery widget Single mode</li>\n<li>Fix: Ken burns effect not working on the 1st slide if Infinite Loop option is turned off in Carousel widgets</li>\n<li>Fix: Popup Advanced Rules detects internal links as external if current URL starts with <code>www</code></li>\n</ul>\n<h4>2.7.2 - 2019-10-06</h4>\n<ul>\n<li>Fix: Slide Overlay not working when applying Ken burns effect in Slides widget (<a href=\"https://github.com/elementor/elementor/issues/9209\">#9209</a>)</li>\n<li>Fix: Content width glitch in Slides widget (<a href=\"https://github.com/elementor/elementor/issues/9180\">#9180</a>)</li>\n<li>Fix: Horizontal Alignment not working when applying custom style per slide in Slides widget (<a href=\"https://github.com/elementor/elementor/issues/9180\">#9180</a>)</li>\n<li>Fix: Missing semicolon in Custom Fonts <code>font-display</code> CSS</li>\n</ul>\n<h4>2.7.1 - 2019-09-26</h4>\n<ul>\n<li>Fix: Background Overlay layer is over the slide content in Slides widget (<a href=\"https://github.com/elementor/elementor/issues/9180\">#9180</a>)</li>\n<li>Fix: Duplicate images under &quot;All&quot; filter in Multiple Gallery</li>\n</ul>\n<h4>2.7.0 - 2019-09-24</h4>\n<ul>\n<li>New: Enhanced Galleries widget (<a href=\"https://github.com/elementor/elementor/issues/1898\">#1898</a>, <a href=\"https://github.com/elementor/elementor/issues/3103\">#3103</a>, <a href=\"https://github.com/elementor/elementor/issues/4279\">#4279</a>, <a href=\"https://github.com/elementor/elementor/issues/7631\">#7631</a>)</li>\n<li>New: Dynamic Number (<a href=\"https://github.com/elementor/elementor/issues/5952\">#5952</a>)</li>\n<li>New: Full content skin for Posts and Archive-posts widgets (<a href=\"https://github.com/elementor/elementor/issues/4617\">#4617</a>)</li>\n<li>Tweak: Added dynamic number capability to Price List, Price Table, Counter, Star Rating, Progress Bar widgets</li>\n<li>Tweak: Added tags support to forms Mailchimp action (<a href=\"https://github.com/elementor/elementor/issues/5418\">#5418</a>)</li>\n<li>Tweak: User Profile Picture Dynamic Tag (<a href=\"https://github.com/elementor/elementor/issues/7947\">#7947</a>, <a href=\"https://github.com/elementor/elementor/issues/8740\">#8740</a>)</li>\n<li>Tweak: Added <code>font-display</code> support to custom fonts (<a href=\"https://github.com/elementor/elementor/issues/5993\">#5993</a>, <a href=\"https://developers.elementor.com/elementor-pro-2-7-custom-fonts-font-display-support/\">Developers Blog Post</a>)</li>\n<li>Tweak: Added Text Shadow control to Slides widget (<a href=\"https://github.com/elementor/elementor/issues/8800\">#8800</a>)</li>\n<li>Tweak: Added Re-subscribe support to MailerLite (<a href=\"https://github.com/elementor/elementor/issues/8799\">#8799</a>)</li>\n<li>Tweak: Added Dynamic capabilities to Facebook Embed widget (<a href=\"https://github.com/elementor/elementor/issues/9030\">#9030</a>)</li>\n<li>Tweak: Use <code>swiper.js</code> instead of <code>slick.js</code> in Slides widget (<a href=\"https://developers.elementor.com/elementor-2-7-moving-sliders-from-slick-to-swiper/\">Developers Blog Post</a>)</li>\n<li>Tweak: Added <code>elementor_pro/search_form/before_input</code> action hook to Search Form widget (<a href=\"https://github.com/elementor/elementor/issues/5598\">#5598</a>)</li>\n<li>Tweak: Added <code>elementor_pro/search_form/after_input</code> action hook to Search Form widget (<a href=\"https://github.com/elementor/elementor/issues/5598\">#5598</a>)</li>\n<li>Tweak: Added dynamic support for Custom field key (<a href=\"https://github.com/elementor/elementor/issues/7789\">#7789</a>)</li>\n<li>Tweak: Increased expired license notice bar frequency</li>\n<li>Tweak: Changed the icon name of Slides widget</li>\n<li>Tweak: Added designated Finder\'s Icons for Custom icons &amp; Custom fonts</li>\n<li>Tweak: Use Ken Burns Effect as an external module</li>\n<li>Tweak: Remove Fontello conflicting CSS on import to Custom Icons sets</li>\n<li>Tweak: Editor Panel UI tweaks</li>\n<li>Tweak: Added DOM events on Popup show/hide (<a href=\"https://developers.elementor.com/elementor-pro-2-7-popup-events/\">Developers Blog Post</a>)</li>\n<li>Tweak: Added option to change the variations field width in Add to Cart widget</li>\n<li>Tweak: Use select control instead of select2 in Menu Cart widget</li>\n<li>Tweak: Added conditions to the tabs instead of to each control in Share Buttons widget</li>\n<li>Tweak: Added Typography controls to HTML field in Forms widget</li>\n<li>Tweak: Allow edit selected Font file in Custom Font</li>\n<li>Tweak: Changed reCAPTCHA v3 error message</li>\n<li>Tweak: Remove the &quot;Save as Global&quot; option on Global widget context menu</li>\n<li>Fix: Corrected selector for <code>removeControlSpinner()</code> (<a href=\"https://github.com/elementor/elementor/issues/8790\">#8790</a>)</li>\n<li>Fix: Slides widget navigation icons misplacement (<a href=\"https://github.com/elementor/elementor/issues/8533\">#8533</a>)</li>\n<li>Fix: Horizontal Scrollbar when Slider widget is set to Full Width (<a href=\"https://github.com/elementor/elementor/issues/8527\">#8527</a>)</li>\n<li>Fix: Inconsistent behavior when &quot;Infinite Loop&quot; enabled with &quot;Autoplay&quot; in Slides widget (<a href=\"https://github.com/elementor/elementor/issues/6726\">#6726</a>)</li>\n<li>Fix: Ken Burns effect on Chrome transition glitches (<a href=\"https://github.com/elementor/elementor/issues/1671\">#1671</a>)</li>\n<li>Fix: Nothing found message shows up inside the columns set in Posts Archive widget (<a href=\"https://github.com/elementor/elementor/issues/7347\">#7347</a>)</li>\n<li>Fix: Responsive UI glitch in Popup Conditions modal tabs</li>\n<li>Fix: Removed unnecessary divider in Call to Action widget</li>\n<li>Fix: Custom Add To Cart * button style (size, position and background color) when <code>quantity</code> is enabled.</li>\n<li>Fix: Add support for Document/PageBase in Theme Builder (Core &gt;=2.7.0)</li>\n<li>Fix: Ampersand character breaks email link in Share Buttons widget</li>\n<li>Fix: Correct custom font attachment <code>mime-type</code> to show uploaded Custom Fonts</li>\n<li>Fix: Mini-Cart not refreshing in Menu Cart widget</li>\n<li>Fix: Cart drawer not working when WC Subscriptions plugin is activated</li>\n<li>Fix:  Querying CPT with custom taxonomies does not show the taxonomies before saving</li>\n<li>Fix: Double rendering on change caused console error in Theme Builder\'s conditions screen</li>\n<li>Fix: Translations and Strings in Share Buttons widget</li>\n<li>Fix: Avoid using offset if the source is Manual selection in Query Control</li>\n<li>Fix: Form being submitted although reCAPTCHA v3 validation failed in Forms widget</li>\n</ul>\n<h4>2.6.5 - 2019-08-26</h4>\n<ul>\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.7</li>\n<li>Fix: Button style not working when <code>quantity</code> is enabled in Custom Add To Cart widget</li>\n<li>Fix: Updated minified JS file fixed WhatsApp base URL in Share Buttons widget</li>\n</ul>\n<h4>2.6.4 - 2019-08-21</h4>\n<ul>\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.7</li>\n<li>Fix: Changed WhatsApp base URL in Share Buttons widget for cross-device compatibility</li>\n<li>Fix: Random slides order after several clicks on pagination in Testimonial Carousel widget</li>\n</ul>\n<h4>2.6.3 - 2019-08-18</h4>\n<ul>\n<li>Fix: Core version rollback to <code>&gt;2.6.0</code> causes a fatal error</li>\n<li>Fix: Duplicate images when slideshow skin is selected in Media Carousel lightbox</li>\n<li>Fix: Default bottom margin added to reCAPTCHA V3 badge</li>\n<li>Fix: Input glitch in reCAPTCHA V3 threshold settings</li>\n</ul>\n<h4>2.6.2 - 2019-07-30</h4>\n<ul>\n<li>Tweak: Better accessibility support in Search Form widget</li>\n<li>Fix: UI glitched in Popup publish screen (<a href=\"https://github.com/elementor/elementor/issues/8616\">#8616</a>)</li>\n<li>Fix: &quot;Child of Term&quot; and &quot;Any child of term&quot; conditions (<a href=\"https://github.com/elementor/elementor/issues/8695\">#8695</a>)</li>\n<li>Fix: Restored <code>library_widget_templates</code> action hook for 3rd party compatibility (<a href=\"https://github.com/elementor/elementor/issues/8687\">#8687</a>)</li>\n<li>Fix: Twitter Icon missing in Blockquote widget</li>\n<li>Fix: Form reCAPTCHA v3 badge position not working</li>\n<li>Fix: Renewal notice bar appears in wrong situations</li>\n<li>Fix: Draft Icon Set loads empty Icon Library</li>\n</ul>\n<h4>2.6.1 - 2019-07-24</h4>\n<ul>\n<li>Fix: Query Control autocomplete not retrieving results (<a href=\"https://github.com/elementor/elementor/issues/8672\">#8672</a>, <a href=\"https://github.com/elementor/elementor/issues/8661\">#8661</a>)</li>\n<li>Fix: Price Table features section not working (<a href=\"https://github.com/elementor/elementor/issues/8660\">#8660</a>)</li>\n</ul>\n<h4>2.6.0 - 2019-07-23</h4>\n<ul>\n<li>New: Introducing Custom Icon sets - including Fontello, IcoMoon and Fontastic support (<a href=\"https://github.com/elementor/elementor/issues/110\">#110</a>)</li>\n<li>New: Added Font Awesome 5 Pro integration including 5,300+ icons (<a href=\"https://github.com/elementor/elementor/issues/4430\">#4430</a>)</li>\n<li>New: Added reCAPTCHA v3 integration to Form widget (<a href=\"https://github.com/elementor/elementor/issues/8213\">#8213</a>, <a href=\"https://github.com/elementor/elementor/issues/6039\">#6039</a>, <a href=\"https://github.com/elementor/elementor/issues/7165\">#7165</a>)</li>\n<li>Tweak: Added Exit Animation for Popups (<a href=\"https://github.com/elementor/elementor/issues/7063\">#7063</a>)</li>\n<li>Tweak: Added ACF Dynamic tag support for archive pages (<a href=\"https://github.com/elementor/elementor/issues/5147\">#5147</a>)</li>\n<li>Tweak: Added Navigator Indicators for Custom CSS &amp; Motion Effects (<a href=\"https://github.com/elementor/elementor/issues/2180\">#2180</a>)</li>\n<li>Tweak: Added Dynamic capabilities for Form Redirect action (<a href=\"https://github.com/elementor/elementor/issues/7552\">#7552</a>)</li>\n<li>Tweak: Added Logged In Message styling options for Login widget (<a href=\"https://github.com/elementor/elementor/issues/7928\">#7928</a>)</li>\n<li>Tweak: Added <code>none</code> breakpoint option to Nav Menu widget (<a href=\"https://github.com/elementor/elementor/issues/7916\">#7916</a>)</li>\n<li>Tweak: Added option to place Post Terms dynamic tag without links (<a href=\"https://github.com/elementor/elementor/issues/8366\">#8366</a>)</li>\n<li>Tweak: Added <code>elementor/query/query_results</code> hook to Query Control to allow full control over results (<a href=\"https://github.com/elementor/elementor/issues/7912\">#7912</a>)</li>\n<li>Tweak: Allow choosing Heading HTML tag in Price Table widget (<a href=\"https://github.com/elementor/elementor/issues/8090\">#8090</a>)</li>\n<li>Tweak: Show popup on dynamic click even when <code>Avoid Multiple Popups</code> option is selected (<a href=\"https://github.com/elementor/elementor/issues/8189\">#8189</a>)</li>\n<li>Tweak: Added condition option to all of archive child pages (<a href=\"https://github.com/elementor/elementor/issues/8256\">#8256</a>)</li>\n<li>Tweak: Added <code>Effects Relative To</code> control to Scrolling Effects</li>\n<li>Tweak: Allow shortcodes in HTML Form field</li>\n<li>Tweak: Removed donReach integration from Share Buttons widget due to service inconsistent stability</li>\n<li>Tweak: Changed MailChimp <code>List</code> label to <code>Audience</code></li>\n<li>Tweak: Improved Entrance and Exit animation behavior in Popup</li>\n<li>Tweak: Added <code>Deprecated Notice</code> control to <code>Archive Products</code> and <code>Woo Products</code> widgets</li>\n<li>Tweak: Added default dynamic title for archives in Theme Builder</li>\n<li>Tweak: Added condition to show <code>Centered Slides</code> control in Media Carousel widget</li>\n<li>Tweak: Added notice bar in the Editor when the license is expired or not activated</li>\n<li>Tweak: Replaced <code>select</code> control with <code>choose</code> control in Price List widget</li>\n<li>Tweak: Removed Font Awesome 4 dependencies from the Editor</li>\n<li>Tweak: Minor styling tweaks in the Popup publish modal</li>\n<li>Tweak: Hide ordering form in Products widget on front page</li>\n<li>Tweak: Removed page title markup when \'Hide Title\' is active</li>\n<li>Tweak: Added style controls for HTML field in Form widget</li>\n<li>Fix: Form widget Date picker makes the Popup builder disappear (<a href=\"https://github.com/elementor/elementor/issues/7240\">#7240</a>)</li>\n<li>Fix: Sticky element stop point stops working on viewport resize (<a href=\"https://github.com/elementor/elementor/issues/7884\">#7884</a>)</li>\n<li>Fix: Copy-Paste style not pasting the Pointer option in Nav Menu widget (<a href=\"https://github.com/elementor/elementor/issues/8497\">#8497</a>)</li>\n<li>Fix: Missing Print icon in Share Buttons (<a href=\"https://github.com/elementor/elementor/issues/8506\">#8506</a>)</li>\n<li>Fix: UI style glitch in Blockquote widget when viewing from iPad</li>\n<li>Deprecated: <code>DB::save_editor()</code> - Remove usage of this method (<a href=\"https://developers.elementor.com/v2-6-0-planned-deprecations/\">Deprecation Post</a>)</li>\n<li>Deprecated: <code>DB::get_plain_editor()</code> - Remove usage of this method (<a href=\"https://developers.elementor.com/v2-6-0-planned-deprecations/\">Deprecation Post</a>)</li>\n</ul>\n<h4>2.5.14 - 2019-07-14</h4>\n<ul>\n<li>Fix: Better WC Related Product grid support to various themes (<a href=\"https://github.com/elementor/elementor/issues/8555\">#8555</a>)</li>\n</ul>\n<h4>2.5.13 - 2019-07-11</h4>\n<ul>\n<li>Fix: Better WC grid support to various themes</li>\n</ul>\n<h4>2.5.12 - 2019-07-10</h4>\n<ul>\n<li>Fix: Grid for WooCommerce Archive Product widget</li>\n<li>Fix: Remove redundant <code>whitespace</code> CSS property causes style glitch in iPad</li>\n<li>Tweak: Added more compatibility for Elementor v2.6</li>\n</ul>\n<h4>2.5.11 - 2019-07-02</h4>\n<ul>\n<li>Fix: Close icon missing from Nav Menu widget (<a href=\"https://github.com/elementor/elementor/issues/8460\">#8460</a>)</li>\n<li>Fix: Elementor Pro v2.5.10 shows PHP notice regarding notice bar (<a href=\"https://github.com/elementor/elementor/issues/8461\">#8461</a>)</li>\n<li>Fix: Fatal error when deleting used Pods fields (<a href=\"https://github.com/elementor/elementor/issues/8396\">#8396</a>)</li>\n<li>Fix: Missing dropdown icon in conditions screen</li>\n</ul>\n<h4>2.5.10 - 2019-05-28</h4>\n<ul>\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.6</li>\n<li>Tweak: Error caused by empty Rows &amp; Columns values in Products widget (<a href=\"https://github.com/elementor/elementor/issues/8261\">#8261</a>)</li>\n<li>Fix: Do not unset <code>product</code> CPT if it\'s not from WooCommerce (<a href=\"https://github.com/elementor/elementor/issues/8160\">#8160</a>)</li>\n<li>Fix: Column Spacing not working in WooCommerce Archive Products widget (<a href=\"https://github.com/elementor/elementor/issues/8285\">#8285</a>)</li>\n<li>Fix: Title styling not working in Products Categories widget</li>\n<li>Fix: Empty value in Dynamic Pods Gallery dropdown using Safari browser</li>\n<li>Fix: WooCommerce archives included in &quot;All Archives&quot; condition</li>\n</ul>\n<h4>2.5.9 - 2019-05-28</h4>\n<ul>\n<li>Tweak: Removed <code>auto-confirm</code> control from MailPoet to support new version of MailPoet</li>\n<li>Fix: Multiple Custom Fonts not rendered in the editor</li>\n<li>Fix: Products <code>sale</code> query - handle exclude by manual selection.</li>\n<li>Fix: Product Categories grid row &amp; column style</li>\n<li>Fix: Form integration AJAX cache override</li>\n<li>Fix: Removed redundant CSS on Canvas &amp; Header-Footer page templates</li>\n</ul>\n<h4>2.5.8 - 2019-05-06</h4>\n<ul>\n<li>Fix: Popup entrance animation not working in frontend</li>\n<li>Fix: Popup Exit Intent trigger activated multiple times</li>\n</ul>\n<h4>2.5.7 - 2019-05-05</h4>\n<ul>\n<li>Fix: Embedded video keeps playing after a Popup is closed (<a href=\"https://github.com/elementor/elementor/issues/7875\">#7875</a>)</li>\n<li>Fix: Maximum call stack size exceeded error in Safari (<a href=\"https://github.com/elementor/elementor/issues/7824\">#7824</a>)</li>\n<li>Fix: Entrance animations not appearing on Popup reopen (<a href=\"https://github.com/elementor/elementor/issues/7395\">#7395</a>)</li>\n<li>Fix: WC variations select style glitch in several themes (<a href=\"https://github.com/elementor/elementor/issues/8008\">#8008</a>)</li>\n<li>Fix: Theme Builder taxonomy conditions not retrieving proper results in edge cases</li>\n</ul>\n<h4>2.5.6 - 2019-04-29</h4>\n<ul>\n<li>Tweak: Removed <code>Shortcode</code> dynamic from Image, Gallery and Media control</li>\n<li>Fix: Popup not inheriting entrance animation in responsive mode (<a href=\"https://github.com/elementor/elementor/issues/7809\">#7809</a>)</li>\n<li>Fix: Terms autocomplete retrieves wrong results in Query Control</li>\n<li>Fix: Query Control Related by author glitches in edge cases</li>\n<li>Fix: Query Control using terms for Products widget</li>\n<li>Fix: Posts cards style glitch in small screens</li>\n<li>Fix: Display conditions delete icon missing in small screens</li>\n<li>Fix: Avoid rendering Menu Cart widget in WordPress native editor</li>\n</ul>\n<h4>2.5.5 - 2019-04-08</h4>\n<ul>\n<li>Tweak: Allow text selection inside a Popup</li>\n<li>Fix: Added backwards compatibility for <code>tax_query</code> in Query Control (<a href=\"https://github.com/elementor/elementor/issues/7751\">#7751</a>)</li>\n<li>Fix: Missing arguments for <code>widget_title</code> filter (<a href=\"https://github.com/elementor/elementor/issues/7745\">#7745</a>)</li>\n</ul>\n<h4>2.5.4 - 2019-04-03</h4>\n<ul>\n<li>Fix: Move Query from using <code>term_id</code> to <code>term_taxonomy_id</code> (<a href=\"https://github.com/elementor/elementor/issues/7653\">#7653</a>)</li>\n<li>Fix: Offset manipulation hook removal in Query control</li>\n<li>Fix: Missing form field <code>ID</code> in some edge cases (<a href=\"https://github.com/elementor/elementor/issues/7711\">#7711</a>, <a href=\"https://github.com/elementor/elementor/issues/7660\">#7660</a>)</li>\n</ul>\n<h4>2.5.3 - 2019-03-31</h4>\n<ul>\n<li>Tweak: Updated Google Calendar dynamic tag URL (<a href=\"https://github.com/elementor/elementor/issues/7673\">#7673</a>)</li>\n<li>Fix: Missing form field names (<a href=\"https://github.com/elementor/elementor/issues/7651\">#7651</a>)</li>\n<li>Fix: PHP 5.4 backward compatibility in Query Control (<a href=\"https://github.com/elementor/elementor/issues/7633\">#7633</a>)</li>\n<li>Fix: <code>products_deprecated</code> Query Control module compatibility (<a href=\"https://github.com/elementor/elementor/issues/7654\">#7654</a>)</li>\n<li>Fix: Changed query method from <code>term_id</code> to <code>term_taxonomy_id</code> (<a href=\"https://github.com/elementor/elementor/issues/7653\">#7653</a>)</li>\n</ul>\n<h4>2.5.2 - 2019-03-27</h4>\n<ul>\n<li>Fix: Overwrite parent widget type in Global Widget (<a href=\"https://github.com/elementor/elementor/issues/7632\">#7632</a>)</li>\n<li>Fix: Avoid Duplicates option not working in Query Control (<a href=\"https://github.com/elementor/elementor/issues/7635\">#7635</a>)</li>\n<li>Fix: Manual Selection option not working in Query Control (<a href=\"https://github.com/elementor/elementor/issues/7634\">#7634</a>)</li>\n<li>Fix: Incorrect condition caused handlers issues inside popup</li>\n</ul>\n<h4>2.5.1 - 2019-03-26</h4>\n<ul>\n<li>Fix: Query Control invalid call to deprecated action (<a href=\"https://github.com/elementor/elementor/issues/7619\">#7619</a>)</li>\n<li>Tweak: Renamed action hook from <code>elementor_pro/{$widget_name}/query/{$query_id}</code> to <code>elementor/query/{$query_id}</code></li>\n<li>Tweak: Renamed filter hook from <code>elementor_pro/query_control/get_query_args/current_query</code> to <code>elementor/query/get_query_args/current_query</code></li>\n</ul>\n<h4>2.5.0 - 2019-03-26</h4>\n<ul>\n<li>New: Introducing Motion Effects including Scrolling &amp; Mouse effects (<a href=\"https://github.com/elementor/elementor/issues/72\">#72</a>)</li>\n<li>New: Introducing Related Posts for Query Control (<a href=\"https://github.com/elementor/elementor/issues/7306\">#7306</a>, <a href=\"https://github.com/elementor/elementor/issues/7490\">#7490</a>)</li>\n<li>New: Introducing Date query for Query Control</li>\n<li>New: Introducing Sticky Posts support for Query Control (<a href=\"https://github.com/elementor/elementor/issues/2501\">#2501</a>)</li>\n<li>Tweak: Added option to open a Popup by a custom selector (<a href=\"https://github.com/elementor/elementor/issues/6871\">#6871</a>, <a href=\"https://github.com/elementor/elementor/issues/6876\">#6876</a>, <a href=\"https://github.com/elementor/elementor/issues/7258\">#7258</a>)</li>\n<li>Tweak: Option to count when Popup is closed in &quot;Show up to X times&quot; Advanced Rule</li>\n<li>Tweak: Added full border radius control options inside Popup</li>\n<li>Tweak: Changed exit intent icon in Popups</li>\n<li>Tweak: Show only one popup in its own preview</li>\n<li>Tweak: Added responsive support to Popup entrance animation control</li>\n<li>Tweak: Conditions - Singular <code>All Pages</code> string changed to <code>Pages</code></li>\n<li>Tweak: Added form field shortcode support for Drip tags (<a href=\"https://github.com/elementor/elementor/issues/7000\">#7000</a>)</li>\n<li>Tweak: Added dynamic capabilities to Price List widget (<a href=\"https://github.com/elementor/elementor/issues/7258\">#7258</a>)</li>\n<li>Tweak: Added Dynamic capabilities to Custom Attributes (<a href=\"https://github.com/elementor/elementor/issues/6779\">#6779</a>)</li>\n<li>Tweak: Added dynamic capabilities to Flip Box widget (<a href=\"https://github.com/elementor/elementor/issues/6986\">#6986</a>)</li>\n<li>Tweak: Decrease <code>z-index</code> for Nav Menu (<a href=\"https://github.com/elementor/elementor/issues/6869\">#6869</a>)</li>\n<li>Tweak: Changed &quot;Scrolling Effects&quot; section label to &quot;Motion Effects&quot;</li>\n<li>Tweak: Use filter <code>get_meta_viewport</code> for header templates (<a href=\"https://github.com/elementor/elementor/issues/7043\">#7043</a>)</li>\n<li>Tweak: use filterable <code>Util::get_public_post_types()</code> in Theme Builder (<a href=\"https://github.com/elementor/elementor/issues/7172\">#7172</a>)</li>\n<li>Tweak: Added Cloudflare rocket-loader support (<a href=\"https://github.com/elementor/elementor/issues/7443\">#7443</a>)</li>\n<li>Tweak: Added responsive support to WC Products Columns &amp; Rows Gap controls (<a href=\"https://github.com/elementor/elementor/issues/6913\">#6913</a>)</li>\n<li>Tweak: WC Menu cart &quot;View Cart&quot; &amp; &quot;Checkout&quot; buttons styling</li>\n<li>Fix: Custom ID reset to default when dragging repeater</li>\n<li>Fix: Conflict between archive-products widget and WC customizer</li>\n<li>Fix: Add to Cart widget <code>spacing</code> and <code>space-between</code></li>\n<li>Fix: Library view when creating a new Header or Footer</li>\n<li>Fix: Post types labels missing on Add New Template modal</li>\n</ul>\n<h4>2.4.8 - 2019-03-11</h4>\n<ul>\n<li>Fix: Missing query section in Products widget</li>\n<li>Fix: Missing Taxonomy controls in Products widget in edge cases</li>\n</ul>\n<h4>2.4.7 - 2019-03-06</h4>\n<ul>\n<li>Fix: Compatibility Global Widget with Elementor v2.5.0+</li>\n</ul>\n<h4>2.4.6 - 2019-03-04</h4>\n<ul>\n<li>Fix: Pods gallery dynamic when empty (<a href=\"https://github.com/elementor/elementor/issues/7127\">#7127</a>)</li>\n<li>Fix: Duplicate call for conditions screen issue</li>\n<li>Fix: Compatibility with Elementor v2.5.0</li>\n</ul>\n<h4>2.4.5 - 2019-02-18</h4>\n<ul>\n<li>Fix: Image size issue in Testimonial Carousel (<a href=\"https://github.com/elementor/elementor/issues/7058\">#7058</a>)</li>\n<li>Fix: MailChimp groups not saved in a form integration (<a href=\"https://github.com/elementor/elementor/issues/7083\">#7083</a>)</li>\n<li>Fix: Show popup preview only on it\'s own preview</li>\n<li>Fix: Elementor dashboard templates URL corrupted links in edge cases</li>\n</ul>\n<h4>2.4.4 - 2019-02-11</h4>\n<ul>\n<li>Tweak: Added ACF Date Time Picker field support (<a href=\"https://github.com/elementor/elementor/issues/6690\">#6690</a>)</li>\n<li>Tweak: Changed the term of <code>All Posts</code> condition to <code>Posts</code></li>\n<li>Fix: Added <code>&lt;IfModule&gt;</code> to avoid 500 error when <code>mod-headers</code> is missing (<a href=\"https://github.com/elementor/elementor/issues/7034\">#7034</a>)</li>\n<li>Fix: Include post CSS deletion in Global Widget update (<a href=\"https://github.com/elementor/elementor/issues/6856\">#6856</a>)</li>\n<li>Fix: <code>Textarea</code> default value in Forms Widget (<a href=\"https://github.com/elementor/elementor/issues/6934\">#6934</a>)</li>\n<li>Fix: MailPoet latest version caused fatal error (<a href=\"https://github.com/elementor/elementor/issues/6996\">#6996</a>)</li>\n<li>Fix: Fatal Error caused by calling MailPoet deleted method</li>\n<li>Notice: MailPoet <code>Auto Confirm</code> option will now default to &quot;On&quot;</li>\n</ul>\n<h4>2.4.3 - 2019-01-30</h4>\n<ul>\n<li>Fix: Custom Add to Cart widget responsive alignment settings</li>\n<li>Fix: Links in Post Info widget</li>\n<li>Fix: WooCommerce <code>View Cart</code> string translate</li>\n<li>Fix: Wrapper classes for header/footer templates (<a href=\"https://github.com/elementor/elementor/issues/6884\">#6884</a>)</li>\n</ul>\n<h4>2.4.2 - 2019-01-25</h4>\n<ul>\n<li>Tweak: Added pixel units to Close Button position control in Popups</li>\n<li>Fix: Exclude error in WC Products widget</li>\n</ul>\n<h4>2.4.1 - 2019-01-24</h4>\n<ul>\n<li>Tweak: Added CSS classes control to Popup (<a href=\"https://github.com/elementor/elementor/issues/6826\">#6826</a>)</li>\n<li>Tweak: Added responsive image size to Testimonial Carousel widget</li>\n<li>Fix: PHP warning when Toolset Date dynamic is empty (<a href=\"https://github.com/elementor/elementor/issues/6842\">#6842</a>)</li>\n<li>Fix: Support of exclude-ids in WC Products widget</li>\n<li>Fix: Popup close button not clickable</li>\n<li>Fix: Alignment justify issue of Add to Cart widget (<a href=\"https://github.com/elementor/elementor/issues/6749\">#6749</a>)</li>\n<li>Fix: Bad anchors breaks the page JS</li>\n<li>Fix: Popup overlay shown when turned off</li>\n</ul>\n<h4>2.4.0 - 2019-01-21</h4>\n<ul>\n<li>New: Introducing Popup Builder (<a href=\"https://github.com/elementor/elementor/issues/628\">#628</a>)</li>\n<li>New: Added <code>Popup</code> Dynamic Tag</li>\n<li>New: Added <code>Popup</code> forms action after submit</li>\n<li>New: Added User Info dynamic tag (<a href=\"https://github.com/elementor/elementor/issues/6322\">#6322</a>)</li>\n<li>Tweak: Added dynamic capabilities for &quot;Nothing Found&quot; message</li>\n<li>Tweak: Added <code>elementor_pro/theme_builder/archive/escape_nothing_found_message</code> Filter to avoid HTML escaping in &quot;Nothing Found&quot; message (<a href=\"https://github.com/elementor/elementor/issues/6053\">#6053</a>)</li>\n<li>Tweak: Added <code>add_doc_to_location</code> method to Allow insertion of a document to a location</li>\n<li>Fix: <code>z-index</code> issue with CTA widget (<a href=\"https://github.com/elementor/elementor/issues/6486\">#6486</a>)</li>\n<li>Fix: Hide the Post Content widget and show it only in a Single document</li>\n<li>Fix: <code>selector</code> replacement in Custom CSS</li>\n<li>Fix: Apply <code>the_content</code> on the real content only</li>\n<li>Fix: CSS for WC products selector (<a href=\"https://github.com/elementor/elementor/issues/6559\">#6559</a>)</li>\n<li>Fix: Odnoklassniki share URL (<a href=\"https://github.com/elementor/elementor/issues/6638\">#6638</a>)</li>\n<li>Fix: Custom link new tab in Post Info widget (<a href=\"https://github.com/elementor/elementor/issues/5766\">#5766</a>)</li>\n<li>Fix: <code>nofollow</code> link in Flip Box &amp; CTA widgets</li>\n<li>Fix: Post Terms in Post Info widget</li>\n<li>Fix: Added screen reader to some icons &amp; buttons for better accessibility (<a href=\"https://github.com/elementor/elementor/issues/5386\">#5386</a>)</li>\n<li>Fix: Accessibility labels in Reviews widget (<a href=\"https://github.com/elementor/elementor/issues/6630\">#6630</a>)</li>\n<li>Fix: Link to cart page not working when WooCommerce Subscriptions is active</li>\n<li>Fix: MailChimp Selected list not showing on reloading in Form widget</li>\n<li>Fix: Sub-menu arrow position in Nav Menu widget</li>\n<li>Fix: Conflict with WP Security Audit Log plugin (<a href=\"https://github.com/elementor/elementor/issues/6648\">#6648</a>)</li>\n</ul>\n<h4>2.3.1 - 2018-12-19</h4>\n<ul>\n<li>Fix: Template widget search functionality (<a href=\"https://github.com/elementor/elementor/issues/6473\">#6473</a>)</li>\n<li>Fix: Apply <code>the_content</code> filter to post content in theme builder</li>\n</ul>\n<h4>2.3.0 - 2018-12-17</h4>\n<ul>\n<li>New: Introducing Discord Integration for Forms (<a href=\"https://github.com/elementor/elementor/issues/4218\">#4218</a>)</li>\n<li>New: Introducing Slack Integration for Forms</li>\n<li>New: Introducing MailerLite Integration for Forms (<a href=\"https://github.com/elementor/elementor/issues/4462\">#4462</a>)</li>\n<li>New: Activate Elementor Pro plugin by connecting to Elementor account</li>\n<li>Tweak: Added <code>elementor_pro/utils/get_public_post_types</code> filter hook (<a href=\"https://github.com/elementor/elementor/issues/5900\">#5900</a>)</li>\n<li>Tweak: Added <code>loop_start</code> &amp; <code>the_content</code> hooks for Post Content (<a href=\"https://github.com/elementor/elementor/issues/6173\">#6173</a>)</li>\n<li>Tweak: Removed Custom Attributes from Page Settings</li>\n<li>Tweak: Always add the Custom CSS control to the Advanced tab</li>\n<li>Fix: In sub Term condition false positive in edge cases</li>\n<li>Fix: ToolSet Dynamic Image fallback</li>\n<li>Fix: Style glitch with the dropdown color in Nav Menu widget</li>\n<li>Fix: Style glitch in the Conditions screen in Safari browser</li>\n<li>Fix: Ribbon in the CTA widget obscures drop down menu (<a href=\"https://github.com/elementor/elementor/issues/6080\">#6080</a>)</li>\n<li>Fix: The color of label won\'t change color in Widget login</li>\n</ul>\n<h4>2.2.5 - 2018-12-11</h4>\n<ul>\n<li>New: Add Style Tab &amp; Custom CSS for Header &amp; Footer Templates.</li>\n<li>Tweak: Added a better identifier for subpages (<a href=\"https://github.com/elementor/elementor/issues/6362\">#6362</a>)</li>\n<li>Tweak: Removed Custom Attributes from page settings</li>\n<li>Fix: Yahoo event URL date issue (<a href=\"https://github.com/elementor/elementor/issues/6354\">#6354</a>)</li>\n<li>Fix: Allow timezone settings in Google event URL (<a href=\"https://github.com/elementor/elementor/issues/6354\">#6354</a>)</li>\n<li>Fix: Avoid <code>z-index</code> changes by <code>nanocss</code> in build process</li>\n<li>Fix: Added missing WC upsells products CSS</li>\n<li>Fix: Nav Menu dropdown losing color on hover</li>\n<li>Fix: WC Product Add-ons CSS compatibility</li>\n</ul>\n<h4>2.2.4 - 2018-12-04</h4>\n<ul>\n<li>Fix: Global widget not saving changes (<a href=\"https://github.com/elementor/elementor/issues/6340\">#6340</a>)</li>\n<li>Fix: Dynamic tags support in Blockquote widget (<a href=\"https://github.com/elementor/elementor/issues/6334\">#6334</a>)</li>\n<li>Fix: Forms Redirect URL action when using form field values with spaces</li>\n</ul>\n<h4>2.2.3 - 2018-11-29</h4>\n<ul>\n<li>Fix: Missing &quot;Edit Template&quot; in Template widget (<a href=\"https://github.com/elementor/elementor/issues/6271\">#6271</a>)</li>\n<li>Fix: Follow menu anchors with UTF8 characters in Nav Menu</li>\n<li>Fix: Show only supported templates in Template widget</li>\n<li>Fix: Revert conflicting fix for a default order for WC archive</li>\n</ul>\n<h4>2.2.2 - 2018-11-28</h4>\n<ul>\n<li>Fix: Lightbox dynamic tag crashes the editor</li>\n</ul>\n<h4>2.2.1 - 2018-11-28</h4>\n<ul>\n<li>New: Added <code>ACF File</code> Dynamic tag to support text controls.</li>\n<li>Tweak: Added option to hide item count bubble when cart is empty in Menu Cart widget (<a href=\"https://github.com/elementor/elementor/issues/6223\">#6223</a>)</li>\n<li>Tweak: Added Actions group for Lightbox and Contact URL tags</li>\n<li>Tweak: Added filter <code>elementor_pro/dynamic_tags/shortcode/should_escape</code> to avoid escaping in Shortcode dynamic tag</li>\n<li>Tweak: MailPoet3 integration allow Subscriber to to subscribe to multiple lists</li>\n<li>Tweak: Added front-end max file size validation for upload fields</li>\n<li>Tweak: Added <code>by-author</code> per Post-Type condition for theme builder</li>\n<li>Fix: Template widget panel not showing the selected template (<a href=\"https://github.com/elementor/elementor/issues/6271\">#6271</a>)</li>\n<li>Fix: Conflict between ACF with Safari browser on Select option in Dynamic tag</li>\n<li>Fix: Add post classes only for the Single template</li>\n<li>Fix: Set document type as not editable for unsupported document like Global widget</li>\n<li>Fix: Avoid duplicate query for current WC product query</li>\n<li>Fix: Product Archive showing oldest products instead of latest</li>\n<li>Fix: CSS reset in Posts widget using cards skin</li>\n</ul>\n<h4>2.2.0 - 2018-11-19</h4>\n<ul>\n<li>New: Introducing Custom Attributes (<a href=\"https://github.com/elementor/elementor/issues/290\">#290</a>, <a href=\"https://github.com/elementor/elementor/issues/3990\">#3990</a>)</li>\n<li>New: Added evergreen option for Countdown widget (<a href=\"https://github.com/elementor/elementor/issues/4459\">#4459</a>)</li>\n<li>New: Added expire actions option for Countdown widget (<a href=\"https://github.com/elementor/elementor/issues/5242\">#5242</a>)</li>\n<li>New: Introducing Reviews widget (<a href=\"https://github.com/elementor/elementor/issues/3854\">#3854</a>)</li>\n<li>New: Introducing Sitemap widget (<a href=\"https://github.com/elementor/elementor/issues/5594\">#5594</a>)</li>\n<li>New: Added Request Parameter dynamic tag (<a href=\"https://github.com/elementor/elementor/issues/4934\">#4934</a>)</li>\n<li>New: Added Shortcode dynamic tag</li>\n<li>New: Added Image and Video Lightbox dynamic tag</li>\n<li>New: Added Contact URL dynamic tag</li>\n<li>New: Added Featured Image Data dynamic tag</li>\n<li>New: Added default value to each field in the Form widget (<a href=\"https://github.com/elementor/elementor/issues/4268\">#4268</a>)</li>\n<li>New: Added &quot;Any Child Of&quot; condition to template conditions (<a href=\"https://github.com/elementor/elementor/issues/5321\">#5321</a>)</li>\n<li>New: Added &quot;In Child&quot; condition to template conditions (<a href=\"https://github.com/elementor/elementor/issues/5587\">#5587</a>)</li>\n<li>Tweak: Added Form Redirect URL with form values (<a href=\"https://github.com/elementor/elementor/issues/2564\">#2564</a>)</li>\n<li>Tweak: Added default post classes to template wrapper (<a href=\"https://github.com/elementor/elementor/issues/5959\">#5959</a>)</li>\n<li>Tweak: Better labels for terms in Query control (<a href=\"https://github.com/elementor/elementor/issues/6092\">#6092</a>)</li>\n<li>Tweak: Renamed &quot;Child Of&quot; templates condition to &quot;Direct Child Of&quot;</li>\n<li>Tweak: Added <code>elementor/theme/get_location_templates/condition_sub_id</code> filter hook to allow template condition translations</li>\n<li>Tweak: Load the Template Library widget via Ajax for better performance</li>\n<li>Tweak: Added 404 page title for Page Title dynamic tag</li>\n<li>Fix: Menu Cart Toggle has # URL link (<a href=\"https://github.com/elementor/elementor/issues/6141\">#6141</a>)</li>\n<li>Fix: Alignment issue in Nav Menu widget (<a href=\"https://github.com/elementor/elementor/issues/5790\">#5790</a>)</li>\n<li>Fix: Avoid potential security risk in forms</li>\n<li>Fix: Template By Author condition conflicts with 404 page</li>\n<li>Fix: Restored WC Product Content widget in Single Product template</li>\n<li>Fix: Theme Builder Preview URLs for date archives and 404 pages</li>\n<li>Fix: Highlight active menu anchor items only when scrolled into view</li>\n<li>Fix: Carousel Pagination Progress style to support new Swiper version</li>\n</ul>\n<h4>2.1.13 - 2018-11-12</h4>\n<ul>\n<li>Tweak: Added compatibility for new brand Finder in v2.3.0</li>\n<li>Fix: Settings conflict when there are multiple carousels in the page</li>\n</ul>\n<h4>2.1.12 - 2018-11-05</h4>\n<ul>\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.3</li>\n<li>Tweak: Better performance for Template Library widget</li>\n<li>Fix: Fatal error if a taxonomy used in a dynamic field is removed (<a href=\"https://github.com/elementor/elementor/issues/6029\">#6029</a>)</li>\n<li>Fix: Date Time dynamic tag now respect site language (<a href=\"https://github.com/elementor/elementor/issues/6001\">#6001</a>)</li>\n<li>Fix: Custom CSS printed twice in the front-end</li>\n<li>Fix: ACF Image field PHP warning (<a href=\"https://github.com/elementor/elementor/issues/6051\">#6051</a>)</li>\n</ul>\n<h4>2.1.11 - 2018-10-22</h4>\n<ul>\n<li>New: Added ACF local fields compatibility</li>\n<li>Tweak: Re-brand TypeKit by Adobe Fonts integration</li>\n<li>Fix: Exclude <code>is_embed</code> from Singular condition (<a href=\"https://github.com/elementor/elementor/issues/5915\">#5915</a>)</li>\n<li>Fix: Avoid conflict with Ad Blockers and Share Buttons</li>\n<li>Fix: Current date time dynamic tag now shows local time</li>\n<li>Fix: Avoid conflict with 3rd party plugins that filter the permalink</li>\n<li>Fix: Avoid PHP warning when no groups are selected for MailChimp integration</li>\n<li>Fix: Avoid PHP warning if checkbox field is empty for ACF</li>\n<li>Fix: Respect password protected for a WC single product template</li>\n<li>Fix: Respect <code>order</code> settings for WC archive also without pagination</li>\n</ul>\n<h4>2.1.10 - 2018-10-09</h4>\n<ul>\n<li>Tweak: Added responsive alignment control for Share Buttons widget (<a href=\"https://github.com/elementor/elementor/issues/5821\">#5821</a>)</li>\n<li>Tweak: Added link control to Animated Headline widget</li>\n<li>Fix: Mobile nav menu jump on RTL (<a href=\"https://github.com/elementor/elementor/issues/5711\">#5711</a>)</li>\n<li>Fix: Responsive alignment control in Add to Cart widget (<a href=\"https://github.com/elementor/elementor/issues/5830\">#5830</a>)</li>\n<li>Fix: Added IE compatibility for Animated Headline widget</li>\n<li>Fix: Post Content widget is now shown only on <code>Single</code> templates</li>\n<li>Fix: Query Control Pagination with offset</li>\n</ul>\n<h4>2.1.9 - 2018-09-17</h4>\n<ul>\n<li>Tweak: Added Centered Slides option for Slideshow carousel</li>\n<li>Fix: Allow only public CPT for Manual Selection in Query Control (<a href=\"https://github.com/elementor/elementor/issues/5091\">#5091</a>)</li>\n<li>Fix: ACF Gallery option support (<a href=\"https://github.com/elementor/elementor/issues/5344\">#5344</a>)</li>\n<li>Fix: Page scrolling on resize when sticky is active (<a href=\"https://github.com/elementor/elementor/issues/5740\">#5740</a>)</li>\n<li>Fix: Edit custom name for Global Widget in the Navigator (<a href=\"https://github.com/elementor/elementor/issues/5689\">#5689</a>)</li>\n<li>Fix: Coverflow transition effect in Carousel</li>\n<li>Fix: Weird mobile behavior with Cube effect in Carousel</li>\n<li>Fix: Show the first thumbnail in the Slideshow carousel correctly</li>\n</ul>\n<h4>2.1.8 - 2018-09-12</h4>\n<ul>\n<li>Tweak: Added styling options for WC Additional Information widget</li>\n<li>Tweak: Added styling options for \'View Cart\' link in Products widget</li>\n<li>Fix: 3rd party plugin support for WC single product template (<a href=\"https://github.com/elementor/elementor/issues/5338\">#5338</a>)</li>\n<li>Fix: Layout of Related Product widget with WC native style</li>\n</ul>\n<h4>2.1.7 - 2018-09-03</h4>\n<ul>\n<li>New: WC Archive Description widget</li>\n<li>Tweak: Added blend mode to Slides widget background overlay (<a href=\"https://github.com/elementor/elementor/issues/5555\">#5555</a>)</li>\n<li>Tweak: Added \'Current Subcategories\' option to Product Categories widget</li>\n<li>Fix: Added default vertical alignment in Author Box widget (<a href=\"https://github.com/elementor/elementor/issues/5589\">#5589</a>)</li>\n<li>Tweak: Added more blend mode options for CTA widget</li>\n<li>Tweak: Improved plugin updater method based on WordPress version</li>\n<li>Fix: Improved IE compatibility for Posts and Portfolio widgets</li>\n<li>Fix: Added default gap for products pagination</li>\n<li>Fix: Post thumbnail flickering in Safari browser</li>\n<li>Fix: Close mobile nav menu on click only in full-width mode</li>\n<li>Fix: Added trailing slash to pagination links in Posts widget</li>\n</ul>\n<h4>2.1.6 - 2018-08-28</h4>\n<ul>\n<li>New: WC Product Category Image widget and Dynamic tag (<a href=\"https://github.com/elementor/elementor/issues/5117\">#5117</a>)</li>\n<li>Tweak: Allow HTML in Excerpt widget (<a href=\"https://github.com/elementor/elementor/issues/5491\">#5491</a>)</li>\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.2</li>\n<li>Tweak: Deprecated Follow option in the Facebook Button widget</li>\n<li>Fix: Posts widget grid in Safari &amp; IE11 (Depended on Elementor v2.2)</li>\n<li>Fix: Posts widget CSS when using cards skin in masonry mode</li>\n<li>Fix: ACF Image &amp; ACF URL option support (<a href=\"https://github.com/elementor/elementor/issues/5344\">#5344</a>)</li>\n<li>Fix: WC product gallery links in RTL</li>\n<li>Fix: Dynamic tags in Call To Action widget</li>\n</ul>\n<h4>2.1.5 - 2018-08-21</h4>\n<ul>\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.2</li>\n<li>Fix: Posts Widget layout theme compatibility</li>\n<li>Fix: Added compatibility for WooCommerce native style</li>\n</ul>\n<h4>2.1.4 - 2018-08-19</h4>\n<ul>\n<li>Fix: Layout issue compatibility with themes caused by v2.1 (<a href=\"https://github.com/elementor/elementor/issues/5442\">#5442</a>)</li>\n<li>Fix: Dynamic setting in Pricing Table widget (<a href=\"https://github.com/elementor/elementor/issues/5460\">#5460</a>)</li>\n<li>Fix: Hide Target URL control if is not necessary in Blockquote widget</li>\n<li>Fix: Selector specificity for WooCommerce Products widget</li>\n<li>Fix: WooCommerce conflicts in the editor in edge cases</li>\n</ul>\n<h4>2.1.3 - 2018-08-15</h4>\n<ul>\n<li>Fix: Thumbnails in the Posts widget jumping (<a href=\"https://github.com/elementor/elementor/issues/5350\">#5350</a>)</li>\n<li>Fix: Responsive grid in the Share Buttons widget (<a href=\"https://github.com/elementor/elementor/issues/5375\">#5375</a>)</li>\n<li>Fix: Added missing <code>setup_postdata</code> for Product Data Tabs widget</li>\n<li>Fix: Rollback to older version of Flip Box widget to resolve 3D depth issue (<a href=\"https://github.com/elementor/elementor/issues/5399\">#5399</a>)</li>\n<li>Fix: Allowed types in the Upload File field are now case-insensitive (<a href=\"https://github.com/elementor/elementor/issues/5254\">#5254</a>)</li>\n<li>Fix: Carousel behavior when using a single slide</li>\n</ul>\n<h4>2.1.2 - 2018-08-12</h4>\n<ul>\n<li>Fix: Error when ACF Pro is not installed (<a href=\"https://github.com/elementor/elementor/issues/5367\">#5367</a>)</li>\n<li>Fix: Edge cases in Inspector where document is a boolean</li>\n<li>Fix: Edge cases for incorrect file fields in PODS</li>\n</ul>\n<h4>2.1.1 - 2018-08-09</h4>\n<ul>\n<li>Fix: Highlighted text in Animated Headline widget (<a href=\"https://github.com/elementor/elementor/issues/5345\">#5345</a>)</li>\n<li>Fix: Flip Box effect issues</li>\n<li>Fix: ACF Options page fields support (<a href=\"https://github.com/elementor/elementor/issues/5329\">#5329</a>)</li>\n<li>Fix: Import Pro templates in edge cases</li>\n</ul>\n<h4>2.1.0 - 2018-08-07</h4>\n<ul>\n<li>New: Introducing WooCommerce Builder (<a href=\"https://github.com/elementor/elementor/issues/1690\">#1690</a>)</li>\n<li>New: Introducing 12 new dynamic tags &amp; widgets for WooCommerce: Gallery, Image, Price, Rating, Description, Breadcrumbs, Data Tabs, Stock, Related, Upsell, Title &amp; Archive</li>\n<li>New: Introducing Cart Menu widget (<a href=\"https://github.com/elementor/elementor/issues/4220\">#4220</a>, <a href=\"https://github.com/elementor/elementor/issues/4600\">#4600</a>)</li>\n<li>New: Added integration with Toolset (<a href=\"https://github.com/elementor/elementor/issues/2949\">#2949</a>)</li>\n<li>New: Added integration with Pods (<a href=\"https://github.com/elementor/elementor/issues/4129\">#4129</a>)</li>\n<li>New: Added stick to bottom in scrolling effects (<a href=\"https://github.com/elementor/elementor/issues/4799\">#4799</a>)</li>\n<li>New: Added Scrolling Effect to Widgets under advanced tab</li>\n<li>New: Introducing Internal URL Dynamic Tag</li>\n<li>Tweak: Added a Last Updated Date in the Post Info widget (<a href=\"https://github.com/elementor/elementor/issues/4597\">#4597</a>)</li>\n<li>Tweak: Added Redirect after Logout option for Login widget (<a href=\"https://github.com/elementor/elementor/issues/4447\">#4447</a>)</li>\n<li>Tweak: Avoid repeating posts when using more than one in the Posts widget (<a href=\"https://github.com/elementor/elementor/issues/1878\">#1878</a>)</li>\n<li>Tweak: Add Custom Query hook for Query control (<a href=\"https://developers.elementor.com/custom-query-filter/\">More Info</a>) (<a href=\"https://github.com/elementor/elementor/issues/1748\">#1748</a>)</li>\n<li>Tweak: Added form-message style (<a href=\"https://github.com/elementor/elementor/issues/1180\">#1180</a>)</li>\n<li>Tweak: Added dynamic tag for button on the Price Table widget (<a href=\"https://github.com/elementor/elementor/issues/4242\">#4242</a>)</li>\n<li>Tweak: Added dynamic tag for Call to action widget (<a href=\"https://github.com/elementor/elementor/issues/4767\">#4767</a>)</li>\n<li>Tweak: Added Dynamic Tags support for Google Map field (<a href=\"https://github.com/elementor/elementor/issues/4602\">#4602</a>)</li>\n<li>Tweak: Added an support for <code>label|value</code> in options field (<a href=\"https://github.com/elementor/elementor/issues/4594\">#4594</a>)</li>\n<li>Tweak: Added <code>by-author</code> condition for theme builder (<a href=\"https://github.com/elementor/elementor/issues/4681\">#4681</a>)</li>\n<li>Tweak: Added Activate/Deactivate license key via WP-CLI command (<a href=\"https://github.com/elementor/elementor/issues/4149\">#4149</a>)</li>\n<li>Tweak: Added <code>is_scroll</code> trigger to scrolling effect (<a href=\"https://github.com/elementor/elementor/issues/4340\">#4340</a>)</li>\n<li>Tweak: Added In Same Term support for Post Navigation widget (<a href=\"https://github.com/elementor/elementor/issues/4177\">#4177</a>)</li>\n<li>Tweak: Added responsive control for Slides To Scroll control in all carousel widgets (<a href=\"https://github.com/elementor/elementor/issues/3697\">#3697</a>)</li>\n<li>Tweak: Added style options for Posts widget (<a href=\"https://github.com/elementor/elementor/issues/1335\">#1335</a>)</li>\n<li>Tweak: Added button CSS ID for Forms widget</li>\n<li>Tweak: Added pixel units to Post-Info divider height control</li>\n<li>Tweak: Rewrite sticky library to handle with stretch section, auto scroller &amp; more bugs</li>\n<li>Tweak: Re-organize the panel categories per document type</li>\n<li>Tweak: Added ACF support for <code>options-page</code> fields</li>\n<li>Tweak: Added dynamic tag for Animated headlines</li>\n<li>Tweak: Added dynamic tag for BlockQuote widget</li>\n<li>Fix: Elementor Full Width template in GeneratePress theme (<a href=\"https://github.com/elementor/elementor/issues/4817\">#4817</a>)</li>\n<li>Fix: Checkbox fields can accidentally be set to required (<a href=\"https://github.com/elementor/elementor/issues/4324\">#4324</a>)</li>\n<li>Fix: Initial slide in Carousel widget</li>\n<li>Fix: Stay on current slide while editing in Carousel widget</li>\n<li>Fix: Default slides per device in Carousel widget</li>\n<li>Deprecated: Woo Products, Woo Elements &amp; Single elements widgets</li>\n</ul>\n<h4>2.0.18 - 2018-07-27</h4>\n<ul>\n<li>Fix: Global widget error on saving page</li>\n</ul>\n<h4>2.0.17 - 2018-07-26</h4>\n<ul>\n<li>Fix: Sub menu indicator direction in Nav Menu widget</li>\n<li>Fix: Change the title and icon for Global Widget when is moving</li>\n<li>Fix: CSS wrapper selector for Page Document</li>\n</ul>\n<h4>2.0.16 - 2018-07-16</h4>\n<ul>\n<li>Tweak: CSS Filter Control module is now included in Elementor</li>\n<li>Fix: Border gap in Portfolio widget when item gap set as <code>0</code> (<a href=\"https://github.com/elementor/elementor/issues/5077\">#5077</a>)</li>\n<li>Fix: Restore current query after get Global Widget data</li>\n<li>Fix: Add action item in History on unlink Global widget</li>\n</ul>\n<h4>2.0.15 - 2018-07-10</h4>\n<ul>\n<li>Fix: Dropdown menu items collapsing when activated (<a href=\"https://github.com/elementor/elementor/issues/4996\">#4996</a>)</li>\n<li>Fix: GMT offset in Countdown widget (<a href=\"https://github.com/elementor/elementor/issues/4997\">#4997</a>)</li>\n</ul>\n<h4>2.0.14 - 2018-07-08</h4>\n<ul>\n<li>Tweak: Added set method to form record for developers (<a href=\"https://github.com/elementor/elementor/issues/4983\">#4983</a>)</li>\n<li>Fix: Autoplay option for Carousels</li>\n<li>Fix: Close mobile menu on item click in the Nav Menu widget</li>\n</ul>\n<h4>2.0.13 - 2018-07-03</h4>\n<ul>\n<li>Tweak: Added compatibility for Elementor v2.1</li>\n</ul>\n<h4>2.0.12 - 2018-07-02</h4>\n<ul>\n<li>Fix: Global widget PHP notices</li>\n<li>Fix: Slides widget active slide lost focus when clicking Editor tabs</li>\n<li>Fix: Form select field send all selected values on multiple selection</li>\n<li>Fix: Validate time field only if it\'s not empty</li>\n<li>Fix: ConvertKit API not saving name field</li>\n</ul>\n<h4>2.0.11 - 2018-06-12</h4>\n<ul>\n<li>Fix: Theme Builder <code>author</code> archive condition (<a href=\"https://github.com/elementor/elementor/issues/4593\">#4593</a>)</li>\n<li>Fix: Respect password protected posts in Post Content widget</li>\n<li>Fix: Custom Fonts redirect to post edit screen in edge cases.</li>\n</ul>\n<h4>2.0.10 - 2018-06-05</h4>\n<ul>\n<li>Tweak: Added <code>elementor/theme/get_location_templates/template_id</code> filter hook for multi-language plugins</li>\n<li>Fix: Dynamic Post Terms missing taxonomies if the taxonomy is registered to more then one post types (#4386)</li>\n<li>Fix: Fields shortcode missing after removing a field in Form widget</li>\n<li>Deprecated: <code>get_theme_templates_by_location</code> is replaced by <code>get_location_templates</code></li>\n</ul>\n<h4>2.0.9 - 2018-05-28</h4>\n<ul>\n<li>Fix: Compatibility for PHP version 5.4</li>\n</ul>\n<h4>2.0.8 - 2018-05-28</h4>\n<ul>\n<li>Tweak: Added Active state for Nav Menu dropdown</li>\n<li>Tweak: Added style for &quot;Nothing Found&quot; Message for Archive Posts widget</li>\n<li>Tweak: Removed caption control in Site Logo widget</li>\n<li>Tweak: Added option to position currency symbol before/after In Price Table widget</li>\n<li>Fix: Query control manual selection does not show more than 10 items (<a href=\"https://github.com/elementor/elementor/issues/4479\">#4479</a>)</li>\n<li>Fix: Styling glitch with terms list in Post Info widget (<a href=\"https://github.com/elementor/elementor/issues/4342\">#4342</a>)</li>\n<li>Fix: Sub terms missing in Query control in edge cases (<a href=\"https://github.com/elementor/elementor/issues/4527\">#4527</a>)</li>\n<li>Fix: Avoid rendering a template if it\'s not published</li>\n<li>Fix: 404 Page style not working</li>\n<li>Fix: Price Table button with hover animation not working in editor</li>\n<li>Fix: Styling conflict in Call to Action widget</li>\n<li>Fix: Global Widget tab translation</li>\n<li>Fix: Adding parent wrapper class to Site Title widget</li>\n</ul>\n<h4>2.0.7 - 2018-05-16</h4>\n<ul>\n<li>Fix: Content not found on section when single is set to &quot;All Singular&quot;</li>\n<li>Fix: Open 404 template library for 404 page</li>\n<li>Tweak: Added CSS prefix for dev files</li>\n<li>Tweak: Removed product post type from display conditions</li>\n</ul>\n<h4>2.0.6 - 2018-05-15</h4>\n<ul>\n<li>Tweak: Set type on create new single template</li>\n<li>Tweak: Always show the conditions dialog in the Draft status</li>\n<li>Tweak: Added document type <code>widget</code></li>\n<li>Tweak: Added Post Custom Field tag to URL category</li>\n<li>Fix: When ACF Field Groups are Empty (<a href=\"https://github.com/elementor/elementor/issues/4428\">#4428</a>)</li>\n<li>Fix: Links inside carousel in edge cases</li>\n<li>Fix: Responsive issue in My Templates area</li>\n<li>Fix: Image alignment for post content with text alignment</li>\n<li>Fix: Post Content widget when preview post is missing</li>\n<li>Fix: Global Widget tab translation</li>\n<li>Fix: Style settings for Post / Archive Title widgets</li>\n</ul>\n<h4>2.0.5 - 2018-05-08</h4>\n<ul>\n<li>Fix: Creating a CPT with name like document-type breaks the editor (<a href=\"https://github.com/elementor/elementor/issues/4203\">#4203</a>)</li>\n<li>Fix: Added support for new version of reCAPTCHA</li>\n<li>Fix: Added fallback for controls after <code>post_status</code></li>\n<li>Fix: Required field in forms widget</li>\n<li>Fix: Media Carousel in the Coverflow skin</li>\n<li>Fix: 404 Page show wrong template in edge cases</li>\n<li>Fix: Save the default menu in the Nav Menu widget</li>\n</ul>\n<h4>2.0.4 - 2018-05-02</h4>\n<ul>\n<li>Tweak: Added parent\'s class for extended widgets</li>\n<li>Tweak: Set entire-site as default to avoid conflict with save without conditions</li>\n<li>Tweak: Initialize global model when it\'s needed</li>\n<li>Tweak: Removed some duplicate strings</li>\n<li>Tweak: Query control now includes empty terms</li>\n<li>Tweak: Design polish for conditions dialog</li>\n<li>Tweak: Decreasing <code>minimumInputLength</code> to 1 of select2</li>\n<li>Fix: Editor not loading for single templates in edge cases</li>\n<li>Fix: Select2 in Safari takes it\'s time to get the original select width (<a href=\"https://github.com/elementor/elementor/issues/4310\">#4310</a>)</li>\n<li>Fix: Slides per view not working for some effects</li>\n<li>Fix: New slides not showing in the editor</li>\n<li>Fix: Editor for section without a defined location, defaults to content area</li>\n</ul>\n<h4>2.0.3 - 2018-04-24</h4>\n<ul>\n<li>Tweak: Optimize CSS for Post Info widget (<a href=\"https://github.com/elementor/elementor/issues/4214\">#4214</a>, <a href=\"https://github.com/elementor/elementor/issues/4216\">#4216</a>, <a href=\"https://github.com/elementor/elementor/issues/4225\">#4225</a>)</li>\n<li>Fix: Double render on frontend view in core locations</li>\n<li>Fix: Masonry not working in edge cases</li>\n<li>Fix: Added default setting for Author Info tag</li>\n</ul>\n<h4>2.0.2 - 2018-04-18</h4>\n<ul>\n<li>Fix: Regenerate conditions to include all templates</li>\n</ul>\n<h4>2.0.1 - 2018-04-17</h4>\n<ul>\n<li>Tweak: Added div wrapper for Nothing Found massage (<a href=\"https://github.com/elementor/elementor/issues/4136\">#4136</a>)</li>\n<li>Tweak: Show empty categories in Query Control &amp; Display Conditions (<a href=\"https://github.com/elementor/elementor/issues/4127\">#4127</a>)</li>\n<li>Tweak: Added Divider control for Post Info widget</li>\n<li>Fix: Update admin links in Yoast Breadcrumbs widget</li>\n<li>Fix: Sticky element conflict with clearfix CSS</li>\n<li>Fix: Compatibility for PHP version 5.4.32 &amp; 5.5.16 and below</li>\n<li>Fix: Avoid running <code>wp_head</code> hooks twice</li>\n</ul>\n<h4>2.0.0 - 2018-04-16</h4>\n<ul>\n<li>New: Introducing Theme Builder - <a href=\"https://elementor.com/introducing-theme-builder/\">Release Post</a> (<a href=\"https://github.com/elementor/elementor/issues/417\">#417</a>)</li>\n<li>New: Introducing Locations API to inject custom location templates</li>\n<li>New: Introducing Display Conditions for all dynamic templates</li>\n<li>New: Introducing Dynamic Tag feature - a new way to add dynamic content to your design</li>\n<li>New: Introducing Role manager to allow &quot;Content Only mode&quot; (<a href=\"https://github.com/elementor/elementor/issues/483\">#483</a>, <a href=\"https://github.com/elementor/elementor/issues/653\">#653</a>, <a href=\"https://github.com/elementor/elementor/issues/885\">#885</a>)</li>\n<li>New: Introducing 9 new dynamic widgets: Archive Posts, Archive Title, Post Content, Post Info, Post Title, Post Excerpt, Featured Image, Site Logo &amp; Site Name (<a href=\"https://github.com/elementor/elementor/issues/543\">#543</a>)</li>\n<li>New: Introducing Developers area with guides and API documentation - <a href=\"https://elementor.com/introducing-elementor-developer-api/\">Release Post</a> (<a href=\"https://github.com/elementor/elementor/issues/451\">#451</a>)</li>\n<li>New: Introducing <a href=\"https://github.com/elementor/elementor-hello-theme\">Elementor Hello Theme</a> - A demonstration theme for developers</li>\n<li>New: Added new type of templates: Header, Footer, Single and Archive (<a href=\"https://github.com/elementor/elementor/issues/2761\">#2761</a>, <a href=\"https://github.com/elementor/elementor/issues/2623\">#2623</a>, <a href=\"https://github.com/elementor/elementor/issues/2109\">#2109</a>, <a href=\"https://github.com/elementor/elementor/issues/2061\">#2061</a>, <a href=\"https://github.com/elementor/elementor/issues/2439\">#2439</a>)</li>\n<li>New: Design 404 page with Single template (<a href=\"https://github.com/elementor/elementor/issues/1558\">#1558</a>)</li>\n<li>New: Design Search Results with Archive template (<a href=\"https://github.com/elementor/elementor/issues/3196\">#3196</a>, <a href=\"https://github.com/elementor/elementor/issues/2590\">#2590</a>)</li>\n<li>New: Added Scrolling Effect for sections including <em>Sticky Element</em> per device (<a href=\"https://github.com/elementor/elementor/issues/2412\">#2412</a>)</li>\n<li>New: Integration with Custom Fields (<a href=\"https://github.com/elementor/elementor/issues/2054\">#2054</a>)</li>\n<li>New: Partial support for Toolset integration (<a href=\"https://github.com/elementor/elementor/issues/2949\">#2949</a>)</li>\n<li>New: Partial support for Pods integration (<a href=\"https://github.com/elementor/elementor/issues/2169\">#2169</a>)</li>\n<li>New: Partial support for ACF integration (<a href=\"https://github.com/elementor/elementor/issues/2041\">#2041</a>, <a href=\"https://github.com/elementor/elementor/issues/2059\">#2059</a>)</li>\n<li>Tweak: Add custom fields support for ActiveCampaign (<a href=\"https://github.com/elementor/elementor/issues/3531\">#3531</a>)</li>\n<li>Tweak: Allow brackets in Forms Tel field</li>\n<li>Tweak: Added currency format control for Price Table widget</li>\n<li>Tweak: Reduced API request for some servers</li>\n<li>Fix: Dropdown <code>border-radius</code> in Nav Menu widget</li>\n<li>Fix: Price List widget layout breaks in edge cases</li>\n<li>Note: This version requires Elementor v2.0.6</li>\n</ul>\n<h4>1.15.6 - 2018-03-28</h4>\n<ul>\n<li>Fix: Removed duplicate Custom CSS section (<a href=\"https://github.com/elementor/elementor/issues/3938\">#3938</a>)</li>\n<li>Fix: <code>box-shadow</code> issue with cards skin (<a href=\"https://github.com/elementor/elementor/issues/3940\">#3940</a>)</li>\n</ul>\n<h4>1.15.5 - 2018-03-27</h4>\n<ul>\n<li>Fix: Added global widget compatibility for Elementor v2.0</li>\n<li>Fix: Reduced API request for some servers</li>\n</ul>\n<h4>1.15.4 - 2018-03-26</h4>\n<ul>\n<li>Tweak: Allow brackets in phone field</li>\n<li>Tweak: Added compatibility with Yoast 7.0.+</li>\n<li>Tweak: Added compatibility for the future release of Elementor v2.0</li>\n<li>Fix: Support for multiple carousel setting in editor</li>\n<li>Fix: <code>on_export</code> issue in forms widget (<a href=\"https://github.com/elementor/elementor/issues/3890\">#3890</a>)</li>\n</ul>\n<h4>1.15.3 - 2018-03-07</h4>\n<ul>\n<li>Tweak: Added unique class to field group div (<a href=\"https://github.com/elementor/elementor/issues/3595\">#3595</a>)</li>\n<li>Fix: Screen Options missing when Pro is active (<a href=\"https://github.com/elementor/elementor/issues/3622\">#3622</a>)</li>\n<li>Fix: Allow label styling even when <code>show labels</code> is set hide (<a href=\"https://github.com/elementor/elementor/issues/3544\">#3544</a>)</li>\n<li>Fix: Typography control not working in edge cases</li>\n<li>Fix: Safari compatibility for Search widget</li>\n</ul>\n<h4>1.15.2 - 2018-02-27</h4>\n<ul>\n<li>Fix: Only add support mine-type if needed (<a href=\"https://github.com/elementor/elementor/issues/3543\">#3543</a>)</li>\n<li>Fix: Better support for Old Typekit kits</li>\n</ul>\n<h4>1.15.1 - 2018-02-21</h4>\n<ul>\n<li>Tweak: Custom font title placeholder is not <code>enter font family</code></li>\n<li>Tweak: Custom font title set as required</li>\n<li>Fix: Custom font, <code>font-face</code> enqueued only once if used in global (<a href=\"https://github.com/elementor/elementor/issues/3513\">#3513</a>)</li>\n<li>Fix: Added workaround for upload validation which relies on a PHP extension (fileinfo) with inconsistent reporting behavior.</li>\n</ul>\n<h4>1.15.0 - 2018-02-19</h4>\n<ul>\n<li>New: Added custom fonts manager for self hosted fonts (<a href=\"https://github.com/elementor/elementor/issues/852\">#852</a>)</li>\n<li>New: Integration with Adobe TypeKit fonts (<a href=\"https://github.com/elementor/elementor/issues/631\">#631</a>)</li>\n<li>Tweak: Clear menu from Nav Menu widget on template export</li>\n<li>Tweak: Allow zero for GetResponse integration as <code>day of cycle</code></li>\n</ul>\n<h4>1.14.2 - 2018-02-13</h4>\n<ul>\n<li>Fix: Global widget content that got affected by previous update</li>\n</ul>\n<h4>1.14.1 - 2018-02-13</h4>\n<ul>\n<li>Tweak: Added <code>none</code> option to content animation in CTA widget</li>\n<li>Tweak: Added <code>form_id</code> to ActiveCampaign integration (<a href=\"https://github.com/elementor/elementor/issues/3422\">#3422</a>)</li>\n<li>Fix: Page crashed when Global widget not found.</li>\n</ul>\n<h4>1.14.0 - 2018-02-12</h4>\n<ul>\n<li>New: Added Call to Action widget</li>\n<li>Tweak: MailPoet pull field mapping from MailPoet instead of hardcoded</li>\n<li>Tweak: Added compatibility for the future release of Elementor v2.0</li>\n<li>Fix: Allow zero (0) to be accepted as a field value</li>\n<li>Fix: Login form when custom login URL is set</li>\n<li>Fix: Added Day of cycle control to GetResponse integration</li>\n</ul>\n<h4>1.13.2 - 2018-01-23</h4>\n<ul>\n<li>Tweak: Added placeholder to Password field</li>\n<li>Tweak: Removed <code>subscriber_already_exists_message</code> control to prevent potential data leakage</li>\n<li>Fix: MailPoet Subscriber Already Exists error validation against translated string directly from MailPoet</li>\n<li>Fix: Changed <code>imagesLoaded()</code> to Vanilla JS to avoid compatibility issues with some themes</li>\n<li>Fix: Only validate Tel field if not empty</li>\n<li>Fix: Stop slider while editing</li>\n</ul>\n<h4>1.13.1 - 2018-01-16</h4>\n<ul>\n<li>Fix: Added compatibility with old PHP versions</li>\n</ul>\n<h4>1.13.0 - 2018-01-16</h4>\n<ul>\n<li>New: Added File Upload field for Forms widget (<a href=\"https://github.com/elementor/elementor/issues/1482\">#1482</a>, <a href=\"https://github.com/elementor/elementor/issues/2974\">#2974</a>)</li>\n<li>New: Added Acceptance field for Forms widget (<a href=\"https://github.com/elementor/elementor/issues/1693\">#1693</a>, <a href=\"https://github.com/elementor/elementor/issues/2974\">#2974</a>)</li>\n<li>New: Added Date field for Forms widget (<a href=\"https://github.com/elementor/elementor/issues/1868\">#1868</a>)</li>\n<li>New: Added Time field for Forms widget</li>\n<li>New: Added Password field for Forms widget (<a href=\"https://github.com/elementor/elementor/issues/2164\">#2164</a>)</li>\n<li>New: Added HTML field for Forms widget (<a href=\"https://github.com/elementor/elementor/issues/1500\">#1500</a>)</li>\n<li>Tweak: Added characters validation for Tel field</li>\n<li>Tweak: Added min &amp; max validation for Number field</li>\n<li>Tweak: Added multiple selection for Select field</li>\n<li>Tweak: Added donReach integration for Share Buttons widget</li>\n</ul>\n<h4>1.12.3 - 2018-01-09</h4>\n<ul>\n<li>Fix: Render element plain content instead of parsed content when not needed in global widget</li>\n<li>Fix: Apply <code>url-encoding</code> to &quot;Tweet&quot; button text in Blockquote widget to prevent unexpected corruption of the tweet text</li>\n<li>Fix: Removed My Account link from dashboard widget</li>\n</ul>\n<h4>1.12.2 - 2018-01-03</h4>\n<ul>\n<li>Tweak: Added animation none for Nav Menu widget (<a href=\"https://github.com/elementor/elementor/issues/2964\">#2964</a>)</li>\n<li>Fix: Active license button style</li>\n</ul>\n<h4>1.12.1 - 2018-01-02</h4>\n<ul>\n<li>Tweak: Removed theme-element widgets from plain content</li>\n<li>Tweak: Set all theme-element widgets to extend same widget Base</li>\n<li>Tweak: Removed credit URL in forms meta data</li>\n<li>Tweak: Added compatibility for the future release of Elementor v1.9</li>\n<li>Fix: Validate Get response Error as real error</li>\n<li>Fix: Removed responsive height control from Facebook Page widget</li>\n</ul>\n<h4>1.12.0 - 2017-12-20</h4>\n<ul>\n<li>New: Added Drip integration to Forms</li>\n<li>New: Added ActiveCampaign integration to Forms</li>\n<li>New: Added ConverKit integration to Forms</li>\n<li>New: Added GetResponse integration to Forms</li>\n<li>New: Added form <code>id</code>, <code>name</code> attributes to handle integration with auto collectors like HubSpot</li>\n<li>New: Added Global API key for MailChimp to improve the workflow</li>\n<li>Tweak: Better error handling and message display for Forms</li>\n<li>Fix: PHP notice Undefined variable <code>$cc_header</code> (<a href=\"https://github.com/elementor/elementor/issues/2934\">#2934</a>)</li>\n</ul>\n<h4>1.11.0 - 2017-12-11</h4>\n<ul>\n<li>New: Added a native Comments widget (<a href=\"https://github.com/elementor/elementor/issues/543\">#543</a>)</li>\n<li>New: Added an Author Box widget</li>\n<li>New: Added a Post Navigation widget</li>\n<li>New: Added a Yoast Breadcrumbs widget (<a href=\"https://github.com/elementor/elementor/issues/2749\">#2749</a>)</li>\n<li>Tweak: Added a close button to search widget under Full Screen skin (<a href=\"https://github.com/elementor/elementor/issues/2762\">#2762</a>)</li>\n<li>Fix: Allow currency symbol to appear even if price isn\'t numeric</li>\n<li>Fix: Edge cases when the nav menu is empty in a stretched section</li>\n<li>Fix: Added fallback when you remove the <code>space-between</code> on Swiper carousel</li>\n</ul>\n<h4>1.10.2 - 2017-12-03</h4>\n<ul>\n<li>Fix: Missing save widget icon (<a href=\"https://github.com/elementor/elementor/issues/2878\">#2878</a>)</li>\n<li>Fix: Global widgets not saving edits (<a href=\"https://github.com/elementor/elementor/issues/2874\">#2874</a>)</li>\n<li>Fix: Removed <code>white-space: nowrap;</code> property from vertical menu in Nav Menu widget (<a href=\"https://github.com/elementor/elementor/issues/2815\">#2815</a>)</li>\n</ul>\n<h4>1.10.1 - 2017-11-30</h4>\n<ul>\n<li>Tweak: Added default value for search form</li>\n<li>Tweak: Order template list A-Z in the library widget</li>\n<li>Tweak: get_users/authors query is now done using AJAX only, for better performance in Query Control (<a href=\"https://github.com/elementor/elementor/issues/2865\">#2865</a>)</li>\n<li>Fix: When adding <code>.00</code> it is not displayed on the front</li>\n<li>Fix: Make sure space between is numeric for carousel control</li>\n<li>Fix: Added space for radio &amp; checkbox fields in form widget</li>\n</ul>\n<h4>1.10.0 - 2017-11-15</h4>\n<ul>\n<li>New: Added native Search form widget (<a href=\"https://github.com/elementor/elementor/issues/2576\">#2576</a>)</li>\n<li>Tweak: Added Slides To Scroll &amp; Loop controls to Media Carousel and Testimonials widgets</li>\n<li>Tweak: Added Inline editing to Blockquote widget</li>\n<li>Fix: Animated Headline color bug (<a href=\"https://github.com/elementor/elementor/issues/2516\">#2516</a>)</li>\n<li>Fix: Animated Headline with Rotating skin</li>\n<li>Fix: RTL fix for Animated Headline widget in \'typing\' and \'clip\' animations</li>\n<li>Fix: Empty menu cause jQuery to crash in Menu widget (<a href=\"https://github.com/elementor/elementor/issues/2662\">#2662</a>)</li>\n<li>Fix: Custom CSS gone after reloading the editor</li>\n</ul>\n<h4>1.9.5 - 2017-10-27</h4>\n<ul>\n<li>Fix: Broken Global widget with JS (<a href=\"https://github.com/elementor/elementor/issues/2639\">#2639</a>)</li>\n</ul>\n<h4>1.9.4 - 2017-10-24</h4>\n<ul>\n<li>Tweak: Improved UI for notices and license page</li>\n<li>Fix: Update system conflict with other EDD plugins</li>\n<li>Fix: WooCommerce frontend hooks on Elementor editor (<a href=\"https://github.com/elementor/elementor/issues/2577\">#2577</a>)</li>\n<li>Fix: Removed default border left in Nav Menu dropdown CSS (<a href=\"https://github.com/elementor/elementor/issues/2496\">#2496</a>)</li>\n<li>Fix: Increased submenu max-width (<a href=\"https://github.com/elementor/elementor/issues/2558\">#2558</a>)</li>\n<li>Fix: Save global templates without their defaults</li>\n<li>Fix: Horizontal scrolling issue with posts grid</li>\n</ul>\n<h4>1.9.3 - 2017-10-03</h4>\n<ul>\n<li>Fix: Condition slide style that got affected by previous update</li>\n</ul>\n<h4>1.9.2 - 2017-10-02</h4>\n<ul>\n<li>New: Added integration with MailPoet 3 for Forms actions</li>\n<li>Fix: Removed height control from Testimonial carousel in mobile editing mode</li>\n<li>Fix: Removed bottom padding when there\'s no pagination in Testimonial carousel</li>\n<li>Fix: Added condition for slides style section in skin bubble mode</li>\n<li>Fix: Slides per view control for mobile editing in Testimonial carousel</li>\n<li>Fix: Navigation Arrows icons matched with common Elementor Navigation Arrows</li>\n</ul>\n<h4>1.9.1 - 2017-09-28</h4>\n<ul>\n<li>Fix: Slides per view for slideshow carousel</li>\n<li>Fix: Final polish for the new Testimonial Carousel widget</li>\n<li>Fix: Don\'t play video if slide type is not video</li>\n<li>Fix: Removed slides style section condition (<a href=\"https://github.com/elementor/elementor/issues/2497\">#2497</a>)</li>\n<li>Fix: Set cursor as pointer for slideshow thumbnails</li>\n</ul>\n<h4>1.9.0 - 2017-09-26</h4>\n<ul>\n<li>New: Added Media Carousel widget (<a href=\"https://github.com/elementor/elementor/issues/216\">#216</a>, <a href=\"https://github.com/elementor/elementor/issues/347\">#347</a>, <a href=\"https://github.com/elementor/elementor/issues/2209\">#2209</a>)</li>\n<li>New: Added Testimonial Carousel widget (<a href=\"https://github.com/elementor/elementor/issues/715\">#715</a>)</li>\n</ul>\n<h4>1.8.3 - 2017-09-24</h4>\n<ul>\n<li>Fix: Added compatibility for WordPress 4.8.2 &amp; 4.7.6</li>\n<li>Fix: Remove slashes from Form sent data</li>\n</ul>\n<h4>1.8.2 - 2017-09-19</h4>\n<ul>\n<li>Tweak: Added target URL for the tweet message in Blockquote widget</li>\n<li>Tweak: Render the slide height before the slider is finished loading</li>\n<li>Fix: Space between words for Animated Headline widget</li>\n<li>Fix: RTL compatibility for Animated Headline widget</li>\n<li>Fix: Italic font style for Animated Headline widget</li>\n<li>Fix: Excluded Menu widget from the WP Editor text rendering</li>\n</ul>\n<h4>1.8.1 - 2017-09-18</h4>\n<ul>\n<li>Fix: WCAG Compatible &quot;required&quot; field attribute for W3C validation (<a href=\"https://github.com/elementor/elementor/issues/2391\">#2391</a>)</li>\n<li>Fix: Print the main menu only when is necessary in Menu widget</li>\n<li>Fix: Use CSS media query instead of JS to hide items in Menu widget to avoid flickering on page load (<a href=\"https://github.com/elementor/elementor/issues/2381\">#2381</a>)</li>\n</ul>\n<h4>1.8.0 - 2017-09-12</h4>\n<ul>\n<li>New: Added Nav Menu widget (<a href=\"https://github.com/elementor/elementor/issues/1406\">#1406</a>)</li>\n<li>Fix: Field ID for checkbox control in Form widget (<a href=\"https://github.com/elementor/elementor/issues/2279\">#2279</a>)</li>\n<li>Fix: Style for Blockquote widget included</li>\n</ul>\n<h4>1.7.2 - 2017-09-07</h4>\n<ul>\n<li>Tweak: Loading Facebook SDK via JS for better compatibility with caching plugins</li>\n<li>Fix: Responsive Embed Facebook post widget for Safari iOS (<a href=\"https://github.com/elementor/elementor/issues/2340\">#2340</a>)</li>\n</ul>\n<h4>1.7.1 - 2017-09-05</h4>\n<ul>\n<li>Fix: Facebook SDK version</li>\n</ul>\n<h4>1.7.0 - 2017-09-05</h4>\n<ul>\n<li>New: Added Facebook Button widget for Like, Recommend, Share and Follow</li>\n<li>New: Added Facebook Embed widget for Post, Video and Comment</li>\n<li>New: Added Facebook Comments widget</li>\n<li>New: Added Facebook Page widget (Previously known as Like Box)</li>\n<li>New: Added Blockquote widget with Tweet button</li>\n<li>Tweak: Added Facebook SDK integration for all Facebook widgets</li>\n<li>Fix: Animated headline rotating with long words</li>\n</ul>\n<h4>1.6.1 - 2017-08-28</h4>\n<ul>\n<li>Fix: Animated Headline marker gets in front of neighboring spans even when &quot;Bring to Front&quot; is not set</li>\n<li>Fix: Stroke animation in Animated Headline for MS Edge browser</li>\n<li>Fix: Animated headline with more than 1-word per rotation</li>\n<li>Fix: Animated Headline in two lines</li>\n<li>Fix: Some errors in Global widget</li>\n</ul>\n<h4>1.6.0 - 2017-08-22</h4>\n<ul>\n<li>New: Added Animated Headline widget</li>\n<li>New: Added Hidden field for Forms widget (<a href=\"https://github.com/elementor/elementor/issues/2038\">#2038</a>)</li>\n<li>Tweak: Added notice to update Elementor to v1.6.5 or higher</li>\n<li>Fix: CSS Animations names no longer minified, in order to prevent unexpected conflicts</li>\n</ul>\n<h4>1.5.9 - 2017-08-16</h4>\n<ul>\n<li>Tweak: Added compatibility for the future release of Elementor v1.7</li>\n<li>Fix: Portfolio compatibility for GeneratePress theme</li>\n<li>Fix: Portfolio filter compatibility for RTL</li>\n<li>Fix: Pagination apply for all posts widget in the page</li>\n<li>Fix: Global form widget with MailChimp integration not saving</li>\n</ul>\n<h4>1.5.8 - 2017-07-25</h4>\n<ul>\n<li>Tweak: Added compatibility for the future release of Elementor v1.6</li>\n<li>Fix: Improved backward compatibility for query control rename</li>\n</ul>\n<h4>1.5.7 - 2017-07-24</h4>\n<ul>\n<li>Tweak: Moved JS render of reCAPTCHA to a separate file</li>\n<li>Tweak: Display the label in the reCAPTCHA field for better experience</li>\n<li>Tweak: Rename <code>panel-posts-control</code> to <code>query-control</code> and added fallback support</li>\n<li>Tweak: Added compatibility for the future release of Elementor with history feature</li>\n<li>Fix: reCAPTCHA preview on the editor</li>\n<li>Fix: Manual selection (query control) has stopped working after saving (<a href=\"https://github.com/elementor/elementor/issues/2000\">#2000</a>)</li>\n<li>Fix: Added condition for icon size control in Share Buttons widget</li>\n</ul>\n<h4>1.5.6 - 2017-07-12</h4>\n<ul>\n<li>Fix: Query Control correction for taxonomies (<a href=\"https://github.com/elementor/elementor/issues/1963\">#1963</a>)</li>\n<li>Fix: Custom CSS override scheme color in the editor</li>\n<li>Fix: Added order by Menu Order for Query Control in WC widget</li>\n<li>Fix: Glitch with Flip Box background overlay</li>\n</ul>\n<h4>1.5.5 - 2017-07-03</h4>\n<ul>\n<li>Tweak: Moved reCAPTCHA render to handler &amp; load only if a form is exist</li>\n<li>Fix: MailChimp integration: Default number of items returned by API increased to 999</li>\n<li>Fix: MailChimp integration: Refresh the groups list if API is changed</li>\n<li>Fix: Sorted items in filter bar by A-Z</li>\n<li>Fix: Editor glitch with Elementor v1.5 (<a href=\"https://github.com/elementor/elementor/issues/1927\">#1927</a>)</li>\n</ul>\n<h4>1.5.4 - 2017-06-22</h4>\n<ul>\n<li>Tweak: Improved compatibility for Elementor v1.5</li>\n<li>Fix: URL default for Add To Cart widget</li>\n<li>Fix: Allowed <code>date</code> and <code>birthday</code> fields as text for MailChimp integration</li>\n</ul>\n<h4>1.5.3 - 2017-06-19</h4>\n<ul>\n<li>Tweak: Make flip-box height responsive control</li>\n<li>Fix: Facebook share count now gets retrieved by Elementor (<a href=\"https://github.com/elementor/elementor/issues/1829\">#1829</a>)</li>\n<li>Fix: Global form widget with MailChimp integration not saving</li>\n</ul>\n<h4>1.5.2 - 2017-06-13</h4>\n<ul>\n<li>Fix: Custom CSS panel location compatibility for the old versions</li>\n</ul>\n<h4>1.5.1 - 2017-06-12</h4>\n<ul>\n<li>Fix: MailChimp update existing user registration</li>\n<li>Fix: Global widget with JS in the editor mode</li>\n<li>Fix: Label section condition in Login widget</li>\n<li>Fix: Changes to unlinked global widget do not appear in the editor</li>\n</ul>\n<h4>1.5.0 - 2017-05-23</h4>\n<ul>\n<li>New: Added Cards, a new skin for Posts widget</li>\n<li>New: Added Exclude option to post query control group</li>\n<li>Tweak: Added <code>post_class()</code> for each post in the loop</li>\n<li>Tweak: Added <code>.elementor-posts-masonry</code> class when Masonry layout is enabled</li>\n<li>Tweak: Added compatibility for the next release of Elementor v1.5.0</li>\n<li>Tweak: CSS <code>autoprefixer</code> now supports last 5 versions of browsers</li>\n<li>Tweak: Added <code>imageLoaded</code> library for Posts &amp; Portfolio widgets</li>\n</ul>\n<h4>1.4.4 - 2017-05-18</h4>\n<ul>\n<li>Fix: Force Mailchimp API to return all lists and not just 10 (<a href=\"https://github.com/elementor/elementor/issues/1683\">#1683</a>)</li>\n<li>Fix: Added <code>.elementor-form</code> class to Login form to fix style glitch</li>\n</ul>\n<h4>1.4.3 - 2017-05-14</h4>\n<ul>\n<li>Tweak: Added Redirect After Login option to Login widget</li>\n<li>Tweak: Stay in the current page after logout in Login widget</li>\n<li>Tweak: Preparation for Elementor settings tabs in future version</li>\n<li>Fix: Pinterest in Share Buttons widget now sharing the URL alone</li>\n<li>Fix: Bug with <code>active</code> class in portfolio filter item</li>\n<li>Fix: Higher specific list-style-type <code>none</code> for filter items to override some theme style</li>\n</ul>\n<h4>1.4.2 - 2017-05-06</h4>\n<ul>\n<li>Fix: Temporary patch for form field shortcode in some servers</li>\n</ul>\n<h4>1.4.1 - 2017-05-03</h4>\n<ul>\n<li>Fix: Bug with custom success message in form widget</li>\n<li>Fix: Bug with meta data in email action</li>\n</ul>\n<h4>1.4.0 - 2017-05-03</h4>\n<ul>\n<li>New: Forms: integration with MailChimp</li>\n<li>New: Forms: integration with MailPoet</li>\n<li>New: Forms: Added Email 2 action for email confirmation</li>\n<li>New: Forms: Added shortcodes for fields</li>\n<li>New: Forms: Added custom ID for fields</li>\n<li>New: Forms: Added option to edit email HTML template (<a href=\"https://github.com/elementor/elementor/issues/1180\">#1180</a>)</li>\n<li>New: Added Login widget</li>\n<li>Tweak: Move <code>send_html</code> control to <code>email_content_type</code></li>\n<li>Fix: Email still sent even if validation failed in form widget</li>\n</ul>\n<h4>1.3.2 - 2017-05-01</h4>\n<ul>\n<li>New: Added action <code>elementor_pro/init</code> for better integration with Elementor Pro</li>\n<li>Fix: Posts without featured image in Posts widget (<a href=\"https://github.com/elementor/elementor/issues/1234\">#1234</a>, <a href=\"https://github.com/elementor/elementor/issues/1382\">#1382</a>)</li>\n<li>Fix: reCAPTCHA &amp; Honeypot fields with new method</li>\n<li>Fix: Added border width control in Share Buttons to avoid a glitch on Chrome browser</li>\n<li>Fix: Border radius glitch on hover in Share Buttons</li>\n</ul>\n<h4>1.3.1 - 2017-04-25</h4>\n<ul>\n<li>Fix: Conflict update with revision history module</li>\n</ul>\n<h4>1.3.0 - 2017-04-25</h4>\n<ul>\n<li>New: Added Share Buttons widget (<a href=\"https://wordpress.org/support/topic/social-sharing-buttons-is-it-possible/\">Topic</a>)</li>\n<li>New: Added Custom CSS for Page Settings</li>\n<li>New: Added Masonry layout for Portfolio widget</li>\n<li>New: Added Cc &amp; Bcc options to email action (<a href=\"https://github.com/elementor/elementor/issues/1181\">#1181</a>)</li>\n<li>New: Introduced <code>ElementorPro\\Modules\\Forms\\Classes\\Action_Base</code> class for better 3rd party integration for forms</li>\n<li>Tweak: Debugger module now also shows errors from Pro</li>\n<li>Tweak: Added options for Elementor Library</li>\n<li>Tweak: New base posts module for optimized performance</li>\n<li>Tweak: Adjusting Posts / Portfolio to the new structure</li>\n<li>Fix: Export for posts / portfolio</li>\n<li>Fix: Duplicate repeater field with switcher control (<a href=\"https://github.com/elementor/elementor/issues/1442\">#1442</a>)</li>\n<li>Fix: Post per Page in the query control</li>\n<li>Fix: Metadata does not come through on form emails (<a href=\"https://github.com/elementor/elementor/issues/1566\">#1566</a>)</li>\n</ul>\n<h4>1.2.6 - 2017-04-19</h4>\n<ul>\n<li>Fix: Added compatibility with WooCommerce 3.0 - Products &amp; Add to Cart widgets</li>\n</ul>\n<h4>1.2.5 - 2017-04-18</h4>\n<ul>\n<li>Fix: Offset query for posts widgets (Posts, Portfolio and Products)</li>\n</ul>\n<h4>1.2.4 - 2017-03-21</h4>\n<ul>\n<li>Tweak: Added Indian Rupee sign to Price Table widget</li>\n<li>Fix: Portfolio grid for IE11</li>\n<li>Fix: Link target blank in Price List widget</li>\n<li>Fix: Active item for filter bar in Portfolio widget</li>\n</ul>\n<h4>1.2.3 - 2017-03-06</h4>\n<ul>\n<li>Tweak: Fully compatible with Elementor v1.3.0</li>\n<li>Tweak: Added trigger for after form submission in Forms widget</li>\n<li>Tweak: Changed handle name in reCAPTCHA field to avoid conflict with other contact forms</li>\n<li>Fix: Portfolio filter syntax in Non-Latin languages</li>\n<li>Fix: Added <code>no-repeat</code> property for slide with <code>background-size:contain</code></li>\n<li>Fix: Condition control &amp; Import value in Posts widgets</li>\n<li>Fix: Offset and Pagination in WordPress (<a href=\"https://codex.wordpress.org/Making_Custom_Queries_using_Offset_and_Pagination\">More Info</a>)</li>\n<li>Fix: Submit handler bubbling for custom events in Forms widget</li>\n</ul>\n<h4>1.2.2 - 2017-02-23</h4>\n<ul>\n<li>Tweak: Change name from Side A/B to Front and Back in Flip Box widget</li>\n<li>Fix: Error when saving third party widgets in the global widget</li>\n<li>Fix: Image position &quot;none&quot; remains visible in editor preview (Posts)</li>\n<li>Fix: Hide the pagination when there are no links</li>\n</ul>\n<h4>1.2.1 - 2017-02-21</h4>\n<ul>\n<li>Fix: Firefox Flip Box 3D compatibility</li>\n</ul>\n<h4>1.2.0 - 2017-02-21</h4>\n<ul>\n<li>New: Added Flip Box widget</li>\n<li>New: Added Ken Burns effect for slides</li>\n<li>New: Added Masonry layout for Posts widget</li>\n<li>New: Added Pagination option for Posts widget</li>\n<li>Tweak: Added background size contain to slides</li>\n<li>Tweak: Improve Query control by preload items</li>\n<li>Fix: Text color for Checkbox and Radio fields</li>\n</ul>\n<h4>1.1.2 - 2017-02-05</h4>\n<ul>\n<li>Tweak: Added <code>aria-required</code> for better accessibility in forms widget</li>\n<li>Fix: Conflict Call to <code>undefined</code> method in Posts &amp; Portfolio widgets (<a href=\"https://github.com/elementor/elementor/issues/1271\">#1271</a>, <a href=\"https://github.com/elementor/elementor/issues/1266\">#1266</a>)</li>\n<li>Fix: Submit button HTML after error sending</li>\n<li>Fix: Success message for <code>skip_email</code> function</li>\n<li>Notice: Elementor 1.2.0 or later now required</li>\n</ul>\n<h4>1.1.1 - 2017-01-24</h4>\n<ul>\n<li>Fix: Can\'t save global widgets when <code>WP_DEBUG</code> is <code>true</code></li>\n<li>Fix: Undefined variable in WC widgets</li>\n<li>Fix: Removed duplicate strings</li>\n</ul>\n<h4>1.1.0 - 2017-01-24</h4>\n<ul>\n<li>New: Price Table widget (<a href=\"https://github.com/elementor/elementor/issues/102\">#102</a>)</li>\n<li>New: WooCommerce Add to Cart widget</li>\n<li>New: WooCommerce Categories widget</li>\n<li>New: WooCommerce Elements widget</li>\n<li>New: Honeypot field for Forms widgets</li>\n<li>Tweak: Added inline options for taxonomies &amp; authors if is less than 15 items</li>\n<li>Tweak: Added Required Mark for fields in Forms widget</li>\n<li>Fix: CSS selectors priority in Slides widget</li>\n<li>Fix: CSS bug in Price List widget</li>\n<li>Fix: Update all Post CSS files that includes specific Global Widget</li>\n</ul>\n<h4>1.0.9 - 2017-01-18</h4>\n<ul>\n<li>Fix: Auto complete bug in query controls</li>\n<li>Fix: Render template with escaping slashes</li>\n<li>Fix: Reply-to field in Forms widget</li>\n</ul>\n<h4>1.0.8 - 2017-01-11</h4>\n<ul>\n<li>Tweak: Code adjustments for Elementor API</li>\n<li>Fix: Removed go pro link from plugins page in admin</li>\n</ul>\n<h4>1.0.7 - 2017-01-05</h4>\n<ul>\n<li>Tweak: Added filter by featured / sale for WC Products widget</li>\n<li>Tweak: Added author control in Portfolio widget</li>\n<li>Tweak: Code adjustments for Elementor API</li>\n<li>Fix: Added support for empty image ratio</li>\n<li>Fix: Avoid nesting a sidebar within a template that will appear in the sidebar itself</li>\n</ul>\n<h4>1.0.6 - 2017-01-01</h4>\n<ul>\n<li>Tweak: Added Auto-updates for local translation files</li>\n<li>Fix: Custom CSS for Global widgets</li>\n<li>Fix: Remove <code>nonce</code> field (Fix some cache plugins)</li>\n</ul>\n<h4>1.0.5 - 2016-12-27</h4>\n<ul>\n<li>Fix: Slide element bug fix - \'Link apply on\' logic</li>\n<li>Fix: Removed unique wrapper for Custom CSS in order to allow media queries (<a href=\"https://github.com/elementor/elementor/issues/1086\">#1086</a>)</li>\n</ul>\n<h4>1.0.4 - 2016-12-21</h4>\n<ul>\n<li>Tweak: Mobile Editing for fields in the form widget</li>\n<li>Tweak: Mobile Editing for posts</li>\n<li>Tweak: Allow send form as HTML</li>\n<li>Tweak: Improved auto upgrades for Multisite installation</li>\n<li>Tweak: Improve editor rendering experience for Portfolio widget</li>\n<li>Fix: Posts widget check if image exist</li>\n<li>Fix: Changed the clone method for global widget (<a href=\"https://github.com/elementor/elementor/issues/1042\">#1042</a>)</li>\n<li>Fix: Bug slides in RTL (removed direction control)</li>\n<li>Fix: Slides with no height jumps when changing slides</li>\n</ul>\n<h4>1.0.3 - 2016-12-13</h4>\n<ul>\n<li>Fix: Added escape placeholder for HTML Entities in form widget</li>\n<li>Fix: Countdown widget RTL bug</li>\n<li>Fix: Remove redundant #elementor selector for control style</li>\n<li>Fix: Added prefixing with \'0\' for one digit number in Countdown widget</li>\n</ul>\n<h4>1.0.2 - 2016-12-12</h4>\n<ul>\n<li>Fix: Page layout collapses when inserting reCAPTCHA field in Form</li>\n</ul>\n<h4>1.0.1 - 2016-12-12</h4>\n<ul>\n<li>Fix: WordPress widgets disappear from Editor when Elementor Pro active</li>\n</ul>\n<h4>1.0.0 - 2016-12-12</h4>\n<ul>\n<li>Initial release</li>\n</ul>\";}\";s:11:\"new_version\";s:5:\"3.0.5\";s:4:\"name\";s:13:\"Elementor Pro\";s:4:\"slug\";s:13:\"elementor-pro\";s:3:\"url\";s:36:\"https://elementor.com/pro/changelog/\";s:8:\"homepage\";s:26:\"https://elementor.com/pro/\";s:8:\"requires\";s:3:\"5.0\";s:18:\"elementor_requires\";s:5:\"3.0.1\";s:6:\"tested\";s:5:\"5.5.1\";s:7:\"package\";s:192:\"http://my.elementor.com/edd-sl/package_download/MTYwNDMzODE4NDpiN2JjZDM2NTBkY2JiMWUxOWVkY2ZjZGJlNjRiMjczYzoxOmY2N2FjOGMxOTVmYTMzYjk3ODc2ZmEwZDE1YzQ1Zjc5Omh0dHBzQC8vc25hcGlyLXN3aW0uY28uaWw6MA==\";s:13:\"download_link\";s:192:\"http://my.elementor.com/edd-sl/package_download/MTYwNDMzODE4NDpiN2JjZDM2NTBkY2JiMWUxOWVkY2ZjZGJlNjRiMjczYzoxOmY2N2FjOGMxOTVmYTMzYjk3ODc2ZmEwZDE1YzQ1Zjc5Omh0dHBzQC8vc25hcGlyLXN3aW0uY28uaWw6MA==\";s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:5:\"icons\";a:1:{s:3:\"svg\";s:42:\"https://ps.w.org/elementor/assets/icon.svg\";}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:12:{s:11:\"new_version\";s:5:\"3.0.2\";s:4:\"name\";s:13:\"Elementor Pro\";s:4:\"slug\";s:13:\"elementor-pro\";s:3:\"url\";s:36:\"https://elementor.com/pro/changelog/\";s:8:\"homepage\";s:26:\"https://elementor.com/pro/\";s:8:\"requires\";s:3:\"5.0\";s:18:\"elementor_requires\";s:5:\"3.0.1\";s:6:\"tested\";s:5:\"5.5.1\";s:7:\"package\";s:197:\"http://my.elementor.com/edd-sl/previous_download/MTYwNDMzODE4NDpiN2JjZDM2NTBkY2JiMWUxOWVkY2ZjZGJlNjRiMjczYzoxOjMuMC4yOjBkNTJlNWRkNmM0ZTY0YzdiYmVkOGY4YzVhYTQxYzM0Omh0dHBzQC8vc25hcGlyLXN3aW0uY28uaWw=\";s:13:\"download_link\";s:197:\"http://my.elementor.com/edd-sl/previous_download/MTYwNDMzODE4NDpiN2JjZDM2NTBkY2JiMWUxOWVkY2ZjZGJlNjRiMjczYzoxOjMuMC4yOjBkNTJlNWRkNmM0ZTY0YzdiYmVkOGY4YzVhYTQxYzM0Omh0dHBzQC8vc25hcGlyLXN3aW0uY28uaWw=\";s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:5:\"icons\";a:1:{s:3:\"svg\";s:42:\"https://ps.w.org/elementor/assets/icon.svg\";}}s:10:\"conditions\";a:1:{i:0;a:1:{i:0;a:4:{s:4:\"type\";s:6:\"plugin\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:7:\"version\";s:5:\"3.0.2\";s:8:\"operator\";s:2:\">=\";}}}}s:12:\"translations\";a:1:{i:0;a:3:{s:8:\"language\";s:5:\"he_IL\";s:7:\"updated\";s:24:\"2020-09-10 08:05:19+0000\";s:7:\"package\";s:90:\"http://translate.elementor.com/wp-content/uploads/pro-translations/elementor-pro-he_IL.zip\";}}}',	'no'),
(154,	'current_theme',	'Hello Elementor Child',	'yes'),
(177,	'theme_mods_atlanta-child',	'a:9:{s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:10:\"image_logo\";s:90:\"https://snapir-swim.co.il/wp-content/uploads/2020/09/לוגו-חדש-בכחול-כהה.jpg\";s:24:\"image_sticky_header_logo\";s:90:\"https://snapir-swim.co.il/wp-content/uploads/2020/09/לוגו-חדש-בכחול-כהה.jpg\";s:14:\"typo_body_text\";a:2:{s:6:\"family\";s:16:\"Open Sans Hebrew\";s:5:\"color\";s:7:\"#000000\";}s:7:\"typo_h1\";a:3:{s:4:\"size\";s:4:\"23px\";s:6:\"family\";s:16:\"Open Sans Hebrew\";s:5:\"color\";s:7:\"#000000\";}s:7:\"typo_h2\";a:3:{s:4:\"size\";s:4:\"21px\";s:6:\"family\";s:16:\"Open Sans Hebrew\";s:5:\"color\";s:7:\"#000000\";}s:7:\"typo_h3\";a:2:{s:5:\"color\";s:7:\"#000000\";s:6:\"family\";s:16:\"Open Sans Hebrew\";}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1599715993;s:4:\"data\";a:6:{s:19:\"wp_inactive_widgets\";a:0:{}s:17:\"pojo-main-sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:18:\"pojo-top-bar-right\";a:0:{}s:17:\"pojo-top-bar-left\";a:0:{}s:19:\"pojo-outer-slidebar\";a:0:{}s:11:\"pojo-footer\";a:0:{}}}}',	'yes'),
(156,	'theme_switched',	'',	'yes'),
(157,	'pojo_db_version',	'0.9',	'yes'),
(158,	'pojo_builder_enable',	'disable',	'yes'),
(159,	'widget_pojo_sub_page_menu',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(160,	'widget_pojo_opening_hours',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(161,	'widget_pojo_button',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(162,	'widget_pojo_social_links',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(163,	'widget_pojo_embed_video',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(164,	'widget_pojo_google_maps',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(165,	'widget_pojo_image',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(166,	'widget_pojo_image_text',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(167,	'widget_pojo_recent_posts',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(168,	'widget_pojo_tabs',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(169,	'widget_pojo_testimonials',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(170,	'widget_pojo_catalog',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(171,	'widget_pojo_animated_nums',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(172,	'widget_pojo_news_ticker',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(173,	'widget_pojo_form_widget',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(174,	'widget_pojo_recent_galleries',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(175,	'widget_pojo_gallery',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(176,	'widget_pojo_slideshow_widget',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(182,	'pojo_license_atlanta',	'a4b83f9f1bfd8473d10747f28add3b19',	'yes'),
(202,	'elementor_scheme_color',	'a:4:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";}',	'yes'),
(203,	'elementor_scheme_color-picker',	'a:8:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";i:5;s:7:\"#4054b2\";i:6;s:7:\"#23a455\";i:7;s:4:\"#000\";i:8;s:4:\"#fff\";}',	'yes'),
(204,	'elementor_scheme_typography',	'a:4:{i:1;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"600\";}i:2;a:2:{s:11:\"font_family\";s:11:\"Roboto Slab\";s:11:\"font_weight\";s:3:\"400\";}i:3;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"400\";}i:4;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"500\";}}',	'yes'),
(205,	'elementor_install_history',	'a:1:{s:5:\"3.0.3\";i:1598945441;}',	'yes'),
(188,	'activity_log_db_version',	'1.0',	'yes'),
(189,	'recently_activated',	'a:0:{}',	'yes'),
(190,	'activity-log-settings',	'a:1:{s:13:\"logs_lifespan\";s:2:\"30\";}',	'yes'),
(191,	'pojo_a11y_customizer_options',	'a:13:{s:17:\"a11y_toolbar_icon\";s:10:\"wheelchair\";s:21:\"a11y_toolbar_position\";s:5:\"right\";s:25:\"a11y_toolbar_distance_top\";s:5:\"100px\";s:32:\"a11y_toolbar_distance_top_mobile\";s:4:\"50px\";s:15:\"a11y_bg_toolbar\";s:7:\"#ffffff\";s:18:\"a11y_color_toolbar\";s:7:\"#333333\";s:27:\"a11y_toggle_button_bg_color\";s:7:\"#4054b2\";s:24:\"a11y_toggle_button_color\";s:7:\"#ffffff\";s:14:\"a11y_bg_active\";s:7:\"#4054b2\";s:17:\"a11y_color_active\";s:7:\"#ffffff\";s:24:\"a11y_focus_outline_style\";s:5:\"solid\";s:24:\"a11y_focus_outline_width\";s:3:\"1px\";s:24:\"a11y_focus_outline_color\";s:7:\"#FF0000\";}',	'yes'),
(218,	'elementor_pro_version',	'2.10.3',	'yes'),
(219,	'widget_elementor-library',	'a:1:{s:12:\"_multiwidget\";i:1;}',	'yes'),
(220,	'_elementor_pro_installed_time',	'1598793553',	'yes'),
(221,	'elementor_connect_site_key',	'6a5db6e3fe8f0bec69e8efd17e1f1a92',	'yes'),
(222,	'elementor_allow_tracking',	'yes',	'yes'),
(223,	'elementor_tracker_last_send',	'1598793560',	'yes'),
(224,	'elementor_pro_license_key',	'b7bcd3650dcbb1e19edcfcdbe64b273c',	'yes'),
(225,	'_elementor_pro_license_data_fallback',	'a:2:{s:7:\"timeout\";i:1604325251;s:5:\"value\";s:317:\"{\"expires\":\"2020-12-12 23:59:59\",\"payment_id\":7435287,\"customer_name\":\" \",\"customer_email\":\"liat@box.co.il\",\"price_id\":3,\"license_limit\":1000,\"site_count\":322,\"activations_left\":678,\"success\":true,\"license\":\"valid\",\"item_id\":6630548,\"item_name\":\"Elementor Pro - Expert\",\"subscriptions\":\"enable\",\"checksum\":\"checksum\"}\";}',	'yes'),
(226,	'_elementor_pro_license_data',	'a:2:{s:7:\"timeout\";i:1604282051;s:5:\"value\";s:317:\"{\"expires\":\"2020-12-12 23:59:59\",\"payment_id\":7435287,\"customer_name\":\" \",\"customer_email\":\"liat@box.co.il\",\"price_id\":3,\"license_limit\":1000,\"site_count\":322,\"activations_left\":678,\"success\":true,\"license\":\"valid\",\"item_id\":6630548,\"item_name\":\"Elementor Pro - Expert\",\"subscriptions\":\"enable\",\"checksum\":\"checksum\"}\";}',	'yes'),
(227,	'elementor_custom_icon_sets_config',	'a:0:{}',	'yes'),
(228,	'elementor_fonts_manager_font_types',	'a:0:{}',	'yes'),
(229,	'elementor_fonts_manager_fonts',	'a:0:{}',	'yes'),
(7365,	'_site_transient_update_themes',	'O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1604251779;s:7:\"checked\";a:4:{s:13:\"atlanta-child\";s:5:\"1.0.0\";s:7:\"atlanta\";s:5:\"5.2.0\";s:15:\"hello-elementor\";s:5:\"2.3.0\";s:24:\"hello-theme-child-master\";s:5:\"1.0.1\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:1:{s:15:\"hello-elementor\";a:6:{s:5:\"theme\";s:15:\"hello-elementor\";s:11:\"new_version\";s:5:\"2.3.0\";s:3:\"url\";s:45:\"https://wordpress.org/themes/hello-elementor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/hello-elementor.2.3.0.zip\";s:8:\"requires\";s:3:\"4.7\";s:12:\"requires_php\";b:0;}}s:12:\"translations\";a:0:{}}',	'no'),
(7578,	'_site_transient_timeout_jet_dashboard_remote_jet_plugin_list',	'1604338183',	'no'),
(7579,	'_site_transient_jet_dashboard_remote_jet_plugin_list',	'a:18:{i:0;a:9:{s:4:\"name\";s:11:\"JetElements\";s:4:\"slug\";s:29:\"jet-elements/jet-elements.php\";s:7:\"version\";s:5:\"2.4.1\";s:5:\"thumb\";s:75:\"https://account.crocoblock.com/free-download/images/jetlogo/jetelements.svg\";s:9:\"thumb_alt\";s:79:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetelements.svg\";s:4:\"docs\";s:68:\"https://crocoblock.com/knowledge-base/article-category/jet-elements/\";s:4:\"demo\";s:43:\"https://crocoblock.com/plugins/jetelements/\";s:4:\"desc\";s:24:\"Must-have design widgets\";s:8:\"versions\";a:9:{i:0;s:5:\"2.4.1\";i:1;s:5:\"2.4.0\";i:2;s:5:\"2.3.3\";i:3;s:5:\"2.3.2\";i:4;s:5:\"2.3.1\";i:5;s:5:\"2.3.0\";i:6;s:6:\"2.2.17\";i:7;s:6:\"2.2.16\";i:8;s:6:\"2.2.15\";}}i:1;a:9:{s:4:\"name\";s:7:\"JetTabs\";s:4:\"slug\";s:21:\"jet-tabs/jet-tabs.php\";s:7:\"version\";s:5:\"2.1.8\";s:5:\"thumb\";s:71:\"https://account.crocoblock.com/free-download/images/jetlogo/jettabs.svg\";s:9:\"thumb_alt\";s:75:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jettabs.svg\";s:4:\"docs\";s:64:\"https://crocoblock.com/knowledge-base/article-category/jet-tabs/\";s:4:\"demo\";s:39:\"https://crocoblock.com/plugins/jettabs/\";s:4:\"desc\";s:31:\"A smart way to organize content\";s:8:\"versions\";a:5:{i:0;s:5:\"2.1.8\";i:1;s:5:\"2.1.7\";i:2;s:5:\"2.1.6\";i:3;s:5:\"2.1.5\";i:4;s:5:\"2.1.4\";}}i:2;a:9:{s:4:\"name\";s:10:\"JetReviews\";s:4:\"slug\";s:27:\"jet-reviews/jet-reviews.php\";s:7:\"version\";s:5:\"2.0.2\";s:5:\"thumb\";s:74:\"https://account.crocoblock.com/free-download/images/jetlogo/jetreviews.svg\";s:9:\"thumb_alt\";s:78:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetreviews.svg\";s:4:\"docs\";s:66:\"https://crocoblock.com/knowledge-base/article-category/jetreviews/\";s:4:\"demo\";s:42:\"https://crocoblock.com/plugins/jetreviews/\";s:4:\"desc\";s:32:\"Add reviews, comments, and rates\";s:8:\"versions\";a:6:{i:0;s:5:\"2.0.2\";i:1;s:5:\"2.0.1\";i:2;s:5:\"2.0.0\";i:3;s:5:\"1.3.0\";i:4;s:5:\"1.2.2\";i:5;s:5:\"1.2.1\";}}i:3;a:9:{s:4:\"name\";s:7:\"JetMenu\";s:4:\"slug\";s:21:\"jet-menu/jet-menu.php\";s:7:\"version\";s:5:\"2.0.6\";s:5:\"thumb\";s:71:\"https://account.crocoblock.com/free-download/images/jetlogo/jetmenu.svg\";s:9:\"thumb_alt\";s:75:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetmenu.svg\";s:4:\"docs\";s:64:\"https://crocoblock.com/knowledge-base/article-category/jet-menu/\";s:4:\"demo\";s:39:\"https://crocoblock.com/plugins/jetmenu/\";s:4:\"desc\";s:24:\"Build a custom mega menu\";s:8:\"versions\";a:5:{i:0;s:5:\"2.0.6\";i:1;s:5:\"2.0.5\";i:2;s:5:\"2.0.4\";i:3;s:5:\"2.0.3\";i:4;s:6:\"1.5.15\";}}i:4;a:9:{s:4:\"name\";s:7:\"JetBlog\";s:4:\"slug\";s:21:\"jet-blog/jet-blog.php\";s:7:\"version\";s:6:\"2.2.10\";s:5:\"thumb\";s:71:\"https://account.crocoblock.com/free-download/images/jetlogo/jetblog.svg\";s:9:\"thumb_alt\";s:75:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetblog.svg\";s:4:\"docs\";s:64:\"https://crocoblock.com/knowledge-base/article-category/jet-blog/\";s:4:\"demo\";s:39:\"https://crocoblock.com/plugins/jetblog/\";s:4:\"desc\";s:26:\"Create engaging blog pages\";s:8:\"versions\";a:4:{i:0;s:6:\"2.2.10\";i:1;s:5:\"2.2.9\";i:2;s:5:\"2.2.8\";i:3;s:5:\"2.2.7\";}}i:5;a:9:{s:4:\"name\";s:9:\"JetBlocks\";s:4:\"slug\";s:25:\"jet-blocks/jet-blocks.php\";s:7:\"version\";s:5:\"1.2.5\";s:5:\"thumb\";s:73:\"https://account.crocoblock.com/free-download/images/jetlogo/jetblocks.svg\";s:9:\"thumb_alt\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetblocks.svg\";s:4:\"docs\";s:65:\"https://crocoblock.com/knowledge-base/article-category/jetblocks/\";s:4:\"demo\";s:41:\"https://crocoblock.com/plugins/jetblocks/\";s:4:\"desc\";s:30:\"Enrich header & footer content\";s:8:\"versions\";a:5:{i:0;s:5:\"1.2.5\";i:1;s:5:\"1.2.4\";i:2;s:5:\"1.2.3\";i:3;s:5:\"1.2.2\";i:4;s:5:\"1.2.1\";}}i:6;a:9:{s:4:\"name\";s:9:\"JetTricks\";s:4:\"slug\";s:25:\"jet-tricks/jet-tricks.php\";s:7:\"version\";s:5:\"1.3.0\";s:5:\"thumb\";s:73:\"https://account.crocoblock.com/free-download/images/jetlogo/jettricks.svg\";s:9:\"thumb_alt\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jettricks.svg\";s:4:\"docs\";s:65:\"https://crocoblock.com/knowledge-base/article-category/jettricks/\";s:4:\"demo\";s:41:\"https://crocoblock.com/plugins/jettricks/\";s:4:\"desc\";s:30:\"Add interactive visual effects\";s:8:\"versions\";a:7:{i:0;s:5:\"1.3.0\";i:1;s:6:\"1.2.12\";i:2;s:6:\"1.2.11\";i:3;s:6:\"1.2.10\";i:4;s:5:\"1.2.9\";i:5;s:5:\"1.2.8\";i:6;s:5:\"1.2.7\";}}i:7;a:9:{s:4:\"name\";s:15:\"JetSmartFilters\";s:4:\"slug\";s:39:\"jet-smart-filters/jet-smart-filters.php\";s:7:\"version\";s:5:\"2.0.4\";s:5:\"thumb\";s:79:\"https://account.crocoblock.com/free-download/images/jetlogo/jetsmartfilters.svg\";s:9:\"thumb_alt\";s:83:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetsmartfilters.svg\";s:4:\"docs\";s:71:\"https://crocoblock.com/knowledge-base/article-category/jetsmartfilters/\";s:4:\"demo\";s:47:\"https://crocoblock.com/plugins/jetsmartfilters/\";s:4:\"desc\";s:34:\"Advanced filters for any post type\";s:8:\"versions\";a:9:{i:0;s:5:\"2.0.4\";i:1;s:5:\"2.0.3\";i:2;s:5:\"2.0.2\";i:3;s:5:\"2.0.1\";i:4;s:5:\"2.0.0\";i:5;s:5:\"1.8.4\";i:6;s:5:\"1.8.3\";i:7;s:5:\"1.8.2\";i:8;s:5:\"1.8.1\";}}i:8;a:9:{s:4:\"name\";s:8:\"JetPopup\";s:4:\"slug\";s:23:\"jet-popup/jet-popup.php\";s:7:\"version\";s:5:\"1.4.1\";s:5:\"thumb\";s:72:\"https://account.crocoblock.com/free-download/images/jetlogo/jetpopup.svg\";s:9:\"thumb_alt\";s:76:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetpopup.svg\";s:4:\"docs\";s:65:\"https://crocoblock.com/knowledge-base/article-category/jet-popup/\";s:4:\"demo\";s:40:\"https://crocoblock.com/plugins/jetpopup/\";s:4:\"desc\";s:30:\"Create popups that boost sales\";s:8:\"versions\";a:4:{i:0;s:5:\"1.4.1\";i:1;s:5:\"1.4.0\";i:2;s:5:\"1.3.1\";i:3;s:5:\"1.3.0\";}}i:9;a:9:{s:4:\"name\";s:9:\"JetSearch\";s:4:\"slug\";s:25:\"jet-search/jet-search.php\";s:7:\"version\";s:5:\"2.1.8\";s:5:\"thumb\";s:73:\"https://account.crocoblock.com/free-download/images/jetlogo/jetsearch.svg\";s:9:\"thumb_alt\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetsearch.svg\";s:4:\"docs\";s:66:\"https://crocoblock.com/knowledge-base/article-category/jet-search/\";s:4:\"demo\";s:41:\"https://crocoblock.com/plugins/jetsearch/\";s:4:\"desc\";s:27:\"Try the fastest AJAX search\";s:8:\"versions\";a:5:{i:0;s:5:\"2.1.8\";i:1;s:5:\"2.1.7\";i:2;s:5:\"2.1.6\";i:3;s:5:\"2.1.5\";i:4;s:5:\"2.1.4\";}}i:10;a:9:{s:4:\"name\";s:13:\"JetWooBuilder\";s:4:\"slug\";s:35:\"jet-woo-builder/jet-woo-builder.php\";s:7:\"version\";s:5:\"1.7.1\";s:5:\"thumb\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo/jetwoobuilder.svg\";s:9:\"thumb_alt\";s:81:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetwoobuilder.svg\";s:4:\"docs\";s:69:\"https://crocoblock.com/knowledge-base/article-category/jetwoobuilder/\";s:4:\"demo\";s:45:\"https://crocoblock.com/plugins/jetwoobuilder/\";s:4:\"desc\";s:30:\"Create custom e-commerce pages\";s:8:\"versions\";a:6:{i:0;s:5:\"1.7.1\";i:1;s:5:\"1.7.0\";i:2;s:5:\"1.6.6\";i:3;s:5:\"1.6.5\";i:4;s:5:\"1.6.4\";i:5;s:5:\"1.6.3\";}}i:11;a:9:{s:4:\"name\";s:17:\"JetProductGallery\";s:4:\"slug\";s:51:\"jet-woo-product-gallery/jet-woo-product-gallery.php\";s:7:\"version\";s:5:\"1.1.6\";s:5:\"thumb\";s:81:\"https://account.crocoblock.com/free-download/images/jetlogo/jetproductgallery.svg\";s:9:\"thumb_alt\";s:85:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetproductgallery.svg\";s:4:\"docs\";s:73:\"https://crocoblock.com/knowledge-base/article-category/jetproductgallery/\";s:4:\"demo\";s:49:\"https://crocoblock.com/plugins/jetproductgallery/\";s:4:\"desc\";s:38:\"Product gallery sliders and carousels \";s:8:\"versions\";a:4:{i:0;s:5:\"1.1.6\";i:1;s:5:\"1.1.5\";i:2;s:5:\"1.1.4\";i:3;s:5:\"1.1.3\";}}i:12;a:9:{s:4:\"name\";s:19:\"JetCompare&Wishlist\";s:4:\"slug\";s:31:\"jet-compare-wishlist/jet-cw.php\";s:7:\"version\";s:5:\"1.2.1\";s:5:\"thumb\";s:85:\"https://account.crocoblock.com/free-download/images/jetlogo/jetwoocomparewishlist.svg\";s:9:\"thumb_alt\";s:86:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetcomparewishlist.svg\";s:4:\"docs\";s:74:\"https://crocoblock.com/knowledge-base/article-category/jetcomparewishlist/\";s:4:\"demo\";s:50:\"https://crocoblock.com/plugins/jetcomparewishlist/\";s:4:\"desc\";s:34:\"Compare and wishlist functionality\";s:8:\"versions\";a:5:{i:0;s:5:\"1.2.1\";i:1;s:5:\"1.2.0\";i:2;s:5:\"1.1.2\";i:3;s:5:\"1.1.1\";i:4;s:5:\"1.1.0\";}}i:13;a:9:{s:4:\"name\";s:9:\"JetEngine\";s:4:\"slug\";s:25:\"jet-engine/jet-engine.php\";s:7:\"version\";s:5:\"2.5.4\";s:5:\"thumb\";s:73:\"https://account.crocoblock.com/free-download/images/jetlogo/jetengine.svg\";s:9:\"thumb_alt\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetengine.svg\";s:4:\"docs\";s:66:\"https://crocoblock.com/knowledge-base/article-category/jet-engine/\";s:4:\"demo\";s:41:\"https://crocoblock.com/plugins/jetengine/\";s:4:\"desc\";s:36:\"Top-notch plugin for dynamic content\";s:8:\"versions\";a:14:{i:0;s:5:\"2.5.4\";i:1;s:5:\"2.5.3\";i:2;s:5:\"2.5.2\";i:3;s:5:\"2.5.1\";i:4;s:5:\"2.5.0\";i:5;s:6:\"2.4.13\";i:6;s:6:\"2.4.12\";i:7;s:6:\"2.4.11\";i:8;s:6:\"2.4.10\";i:9;s:5:\"2.4.9\";i:10;s:5:\"2.4.8\";i:11;s:5:\"2.4.6\";i:12;s:5:\"2.4.5\";i:13;s:5:\"2.4.4\";}}i:14;a:9:{s:4:\"name\";s:10:\"JetBooking\";s:4:\"slug\";s:27:\"jet-booking/jet-booking.php\";s:7:\"version\";s:5:\"2.1.1\";s:5:\"thumb\";s:74:\"https://account.crocoblock.com/free-download/images/jetlogo/jetbooking.svg\";s:9:\"thumb_alt\";s:78:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetbooking.svg\";s:4:\"docs\";s:66:\"https://crocoblock.com/knowledge-base/article-category/jetbooking/\";s:4:\"demo\";s:42:\"https://crocoblock.com/plugins/jetbooking/\";s:4:\"desc\";s:29:\"Complex booking functionality\";s:8:\"versions\";a:4:{i:0;s:5:\"2.1.1\";i:1;s:5:\"2.1.0\";i:2;s:5:\"2.0.2\";i:3;s:5:\"2.0.1\";}}i:15;a:9:{s:4:\"name\";s:15:\"JetStyleManager\";s:4:\"slug\";s:39:\"jet-style-manager/jet-style-manager.php\";s:7:\"version\";s:5:\"1.0.0\";s:5:\"thumb\";s:79:\"https://account.crocoblock.com/free-download/images/jetlogo/jetstylemanager.svg\";s:9:\"thumb_alt\";s:83:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetstylemanager.svg\";s:4:\"docs\";s:71:\"https://crocoblock.com/knowledge-base/article-category/jetstylemanager/\";s:4:\"demo\";s:47:\"https://crocoblock.com/plugins/jetstylemanager/\";s:4:\"desc\";s:36:\"Manage Elementor page style settings\";s:8:\"versions\";a:1:{i:0;s:5:\"1.0.0\";}}i:16;a:9:{s:4:\"name\";s:14:\"JetAppointment\";s:4:\"slug\";s:53:\"jet-appointments-booking/jet-appointments-booking.php\";s:7:\"version\";s:5:\"1.2.2\";s:5:\"thumb\";s:79:\"https://account.crocoblock.com/free-download/images/jetlogo/jet-appointment.svg\";s:9:\"thumb_alt\";s:83:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jet-appointment.svg\";s:4:\"docs\";s:70:\"https://crocoblock.com/knowledge-base/article-category/jetappointment/\";s:4:\"demo\";s:46:\"https://crocoblock.com/plugins/jetappointment/\";s:4:\"desc\";s:31:\"Create custom appointment forms\";s:8:\"versions\";a:6:{i:0;s:5:\"1.2.2\";i:1;s:5:\"1.2.1\";i:2;s:5:\"1.2.0\";i:3;s:5:\"1.1.1\";i:4;s:5:\"1.1.0\";i:5;s:5:\"1.0.0\";}}i:17;a:9:{s:4:\"name\";s:12:\"JetThemeCore\";s:4:\"slug\";s:33:\"jet-theme-core/jet-theme-core.php\";s:7:\"version\";s:5:\"1.2.1\";s:5:\"thumb\";s:76:\"https://account.crocoblock.com/free-download/images/jetlogo/jetthemecore.svg\";s:9:\"thumb_alt\";s:80:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetthemecore.svg\";s:4:\"docs\";s:67:\"https://crocoblock.com/knowledge-base/article-category/theme-parts/\";s:4:\"demo\";s:44:\"https://crocoblock.com/plugins/jetthemecore/\";s:4:\"desc\";s:44:\"Design the entire site with a theme builder \";s:8:\"versions\";a:7:{i:0;s:5:\"1.2.1\";i:1;s:5:\"1.2.0\";i:2;s:6:\"1.1.25\";i:3;s:6:\"1.1.24\";i:4;s:6:\"1.1.23\";i:5;s:6:\"1.1.22\";i:6;s:6:\"1.1.21\";}}}',	'no'),
(7427,	'_transient_timeout_pojo_forms_check_protection_files',	'1604301325',	'no'),
(7337,	'_transient_wc_related_74',	'a:1:{s:50:\"limit=4&exclude_ids%5B0%5D=0&exclude_ids%5B1%5D=74\";a:1:{i:0;s:2:\"87\";}}',	'no'),
(7428,	'_transient_pojo_forms_check_protection_files',	'1',	'no'),
(7364,	'_site_transient_update_core',	'O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/he_IL/wordpress-5.5.3.zip\";s:6:\"locale\";s:5:\"he_IL\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/he_IL/wordpress-5.5.3.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"5.5.3\";s:7:\"version\";s:5:\"5.5.3\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.3\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1604251776;s:15:\"version_checked\";s:5:\"5.5.3\";s:12:\"translations\";a:0:{}}',	'no'),
(246,	'jet-license-data',	'a:1:{s:12:\"license-list\";a:1:{s:32:\"877e4bb86f76a38df75c36354a2845dc\";a:3:{s:13:\"licenseStatus\";s:6:\"active\";s:10:\"licenseKey\";s:32:\"877e4bb86f76a38df75c36354a2845dc\";s:14:\"licenseDetails\";a:7:{s:7:\"license\";s:32:\"877e4bb86f76a38df75c36354a2845dc\";s:4:\"type\";s:10:\"crocoblock\";s:12:\"product_name\";s:49:\"Crocoblock Membership Lifetime Unlimited Websites\";s:6:\"expire\";s:19:\"0000-00-00 00:00:00\";s:16:\"activation_limit\";i:0;s:7:\"plugins\";a:18:{s:29:\"jet-elements/jet-elements.php\";a:8:{s:4:\"name\";s:11:\"JetElements\";s:4:\"slug\";s:29:\"jet-elements/jet-elements.php\";s:7:\"version\";s:5:\"2.3.3\";s:5:\"thumb\";s:75:\"https://account.crocoblock.com/free-download/images/jetlogo/jetelements.svg\";s:9:\"thumb_alt\";s:79:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetelements.svg\";s:4:\"docs\";s:68:\"https://crocoblock.com/knowledge-base/article-category/jet-elements/\";s:4:\"demo\";s:43:\"https://crocoblock.com/plugins/jetelements/\";s:4:\"desc\";s:64:\"Provides the set of widgets to create different kinds of content\";}s:21:\"jet-tabs/jet-tabs.php\";a:8:{s:4:\"name\";s:7:\"JetTabs\";s:4:\"slug\";s:21:\"jet-tabs/jet-tabs.php\";s:7:\"version\";s:5:\"2.1.7\";s:5:\"thumb\";s:71:\"https://account.crocoblock.com/free-download/images/jetlogo/jettabs.svg\";s:9:\"thumb_alt\";s:75:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jettabs.svg\";s:4:\"docs\";s:64:\"https://crocoblock.com/knowledge-base/article-category/jet-tabs/\";s:4:\"demo\";s:39:\"https://crocoblock.com/plugins/jettabs/\";s:4:\"desc\";s:46:\"Tabs and Accordions for Elementor Page Builder\";}s:27:\"jet-reviews/jet-reviews.php\";a:8:{s:4:\"name\";s:10:\"JetReviews\";s:4:\"slug\";s:27:\"jet-reviews/jet-reviews.php\";s:7:\"version\";s:5:\"2.0.1\";s:5:\"thumb\";s:74:\"https://account.crocoblock.com/free-download/images/jetlogo/jetreviews.svg\";s:9:\"thumb_alt\";s:78:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetreviews.svg\";s:4:\"docs\";s:66:\"https://crocoblock.com/knowledge-base/article-category/jetreviews/\";s:4:\"demo\";s:42:\"https://crocoblock.com/plugins/jetreviews/\";s:4:\"desc\";s:41:\"Reviews Widget for Elementor Page Builder\";}s:21:\"jet-menu/jet-menu.php\";a:8:{s:4:\"name\";s:7:\"JetMenu\";s:4:\"slug\";s:21:\"jet-menu/jet-menu.php\";s:7:\"version\";s:5:\"2.0.5\";s:5:\"thumb\";s:71:\"https://account.crocoblock.com/free-download/images/jetlogo/jetmenu.svg\";s:9:\"thumb_alt\";s:75:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetmenu.svg\";s:4:\"docs\";s:64:\"https://crocoblock.com/knowledge-base/article-category/jet-menu/\";s:4:\"demo\";s:39:\"https://crocoblock.com/plugins/jetmenu/\";s:4:\"desc\";s:41:\"A top-notch mega menu addon for Elementor\";}s:21:\"jet-blog/jet-blog.php\";a:8:{s:4:\"name\";s:7:\"JetBlog\";s:4:\"slug\";s:21:\"jet-blog/jet-blog.php\";s:7:\"version\";s:5:\"2.2.9\";s:5:\"thumb\";s:71:\"https://account.crocoblock.com/free-download/images/jetlogo/jetblog.svg\";s:9:\"thumb_alt\";s:75:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetblog.svg\";s:4:\"docs\";s:64:\"https://crocoblock.com/knowledge-base/article-category/jet-blog/\";s:4:\"demo\";s:39:\"https://crocoblock.com/plugins/jetblog/\";s:4:\"desc\";s:43:\"Blogging Package for Elementor Page Builder\";}s:25:\"jet-blocks/jet-blocks.php\";a:8:{s:4:\"name\";s:9:\"JetBlocks\";s:4:\"slug\";s:25:\"jet-blocks/jet-blocks.php\";s:7:\"version\";s:5:\"1.2.4\";s:5:\"thumb\";s:73:\"https://account.crocoblock.com/free-download/images/jetlogo/jetblocks.svg\";s:9:\"thumb_alt\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetblocks.svg\";s:4:\"docs\";s:65:\"https://crocoblock.com/knowledge-base/article-category/jetblocks/\";s:4:\"demo\";s:41:\"https://crocoblock.com/plugins/jetblocks/\";s:4:\"desc\";s:64:\" Lots of widgets needed for creating unique headers and footers\";}s:25:\"jet-tricks/jet-tricks.php\";a:8:{s:4:\"name\";s:9:\"JetTricks\";s:4:\"slug\";s:25:\"jet-tricks/jet-tricks.php\";s:7:\"version\";s:6:\"1.2.11\";s:5:\"thumb\";s:73:\"https://account.crocoblock.com/free-download/images/jetlogo/jettricks.svg\";s:9:\"thumb_alt\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jettricks.svg\";s:4:\"docs\";s:65:\"https://crocoblock.com/knowledge-base/article-category/jettricks/\";s:4:\"demo\";s:41:\"https://crocoblock.com/plugins/jettricks/\";s:4:\"desc\";s:28:\"Visual effects for Elementor\";}s:39:\"jet-smart-filters/jet-smart-filters.php\";a:8:{s:4:\"name\";s:15:\"JetSmartFilters\";s:4:\"slug\";s:39:\"jet-smart-filters/jet-smart-filters.php\";s:7:\"version\";s:5:\"2.0.0\";s:5:\"thumb\";s:79:\"https://account.crocoblock.com/free-download/images/jetlogo/jetsmartfilters.svg\";s:9:\"thumb_alt\";s:83:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetsmartfilters.svg\";s:4:\"docs\";s:71:\"https://crocoblock.com/knowledge-base/article-category/jetsmartfilters/\";s:4:\"demo\";s:47:\"https://crocoblock.com/plugins/jetsmartfilters/\";s:4:\"desc\";s:34:\"Advanced filters for any post type\";}s:23:\"jet-popup/jet-popup.php\";a:8:{s:4:\"name\";s:8:\"JetPopup\";s:4:\"slug\";s:23:\"jet-popup/jet-popup.php\";s:7:\"version\";s:5:\"1.4.0\";s:5:\"thumb\";s:72:\"https://account.crocoblock.com/free-download/images/jetlogo/jetpopup.svg\";s:9:\"thumb_alt\";s:76:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetpopup.svg\";s:4:\"docs\";s:65:\"https://crocoblock.com/knowledge-base/article-category/jet-popup/\";s:4:\"demo\";s:40:\"https://crocoblock.com/plugins/jetpopup/\";s:4:\"desc\";s:35:\"Stylish Popup builder for Elementor\";}s:25:\"jet-search/jet-search.php\";a:8:{s:4:\"name\";s:9:\"JetSearch\";s:4:\"slug\";s:25:\"jet-search/jet-search.php\";s:7:\"version\";s:5:\"2.1.7\";s:5:\"thumb\";s:73:\"https://account.crocoblock.com/free-download/images/jetlogo/jetsearch.svg\";s:9:\"thumb_alt\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetsearch.svg\";s:4:\"docs\";s:66:\"https://crocoblock.com/knowledge-base/article-category/jet-search/\";s:4:\"demo\";s:41:\"https://crocoblock.com/plugins/jetsearch/\";s:4:\"desc\";s:37:\"The fastest AJAX search for Elementor\";}s:35:\"jet-woo-builder/jet-woo-builder.php\";a:8:{s:4:\"name\";s:13:\"JetWooBuilder\";s:4:\"slug\";s:35:\"jet-woo-builder/jet-woo-builder.php\";s:7:\"version\";s:5:\"1.6.5\";s:5:\"thumb\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo/jetwoobuilder.svg\";s:9:\"thumb_alt\";s:81:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetwoobuilder.svg\";s:4:\"docs\";s:69:\"https://crocoblock.com/knowledge-base/article-category/jetwoobuilder/\";s:4:\"demo\";s:45:\"https://crocoblock.com/plugins/jetwoobuilder/\";s:4:\"desc\";s:36:\"Everything for WooCommerce&Elementor\";}s:51:\"jet-woo-product-gallery/jet-woo-product-gallery.php\";a:8:{s:4:\"name\";s:17:\"JetProductGallery\";s:4:\"slug\";s:51:\"jet-woo-product-gallery/jet-woo-product-gallery.php\";s:7:\"version\";s:5:\"1.1.5\";s:5:\"thumb\";s:81:\"https://account.crocoblock.com/free-download/images/jetlogo/jetproductgallery.svg\";s:9:\"thumb_alt\";s:85:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetproductgallery.svg\";s:4:\"docs\";s:73:\"https://crocoblock.com/knowledge-base/article-category/jetproductgallery/\";s:4:\"demo\";s:49:\"https://crocoblock.com/plugins/jetproductgallery/\";s:4:\"desc\";s:34:\"Top-notch Elementor gallery plugin\";}s:31:\"jet-compare-wishlist/jet-cw.php\";a:8:{s:4:\"name\";s:19:\"JetCompare&Wishlist\";s:4:\"slug\";s:31:\"jet-compare-wishlist/jet-cw.php\";s:7:\"version\";s:5:\"1.2.1\";s:5:\"thumb\";s:85:\"https://account.crocoblock.com/free-download/images/jetlogo/jetwoocomparewishlist.svg\";s:9:\"thumb_alt\";s:86:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetcomparewishlist.svg\";s:4:\"docs\";s:74:\"https://crocoblock.com/knowledge-base/article-category/jetcomparewishlist/\";s:4:\"demo\";s:50:\"https://crocoblock.com/plugins/jetcomparewishlist/\";s:4:\"desc\";s:27:\"Must-have for online stores\";}s:25:\"jet-engine/jet-engine.php\";a:8:{s:4:\"name\";s:9:\"JetEngine\";s:4:\"slug\";s:25:\"jet-engine/jet-engine.php\";s:7:\"version\";s:6:\"2.4.11\";s:5:\"thumb\";s:73:\"https://account.crocoblock.com/free-download/images/jetlogo/jetengine.svg\";s:9:\"thumb_alt\";s:77:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetengine.svg\";s:4:\"docs\";s:66:\"https://crocoblock.com/knowledge-base/article-category/jet-engine/\";s:4:\"demo\";s:41:\"https://crocoblock.com/plugins/jetengine/\";s:4:\"desc\";s:29:\"Dynamic Content for Elementor\";}s:27:\"jet-booking/jet-booking.php\";a:8:{s:4:\"name\";s:10:\"JetBooking\";s:4:\"slug\";s:27:\"jet-booking/jet-booking.php\";s:7:\"version\";s:5:\"2.1.0\";s:5:\"thumb\";s:74:\"https://account.crocoblock.com/free-download/images/jetlogo/jetbooking.svg\";s:9:\"thumb_alt\";s:78:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetbooking.svg\";s:4:\"docs\";s:66:\"https://crocoblock.com/knowledge-base/article-category/jetbooking/\";s:4:\"demo\";s:42:\"https://crocoblock.com/plugins/jetbooking/\";s:4:\"desc\";s:35:\"Booking functionality for Elementor\";}s:39:\"jet-style-manager/jet-style-manager.php\";a:8:{s:4:\"name\";s:15:\"JetStyleManager\";s:4:\"slug\";s:39:\"jet-style-manager/jet-style-manager.php\";s:7:\"version\";s:5:\"1.0.0\";s:5:\"thumb\";s:79:\"https://account.crocoblock.com/free-download/images/jetlogo/jetstylemanager.svg\";s:9:\"thumb_alt\";s:83:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetstylemanager.svg\";s:4:\"docs\";s:71:\"https://crocoblock.com/knowledge-base/article-category/jetstylemanager/\";s:4:\"demo\";s:47:\"https://crocoblock.com/plugins/jetstylemanager/\";s:4:\"desc\";s:36:\"Manage Elementor page style settings\";}s:53:\"jet-appointments-booking/jet-appointments-booking.php\";a:8:{s:4:\"name\";s:14:\"JetAppointment\";s:4:\"slug\";s:53:\"jet-appointments-booking/jet-appointments-booking.php\";s:7:\"version\";s:5:\"1.1.1\";s:5:\"thumb\";s:79:\"https://account.crocoblock.com/free-download/images/jetlogo/jet-appointment.svg\";s:9:\"thumb_alt\";s:83:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jet-appointment.svg\";s:4:\"docs\";s:70:\"https://crocoblock.com/knowledge-base/article-category/jetappointment/\";s:4:\"demo\";s:46:\"https://crocoblock.com/plugins/jetappointment/\";s:4:\"desc\";s:65:\"A must-have solution to create forms for booking the appointments\";}s:33:\"jet-theme-core/jet-theme-core.php\";a:8:{s:4:\"name\";s:12:\"JetThemeCore\";s:4:\"slug\";s:33:\"jet-theme-core/jet-theme-core.php\";s:7:\"version\";s:6:\"1.1.23\";s:5:\"thumb\";s:76:\"https://account.crocoblock.com/free-download/images/jetlogo/jetthemecore.svg\";s:9:\"thumb_alt\";s:80:\"https://account.crocoblock.com/free-download/images/jetlogo-alt/jetthemecore.svg\";s:4:\"docs\";s:67:\"https://crocoblock.com/knowledge-base/article-category/theme-parts/\";s:4:\"demo\";s:44:\"https://crocoblock.com/plugins/jetthemecore/\";s:4:\"desc\";s:40:\"Create any website from ready-made pages\";}}s:5:\"sites\";a:101:{i:0;s:28:\"greenpharma.design4us.co.il/\";i:1;s:19:\"green-pharma.co.il/\";i:2;s:16:\"startours.co.il/\";i:3;s:17:\"cannabis2u.co.il/\";i:4;s:16:\"epharmacy.co.il/\";i:5;s:16:\"touchfood.co.il/\";i:6;s:17:\"multiplast.co.il/\";i:7;s:13:\"tigbur.co.il/\";i:8;s:16:\"galyasmin.co.il/\";i:9;s:13:\"sheleg.co.il/\";i:10;s:16:\"roomingabox.com/\";i:11;s:19:\"thai-massage.co.il/\";i:12;s:18:\"tigbur-siud.co.il/\";i:13;s:10:\"zhv.co.il/\";i:14;s:14:\"intech.org.il/\";i:15;s:18:\"stage.pirat.co.il/\";i:16;s:13:\"keepit.co.il/\";i:17;s:12:\"pirat.co.il/\";i:18;s:25:\"yanovsky.design4us.co.il/\";i:19;s:14:\"lakoket.co.il/\";i:20;s:14:\"pufim4u.co.il/\";i:21;s:12:\"elipc.co.il/\";i:22;s:29:\"citrindesign.design4us.co.il/\";i:23;s:22:\"manage-my-grocery.com/\";i:24;s:17:\"oforia-art.co.il/\";i:25;s:16:\"tamartivy.co.il/\";i:26;s:12:\"gluya.co.il/\";i:27;s:15:\"tookit-app.com/\";i:28;s:16:\"dogipedia.co.il/\";i:29;s:24:\"diveintothedesert.co.il/\";i:30;s:17:\"moranatias.co.il/\";i:31;s:15:\"dror-adv.co.il/\";i:32;s:16:\"morespace.co.il/\";i:33;s:17:\"investorit.co.il/\";i:34;s:14:\"capisce.co.il/\";i:35;s:20:\"alonlocksmith.co.il/\";i:36;s:14:\"falikmd.co.il/\";i:37;s:18:\"milasheldor.co.il/\";i:38;s:15:\"sevenlaw.co.il/\";i:39;s:16:\"nofnadlan.co.il/\";i:40;s:15:\"rb-taxes.co.il/\";i:41;s:17:\"yafitmoyal.co.il/\";i:42;s:14:\"kelimba.co.il/\";i:43;s:14:\"carroself.com/\";i:44;s:15:\"vilonika.co.il/\";i:45;s:16:\"netzerariel.org/\";i:46;s:17:\"dvoritlevi.co.il/\";i:47;s:20:\"ilan-big-taxi.co.il/\";i:48;s:12:\"kobib.co.il/\";i:49;s:13:\"iritdvir.com/\";i:50;s:17:\"shaylilock.co.il/\";i:51;s:21:\"eliav-consulting.com/\";i:52;s:23:\"eliav-consulting.co.il/\";i:53;s:23:\"stage.zahavi-yeutz.com/\";i:54;s:17:\"prof-reich.co.il/\";i:55;s:22:\"noellacosmetics.co.il/\";i:56;s:15:\"sarhangi.co.il/\";i:57;s:14:\"curvision.com/\";i:58;s:12:\"lucas.co.il/\";i:59;s:15:\"asulinit.co.il/\";i:60;s:22:\"azulay-motidana.co.il/\";i:61;s:13:\"over30.co.il/\";i:62;s:13:\"snslaw.co.il/\";i:63;s:16:\"ml-design.co.il/\";i:64;s:13:\"2bbari.co.il/\";i:65;s:10:\"ubu.co.il/\";i:66;s:15:\"an-shilo.co.il/\";i:67;s:10:\"kee.co.il/\";i:68;s:19:\"michalyphoto.co.il/\";i:69;s:21:\"orenfrankmusic.co.il/\";i:70;s:20:\"eden-hadbarot.co.il/\";i:71;s:13:\"paicpa.co.il/\";i:72;s:15:\"mabatnet.co.il/\";i:73;s:15:\"revivo-fun.com/\";i:74;s:19:\"israelicyber.co.il/\";i:75;s:18:\"mammymarket.co.il/\";i:76;s:14:\"gimbory.co.il/\";i:77;s:20:\"hakol-mischak.co.il/\";i:78;s:14:\"bella-s.co.il/\";i:79;s:18:\"facial-care.co.il/\";i:80;s:25:\"easystat.design4us.co.il/\";i:81;s:14:\"urwomen.co.il/\";i:82;s:15:\"care4all.co.il/\";i:83;s:14:\"magen-law.com/\";i:84;s:21:\"kaitringhadran.co.il/\";i:85;s:13:\"radvin.co.il/\";i:86;s:22:\"ahoyt.design4us.co.il/\";i:87;s:18:\"arinaballas.co.il/\";i:88;s:18:\"mangoni-law.co.il/\";i:89;s:15:\"maratonltd.com/\";i:90;s:17:\"motke-travel.com/\";i:91;s:16:\"pergula4u.co.il/\";i:92;s:31:\"xn----zhcafneepdmens6d4e.co.il/\";i:93;s:16:\"eytansela.co.il/\";i:94;s:16:\"anglebase.co.il/\";i:95;s:15:\"softmetrix.com/\";i:96;s:17:\"michadotan.co.il/\";i:97;s:15:\"sarusi-law.com/\";i:98;s:18:\"pishpeshim.org.il/\";i:99;s:14:\"guy-nlp.co.il/\";i:100;s:18:\"snapir-swim.co.il/\";}}}}}',	'yes'),
(249,	'jet_theme_core_sync',	'true',	'yes'),
(255,	'jet_is_modify_tm_license_data',	'true',	'yes'),
(271,	'category_children',	'a:0:{}',	'yes'),
(283,	'_transient_health-check-site-status-result',	'{\"good\":\"11\",\"recommended\":\"9\",\"critical\":\"0\"}',	'yes'),
(237,	'jet_theme_core_license',	'877e4bb86f76a38df75c36354a2845dc',	'no'),
(238,	'jet_excluded_plugins',	'a:0:{}',	'no'),
(7532,	'_transient_timeout__woocommerce_helper_subscriptions',	'1604252286',	'no'),
(7533,	'_transient__woocommerce_helper_subscriptions',	'a:0:{}',	'no'),
(7580,	'7238c9070c32ed98a38810e053129a9a',	'a:2:{s:7:\"timeout\";i:1604294984;s:5:\"value\";a:17:{s:14:\"stable_version\";s:5:\"3.0.5\";s:12:\"last_updated\";s:19:\"2020-09-23 14:17:56\";s:8:\"sections\";s:109206:\"a:2:{s:11:\"description\";s:161:\"Elementor Pro adds new features to the Elementor Page Builder plugin. Control your conversions, your user engagement, your entire website, from one page builder.\";s:9:\"changelog\";s:108983:\"<h4>3.0.5 - 2020-09-23</h4>\n<ul>\n<li>Fix: If the default page layout is set to &quot;Canvas&quot; Headers and Footers cannot be edited</li>\n<li>Fix: Product Image Dynamic Tag throws an error when no image is set</li>\n<li>Fix: Missing Single document placeholder in Theme Builder</li>\n<li>Fix: Document editing handles inherit the <code>font-family</code> from 3rd party source</li>\n<li>Fix: Can\'t add linebreaks to Textarea input when used as Multi Step Form</li>\n<li>Fix: Incorrect width in Facebook Page widget</li>\n<li>Fix: Added compatibility to allow the use of \'get_create_url\' in Theme Builder</li>\n</ul>\n<h4>3.0.4 - 2020-09-09</h4>\n<ul>\n<li>Fix: Autogenerated screenshots appear in WP Media Library modal (<a href=\"https://github.com/elementor/elementor/issues/12304\">#12304</a>)</li>\n<li>Fix: Make sure Elementor Posts widget Pagination doesn\'t interfere with 3rd party plugins (<a href=\"https://github.com/elementor/elementor/issues/12126\">#12126</a>, <a href=\"https://github.com/elementor/elementor/issues/12127\">#12127</a>)</li>\n<li>Fix: Shrinking conditions indicator in Theme Builder</li>\n<li>Fix: Column can\'t be dragged and dropped if it populates a Global widget</li>\n<li>Fix: Styles are missing from Single templates in some edge cases</li>\n</ul>\n<h4>3.0.3 - 2020-09-02</h4>\n<ul>\n<li>Fix: Pagination doesn\'t work in WordPress 5.5 (<a href=\"https://github.com/elementor/elementor/issues/12126\">#12126</a>, <a href=\"https://github.com/elementor/elementor/issues/12127\">#12127</a>)</li>\n<li>Fix: Change delete template action to &quot;Move to Trash&quot; in the new Theme Builder view</li>\n</ul>\n<h4>3.0.2 - 2020-08-31</h4>\n<ul>\n<li>Tweak: Replaced WordPress &quot;Learn More&quot; links with dynamic links for better control over time (<a href=\"https://github.com/elementor/elementor/issues/12312\">#12312</a>)</li>\n<li>Tweak: UI tweaks to the Conditions screen In the new Theme Builder</li>\n<li>Fix: Motion Effects not working when assigned to a column and throws JS error when DOM optimization is disabled (<a href=\"https://github.com/elementor/elementor/issues/12299\">#12299</a>, <a href=\"https://github.com/elementor/elementor/issues/12275\">#12275</a>)</li>\n<li>Fix: Multiple Galleries display all the images in the Lightbox slideshow (<a href=\"https://github.com/elementor/elementor/issues/11809\">#11809</a>)</li>\n<li>Fix: Old Theme Builder is being opened when accessing through the Finder</li>\n<li>Fix: Mixed templates import glitch in Theme Builder</li>\n<li>Fix: Card icon sizes in Theme Builder</li>\n<li>Fix: Preview button leads to <code>render_mode</code> instead of preview when importing a template from the new Theme Builder</li>\n</ul>\n<h4>3.0.1 - 2020-08-26</h4>\n<ul>\n<li>Tweak: Keep previous Theme Builder when accessing from the WP Dashboard for legacy support</li>\n<li>Tweak: Updated video tutorials in Theme Builder</li>\n<li>Tweak: Don\'t show auto-screenshots in the Media Library (Props <a href=\"https://github.com/black-eye\">@black-eye</a>)</li>\n<li>Fix: Repeater items throws <code>childView</code> is undefined message in Forms widget (<a href=\"https://github.com/elementor/elementor/issues/12239\">#12239</a>, <a href=\"https://github.com/elementor/elementor/issues/12221\">#12221</a>)</li>\n<li>Fix: Misspelling of the word &quot;occurred&quot; in Form widget default error message (<a href=\"https://github.com/elementor/elementor/issues/12137\">#12137</a>)</li>\n<li>Fix: Facebook comments not showing up (<a href=\"https://github.com/elementor/elementor/issues/12157\">#12157</a>)</li>\n<li>Fix: Check for conflicts in Theme Builder doesn\'t work properly</li>\n<li>Fix: Minor UI fixes in Theme Builder</li>\n<li>Fix: Dark mode glitches in Theme Builder</li>\n<li>Fix: Global Site Part toaster appears when you publish a Popup</li>\n<li>Fix: Site Parts aren\'t in the correct order in Theme Builder</li>\n<li>Fix: Date field caused forms to get corrupted in Forms widget</li>\n<li>Fix: Theme Builder application page is forbidden</li>\n</ul>\n<h4>3.0.0 - 2020-08-23</h4>\n<ul>\n<li>New: Introducing the new and improved Theme Builder</li>\n<li>Tweak: Removed <code>.elementor-inner</code> and <code>.elementor-column-wrap</code> from DOM output to improve performance (<a href=\"https://github.com/elementor/elementor/issues/7351\">#7351</a>, <a href=\"https://github.com/elementor/elementor/issues/7817\">#7817</a>, <a href=\"https://developers.elementor.com/dom-improvements-ahead-html-wrappers-removal-from-v3-0/\">Developers Blog Post</a>)</li>\n<li>Tweak: Added contextual anchors ID support to Table of Contents widgets (<a href=\"https://github.com/elementor/elementor/issues/10052\">#10052</a>)</li>\n<li>Tweak: Added WeChat and Weibo social networks to Share Buttons widget (<a href=\"https://github.com/elementor/elementor/issues/11554\">#11554</a>)</li>\n<li>Tweak: Added Dynamic capabilities for Redirect after Login/Logout in Login widget (<a href=\"https://github.com/elementor/elementor/issues/11343\">#11343</a>)</li>\n<li>Tweak: Added Blend Mode and CSS Filters controls to adjust the Background Overlay in Flipbox widget (<a href=\"https://github.com/elementor/elementor/issues/11653\">#11653</a>)</li>\n<li>Tweak: Added responsive capabilities to Toggle Button styling in Nav Menu widget (<a href=\"https://github.com/elementor/elementor/issues/8269\">#8269</a>)</li>\n<li>Tweak: Added responsive Text Alignment control in Call to Action widget (<a href=\"https://github.com/elementor/elementor/issues/11968\">#11968</a>)</li>\n<li>Tweak: Added dynamic content to Ribbon element in Call to Action widget (<a href=\"https://github.com/elementor/elementor/issues/10364\">#10364</a>)</li>\n<li>Tweak: Converted uses of Color and Typography Schemes to Global Colors and Fonts</li>\n<li>Tweak: Separated Title and Description control fields labels in Call to Action widget</li>\n<li>Tweak: Removed unnecessary style in WC Product with variations</li>\n<li>Tweak: Converted Portfolio, Posts and Share Buttons widgets to use CSS Variable-based Elementor Grid (<a href=\"https://developers.elementor.com/elementor-dropping-support-ie/\">Developers Blog Post</a>)</li>\n<li>Tweak: Added Date Modified option to Posts widget metadata</li>\n<li>Fix: PHP 7.4 compatibility to Media Carousel widget (<a href=\"https://github.com/elementor/elementor/issues/11355\">#11355</a>)</li>\n<li>Fix: Divider alignment issue in Post Info widget (<a href=\"https://github.com/elementor/elementor/issues/11628\">#11628</a>)</li>\n<li>Fix: Color doesn’t change in Products Archive Description widget</li>\n<li>Fix: WC Product variations layout breaks when using Variation Swatches plugin</li>\n<li>Fix: WC Product variations layout issue</li>\n<li>Fix: WC Product variations mobile zoom-in glitch</li>\n<li>Fix: Can\'t edit a Popup after accessing Theme Style</li>\n<li>Fix: Twitter icon missing in Blockquote widget</li>\n<li>Fix: Removed redundant default text color from Share Buttons minimal skin</li>\n<li>Fix: UI glitch in Display Conditions modal</li>\n<li>Fix: Insert template button UI glitch in Templates Library</li>\n<li>Fix: Added sanitization to post titles in WordPress dashboard for better security</li>\n<li>Fix: Show when arriving from search engines rule doesn\'t work in Popup</li>\n<li>Fix: Child categories are shown with a different parent category in Query control</li>\n<li>Deprecated: See all deprecations to this version in our <a href=\"https://developers.elementor.com/v3-0-planned-deprecations/\">Developers Deprecations Post</a></li>\n</ul>\n<h4>2.10.3 - 2020-06-29</h4>\n<ul>\n<li>Fix: Form not being submitted when using &quot;Progress Bar&quot; and &quot;None&quot; view types in Multi Step Form (<a href=\"https://github.com/elementor/elementor/issues/11596\">#11596</a>, <a href=\"https://github.com/elementor/elementor/issues/11610\">#11610</a>)</li>\n<li>Fix: Missing &quot;for&quot; attribute in Password field label in Login widget (<a href=\"https://github.com/elementor/elementor/issues/8646\">#8646</a>)</li>\n</ul>\n<h4>2.10.2 - 2020-06-16</h4>\n<ul>\n<li>Fix: Run step events only when in Multi Step Form mode (<a href=\"https://github.com/elementor/elementor/issues/11644\">#11644</a>)</li>\n</ul>\n<h4>2.10.1 - 2020-06-16</h4>\n<ul>\n<li>Tweak: Improved License validation mechanism to avoid limitations</li>\n<li>Tweak: Changed control labels and ordering in Price Table, Lottie and Form widgets</li>\n<li>Fix: Popup close button vertical position glitch (<a href=\"https://github.com/elementor/elementor/issues/10921\">#10921</a>)</li>\n<li>Fix: Radio field placement glitch when in Multi Step mode in Form widget</li>\n<li>Fix: Clicking <code>Enter</code> key submits the form in Multi Step Form</li>\n<li>Fix: Hardened sanitization in Custom Attributes to avoid security issues</li>\n</ul>\n<h4>2.10.0 - 2020-06-07</h4>\n<ul>\n<li>New: Introducing Multi-Step Forms - Breakdown long forms into simple steps (<a href=\"https://github.com/elementor/elementor/issues/5975\">#5975</a>, <a href=\"https://github.com/elementor/elementor/issues/3911\">#3911</a>)</li>\n<li>New: Introducing Lottie widget - easily add Lottie animations to your site, no coding needed (<a href=\"https://github.com/elementor/elementor/issues/11026\">#11026</a>)</li>\n<li>Tweak: Added spacing option to Posts widget pagination (<a href=\"https://github.com/elementor/elementor/issues/5682\">#5682</a>)</li>\n<li>Tweak: Changed texts and logic for administrator plugin renewal notices</li>\n<li>Tweak: Added new Scroll Util for improved scrolling handling</li>\n<li>Tweak: Improved Motion Effects animation performance</li>\n</ul>\n<h4>2.9.5 - 2020-05-24</h4>\n<ul>\n<li>Fix: Added sanitization to Custom Attributes control to avoid security issue</li>\n</ul>\n<h4>2.9.4 - 2020-05-07</h4>\n<ul>\n<li>Fix: Hardened user role that is allowed to upload icon sets and unzip only allowed files in Custom Icons to prevent security vulnerability</li>\n</ul>\n<h4>2.9.3 - 2020-04-19</h4>\n<ul>\n<li>Fix: Form shortcode IDs are not wrapped in double-quotes (<a href=\"https://github.com/elementor/elementor/issues/11023\">#11023</a>, <a href=\"https://github.com/elementor/elementor/issues/10932\">#10932</a>, <a href=\"https://github.com/elementor/elementor/issues/10967\">#10967</a>, <a href=\"https://github.com/elementor/elementor/issues/11000\">#11000</a>, <a href=\"https://github.com/elementor/elementor/issues/11049\">#11049</a>)</li>\n<li>Fix: Escaped Form records metadata to prevent security vulnerability</li>\n<li>Fix: Closing &quot;Save Changes&quot; document confirmation modal causes Panel infinite loading</li>\n<li>Fix: Ken Burns effect not working when there is only one slide in Slides widget</li>\n<li>Fix: Document handles UI glitch</li>\n</ul>\n<h4>2.9.2 - 2020-03-25</h4>\n<ul>\n<li>Tweak: Added compatibility with WordPress v5.4 (<a href=\"https://github.com/elementor/elementor/issues/10745\">#10745</a>)</li>\n<li>Fix: Image ratio number is displayed under the Archive Posts widget (<a href=\"https://github.com/elementor/elementor/issues/10874\">#10874</a>)</li>\n<li>Fix: Theme Style Link color setting overrides the Table of Content list style</li>\n<li>Fix: PHP notice when using dynamic user info <code>id</code></li>\n<li>Fix: Navigation arrows direction is crossed on first drag in Slides Widget</li>\n<li>Fix: &quot;No headings were found on this page&quot; message was not displayed in the frontend in Table of Contents widget</li>\n<li>Fix: Container includes Popup tags by default in Table of Contents widget</li>\n<li>Fix: Twitter icon display issue when Font Awesome 4 support is disabled in Blockquote widget</li>\n<li>Fix: ACF Dynamic tag not working in Form widget Redirect action</li>\n</ul>\n<h4>2.9.1 - 2020-03-16</h4>\n<ul>\n<li>Fix: Can\'t access Elementor Editor when there is Page Title widget in the page</li>\n<li>Fix: Applying styling to Post Content widget affects the Page and Post editing handles</li>\n</ul>\n<h4>2.9.0 - 2020-03-15</h4>\n<ul>\n<li>New: Introducing Full Site Editing: Design header, footer, and content all in one place! (<a href=\"https://github.com/elementor/elementor/issues/4985\">#4985</a>)</li>\n<li>New: Added Global Custom CSS for Your Entire Site in Theme Style (<a href=\"https://github.com/elementor/elementor/issues/3345\">#3345</a>)</li>\n<li>New: Added Dynamic Colors tag (<a href=\"https://github.com/elementor/elementor/issues/6485\">#6485</a>)</li>\n<li>Tweak: Added option to set the Site Part HTML Wrapper Tags (<a href=\"https://github.com/elementor/elementor/issues/9293\">#9293</a>)</li>\n<li>Tweak: Added Link Attributes support to Pro widgets (<a href=\"https://github.com/elementor/elementor/issues/5716\">#5716</a>, <a href=\"https://github.com/elementor/elementor/issues/3642\">#3642</a>, <a href=\"https://github.com/elementor/elementor/issues/9225\">#9225</a>, <a href=\"https://github.com/elementor/elementor/issues/9079\">#9079</a>)</li>\n<li>Tweak: Added Theme Style support in Theme Builder parts (<a href=\"https://github.com/elementor/elementor/issues/10564\">#10564</a>)</li>\n<li>Tweak: Avoid creating empty Custom Font</li>\n<li>Tweak: Added <code>aria-expanded</code> attribute to Menu Cart widget</li>\n<li>Tweak: Moved Link Actions module to Core plugin</li>\n<li>Tweak: Changed the name of “TypeKit Web Fonts by Adobe” to “Adobe Fonts”</li>\n<li>Tweak: Removed redundant display conditions from Blockquote, Flipbox, Price Table, and Search Form widgets</li>\n<li>Tweak: Pro widgets are not draggable unless Elementor license has been activated</li>\n<li>Tweak: Remove redundant <code>label_block</code> parameters from several controls</li>\n<li>Tweak: Converted controls selectors to CSS variables in Gallery widget</li>\n<li>Tweak: Replaced Stumbleupon with Mix in Reviews widget recommended icons (<a href=\"https://github.com/elementor/elementor/issues/10099\">#10099</a>)</li>\n<li>Tweak: Added Mix to the Share Buttons network list (<a href=\"https://github.com/elementor/elementor/issues/10099\">#10099</a>)</li>\n<li>Tweak: Added &quot;Open in new tab&quot; option to Posts widget (<a href=\"https://github.com/elementor/elementor/issues/7924\">#7924</a>)</li>\n<li>Tweak: Upgraded Font Awesome Pro library to v5.12.0</li>\n<li>Tweak: Added new Lightbox compatibility for Gallery and Media Carousel widgets</li>\n<li>Tweak: Expose external API for Swiper instances</li>\n<li>Tweak: Added compatibility to JS API in Theme Builder, Popups, Form widget and Global widget</li>\n<li>Tweak: Replaced nerd icons with new Elementor emojis</li>\n<li>Tweak: Added specific <code>color</code> attribute to header title in Table of Contents widget</li>\n<li>Fix: Line break issues in Animated Headline widget (<a href=\"https://github.com/elementor/elementor/issues/10585\">#10585</a>)</li>\n<li>Fix: Theme Style Link color overrides the Table of Content list style</li>\n<li>Fix: Active state glitches when using Table of contents widget with Sticky mode</li>\n<li>Fix: &quot;Graphic Element&quot; section appears as empty in case of unmarked Graphic Element in Call to Action widget</li>\n<li>Fix: Page Title widget render glitches in the Editor</li>\n<li>Fix: Image ratio parameter visible in some edge cases in Posts widget</li>\n<li>Fix: Image missing when sharing to Pinterest using Share Buttons widget</li>\n<li>Fix: Theme Style Link color setting override the list style in Table of Contents widget</li>\n<li>Deprecated: See all deprecations to this version in our <a href=\"https://developers.elementor.com/v2-9-0-planned-deprecations/\">Developers Deprecations Post</a></li>\n</ul>\n<h4>2.8.5 - 2020-03-08</h4>\n<ul>\n<li>Tweak: Added new Swiper parameter to all Pro carousels to allow 3rd party integration</li>\n<li>Fix: Missing closing bracket in Animated Headline widget</li>\n<li>Fix: Share buttons widgets show Font Awesome 4 icons on first drag in Editor</li>\n</ul>\n<h4>2.8.4 - 2020-02-16</h4>\n<ul>\n<li>Tweak: Added Lightbox Title &amp; Description support to Gallery widget</li>\n<li>Tweak: Added RTL support for Slides widget</li>\n<li>Tweak: Display Lightbox images in Full size in Gallery widget</li>\n<li>Fix: Template with Slides widget not working properly when placed inside Tabs, Accordion and Toggle widget</li>\n<li>Fix: Dropdown menu lost styling after Elementor Pro v2.8 upgrade in Nav Menu widget</li>\n<li>Fix: Indent doesn\'t work on RTL websites in Table of Contents widget</li>\n<li>Fix: Query Control throws <code>Undefined index: q</code> error</li>\n<li>Fix: Typography control not affecting dropdown menu in Nav Menu widget</li>\n<li>Fix: Discord forms integration fails to send submissions in some server configurations</li>\n<li>Fix: Rotating headlines don\'t align center in Animated Headline widget</li>\n<li>Fix: Custom secondary color displayed when not needed in Share buttons widget</li>\n<li>Fix: Motion Effects of certain objects are not functioning properly on Safari browser</li>\n<li>Fix: Missing eye icon in Single template footer preview button</li>\n</ul>\n<h4>2.8.3 - 2020-01-01</h4>\n<ul>\n<li>Tweak: Updated Table of Contents widget panel location</li>\n<li>Fix: ACF URL Dynamic field throws <code>undefined index</code> PHP notice (<a href=\"https://github.com/elementor/elementor/issues/9929\">#9929</a>)</li>\n<li>Fix: Gallery lightbox pagination shows images from all tabs</li>\n<li>Fix: &quot;Reply To&quot; option not working in Form widget &quot;Email 2&quot; Action</li>\n<li>Fix: ACF Dynamic tag not working in Form widget Redirect action</li>\n<li>Fix: Underline option not working in Table of Contents widget Normal state</li>\n<li>Fix: Query Control <code>Undefined index: autocomplete</code> notice in some cases</li>\n<li>Fix: Missing display condition to Read More Spacing control in Posts widget</li>\n</ul>\n<h4>2.8.2 - 2019-12-19</h4>\n<ul>\n<li>Tweak: Improved scroll-spy and collapsing functionality in Table of Contents widget</li>\n<li>Fix: &quot;No products were found&quot; message not being displayed in an empty Products Archive</li>\n<li>Fix: Redundant <code>&lt;br&gt;</code> tags in Single theme template (<a href=\"https://github.com/elementor/elementor/issues/9927\">#9927</a>, <a href=\"https://github.com/elementor/elementor/issues/9928\">#9928</a>)</li>\n<li>Fix: Draft Popup shows up in Dynamic tag dropdown</li>\n</ul>\n<h4>2.8.1 - 2019-12-18</h4>\n<ul>\n<li>Fix: Share Buttons widget not working (<a href=\"https://github.com/elementor/elementor/issues/9920\">#9920</a>)</li>\n<li>Fix: Redundant <code>&lt;p&gt;</code> tags added to Single Template posts</li>\n</ul>\n<h4>2.8.0 - 2019-12-18</h4>\n<ul>\n<li>New: Table of Contents Widget (<a href=\"https://github.com/elementor/elementor/issues/5171\">#5171</a>)</li>\n<li>New: Added Font Awesome Pro Duotone font family support (<a href=\"https://github.com/elementor/elementor/issues/9578\">#9578</a>)</li>\n<li>Tweak: Added Lazy Load option to Gallery widget (<a href=\"https://github.com/elementor/elementor/issues/9763\">#9763</a>)</li>\n<li>Tweak: Added Random order option to Gallery widget (<a href=\"https://github.com/elementor/elementor/issues/9269\">#9269</a>)</li>\n<li>Tweak: Updated Font Awesome Pro to v5.11.2 (<a href=\"https://github.com/elementor/elementor/issues/9578\">#9578</a>)</li>\n<li>Tweak: Added preselect support for multiple default select values in Forms Widget (<a href=\"https://github.com/elementor/elementor/issues/9324\">#9324</a>)</li>\n<li>Tweak: Avoid duplicate queries for Custom Icons (<a href=\"https://github.com/elementor/elementor/issues/9579\">#9579</a>)</li>\n<li>Tweak: Major performance improvements to Gallery widget</li>\n<li>Tweak: Avoid non-existing images in Gallery widget</li>\n<li>Tweak: Added <code>tabindex</code>, <code>aria-expanded</code>, <code>aria-hidden</code> and <code>role=\"navigation\"</code> accessibility attributes to Nav Menu widget</li>\n<li>Tweak: Changed button HTML tag from <code>button</code> to <code>span</code> in Call to Action and Flip Box widgets for better W3C compliance and accessibility</li>\n<li>Tweak: Removed Google+ from default networks in Share Buttons widget</li>\n<li>Tweak: Added compatibility for Library Connect</li>\n<li>Tweak: Added i18n to Toolset date dynamic tag</li>\n<li>Tweak: Added external link support to Gallery widget</li>\n<li>Tweak: Changed the link external attributes implementation to use <code>add_link_attributes()</code> in Gallery widget</li>\n<li>Tweak: Updated references to the new Schemes system location</li>\n<li>Tweak: Avoid running Gallery handler when the gallery is empty</li>\n<li>Tweak: UI Tweaks in Editor Panel</li>\n<li>Tweak: Added responsive capabilities to Pointer Width control in Nav Menu widget</li>\n<li>Tweak: Added mobile support for responsive controls in Nav Menu widget</li>\n<li>Tweak: Refactor <code>register_controls()</code> method in Posts widget skin trait</li>\n<li>Fix: ACF URL &quot;undefined Index&quot; notice (<a href=\"https://github.com/elementor/elementor/issues/7646\">#7646</a>)</li>\n<li>Fix: WooCommerce Mini-Cart widget causes fatal error in edge cases (<a href=\"https://github.com/elementor/elementor/issues/9304\">#9304</a>)</li>\n<li>Fix: <code>PHP Notice: Undefined index</code> display for Author query (<a href=\"https://github.com/elementor/elementor/issues/9864\">#9864</a>)</li>\n<li>Fix: Added compatibility for Button widget placed inside Swiper carousel (<a href=\"https://wordpress.org/support/topic/broken-buttons-since-elementor-2-8/\">Topic</a>)</li>\n<li>Fix: Avoid empty spaces in Post info widget</li>\n<li>Tweak: Always show &quot;Custom label&quot; control in Login widget</li>\n<li>Fix: Nav Menu item typography selector in Nav Menu widget</li>\n<li>Fix: Facebook Like Button widget causes flickering</li>\n<li>Fix: WooCommerce mini-cart behaviour when using <code>plain</code> permalinks format</li>\n<li>Fix: Avoid running Popup triggers when set without conditions</li>\n<li>Fix: Removed &quot;Date&quot; query from Products widget</li>\n<li>Fix: Slides widget when used as a Shortcode and is hidden</li>\n<li>Fix: Custom URL being accessed on swipe in Media Carousel</li>\n<li>Fix: Media Carousel widget Cube effect glitch</li>\n<li>Fix: Lightbox shows images from multiple Gallery widgets in the same page</li>\n<li>Fix: Image <code>alt</code> Text not displayed on overlay in Gallery widget</li>\n<li>Fix: Gallery widget not visible in Posts widget Full Content skin</li>\n<li>Fix: WooCommerce mini-cart remove unnecessary hooks registration when WooCommerce integration set to <code>Disable</code></li>\n<li>Fix: Slides widget button wrapping breaks in mobile view</li>\n<li>Fix: Dynamic capabilities with the Reviews widget</li>\n<li>Fix: Disabling autoplay doesn\'t work in Slides widget</li>\n<li>Fix: Posts widget Full Content skin not working on Single template</li>\n<li>Fix: Autocomplete not working for &quot;By Author&quot; condition in Display Conditions screen</li>\n<li>Fix: Posts widget alignment issue</li>\n<li>Fix: Product Variations Clear button not working in edge cases</li>\n<li>Fix: Styling issues in Form widget submit button</li>\n</ul>\n<h4>2.7.3 - 2019-10-28</h4>\n<ul>\n<li>Tweak: Added RTL support to Galleries widget (<a href=\"https://github.com/elementor/elementor/issues/9213\">#9213</a>)</li>\n<li>Tweak: Added Custom Icons compatibility for WordPress 5.3</li>\n<li>Fix: Missing template function declaration causes fatal error in WC mini-cart widget</li>\n<li>Fix: Pause on hover doesn\'t work in Carousel widgets</li>\n<li>Fix: Link-actions conflict with <code>?action=</code> parameter in the URL</li>\n<li>Fix: Lightbox navigation not working in Gallery widget Single mode</li>\n<li>Fix: Ken burns effect not working on the 1st slide if Infinite Loop option is turned off in Carousel widgets</li>\n<li>Fix: Popup Advanced Rules detects internal links as external if current URL starts with <code>www</code></li>\n</ul>\n<h4>2.7.2 - 2019-10-06</h4>\n<ul>\n<li>Fix: Slide Overlay not working when applying Ken burns effect in Slides widget (<a href=\"https://github.com/elementor/elementor/issues/9209\">#9209</a>)</li>\n<li>Fix: Content width glitch in Slides widget (<a href=\"https://github.com/elementor/elementor/issues/9180\">#9180</a>)</li>\n<li>Fix: Horizontal Alignment not working when applying custom style per slide in Slides widget (<a href=\"https://github.com/elementor/elementor/issues/9180\">#9180</a>)</li>\n<li>Fix: Missing semicolon in Custom Fonts <code>font-display</code> CSS</li>\n</ul>\n<h4>2.7.1 - 2019-09-26</h4>\n<ul>\n<li>Fix: Background Overlay layer is over the slide content in Slides widget (<a href=\"https://github.com/elementor/elementor/issues/9180\">#9180</a>)</li>\n<li>Fix: Duplicate images under &quot;All&quot; filter in Multiple Gallery</li>\n</ul>\n<h4>2.7.0 - 2019-09-24</h4>\n<ul>\n<li>New: Enhanced Galleries widget (<a href=\"https://github.com/elementor/elementor/issues/1898\">#1898</a>, <a href=\"https://github.com/elementor/elementor/issues/3103\">#3103</a>, <a href=\"https://github.com/elementor/elementor/issues/4279\">#4279</a>, <a href=\"https://github.com/elementor/elementor/issues/7631\">#7631</a>)</li>\n<li>New: Dynamic Number (<a href=\"https://github.com/elementor/elementor/issues/5952\">#5952</a>)</li>\n<li>New: Full content skin for Posts and Archive-posts widgets (<a href=\"https://github.com/elementor/elementor/issues/4617\">#4617</a>)</li>\n<li>Tweak: Added dynamic number capability to Price List, Price Table, Counter, Star Rating, Progress Bar widgets</li>\n<li>Tweak: Added tags support to forms Mailchimp action (<a href=\"https://github.com/elementor/elementor/issues/5418\">#5418</a>)</li>\n<li>Tweak: User Profile Picture Dynamic Tag (<a href=\"https://github.com/elementor/elementor/issues/7947\">#7947</a>, <a href=\"https://github.com/elementor/elementor/issues/8740\">#8740</a>)</li>\n<li>Tweak: Added <code>font-display</code> support to custom fonts (<a href=\"https://github.com/elementor/elementor/issues/5993\">#5993</a>, <a href=\"https://developers.elementor.com/elementor-pro-2-7-custom-fonts-font-display-support/\">Developers Blog Post</a>)</li>\n<li>Tweak: Added Text Shadow control to Slides widget (<a href=\"https://github.com/elementor/elementor/issues/8800\">#8800</a>)</li>\n<li>Tweak: Added Re-subscribe support to MailerLite (<a href=\"https://github.com/elementor/elementor/issues/8799\">#8799</a>)</li>\n<li>Tweak: Added Dynamic capabilities to Facebook Embed widget (<a href=\"https://github.com/elementor/elementor/issues/9030\">#9030</a>)</li>\n<li>Tweak: Use <code>swiper.js</code> instead of <code>slick.js</code> in Slides widget (<a href=\"https://developers.elementor.com/elementor-2-7-moving-sliders-from-slick-to-swiper/\">Developers Blog Post</a>)</li>\n<li>Tweak: Added <code>elementor_pro/search_form/before_input</code> action hook to Search Form widget (<a href=\"https://github.com/elementor/elementor/issues/5598\">#5598</a>)</li>\n<li>Tweak: Added <code>elementor_pro/search_form/after_input</code> action hook to Search Form widget (<a href=\"https://github.com/elementor/elementor/issues/5598\">#5598</a>)</li>\n<li>Tweak: Added dynamic support for Custom field key (<a href=\"https://github.com/elementor/elementor/issues/7789\">#7789</a>)</li>\n<li>Tweak: Increased expired license notice bar frequency</li>\n<li>Tweak: Changed the icon name of Slides widget</li>\n<li>Tweak: Added designated Finder\'s Icons for Custom icons &amp; Custom fonts</li>\n<li>Tweak: Use Ken Burns Effect as an external module</li>\n<li>Tweak: Remove Fontello conflicting CSS on import to Custom Icons sets</li>\n<li>Tweak: Editor Panel UI tweaks</li>\n<li>Tweak: Added DOM events on Popup show/hide (<a href=\"https://developers.elementor.com/elementor-pro-2-7-popup-events/\">Developers Blog Post</a>)</li>\n<li>Tweak: Added option to change the variations field width in Add to Cart widget</li>\n<li>Tweak: Use select control instead of select2 in Menu Cart widget</li>\n<li>Tweak: Added conditions to the tabs instead of to each control in Share Buttons widget</li>\n<li>Tweak: Added Typography controls to HTML field in Forms widget</li>\n<li>Tweak: Allow edit selected Font file in Custom Font</li>\n<li>Tweak: Changed reCAPTCHA v3 error message</li>\n<li>Tweak: Remove the &quot;Save as Global&quot; option on Global widget context menu</li>\n<li>Fix: Corrected selector for <code>removeControlSpinner()</code> (<a href=\"https://github.com/elementor/elementor/issues/8790\">#8790</a>)</li>\n<li>Fix: Slides widget navigation icons misplacement (<a href=\"https://github.com/elementor/elementor/issues/8533\">#8533</a>)</li>\n<li>Fix: Horizontal Scrollbar when Slider widget is set to Full Width (<a href=\"https://github.com/elementor/elementor/issues/8527\">#8527</a>)</li>\n<li>Fix: Inconsistent behavior when &quot;Infinite Loop&quot; enabled with &quot;Autoplay&quot; in Slides widget (<a href=\"https://github.com/elementor/elementor/issues/6726\">#6726</a>)</li>\n<li>Fix: Ken Burns effect on Chrome transition glitches (<a href=\"https://github.com/elementor/elementor/issues/1671\">#1671</a>)</li>\n<li>Fix: Nothing found message shows up inside the columns set in Posts Archive widget (<a href=\"https://github.com/elementor/elementor/issues/7347\">#7347</a>)</li>\n<li>Fix: Responsive UI glitch in Popup Conditions modal tabs</li>\n<li>Fix: Removed unnecessary divider in Call to Action widget</li>\n<li>Fix: Custom Add To Cart * button style (size, position and background color) when <code>quantity</code> is enabled.</li>\n<li>Fix: Add support for Document/PageBase in Theme Builder (Core &gt;=2.7.0)</li>\n<li>Fix: Ampersand character breaks email link in Share Buttons widget</li>\n<li>Fix: Correct custom font attachment <code>mime-type</code> to show uploaded Custom Fonts</li>\n<li>Fix: Mini-Cart not refreshing in Menu Cart widget</li>\n<li>Fix: Cart drawer not working when WC Subscriptions plugin is activated</li>\n<li>Fix:  Querying CPT with custom taxonomies does not show the taxonomies before saving</li>\n<li>Fix: Double rendering on change caused console error in Theme Builder\'s conditions screen</li>\n<li>Fix: Translations and Strings in Share Buttons widget</li>\n<li>Fix: Avoid using offset if the source is Manual selection in Query Control</li>\n<li>Fix: Form being submitted although reCAPTCHA v3 validation failed in Forms widget</li>\n</ul>\n<h4>2.6.5 - 2019-08-26</h4>\n<ul>\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.7</li>\n<li>Fix: Button style not working when <code>quantity</code> is enabled in Custom Add To Cart widget</li>\n<li>Fix: Updated minified JS file fixed WhatsApp base URL in Share Buttons widget</li>\n</ul>\n<h4>2.6.4 - 2019-08-21</h4>\n<ul>\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.7</li>\n<li>Fix: Changed WhatsApp base URL in Share Buttons widget for cross-device compatibility</li>\n<li>Fix: Random slides order after several clicks on pagination in Testimonial Carousel widget</li>\n</ul>\n<h4>2.6.3 - 2019-08-18</h4>\n<ul>\n<li>Fix: Core version rollback to <code>&gt;2.6.0</code> causes a fatal error</li>\n<li>Fix: Duplicate images when slideshow skin is selected in Media Carousel lightbox</li>\n<li>Fix: Default bottom margin added to reCAPTCHA V3 badge</li>\n<li>Fix: Input glitch in reCAPTCHA V3 threshold settings</li>\n</ul>\n<h4>2.6.2 - 2019-07-30</h4>\n<ul>\n<li>Tweak: Better accessibility support in Search Form widget</li>\n<li>Fix: UI glitched in Popup publish screen (<a href=\"https://github.com/elementor/elementor/issues/8616\">#8616</a>)</li>\n<li>Fix: &quot;Child of Term&quot; and &quot;Any child of term&quot; conditions (<a href=\"https://github.com/elementor/elementor/issues/8695\">#8695</a>)</li>\n<li>Fix: Restored <code>library_widget_templates</code> action hook for 3rd party compatibility (<a href=\"https://github.com/elementor/elementor/issues/8687\">#8687</a>)</li>\n<li>Fix: Twitter Icon missing in Blockquote widget</li>\n<li>Fix: Form reCAPTCHA v3 badge position not working</li>\n<li>Fix: Renewal notice bar appears in wrong situations</li>\n<li>Fix: Draft Icon Set loads empty Icon Library</li>\n</ul>\n<h4>2.6.1 - 2019-07-24</h4>\n<ul>\n<li>Fix: Query Control autocomplete not retrieving results (<a href=\"https://github.com/elementor/elementor/issues/8672\">#8672</a>, <a href=\"https://github.com/elementor/elementor/issues/8661\">#8661</a>)</li>\n<li>Fix: Price Table features section not working (<a href=\"https://github.com/elementor/elementor/issues/8660\">#8660</a>)</li>\n</ul>\n<h4>2.6.0 - 2019-07-23</h4>\n<ul>\n<li>New: Introducing Custom Icon sets - including Fontello, IcoMoon and Fontastic support (<a href=\"https://github.com/elementor/elementor/issues/110\">#110</a>)</li>\n<li>New: Added Font Awesome 5 Pro integration including 5,300+ icons (<a href=\"https://github.com/elementor/elementor/issues/4430\">#4430</a>)</li>\n<li>New: Added reCAPTCHA v3 integration to Form widget (<a href=\"https://github.com/elementor/elementor/issues/8213\">#8213</a>, <a href=\"https://github.com/elementor/elementor/issues/6039\">#6039</a>, <a href=\"https://github.com/elementor/elementor/issues/7165\">#7165</a>)</li>\n<li>Tweak: Added Exit Animation for Popups (<a href=\"https://github.com/elementor/elementor/issues/7063\">#7063</a>)</li>\n<li>Tweak: Added ACF Dynamic tag support for archive pages (<a href=\"https://github.com/elementor/elementor/issues/5147\">#5147</a>)</li>\n<li>Tweak: Added Navigator Indicators for Custom CSS &amp; Motion Effects (<a href=\"https://github.com/elementor/elementor/issues/2180\">#2180</a>)</li>\n<li>Tweak: Added Dynamic capabilities for Form Redirect action (<a href=\"https://github.com/elementor/elementor/issues/7552\">#7552</a>)</li>\n<li>Tweak: Added Logged In Message styling options for Login widget (<a href=\"https://github.com/elementor/elementor/issues/7928\">#7928</a>)</li>\n<li>Tweak: Added <code>none</code> breakpoint option to Nav Menu widget (<a href=\"https://github.com/elementor/elementor/issues/7916\">#7916</a>)</li>\n<li>Tweak: Added option to place Post Terms dynamic tag without links (<a href=\"https://github.com/elementor/elementor/issues/8366\">#8366</a>)</li>\n<li>Tweak: Added <code>elementor/query/query_results</code> hook to Query Control to allow full control over results (<a href=\"https://github.com/elementor/elementor/issues/7912\">#7912</a>)</li>\n<li>Tweak: Allow choosing Heading HTML tag in Price Table widget (<a href=\"https://github.com/elementor/elementor/issues/8090\">#8090</a>)</li>\n<li>Tweak: Show popup on dynamic click even when <code>Avoid Multiple Popups</code> option is selected (<a href=\"https://github.com/elementor/elementor/issues/8189\">#8189</a>)</li>\n<li>Tweak: Added condition option to all of archive child pages (<a href=\"https://github.com/elementor/elementor/issues/8256\">#8256</a>)</li>\n<li>Tweak: Added <code>Effects Relative To</code> control to Scrolling Effects</li>\n<li>Tweak: Allow shortcodes in HTML Form field</li>\n<li>Tweak: Removed donReach integration from Share Buttons widget due to service inconsistent stability</li>\n<li>Tweak: Changed MailChimp <code>List</code> label to <code>Audience</code></li>\n<li>Tweak: Improved Entrance and Exit animation behavior in Popup</li>\n<li>Tweak: Added <code>Deprecated Notice</code> control to <code>Archive Products</code> and <code>Woo Products</code> widgets</li>\n<li>Tweak: Added default dynamic title for archives in Theme Builder</li>\n<li>Tweak: Added condition to show <code>Centered Slides</code> control in Media Carousel widget</li>\n<li>Tweak: Added notice bar in the Editor when the license is expired or not activated</li>\n<li>Tweak: Replaced <code>select</code> control with <code>choose</code> control in Price List widget</li>\n<li>Tweak: Removed Font Awesome 4 dependencies from the Editor</li>\n<li>Tweak: Minor styling tweaks in the Popup publish modal</li>\n<li>Tweak: Hide ordering form in Products widget on front page</li>\n<li>Tweak: Removed page title markup when \'Hide Title\' is active</li>\n<li>Tweak: Added style controls for HTML field in Form widget</li>\n<li>Fix: Form widget Date picker makes the Popup builder disappear (<a href=\"https://github.com/elementor/elementor/issues/7240\">#7240</a>)</li>\n<li>Fix: Sticky element stop point stops working on viewport resize (<a href=\"https://github.com/elementor/elementor/issues/7884\">#7884</a>)</li>\n<li>Fix: Copy-Paste style not pasting the Pointer option in Nav Menu widget (<a href=\"https://github.com/elementor/elementor/issues/8497\">#8497</a>)</li>\n<li>Fix: Missing Print icon in Share Buttons (<a href=\"https://github.com/elementor/elementor/issues/8506\">#8506</a>)</li>\n<li>Fix: UI style glitch in Blockquote widget when viewing from iPad</li>\n<li>Deprecated: <code>DB::save_editor()</code> - Remove usage of this method (<a href=\"https://developers.elementor.com/v2-6-0-planned-deprecations/\">Deprecation Post</a>)</li>\n<li>Deprecated: <code>DB::get_plain_editor()</code> - Remove usage of this method (<a href=\"https://developers.elementor.com/v2-6-0-planned-deprecations/\">Deprecation Post</a>)</li>\n</ul>\n<h4>2.5.14 - 2019-07-14</h4>\n<ul>\n<li>Fix: Better WC Related Product grid support to various themes (<a href=\"https://github.com/elementor/elementor/issues/8555\">#8555</a>)</li>\n</ul>\n<h4>2.5.13 - 2019-07-11</h4>\n<ul>\n<li>Fix: Better WC grid support to various themes</li>\n</ul>\n<h4>2.5.12 - 2019-07-10</h4>\n<ul>\n<li>Fix: Grid for WooCommerce Archive Product widget</li>\n<li>Fix: Remove redundant <code>whitespace</code> CSS property causes style glitch in iPad</li>\n<li>Tweak: Added more compatibility for Elementor v2.6</li>\n</ul>\n<h4>2.5.11 - 2019-07-02</h4>\n<ul>\n<li>Fix: Close icon missing from Nav Menu widget (<a href=\"https://github.com/elementor/elementor/issues/8460\">#8460</a>)</li>\n<li>Fix: Elementor Pro v2.5.10 shows PHP notice regarding notice bar (<a href=\"https://github.com/elementor/elementor/issues/8461\">#8461</a>)</li>\n<li>Fix: Fatal error when deleting used Pods fields (<a href=\"https://github.com/elementor/elementor/issues/8396\">#8396</a>)</li>\n<li>Fix: Missing dropdown icon in conditions screen</li>\n</ul>\n<h4>2.5.10 - 2019-05-28</h4>\n<ul>\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.6</li>\n<li>Tweak: Error caused by empty Rows &amp; Columns values in Products widget (<a href=\"https://github.com/elementor/elementor/issues/8261\">#8261</a>)</li>\n<li>Fix: Do not unset <code>product</code> CPT if it\'s not from WooCommerce (<a href=\"https://github.com/elementor/elementor/issues/8160\">#8160</a>)</li>\n<li>Fix: Column Spacing not working in WooCommerce Archive Products widget (<a href=\"https://github.com/elementor/elementor/issues/8285\">#8285</a>)</li>\n<li>Fix: Title styling not working in Products Categories widget</li>\n<li>Fix: Empty value in Dynamic Pods Gallery dropdown using Safari browser</li>\n<li>Fix: WooCommerce archives included in &quot;All Archives&quot; condition</li>\n</ul>\n<h4>2.5.9 - 2019-05-28</h4>\n<ul>\n<li>Tweak: Removed <code>auto-confirm</code> control from MailPoet to support new version of MailPoet</li>\n<li>Fix: Multiple Custom Fonts not rendered in the editor</li>\n<li>Fix: Products <code>sale</code> query - handle exclude by manual selection.</li>\n<li>Fix: Product Categories grid row &amp; column style</li>\n<li>Fix: Form integration AJAX cache override</li>\n<li>Fix: Removed redundant CSS on Canvas &amp; Header-Footer page templates</li>\n</ul>\n<h4>2.5.8 - 2019-05-06</h4>\n<ul>\n<li>Fix: Popup entrance animation not working in frontend</li>\n<li>Fix: Popup Exit Intent trigger activated multiple times</li>\n</ul>\n<h4>2.5.7 - 2019-05-05</h4>\n<ul>\n<li>Fix: Embedded video keeps playing after a Popup is closed (<a href=\"https://github.com/elementor/elementor/issues/7875\">#7875</a>)</li>\n<li>Fix: Maximum call stack size exceeded error in Safari (<a href=\"https://github.com/elementor/elementor/issues/7824\">#7824</a>)</li>\n<li>Fix: Entrance animations not appearing on Popup reopen (<a href=\"https://github.com/elementor/elementor/issues/7395\">#7395</a>)</li>\n<li>Fix: WC variations select style glitch in several themes (<a href=\"https://github.com/elementor/elementor/issues/8008\">#8008</a>)</li>\n<li>Fix: Theme Builder taxonomy conditions not retrieving proper results in edge cases</li>\n</ul>\n<h4>2.5.6 - 2019-04-29</h4>\n<ul>\n<li>Tweak: Removed <code>Shortcode</code> dynamic from Image, Gallery and Media control</li>\n<li>Fix: Popup not inheriting entrance animation in responsive mode (<a href=\"https://github.com/elementor/elementor/issues/7809\">#7809</a>)</li>\n<li>Fix: Terms autocomplete retrieves wrong results in Query Control</li>\n<li>Fix: Query Control Related by author glitches in edge cases</li>\n<li>Fix: Query Control using terms for Products widget</li>\n<li>Fix: Posts cards style glitch in small screens</li>\n<li>Fix: Display conditions delete icon missing in small screens</li>\n<li>Fix: Avoid rendering Menu Cart widget in WordPress native editor</li>\n</ul>\n<h4>2.5.5 - 2019-04-08</h4>\n<ul>\n<li>Tweak: Allow text selection inside a Popup</li>\n<li>Fix: Added backwards compatibility for <code>tax_query</code> in Query Control (<a href=\"https://github.com/elementor/elementor/issues/7751\">#7751</a>)</li>\n<li>Fix: Missing arguments for <code>widget_title</code> filter (<a href=\"https://github.com/elementor/elementor/issues/7745\">#7745</a>)</li>\n</ul>\n<h4>2.5.4 - 2019-04-03</h4>\n<ul>\n<li>Fix: Move Query from using <code>term_id</code> to <code>term_taxonomy_id</code> (<a href=\"https://github.com/elementor/elementor/issues/7653\">#7653</a>)</li>\n<li>Fix: Offset manipulation hook removal in Query control</li>\n<li>Fix: Missing form field <code>ID</code> in some edge cases (<a href=\"https://github.com/elementor/elementor/issues/7711\">#7711</a>, <a href=\"https://github.com/elementor/elementor/issues/7660\">#7660</a>)</li>\n</ul>\n<h4>2.5.3 - 2019-03-31</h4>\n<ul>\n<li>Tweak: Updated Google Calendar dynamic tag URL (<a href=\"https://github.com/elementor/elementor/issues/7673\">#7673</a>)</li>\n<li>Fix: Missing form field names (<a href=\"https://github.com/elementor/elementor/issues/7651\">#7651</a>)</li>\n<li>Fix: PHP 5.4 backward compatibility in Query Control (<a href=\"https://github.com/elementor/elementor/issues/7633\">#7633</a>)</li>\n<li>Fix: <code>products_deprecated</code> Query Control module compatibility (<a href=\"https://github.com/elementor/elementor/issues/7654\">#7654</a>)</li>\n<li>Fix: Changed query method from <code>term_id</code> to <code>term_taxonomy_id</code> (<a href=\"https://github.com/elementor/elementor/issues/7653\">#7653</a>)</li>\n</ul>\n<h4>2.5.2 - 2019-03-27</h4>\n<ul>\n<li>Fix: Overwrite parent widget type in Global Widget (<a href=\"https://github.com/elementor/elementor/issues/7632\">#7632</a>)</li>\n<li>Fix: Avoid Duplicates option not working in Query Control (<a href=\"https://github.com/elementor/elementor/issues/7635\">#7635</a>)</li>\n<li>Fix: Manual Selection option not working in Query Control (<a href=\"https://github.com/elementor/elementor/issues/7634\">#7634</a>)</li>\n<li>Fix: Incorrect condition caused handlers issues inside popup</li>\n</ul>\n<h4>2.5.1 - 2019-03-26</h4>\n<ul>\n<li>Fix: Query Control invalid call to deprecated action (<a href=\"https://github.com/elementor/elementor/issues/7619\">#7619</a>)</li>\n<li>Tweak: Renamed action hook from <code>elementor_pro/{$widget_name}/query/{$query_id}</code> to <code>elementor/query/{$query_id}</code></li>\n<li>Tweak: Renamed filter hook from <code>elementor_pro/query_control/get_query_args/current_query</code> to <code>elementor/query/get_query_args/current_query</code></li>\n</ul>\n<h4>2.5.0 - 2019-03-26</h4>\n<ul>\n<li>New: Introducing Motion Effects including Scrolling &amp; Mouse effects (<a href=\"https://github.com/elementor/elementor/issues/72\">#72</a>)</li>\n<li>New: Introducing Related Posts for Query Control (<a href=\"https://github.com/elementor/elementor/issues/7306\">#7306</a>, <a href=\"https://github.com/elementor/elementor/issues/7490\">#7490</a>)</li>\n<li>New: Introducing Date query for Query Control</li>\n<li>New: Introducing Sticky Posts support for Query Control (<a href=\"https://github.com/elementor/elementor/issues/2501\">#2501</a>)</li>\n<li>Tweak: Added option to open a Popup by a custom selector (<a href=\"https://github.com/elementor/elementor/issues/6871\">#6871</a>, <a href=\"https://github.com/elementor/elementor/issues/6876\">#6876</a>, <a href=\"https://github.com/elementor/elementor/issues/7258\">#7258</a>)</li>\n<li>Tweak: Option to count when Popup is closed in &quot;Show up to X times&quot; Advanced Rule</li>\n<li>Tweak: Added full border radius control options inside Popup</li>\n<li>Tweak: Changed exit intent icon in Popups</li>\n<li>Tweak: Show only one popup in its own preview</li>\n<li>Tweak: Added responsive support to Popup entrance animation control</li>\n<li>Tweak: Conditions - Singular <code>All Pages</code> string changed to <code>Pages</code></li>\n<li>Tweak: Added form field shortcode support for Drip tags (<a href=\"https://github.com/elementor/elementor/issues/7000\">#7000</a>)</li>\n<li>Tweak: Added dynamic capabilities to Price List widget (<a href=\"https://github.com/elementor/elementor/issues/7258\">#7258</a>)</li>\n<li>Tweak: Added Dynamic capabilities to Custom Attributes (<a href=\"https://github.com/elementor/elementor/issues/6779\">#6779</a>)</li>\n<li>Tweak: Added dynamic capabilities to Flip Box widget (<a href=\"https://github.com/elementor/elementor/issues/6986\">#6986</a>)</li>\n<li>Tweak: Decrease <code>z-index</code> for Nav Menu (<a href=\"https://github.com/elementor/elementor/issues/6869\">#6869</a>)</li>\n<li>Tweak: Changed &quot;Scrolling Effects&quot; section label to &quot;Motion Effects&quot;</li>\n<li>Tweak: Use filter <code>get_meta_viewport</code> for header templates (<a href=\"https://github.com/elementor/elementor/issues/7043\">#7043</a>)</li>\n<li>Tweak: use filterable <code>Util::get_public_post_types()</code> in Theme Builder (<a href=\"https://github.com/elementor/elementor/issues/7172\">#7172</a>)</li>\n<li>Tweak: Added Cloudflare rocket-loader support (<a href=\"https://github.com/elementor/elementor/issues/7443\">#7443</a>)</li>\n<li>Tweak: Added responsive support to WC Products Columns &amp; Rows Gap controls (<a href=\"https://github.com/elementor/elementor/issues/6913\">#6913</a>)</li>\n<li>Tweak: WC Menu cart &quot;View Cart&quot; &amp; &quot;Checkout&quot; buttons styling</li>\n<li>Fix: Custom ID reset to default when dragging repeater</li>\n<li>Fix: Conflict between archive-products widget and WC customizer</li>\n<li>Fix: Add to Cart widget <code>spacing</code> and <code>space-between</code></li>\n<li>Fix: Library view when creating a new Header or Footer</li>\n<li>Fix: Post types labels missing on Add New Template modal</li>\n</ul>\n<h4>2.4.8 - 2019-03-11</h4>\n<ul>\n<li>Fix: Missing query section in Products widget</li>\n<li>Fix: Missing Taxonomy controls in Products widget in edge cases</li>\n</ul>\n<h4>2.4.7 - 2019-03-06</h4>\n<ul>\n<li>Fix: Compatibility Global Widget with Elementor v2.5.0+</li>\n</ul>\n<h4>2.4.6 - 2019-03-04</h4>\n<ul>\n<li>Fix: Pods gallery dynamic when empty (<a href=\"https://github.com/elementor/elementor/issues/7127\">#7127</a>)</li>\n<li>Fix: Duplicate call for conditions screen issue</li>\n<li>Fix: Compatibility with Elementor v2.5.0</li>\n</ul>\n<h4>2.4.5 - 2019-02-18</h4>\n<ul>\n<li>Fix: Image size issue in Testimonial Carousel (<a href=\"https://github.com/elementor/elementor/issues/7058\">#7058</a>)</li>\n<li>Fix: MailChimp groups not saved in a form integration (<a href=\"https://github.com/elementor/elementor/issues/7083\">#7083</a>)</li>\n<li>Fix: Show popup preview only on it\'s own preview</li>\n<li>Fix: Elementor dashboard templates URL corrupted links in edge cases</li>\n</ul>\n<h4>2.4.4 - 2019-02-11</h4>\n<ul>\n<li>Tweak: Added ACF Date Time Picker field support (<a href=\"https://github.com/elementor/elementor/issues/6690\">#6690</a>)</li>\n<li>Tweak: Changed the term of <code>All Posts</code> condition to <code>Posts</code></li>\n<li>Fix: Added <code>&lt;IfModule&gt;</code> to avoid 500 error when <code>mod-headers</code> is missing (<a href=\"https://github.com/elementor/elementor/issues/7034\">#7034</a>)</li>\n<li>Fix: Include post CSS deletion in Global Widget update (<a href=\"https://github.com/elementor/elementor/issues/6856\">#6856</a>)</li>\n<li>Fix: <code>Textarea</code> default value in Forms Widget (<a href=\"https://github.com/elementor/elementor/issues/6934\">#6934</a>)</li>\n<li>Fix: MailPoet latest version caused fatal error (<a href=\"https://github.com/elementor/elementor/issues/6996\">#6996</a>)</li>\n<li>Fix: Fatal Error caused by calling MailPoet deleted method</li>\n<li>Notice: MailPoet <code>Auto Confirm</code> option will now default to &quot;On&quot;</li>\n</ul>\n<h4>2.4.3 - 2019-01-30</h4>\n<ul>\n<li>Fix: Custom Add to Cart widget responsive alignment settings</li>\n<li>Fix: Links in Post Info widget</li>\n<li>Fix: WooCommerce <code>View Cart</code> string translate</li>\n<li>Fix: Wrapper classes for header/footer templates (<a href=\"https://github.com/elementor/elementor/issues/6884\">#6884</a>)</li>\n</ul>\n<h4>2.4.2 - 2019-01-25</h4>\n<ul>\n<li>Tweak: Added pixel units to Close Button position control in Popups</li>\n<li>Fix: Exclude error in WC Products widget</li>\n</ul>\n<h4>2.4.1 - 2019-01-24</h4>\n<ul>\n<li>Tweak: Added CSS classes control to Popup (<a href=\"https://github.com/elementor/elementor/issues/6826\">#6826</a>)</li>\n<li>Tweak: Added responsive image size to Testimonial Carousel widget</li>\n<li>Fix: PHP warning when Toolset Date dynamic is empty (<a href=\"https://github.com/elementor/elementor/issues/6842\">#6842</a>)</li>\n<li>Fix: Support of exclude-ids in WC Products widget</li>\n<li>Fix: Popup close button not clickable</li>\n<li>Fix: Alignment justify issue of Add to Cart widget (<a href=\"https://github.com/elementor/elementor/issues/6749\">#6749</a>)</li>\n<li>Fix: Bad anchors breaks the page JS</li>\n<li>Fix: Popup overlay shown when turned off</li>\n</ul>\n<h4>2.4.0 - 2019-01-21</h4>\n<ul>\n<li>New: Introducing Popup Builder (<a href=\"https://github.com/elementor/elementor/issues/628\">#628</a>)</li>\n<li>New: Added <code>Popup</code> Dynamic Tag</li>\n<li>New: Added <code>Popup</code> forms action after submit</li>\n<li>New: Added User Info dynamic tag (<a href=\"https://github.com/elementor/elementor/issues/6322\">#6322</a>)</li>\n<li>Tweak: Added dynamic capabilities for &quot;Nothing Found&quot; message</li>\n<li>Tweak: Added <code>elementor_pro/theme_builder/archive/escape_nothing_found_message</code> Filter to avoid HTML escaping in &quot;Nothing Found&quot; message (<a href=\"https://github.com/elementor/elementor/issues/6053\">#6053</a>)</li>\n<li>Tweak: Added <code>add_doc_to_location</code> method to Allow insertion of a document to a location</li>\n<li>Fix: <code>z-index</code> issue with CTA widget (<a href=\"https://github.com/elementor/elementor/issues/6486\">#6486</a>)</li>\n<li>Fix: Hide the Post Content widget and show it only in a Single document</li>\n<li>Fix: <code>selector</code> replacement in Custom CSS</li>\n<li>Fix: Apply <code>the_content</code> on the real content only</li>\n<li>Fix: CSS for WC products selector (<a href=\"https://github.com/elementor/elementor/issues/6559\">#6559</a>)</li>\n<li>Fix: Odnoklassniki share URL (<a href=\"https://github.com/elementor/elementor/issues/6638\">#6638</a>)</li>\n<li>Fix: Custom link new tab in Post Info widget (<a href=\"https://github.com/elementor/elementor/issues/5766\">#5766</a>)</li>\n<li>Fix: <code>nofollow</code> link in Flip Box &amp; CTA widgets</li>\n<li>Fix: Post Terms in Post Info widget</li>\n<li>Fix: Added screen reader to some icons &amp; buttons for better accessibility (<a href=\"https://github.com/elementor/elementor/issues/5386\">#5386</a>)</li>\n<li>Fix: Accessibility labels in Reviews widget (<a href=\"https://github.com/elementor/elementor/issues/6630\">#6630</a>)</li>\n<li>Fix: Link to cart page not working when WooCommerce Subscriptions is active</li>\n<li>Fix: MailChimp Selected list not showing on reloading in Form widget</li>\n<li>Fix: Sub-menu arrow position in Nav Menu widget</li>\n<li>Fix: Conflict with WP Security Audit Log plugin (<a href=\"https://github.com/elementor/elementor/issues/6648\">#6648</a>)</li>\n</ul>\n<h4>2.3.1 - 2018-12-19</h4>\n<ul>\n<li>Fix: Template widget search functionality (<a href=\"https://github.com/elementor/elementor/issues/6473\">#6473</a>)</li>\n<li>Fix: Apply <code>the_content</code> filter to post content in theme builder</li>\n</ul>\n<h4>2.3.0 - 2018-12-17</h4>\n<ul>\n<li>New: Introducing Discord Integration for Forms (<a href=\"https://github.com/elementor/elementor/issues/4218\">#4218</a>)</li>\n<li>New: Introducing Slack Integration for Forms</li>\n<li>New: Introducing MailerLite Integration for Forms (<a href=\"https://github.com/elementor/elementor/issues/4462\">#4462</a>)</li>\n<li>New: Activate Elementor Pro plugin by connecting to Elementor account</li>\n<li>Tweak: Added <code>elementor_pro/utils/get_public_post_types</code> filter hook (<a href=\"https://github.com/elementor/elementor/issues/5900\">#5900</a>)</li>\n<li>Tweak: Added <code>loop_start</code> &amp; <code>the_content</code> hooks for Post Content (<a href=\"https://github.com/elementor/elementor/issues/6173\">#6173</a>)</li>\n<li>Tweak: Removed Custom Attributes from Page Settings</li>\n<li>Tweak: Always add the Custom CSS control to the Advanced tab</li>\n<li>Fix: In sub Term condition false positive in edge cases</li>\n<li>Fix: ToolSet Dynamic Image fallback</li>\n<li>Fix: Style glitch with the dropdown color in Nav Menu widget</li>\n<li>Fix: Style glitch in the Conditions screen in Safari browser</li>\n<li>Fix: Ribbon in the CTA widget obscures drop down menu (<a href=\"https://github.com/elementor/elementor/issues/6080\">#6080</a>)</li>\n<li>Fix: The color of label won\'t change color in Widget login</li>\n</ul>\n<h4>2.2.5 - 2018-12-11</h4>\n<ul>\n<li>New: Add Style Tab &amp; Custom CSS for Header &amp; Footer Templates.</li>\n<li>Tweak: Added a better identifier for subpages (<a href=\"https://github.com/elementor/elementor/issues/6362\">#6362</a>)</li>\n<li>Tweak: Removed Custom Attributes from page settings</li>\n<li>Fix: Yahoo event URL date issue (<a href=\"https://github.com/elementor/elementor/issues/6354\">#6354</a>)</li>\n<li>Fix: Allow timezone settings in Google event URL (<a href=\"https://github.com/elementor/elementor/issues/6354\">#6354</a>)</li>\n<li>Fix: Avoid <code>z-index</code> changes by <code>nanocss</code> in build process</li>\n<li>Fix: Added missing WC upsells products CSS</li>\n<li>Fix: Nav Menu dropdown losing color on hover</li>\n<li>Fix: WC Product Add-ons CSS compatibility</li>\n</ul>\n<h4>2.2.4 - 2018-12-04</h4>\n<ul>\n<li>Fix: Global widget not saving changes (<a href=\"https://github.com/elementor/elementor/issues/6340\">#6340</a>)</li>\n<li>Fix: Dynamic tags support in Blockquote widget (<a href=\"https://github.com/elementor/elementor/issues/6334\">#6334</a>)</li>\n<li>Fix: Forms Redirect URL action when using form field values with spaces</li>\n</ul>\n<h4>2.2.3 - 2018-11-29</h4>\n<ul>\n<li>Fix: Missing &quot;Edit Template&quot; in Template widget (<a href=\"https://github.com/elementor/elementor/issues/6271\">#6271</a>)</li>\n<li>Fix: Follow menu anchors with UTF8 characters in Nav Menu</li>\n<li>Fix: Show only supported templates in Template widget</li>\n<li>Fix: Revert conflicting fix for a default order for WC archive</li>\n</ul>\n<h4>2.2.2 - 2018-11-28</h4>\n<ul>\n<li>Fix: Lightbox dynamic tag crashes the editor</li>\n</ul>\n<h4>2.2.1 - 2018-11-28</h4>\n<ul>\n<li>New: Added <code>ACF File</code> Dynamic tag to support text controls.</li>\n<li>Tweak: Added option to hide item count bubble when cart is empty in Menu Cart widget (<a href=\"https://github.com/elementor/elementor/issues/6223\">#6223</a>)</li>\n<li>Tweak: Added Actions group for Lightbox and Contact URL tags</li>\n<li>Tweak: Added filter <code>elementor_pro/dynamic_tags/shortcode/should_escape</code> to avoid escaping in Shortcode dynamic tag</li>\n<li>Tweak: MailPoet3 integration allow Subscriber to to subscribe to multiple lists</li>\n<li>Tweak: Added front-end max file size validation for upload fields</li>\n<li>Tweak: Added <code>by-author</code> per Post-Type condition for theme builder</li>\n<li>Fix: Template widget panel not showing the selected template (<a href=\"https://github.com/elementor/elementor/issues/6271\">#6271</a>)</li>\n<li>Fix: Conflict between ACF with Safari browser on Select option in Dynamic tag</li>\n<li>Fix: Add post classes only for the Single template</li>\n<li>Fix: Set document type as not editable for unsupported document like Global widget</li>\n<li>Fix: Avoid duplicate query for current WC product query</li>\n<li>Fix: Product Archive showing oldest products instead of latest</li>\n<li>Fix: CSS reset in Posts widget using cards skin</li>\n</ul>\n<h4>2.2.0 - 2018-11-19</h4>\n<ul>\n<li>New: Introducing Custom Attributes (<a href=\"https://github.com/elementor/elementor/issues/290\">#290</a>, <a href=\"https://github.com/elementor/elementor/issues/3990\">#3990</a>)</li>\n<li>New: Added evergreen option for Countdown widget (<a href=\"https://github.com/elementor/elementor/issues/4459\">#4459</a>)</li>\n<li>New: Added expire actions option for Countdown widget (<a href=\"https://github.com/elementor/elementor/issues/5242\">#5242</a>)</li>\n<li>New: Introducing Reviews widget (<a href=\"https://github.com/elementor/elementor/issues/3854\">#3854</a>)</li>\n<li>New: Introducing Sitemap widget (<a href=\"https://github.com/elementor/elementor/issues/5594\">#5594</a>)</li>\n<li>New: Added Request Parameter dynamic tag (<a href=\"https://github.com/elementor/elementor/issues/4934\">#4934</a>)</li>\n<li>New: Added Shortcode dynamic tag</li>\n<li>New: Added Image and Video Lightbox dynamic tag</li>\n<li>New: Added Contact URL dynamic tag</li>\n<li>New: Added Featured Image Data dynamic tag</li>\n<li>New: Added default value to each field in the Form widget (<a href=\"https://github.com/elementor/elementor/issues/4268\">#4268</a>)</li>\n<li>New: Added &quot;Any Child Of&quot; condition to template conditions (<a href=\"https://github.com/elementor/elementor/issues/5321\">#5321</a>)</li>\n<li>New: Added &quot;In Child&quot; condition to template conditions (<a href=\"https://github.com/elementor/elementor/issues/5587\">#5587</a>)</li>\n<li>Tweak: Added Form Redirect URL with form values (<a href=\"https://github.com/elementor/elementor/issues/2564\">#2564</a>)</li>\n<li>Tweak: Added default post classes to template wrapper (<a href=\"https://github.com/elementor/elementor/issues/5959\">#5959</a>)</li>\n<li>Tweak: Better labels for terms in Query control (<a href=\"https://github.com/elementor/elementor/issues/6092\">#6092</a>)</li>\n<li>Tweak: Renamed &quot;Child Of&quot; templates condition to &quot;Direct Child Of&quot;</li>\n<li>Tweak: Added <code>elementor/theme/get_location_templates/condition_sub_id</code> filter hook to allow template condition translations</li>\n<li>Tweak: Load the Template Library widget via Ajax for better performance</li>\n<li>Tweak: Added 404 page title for Page Title dynamic tag</li>\n<li>Fix: Menu Cart Toggle has # URL link (<a href=\"https://github.com/elementor/elementor/issues/6141\">#6141</a>)</li>\n<li>Fix: Alignment issue in Nav Menu widget (<a href=\"https://github.com/elementor/elementor/issues/5790\">#5790</a>)</li>\n<li>Fix: Avoid potential security risk in forms</li>\n<li>Fix: Template By Author condition conflicts with 404 page</li>\n<li>Fix: Restored WC Product Content widget in Single Product template</li>\n<li>Fix: Theme Builder Preview URLs for date archives and 404 pages</li>\n<li>Fix: Highlight active menu anchor items only when scrolled into view</li>\n<li>Fix: Carousel Pagination Progress style to support new Swiper version</li>\n</ul>\n<h4>2.1.13 - 2018-11-12</h4>\n<ul>\n<li>Tweak: Added compatibility for new brand Finder in v2.3.0</li>\n<li>Fix: Settings conflict when there are multiple carousels in the page</li>\n</ul>\n<h4>2.1.12 - 2018-11-05</h4>\n<ul>\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.3</li>\n<li>Tweak: Better performance for Template Library widget</li>\n<li>Fix: Fatal error if a taxonomy used in a dynamic field is removed (<a href=\"https://github.com/elementor/elementor/issues/6029\">#6029</a>)</li>\n<li>Fix: Date Time dynamic tag now respect site language (<a href=\"https://github.com/elementor/elementor/issues/6001\">#6001</a>)</li>\n<li>Fix: Custom CSS printed twice in the front-end</li>\n<li>Fix: ACF Image field PHP warning (<a href=\"https://github.com/elementor/elementor/issues/6051\">#6051</a>)</li>\n</ul>\n<h4>2.1.11 - 2018-10-22</h4>\n<ul>\n<li>New: Added ACF local fields compatibility</li>\n<li>Tweak: Re-brand TypeKit by Adobe Fonts integration</li>\n<li>Fix: Exclude <code>is_embed</code> from Singular condition (<a href=\"https://github.com/elementor/elementor/issues/5915\">#5915</a>)</li>\n<li>Fix: Avoid conflict with Ad Blockers and Share Buttons</li>\n<li>Fix: Current date time dynamic tag now shows local time</li>\n<li>Fix: Avoid conflict with 3rd party plugins that filter the permalink</li>\n<li>Fix: Avoid PHP warning when no groups are selected for MailChimp integration</li>\n<li>Fix: Avoid PHP warning if checkbox field is empty for ACF</li>\n<li>Fix: Respect password protected for a WC single product template</li>\n<li>Fix: Respect <code>order</code> settings for WC archive also without pagination</li>\n</ul>\n<h4>2.1.10 - 2018-10-09</h4>\n<ul>\n<li>Tweak: Added responsive alignment control for Share Buttons widget (<a href=\"https://github.com/elementor/elementor/issues/5821\">#5821</a>)</li>\n<li>Tweak: Added link control to Animated Headline widget</li>\n<li>Fix: Mobile nav menu jump on RTL (<a href=\"https://github.com/elementor/elementor/issues/5711\">#5711</a>)</li>\n<li>Fix: Responsive alignment control in Add to Cart widget (<a href=\"https://github.com/elementor/elementor/issues/5830\">#5830</a>)</li>\n<li>Fix: Added IE compatibility for Animated Headline widget</li>\n<li>Fix: Post Content widget is now shown only on <code>Single</code> templates</li>\n<li>Fix: Query Control Pagination with offset</li>\n</ul>\n<h4>2.1.9 - 2018-09-17</h4>\n<ul>\n<li>Tweak: Added Centered Slides option for Slideshow carousel</li>\n<li>Fix: Allow only public CPT for Manual Selection in Query Control (<a href=\"https://github.com/elementor/elementor/issues/5091\">#5091</a>)</li>\n<li>Fix: ACF Gallery option support (<a href=\"https://github.com/elementor/elementor/issues/5344\">#5344</a>)</li>\n<li>Fix: Page scrolling on resize when sticky is active (<a href=\"https://github.com/elementor/elementor/issues/5740\">#5740</a>)</li>\n<li>Fix: Edit custom name for Global Widget in the Navigator (<a href=\"https://github.com/elementor/elementor/issues/5689\">#5689</a>)</li>\n<li>Fix: Coverflow transition effect in Carousel</li>\n<li>Fix: Weird mobile behavior with Cube effect in Carousel</li>\n<li>Fix: Show the first thumbnail in the Slideshow carousel correctly</li>\n</ul>\n<h4>2.1.8 - 2018-09-12</h4>\n<ul>\n<li>Tweak: Added styling options for WC Additional Information widget</li>\n<li>Tweak: Added styling options for \'View Cart\' link in Products widget</li>\n<li>Fix: 3rd party plugin support for WC single product template (<a href=\"https://github.com/elementor/elementor/issues/5338\">#5338</a>)</li>\n<li>Fix: Layout of Related Product widget with WC native style</li>\n</ul>\n<h4>2.1.7 - 2018-09-03</h4>\n<ul>\n<li>New: WC Archive Description widget</li>\n<li>Tweak: Added blend mode to Slides widget background overlay (<a href=\"https://github.com/elementor/elementor/issues/5555\">#5555</a>)</li>\n<li>Tweak: Added \'Current Subcategories\' option to Product Categories widget</li>\n<li>Fix: Added default vertical alignment in Author Box widget (<a href=\"https://github.com/elementor/elementor/issues/5589\">#5589</a>)</li>\n<li>Tweak: Added more blend mode options for CTA widget</li>\n<li>Tweak: Improved plugin updater method based on WordPress version</li>\n<li>Fix: Improved IE compatibility for Posts and Portfolio widgets</li>\n<li>Fix: Added default gap for products pagination</li>\n<li>Fix: Post thumbnail flickering in Safari browser</li>\n<li>Fix: Close mobile nav menu on click only in full-width mode</li>\n<li>Fix: Added trailing slash to pagination links in Posts widget</li>\n</ul>\n<h4>2.1.6 - 2018-08-28</h4>\n<ul>\n<li>New: WC Product Category Image widget and Dynamic tag (<a href=\"https://github.com/elementor/elementor/issues/5117\">#5117</a>)</li>\n<li>Tweak: Allow HTML in Excerpt widget (<a href=\"https://github.com/elementor/elementor/issues/5491\">#5491</a>)</li>\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.2</li>\n<li>Tweak: Deprecated Follow option in the Facebook Button widget</li>\n<li>Fix: Posts widget grid in Safari &amp; IE11 (Depended on Elementor v2.2)</li>\n<li>Fix: Posts widget CSS when using cards skin in masonry mode</li>\n<li>Fix: ACF Image &amp; ACF URL option support (<a href=\"https://github.com/elementor/elementor/issues/5344\">#5344</a>)</li>\n<li>Fix: WC product gallery links in RTL</li>\n<li>Fix: Dynamic tags in Call To Action widget</li>\n</ul>\n<h4>2.1.5 - 2018-08-21</h4>\n<ul>\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.2</li>\n<li>Fix: Posts Widget layout theme compatibility</li>\n<li>Fix: Added compatibility for WooCommerce native style</li>\n</ul>\n<h4>2.1.4 - 2018-08-19</h4>\n<ul>\n<li>Fix: Layout issue compatibility with themes caused by v2.1 (<a href=\"https://github.com/elementor/elementor/issues/5442\">#5442</a>)</li>\n<li>Fix: Dynamic setting in Pricing Table widget (<a href=\"https://github.com/elementor/elementor/issues/5460\">#5460</a>)</li>\n<li>Fix: Hide Target URL control if is not necessary in Blockquote widget</li>\n<li>Fix: Selector specificity for WooCommerce Products widget</li>\n<li>Fix: WooCommerce conflicts in the editor in edge cases</li>\n</ul>\n<h4>2.1.3 - 2018-08-15</h4>\n<ul>\n<li>Fix: Thumbnails in the Posts widget jumping (<a href=\"https://github.com/elementor/elementor/issues/5350\">#5350</a>)</li>\n<li>Fix: Responsive grid in the Share Buttons widget (<a href=\"https://github.com/elementor/elementor/issues/5375\">#5375</a>)</li>\n<li>Fix: Added missing <code>setup_postdata</code> for Product Data Tabs widget</li>\n<li>Fix: Rollback to older version of Flip Box widget to resolve 3D depth issue (<a href=\"https://github.com/elementor/elementor/issues/5399\">#5399</a>)</li>\n<li>Fix: Allowed types in the Upload File field are now case-insensitive (<a href=\"https://github.com/elementor/elementor/issues/5254\">#5254</a>)</li>\n<li>Fix: Carousel behavior when using a single slide</li>\n</ul>\n<h4>2.1.2 - 2018-08-12</h4>\n<ul>\n<li>Fix: Error when ACF Pro is not installed (<a href=\"https://github.com/elementor/elementor/issues/5367\">#5367</a>)</li>\n<li>Fix: Edge cases in Inspector where document is a boolean</li>\n<li>Fix: Edge cases for incorrect file fields in PODS</li>\n</ul>\n<h4>2.1.1 - 2018-08-09</h4>\n<ul>\n<li>Fix: Highlighted text in Animated Headline widget (<a href=\"https://github.com/elementor/elementor/issues/5345\">#5345</a>)</li>\n<li>Fix: Flip Box effect issues</li>\n<li>Fix: ACF Options page fields support (<a href=\"https://github.com/elementor/elementor/issues/5329\">#5329</a>)</li>\n<li>Fix: Import Pro templates in edge cases</li>\n</ul>\n<h4>2.1.0 - 2018-08-07</h4>\n<ul>\n<li>New: Introducing WooCommerce Builder (<a href=\"https://github.com/elementor/elementor/issues/1690\">#1690</a>)</li>\n<li>New: Introducing 12 new dynamic tags &amp; widgets for WooCommerce: Gallery, Image, Price, Rating, Description, Breadcrumbs, Data Tabs, Stock, Related, Upsell, Title &amp; Archive</li>\n<li>New: Introducing Cart Menu widget (<a href=\"https://github.com/elementor/elementor/issues/4220\">#4220</a>, <a href=\"https://github.com/elementor/elementor/issues/4600\">#4600</a>)</li>\n<li>New: Added integration with Toolset (<a href=\"https://github.com/elementor/elementor/issues/2949\">#2949</a>)</li>\n<li>New: Added integration with Pods (<a href=\"https://github.com/elementor/elementor/issues/4129\">#4129</a>)</li>\n<li>New: Added stick to bottom in scrolling effects (<a href=\"https://github.com/elementor/elementor/issues/4799\">#4799</a>)</li>\n<li>New: Added Scrolling Effect to Widgets under advanced tab</li>\n<li>New: Introducing Internal URL Dynamic Tag</li>\n<li>Tweak: Added a Last Updated Date in the Post Info widget (<a href=\"https://github.com/elementor/elementor/issues/4597\">#4597</a>)</li>\n<li>Tweak: Added Redirect after Logout option for Login widget (<a href=\"https://github.com/elementor/elementor/issues/4447\">#4447</a>)</li>\n<li>Tweak: Avoid repeating posts when using more than one in the Posts widget (<a href=\"https://github.com/elementor/elementor/issues/1878\">#1878</a>)</li>\n<li>Tweak: Add Custom Query hook for Query control (<a href=\"https://developers.elementor.com/custom-query-filter/\">More Info</a>) (<a href=\"https://github.com/elementor/elementor/issues/1748\">#1748</a>)</li>\n<li>Tweak: Added form-message style (<a href=\"https://github.com/elementor/elementor/issues/1180\">#1180</a>)</li>\n<li>Tweak: Added dynamic tag for button on the Price Table widget (<a href=\"https://github.com/elementor/elementor/issues/4242\">#4242</a>)</li>\n<li>Tweak: Added dynamic tag for Call to action widget (<a href=\"https://github.com/elementor/elementor/issues/4767\">#4767</a>)</li>\n<li>Tweak: Added Dynamic Tags support for Google Map field (<a href=\"https://github.com/elementor/elementor/issues/4602\">#4602</a>)</li>\n<li>Tweak: Added an support for <code>label|value</code> in options field (<a href=\"https://github.com/elementor/elementor/issues/4594\">#4594</a>)</li>\n<li>Tweak: Added <code>by-author</code> condition for theme builder (<a href=\"https://github.com/elementor/elementor/issues/4681\">#4681</a>)</li>\n<li>Tweak: Added Activate/Deactivate license key via WP-CLI command (<a href=\"https://github.com/elementor/elementor/issues/4149\">#4149</a>)</li>\n<li>Tweak: Added <code>is_scroll</code> trigger to scrolling effect (<a href=\"https://github.com/elementor/elementor/issues/4340\">#4340</a>)</li>\n<li>Tweak: Added In Same Term support for Post Navigation widget (<a href=\"https://github.com/elementor/elementor/issues/4177\">#4177</a>)</li>\n<li>Tweak: Added responsive control for Slides To Scroll control in all carousel widgets (<a href=\"https://github.com/elementor/elementor/issues/3697\">#3697</a>)</li>\n<li>Tweak: Added style options for Posts widget (<a href=\"https://github.com/elementor/elementor/issues/1335\">#1335</a>)</li>\n<li>Tweak: Added button CSS ID for Forms widget</li>\n<li>Tweak: Added pixel units to Post-Info divider height control</li>\n<li>Tweak: Rewrite sticky library to handle with stretch section, auto scroller &amp; more bugs</li>\n<li>Tweak: Re-organize the panel categories per document type</li>\n<li>Tweak: Added ACF support for <code>options-page</code> fields</li>\n<li>Tweak: Added dynamic tag for Animated headlines</li>\n<li>Tweak: Added dynamic tag for BlockQuote widget</li>\n<li>Fix: Elementor Full Width template in GeneratePress theme (<a href=\"https://github.com/elementor/elementor/issues/4817\">#4817</a>)</li>\n<li>Fix: Checkbox fields can accidentally be set to required (<a href=\"https://github.com/elementor/elementor/issues/4324\">#4324</a>)</li>\n<li>Fix: Initial slide in Carousel widget</li>\n<li>Fix: Stay on current slide while editing in Carousel widget</li>\n<li>Fix: Default slides per device in Carousel widget</li>\n<li>Deprecated: Woo Products, Woo Elements &amp; Single elements widgets</li>\n</ul>\n<h4>2.0.18 - 2018-07-27</h4>\n<ul>\n<li>Fix: Global widget error on saving page</li>\n</ul>\n<h4>2.0.17 - 2018-07-26</h4>\n<ul>\n<li>Fix: Sub menu indicator direction in Nav Menu widget</li>\n<li>Fix: Change the title and icon for Global Widget when is moving</li>\n<li>Fix: CSS wrapper selector for Page Document</li>\n</ul>\n<h4>2.0.16 - 2018-07-16</h4>\n<ul>\n<li>Tweak: CSS Filter Control module is now included in Elementor</li>\n<li>Fix: Border gap in Portfolio widget when item gap set as <code>0</code> (<a href=\"https://github.com/elementor/elementor/issues/5077\">#5077</a>)</li>\n<li>Fix: Restore current query after get Global Widget data</li>\n<li>Fix: Add action item in History on unlink Global widget</li>\n</ul>\n<h4>2.0.15 - 2018-07-10</h4>\n<ul>\n<li>Fix: Dropdown menu items collapsing when activated (<a href=\"https://github.com/elementor/elementor/issues/4996\">#4996</a>)</li>\n<li>Fix: GMT offset in Countdown widget (<a href=\"https://github.com/elementor/elementor/issues/4997\">#4997</a>)</li>\n</ul>\n<h4>2.0.14 - 2018-07-08</h4>\n<ul>\n<li>Tweak: Added set method to form record for developers (<a href=\"https://github.com/elementor/elementor/issues/4983\">#4983</a>)</li>\n<li>Fix: Autoplay option for Carousels</li>\n<li>Fix: Close mobile menu on item click in the Nav Menu widget</li>\n</ul>\n<h4>2.0.13 - 2018-07-03</h4>\n<ul>\n<li>Tweak: Added compatibility for Elementor v2.1</li>\n</ul>\n<h4>2.0.12 - 2018-07-02</h4>\n<ul>\n<li>Fix: Global widget PHP notices</li>\n<li>Fix: Slides widget active slide lost focus when clicking Editor tabs</li>\n<li>Fix: Form select field send all selected values on multiple selection</li>\n<li>Fix: Validate time field only if it\'s not empty</li>\n<li>Fix: ConvertKit API not saving name field</li>\n</ul>\n<h4>2.0.11 - 2018-06-12</h4>\n<ul>\n<li>Fix: Theme Builder <code>author</code> archive condition (<a href=\"https://github.com/elementor/elementor/issues/4593\">#4593</a>)</li>\n<li>Fix: Respect password protected posts in Post Content widget</li>\n<li>Fix: Custom Fonts redirect to post edit screen in edge cases.</li>\n</ul>\n<h4>2.0.10 - 2018-06-05</h4>\n<ul>\n<li>Tweak: Added <code>elementor/theme/get_location_templates/template_id</code> filter hook for multi-language plugins</li>\n<li>Fix: Dynamic Post Terms missing taxonomies if the taxonomy is registered to more then one post types (#4386)</li>\n<li>Fix: Fields shortcode missing after removing a field in Form widget</li>\n<li>Deprecated: <code>get_theme_templates_by_location</code> is replaced by <code>get_location_templates</code></li>\n</ul>\n<h4>2.0.9 - 2018-05-28</h4>\n<ul>\n<li>Fix: Compatibility for PHP version 5.4</li>\n</ul>\n<h4>2.0.8 - 2018-05-28</h4>\n<ul>\n<li>Tweak: Added Active state for Nav Menu dropdown</li>\n<li>Tweak: Added style for &quot;Nothing Found&quot; Message for Archive Posts widget</li>\n<li>Tweak: Removed caption control in Site Logo widget</li>\n<li>Tweak: Added option to position currency symbol before/after In Price Table widget</li>\n<li>Fix: Query control manual selection does not show more than 10 items (<a href=\"https://github.com/elementor/elementor/issues/4479\">#4479</a>)</li>\n<li>Fix: Styling glitch with terms list in Post Info widget (<a href=\"https://github.com/elementor/elementor/issues/4342\">#4342</a>)</li>\n<li>Fix: Sub terms missing in Query control in edge cases (<a href=\"https://github.com/elementor/elementor/issues/4527\">#4527</a>)</li>\n<li>Fix: Avoid rendering a template if it\'s not published</li>\n<li>Fix: 404 Page style not working</li>\n<li>Fix: Price Table button with hover animation not working in editor</li>\n<li>Fix: Styling conflict in Call to Action widget</li>\n<li>Fix: Global Widget tab translation</li>\n<li>Fix: Adding parent wrapper class to Site Title widget</li>\n</ul>\n<h4>2.0.7 - 2018-05-16</h4>\n<ul>\n<li>Fix: Content not found on section when single is set to &quot;All Singular&quot;</li>\n<li>Fix: Open 404 template library for 404 page</li>\n<li>Tweak: Added CSS prefix for dev files</li>\n<li>Tweak: Removed product post type from display conditions</li>\n</ul>\n<h4>2.0.6 - 2018-05-15</h4>\n<ul>\n<li>Tweak: Set type on create new single template</li>\n<li>Tweak: Always show the conditions dialog in the Draft status</li>\n<li>Tweak: Added document type <code>widget</code></li>\n<li>Tweak: Added Post Custom Field tag to URL category</li>\n<li>Fix: When ACF Field Groups are Empty (<a href=\"https://github.com/elementor/elementor/issues/4428\">#4428</a>)</li>\n<li>Fix: Links inside carousel in edge cases</li>\n<li>Fix: Responsive issue in My Templates area</li>\n<li>Fix: Image alignment for post content with text alignment</li>\n<li>Fix: Post Content widget when preview post is missing</li>\n<li>Fix: Global Widget tab translation</li>\n<li>Fix: Style settings for Post / Archive Title widgets</li>\n</ul>\n<h4>2.0.5 - 2018-05-08</h4>\n<ul>\n<li>Fix: Creating a CPT with name like document-type breaks the editor (<a href=\"https://github.com/elementor/elementor/issues/4203\">#4203</a>)</li>\n<li>Fix: Added support for new version of reCAPTCHA</li>\n<li>Fix: Added fallback for controls after <code>post_status</code></li>\n<li>Fix: Required field in forms widget</li>\n<li>Fix: Media Carousel in the Coverflow skin</li>\n<li>Fix: 404 Page show wrong template in edge cases</li>\n<li>Fix: Save the default menu in the Nav Menu widget</li>\n</ul>\n<h4>2.0.4 - 2018-05-02</h4>\n<ul>\n<li>Tweak: Added parent\'s class for extended widgets</li>\n<li>Tweak: Set entire-site as default to avoid conflict with save without conditions</li>\n<li>Tweak: Initialize global model when it\'s needed</li>\n<li>Tweak: Removed some duplicate strings</li>\n<li>Tweak: Query control now includes empty terms</li>\n<li>Tweak: Design polish for conditions dialog</li>\n<li>Tweak: Decreasing <code>minimumInputLength</code> to 1 of select2</li>\n<li>Fix: Editor not loading for single templates in edge cases</li>\n<li>Fix: Select2 in Safari takes it\'s time to get the original select width (<a href=\"https://github.com/elementor/elementor/issues/4310\">#4310</a>)</li>\n<li>Fix: Slides per view not working for some effects</li>\n<li>Fix: New slides not showing in the editor</li>\n<li>Fix: Editor for section without a defined location, defaults to content area</li>\n</ul>\n<h4>2.0.3 - 2018-04-24</h4>\n<ul>\n<li>Tweak: Optimize CSS for Post Info widget (<a href=\"https://github.com/elementor/elementor/issues/4214\">#4214</a>, <a href=\"https://github.com/elementor/elementor/issues/4216\">#4216</a>, <a href=\"https://github.com/elementor/elementor/issues/4225\">#4225</a>)</li>\n<li>Fix: Double render on frontend view in core locations</li>\n<li>Fix: Masonry not working in edge cases</li>\n<li>Fix: Added default setting for Author Info tag</li>\n</ul>\n<h4>2.0.2 - 2018-04-18</h4>\n<ul>\n<li>Fix: Regenerate conditions to include all templates</li>\n</ul>\n<h4>2.0.1 - 2018-04-17</h4>\n<ul>\n<li>Tweak: Added div wrapper for Nothing Found massage (<a href=\"https://github.com/elementor/elementor/issues/4136\">#4136</a>)</li>\n<li>Tweak: Show empty categories in Query Control &amp; Display Conditions (<a href=\"https://github.com/elementor/elementor/issues/4127\">#4127</a>)</li>\n<li>Tweak: Added Divider control for Post Info widget</li>\n<li>Fix: Update admin links in Yoast Breadcrumbs widget</li>\n<li>Fix: Sticky element conflict with clearfix CSS</li>\n<li>Fix: Compatibility for PHP version 5.4.32 &amp; 5.5.16 and below</li>\n<li>Fix: Avoid running <code>wp_head</code> hooks twice</li>\n</ul>\n<h4>2.0.0 - 2018-04-16</h4>\n<ul>\n<li>New: Introducing Theme Builder - <a href=\"https://elementor.com/introducing-theme-builder/\">Release Post</a> (<a href=\"https://github.com/elementor/elementor/issues/417\">#417</a>)</li>\n<li>New: Introducing Locations API to inject custom location templates</li>\n<li>New: Introducing Display Conditions for all dynamic templates</li>\n<li>New: Introducing Dynamic Tag feature - a new way to add dynamic content to your design</li>\n<li>New: Introducing Role manager to allow &quot;Content Only mode&quot; (<a href=\"https://github.com/elementor/elementor/issues/483\">#483</a>, <a href=\"https://github.com/elementor/elementor/issues/653\">#653</a>, <a href=\"https://github.com/elementor/elementor/issues/885\">#885</a>)</li>\n<li>New: Introducing 9 new dynamic widgets: Archive Posts, Archive Title, Post Content, Post Info, Post Title, Post Excerpt, Featu